BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Env File::Spec File::Temp FindBin Scalar::Util Text::ParseWords base strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  print STDERR "\n\n";
  print STDERR " ********************************************* \n";
  print STDERR " * WARNING:                                  * \n";
  print STDERR " * Test::CChecker has been deprecated!       * \n";
  print STDERR " * Please use Test::Alien instead.           * \n";
  print STDERR " ********************************************* \n";
  print STDERR "\n\n";
  unless(eval q{ use 5.008001; 1}) {
    print "Perl 5.008001 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.36.
use strict;
use warnings;
use 5.008001;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Test-time utilities for checking C headers, libraries, or OS features (DEPRECATED)",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "Test-CChecker",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME"             => "Test::CChecker",
  "PM"               => {
    "lib/Test/CChecker.pm" => "\$(INST_LIB)/Test/CChecker.pm"
  },
  "PREREQ_PM" => {
    "Capture::Tiny"         => 0,
    "ExtUtils::CChecker"    => "0.09",
    "Test::Builder::Module" => 0
  },
  "TEST_REQUIRES" => {
    "Test::More" => "0.98"
  },
  "VERSION" => "0.10",
  "test"    => {
    "TESTS" => "t/*.t"
    }
);

my %FallbackPrereqs = (
  "Capture::Tiny"         => 0,
  "ExtUtils::CChecker"    => "0.09",
  "Test::Builder::Module" => 0,
  "Test::More"            => "0.98"
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);