package Test::AutomationFramework; 
use 5.010001;
use strict;
use warnings;
use Date::Manip;
use File::Path;
#use Test::More;
use Getopt::Long;
use File::Copy;
use File::Copy::Recursive qw(fcopy rcopy dircopy fmove rmove dirmove);
use File::Find;
use Regexp::Assemble;
use Cwd;
use IO::Socket;			# might not work in http mode
#if ($^O  =~ /win32/i) { use Term::ReadKey; }
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
$| = 1;
require Exporter;
our @ISA = qw(Exporter);
our %EXPORT_TAGS = ( 'all' => [ qw(
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our @EXPORT = qw(
help
processTCs
processTC
processProperty
genDriver_taf_pl
genDriver_taf_cgi
genDriver_taf_svr
initTAF
printVersion
printTAFVersion
printOSVersion
fetchmail
);


our $VERSION = '0.060.01';   	

###################### TAF Global Variables ###############################
	my %tsProperty			; my %tsPropertyRoot; my %tafProperty	; my %tafPropertyRev; my $propertyOp='';	my $regression=0; my $help=0; my $sleep4Display = 1; my $notUsegetTCName= 0; my %recordTags=();
	my $tcIdCtr=0			; my $tsDriver = "null" ;	 				# cmd-line-overwrite $testDriverName (generated by -e .. index.pl or index.ps1)
 	my $pr2Screen = 1		; my $tcIdMin= 0	; my $reportHtmlSummaryStr = ''; 	# String for mouse-over display TC summary
	my $Execution_24_7	= "n";
	my $Execution_24_7_title= "y";
	my $Execution_local_only= "n";
	my $Execution_from_cgi  = "n";
	my $NofExecution	= "1"; my $NofExecutionCtr=0; my $NofExecutionCtrExec=0;
	my $ExecutionLength	= "10000 hour";
	my $ExecutionType 	= '>'; 
	my @tcDesc;		 my $tsFilter=".*";
	my $exitTAFTCId		;
	my $tcComment1		="Comment1";
	my $tcComment2		="PlaceHolderforComment2";
	my $MaxTCExecTime 	= 10	; 
	my $NofPropertyExecCtr	= 0	;
	my $NofPropertyExec     = 0	;
	my $tags		="_full_,_smoke_,_smoketest_,_regression_,_regressiontest_,_bat_,_32bit_,_64bit_,_list_,_load_,_erase_,_install_";
	my $TSHookIsPerl	= "n";
	my $outputFormat	= "text"; 	# noOutput
	my $htmlRefreshRate     = 200;
	my $htmlRefreshRateWebUI= 200;
	my $htmlRefreshRateLogUI= 200;
	my $createOrAppendTS    = "create"; 	#"append";	# create
	my $outputPause 	= 0;
	my $titleStatus		= "";
	my $perl = $^X;  $perl =~ s/\\/\\\//g;	 # todo3 \\ linux
	my $perl_ = $^X; $perl_=~ s/\\/\//g;	 # todo3 \\

###################### TAF Generated Variables ###############################
	my $scriptName 			= $0; $scriptName =~ s/\\/\//g;  # linux
	my $workingDir			= getcwd(); 
	my $TSHookName 			= "index.pl";
	my $TSHookNameGenerated 	= "index.pl";
	my $createTS_index		= "createTS_index.pl";
	my $createTS_indexindex		= "createTS_indexindex.pl";

###################### TAF Default Variables ###############################
	my $overWriteTC			= "y";
	my $interact 			= "n";

	my $tcPropertyPatternName 	= "tcRunResult";
	my $tcPropertyPatternPattern 	= ".*"; 
	my $tcPropertyPatternName1 	= "tcRunResult";
	my $tcPropertyPatternPattern1 	= ".*"; 
	my $tcPropertyPatternName2 	= "tcRunResult";
	my $tcPropertyPatternPattern2 	= ".*"; 
	my $tcPropertyPatternName3 	= "tcRunResult";
	my $tcPropertyPatternPattern3	= ".*"; 
	my $tcPropertyName 		= "all";
	my $tcPropertyPattern		= Regexp::Assemble->new; 
	my $tcNamePattern		= "TC*"; 		
	my $tcOp			= 'list';	
	my $tcCtr  			= 0;
	my $tcDelta			= 20;	
	my $markSymbol			= '|';
	my $cgi_bin  			= "/";					if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $cgi_bin = "/" ;		}
	my $c				= "c:"; 				if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $c= "/tmp/var/www/cgi-bin" ;	}
	my $ping			= "C:/Windows/System32/ping.exe -n 1 "; if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $ping = "/bin/ping -c 1 " ;	}
	my $deli			= ";"; 					if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $deli = '~' ;			}
	my $copy			= "copy"; 				if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $copy= 'copy' ;			}
	my $http_port			= ":8080";				if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $http_port= ":1234" ;		}
	my $_realSemi_			= ";";					if ( $^O =~ /MSWin32/ ) {; } elsif ($^O =~ /linux/i) { $_realSemi_ = '&' ;		}	
	my $taf				= "taf.pl";
	my $tafCGI			= "taf.cgi";
	my $SUTSymbol			= "_";
	my $tsFilterDefault 		= "_";
	my $tcFilterDefault 		= ".*";
	my $_TAF			= "_TAF";				# very useful variable 
	my $NofTCinTSTemplate  		= -1;				# very useful variable 
	my $SvrDrive 			= $c.'/'.$_TAF; 			# *:will be reset later in generated variable section
	my $SvrProjName 		= '_testsuite1_'; 
	my $SvrProjNameSub 		= ''; 
	my $SvrTCName 			= '_testcase1_';
	my $SvrTCNamePattern 		= "*"; 
	my $SvrPropNamePattern 		= '.*';
	my $SvrPropValuePattern 	= ".*";

	my $SvrTCNameExecPattern 	= ".".$SvrTCNamePattern;  		# * 
	my $SvrLogDir 			= ''.$SvrProjName.''; 			# * 
	my $ps1_args 			= "-ps1_args___powershell_args";  	# should not include -ps1_args 
	my $exitTAFGracefullyLock   	= $c.'/'.$_TAF.'/'."_exitTAFGracefully_.txt"; # *
	my $exitTAFGracefullyString	= 1;
 	my $performanceMode		= "slow4webUI"; 			# fast4cmd
	my $generateTestsuiteBAT	= $c.'/'.$_TAF."/taf_generateTestsuite.bat"; 	# *
	my $tsFrom			="";
	my $tsTo   			="";
	my $resetTSFileName		="";
	my $externalLogName		="$c/$_TAF/externalLog.txt";		# *
	my $commandLogName		="$c/$_TAF/_cmdLogs.txt";		# *
	my $commandLogLifeSpan		= "-3 days";
	my $queueSizeLimit		= 10000;
###################### TAF WebUI Default Settings ###############################

	my $webUITreeViewLevel		= 20;
	my $excelReportColumnWidth 	= 9; 
	my $AutomationtsName		="Automation_MVSDK";
 	my $makeMark			= 'n'; my $makeMarkComment		= '';
 	my $makeMarkLastDay		= &getExecDay();
	my $web_ui_title		="Test Automation Framework"; 
	my $webUI_TCDescWidth 		= 120; 					# <<<<<<<<<<<<<<
	my $scrollAmount		= 0; 
	my $borderWidth			= 0; 
	my $borderStyle			= "SOLID"; 
	my $passFailDisplayWidth	= 8;					# TS Variable. Should be reset for each TS execution 
	my $maxPassFailDisplayWidth	= 40; 
	my $reportHtmlSummaryScale 	= 3600; 				# in seconds
	my $reportHtmlSummaryScaleMajor = 12; 					# in seconds
	my $tsProperty    		= 'tsProperty.txt';
	my $tsPropertyWidth		= 150;					# <<<<<<<<<<<<<<<<<
	my $testcaseNode		= "testcase"	; 			
	my $testType    		= "ts";					# ts for testsuite
	my $reportHtml  		= 'index.htm';
	my $reportHtml1 		= '_tcReport_.html';
	my $reportHtmlHistory		= '_tcReportHistory_.html';
	my $reportHtmlSummary   	= '_tcReportSummary_.html';
	my $tc_pl			= "tc.pl";

	my $reportHtml_http  		= 'index_http.htm'; 			# $reportHtml."_http";
	my $reportHtml1_http 		= '_tcReport_.html'."_http";
	my $reportHtmlHistory_http	= '_tcReportHistory_.html'."_http";

	my $web_ui_title_tip 		= "Run TAF-Team Version based on IIS/httpd";
	my $hostname 			= "localhost";
	my $ip 				= "127.0.0.1";

	my $rst 			= `$ping $hostname`; 
 	if    ($rst =~ /Ping request could not/i) { $web_ui_title_tip = "Click to update every TAF testsuites";}
 	elsif ($rst  =~ /unknown/i)                { $web_ui_title_tip = "Click to update every TAF testsuites";}
 	else {
 		$hostname 		= `hostname`; chop $hostname; 
 		$ip			= inet_ntoa((gethostbyname($hostname))[4]);
 	}
		
	my $queueFName 			= "taf.queue";

	my $lockFName 			= "$c/$_TAF/taf.lock";
	my $url 			= 'file:///'.$SvrDrive;  		# will be updated in the sub-processTCs
	my $urlHttp			= 'http://'.$ip.$http_port;		# will be updated in the sub-processTCs
	my $indexTitleRefresh   = sprintf("<a href=\"${url}/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$c;_TAF=$_TAF;generateTestsuiteAgain')\" title=\"Refresh *all* TAF Testsuites\" >    </a>");
	my $indexTitleRefreshCGI= sprintf("<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=${SvrDrive}_semi_generateTestsuiteAgain;tafRedirectory=${urlHttp}/$reportHtml_http\" title=\"Refresh *all* TAF Testsuites\">    </a>");
	
	my $indexTitleRefreshRoot   = sprintf("<a href=\"${url}/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$c;_TAF=$_TAF;generateRootIndex')\" title=\"Refresh Root Index\" >    </a>");
	my $indexTitleRefreshCGIRoot= sprintf("<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=${SvrDrive}_semi_generateRootIndex;tafRedirectory=${urlHttp}/$reportHtml_http\" title=\"Refresh Root Index\">    </a>");

	if (-e "$c/$_TAF/_tafGlobalVars.txt") { &readTAFGlobalVars(); } # else { &printTAFGlobalVars();}  # Global Variables 

	######### Generated Variables 
	$SvrDrive 			= $c.'/'.$_TAF; 
	$exitTAFGracefullyLock   	= $c.'/'.$_TAF.'/'."_exitTAFGracefully_.txt";
	$SvrTCNameExecPattern 	= ".".$SvrTCNamePattern;  				# * 
	$SvrLogDir 			= ''.$SvrProjName.''; 				# * 
	$generateTestsuiteBAT	= $c.'/'.$_TAF."/taf_generateTestsuite.bat"; 		# *
	$externalLogName		="$c/$_TAF/externalLog.txt";			# *
	$commandLogName		="$c/$_TAF/_cmdLogs.txt";				# *

sub new { my $package = shift; return bless({}, $package); }

sub tcLoop {			###### Testsuite Loop #####
	my $returnValue;
	if (-e "$c/$_TAF/$SvrProjName/_tafGlobalVars.txt") { &readTAFTSVars();} # TS Global Variables will overwrite TAF Global Variables

	while ((($Execution_24_7 eq 'y') || ($NofExecution > $NofExecutionCtr)) && ($NofPropertyExec >= $NofPropertyExecCtr )) {
		&markDaily();
		 $NofExecutionCtr++;
		my $tcOp_ = $tcOp; if ($tcOp_ =~ /list/) {$tcOp_ = "list & update";}
		if ($pr2Screen == 1) { if (($NofExecution == 1) && ($Execution_24_7 ne 'y')){ print "Processing           $c/$_TAF/$SvrProjName     ($tcOp_)          <- Testsuite \n" if ($outputFormat =~ /text/i) ; } else {print "Processing ($NofExecutionCtrExec\/$NofExecution) ......\n" ; } } else { print "";}

		if (($propertyOp =~ /^\s*$/) || ($propertyOp =~ /tcDescAuto/i)) { $NofExecutionCtrExec++; 
			&tcPre(); &tcMain_(); &tcPost(); } 
		else { 
			#&xtcMain_(); if ($NofPropertyExec =~ /y/i) { $propertyExecCtrEqZero = "y"; $propertyOp = ""; } else {$NofPropertyExecCtr++;}
			&tcMain_();  $NofPropertyExecCtr++;
		} # TC Property Process
		#### uncomment for debugging if ($pr2Screen==1) { if ($propertyOp) { print " -> $SvrDrive/$SvrProjName/_${propertyOp}.txt\n"; }	print " - Completed -\n"; } else { print "";} 
	}
	return $returnValue;
}
sub tcPre {
	# if (-e $SvrDrive.'/'.$SvrProjName) {;} else { print "$SvrDrive/$SvrProjName doesn't exist.\n"; exit; }	# Fix 2013/04/13 
	##################### PrePRocessor #####################
	if ($tcOp =~ /create/i) {
		if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1,"<html><body>")	}; 
		if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http,"<html><body>--- _tcReport_.htm will be available after list/update operation ---</body></html>")	}; 
		if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary,"<html><body>--- summary file will be available after list/update operation ---</body></html>")	}; 
		if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"<html><body>--- history file will be available after list/update operation ---</body></html>")	}; 
	}
	&readTestSuitProperty();
	########################################################
}

sub tcMain_ { $notUsegetTCName= 1; find( {preprocess=>sub {return sort @_;}, wanted=>\&recursiveSearchtcMain}, $SvrDrive); }
sub recursiveSearchtcMain() { 
	my $returnValue ='';
	if ($SvrTCNamePattern eq '*') { $SvrTCNamePattern = '.*';} 
	if (($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i) && ($File::Find::name =~ /$SvrTCNamePattern/i))  # TC Filter
	{	
		$tcIdCtr++;
		my $eachTC 	= &getRoot($File::Find::name);	
		$SvrTCName 	= &getDir ($File::Find::name);
		$eachTC	 	= &getRoot($eachTC);
		if (-e "$SvrTCName/_tafGlobalVars.txt") { &readTAFTCVars();} # TC Global Variables will overwrite TAF Global Variables
		&getWeb_($eachTC) =~ /scrollAmount\s*=\s*(\d+)/; $scrollAmount = $1; if ($scrollAmount) {;} else {$scrollAmount =0;}
		&getWeb_($eachTC) =~ /borderWidth\s*=\s*(\d+)/ ; $borderWidth  = $1; if ($borderWidth) {;} else {$borderWidth=0;}
		&getWeb_($eachTC) =~ /borderStyle\s*=\s*(.+)/  ; $borderStyle  = $1; if ($borderStyle) {;} else {$borderStyle=0;}


		if (    ($tcOp !~ /^\s*$/)&&($SvrTCName =~/$SvrTCNameExecPattern/)&&($tcIdCtr >= $tcIdMin) 
			&& (&getProperties(&getTCName($SvrTCName) , $tcPropertyPatternName, "value") =~ /$tcPropertyPatternPattern/i)
			&& (&getProperties(&getTCName($SvrTCName) , $tcPropertyPatternName1, "value") =~ /$tcPropertyPatternPattern1/i)
			&& (&getProperties(&getTCName($SvrTCName) , $tcPropertyPatternName2, "value") =~ /$tcPropertyPatternPattern2/i)
			&& (&getProperties(&getTCName($SvrTCName) , $tcPropertyPatternName3, "value") =~ /$tcPropertyPatternPattern3/i)
		)  { 		# Property/testcaseExec Filter
		   if ($propertyOp) {								# Property Processor
		        ##################### Property OPeration Start ####################
			if ($propertyOp =~ /tcDescAuto/) {					# add tcDesc when generateTestsuite
				my $tcDescAuto="";
				if ($#tcDesc eq 0 ) {;} else { $tcDescAuto = "add=tcDesc:".shift @tcDesc; }
				my $tcDescAuto_ = $tcDescAuto; $tcDescAuto =~ s/_space_/ /g; $tcDescAuto =~ s/_column_/:/g; $tcDescAuto =~ s/_eq_/=/g; 
				printf "%-20s %s %s\n", "processProperty:", &getTCName($File::Find::name),$tcDescAuto;
				&processProperty("",&getTCName($File::Find::name), $tcDescAuto_);
			} elsif (($propertyOp =~ /_doit_/i) || ($propertyOp =~ /^\s*_?get_/i) || ($propertyOp =~ /^\s*_?list_/i)) {   	# property Operation (_doit_)
				my $propertyOp_  = $propertyOp; 
				$propertyOp_  =~ s/_doit_//g; 
				my $rst = &processProperty("",&getTCName($File::Find::name), $propertyOp_);
				my $File_Find_name = $File::Find::name; $File_Find_name =~ s/\/$tc_pl//g;
				if ($rst =~ /\n/) {
 					&appendtoFile_	($SvrDrive.'/'.$SvrProjName.'/'."_$propertyOp_.txt","$File_Find_name\t$propertyOp_=\n$rst\n")				;
				} else {
 					&appendtoFile_	($SvrDrive.'/'.$SvrProjName.'/'."_$propertyOp_.txt","$File_Find_name\t$propertyOp_=$rst\n")				;
				}
			} else {
				print "[TS/TC=$File::Find::name]  propertyOp=$propertyOp    _doit_\n"; # property Operation (print it)
			}
		        ##################### Property OPeration End   ####################
		   } # else 
		   if (($propertyOp =~ /tcDescAuto/i) || ($propertyOp =~ /^\s*$/)) {			# TC Exec Processor
			##################### TC Operation Start ######################
			if ($scrollAmount ==0 and $borderWidth ==0) { 					# TC Execution
				my $scrollAmount_ = 1 ; if ($tcOp =~ /list/) { $scrollAmount_ = 0; } 
				if ($tcOp =~ /exec/i) { &updateWeb_(&getDir($File::Find::name),$scrollAmount_, $borderWidth, "SOLID", $ExecutionType); &generateRootIndex ()	; } # update RootIndex
				$returnValue = $returnValue. &processTC("","$tcOp=$eachTC",$pr2Screen)."\n"; 
					&logTC($eachTC);						# TC Logging	  -> tesesuite\testcase\_tcLog.html
				if ($performanceMode =~ /slow4WebUI/i) {
					&reportTCHistory($eachTC);					# TC ReporHistory -> testsuite\_tcReportHistory_.html
					&reportTCSummary ();
					&updateTestsuitePassFail ()	;
					&Queue("updateQueue");
				}
				&updateWeb_(&getDir($File::Find::name),0, $borderWidth, "SOLID");
				if (($tcOp !~ /list/) && ($tcOp !~ /mark/)) { sleep $sleep4Display;}
			} elsif ( $scrollAmount != 0 ) {						# Handle different TC exec state - handle concurrency 
				if       (($scrollAmount != 0 and $borderWidth== 0 )) { $borderWidth = 1; $borderStyle = "DOTTED"; }
				elsif    (($scrollAmount != 0 and $borderStyle =~ /DOTTED/i)) {$borderWidth =1; $borderStyle = "SOLID"; }
				elsif    (($scrollAmount != 0 and $borderStyle =~ /SOLID/i)) {$scrollAmount=0; $borderWidth =0; $borderStyle = "SOLID"; }
					&logTC($eachTC);						# TC Logging	  -> tesesuite\testcase\_tcLog.html
				if ($performanceMode =~ /slow4WebUI/i) {
					#### &reportTCHistory($eachTC);					# TC ReporHistory -> testsuite\_tcReportHistory_.html
					&reportTCSummary ();
					&updateWeb_(&getDir($File::Find::name),$scrollAmount, $borderWidth, $borderStyle);
				}
			} ##################### TC Operation End ######################
			if ((&getExitTAFGracefullyLock() eq &getRoot_2($File::Find::name)) || (&getExitTAFGracefullyLock() eq "exitTAF" ) ) { print "TAF exited gracefully\n"; &tcPost();  &releaseExitTAFGracefullyLock(); exit; } 
			# &generateRootIndex ()	; 
		   } 
		} else {	# to handle no-run execution add to ts/tc/thProperty.txt
				&dumyTC_ ();
		}

		$scrollAmount = 0; $borderWidth = 0; $borderStyle = "SOLID";
		#}	# Property Filter 							# Passing $scrollAmount, $borderWidth, $borderStyle, 
	} # TC Filter
}
sub tcPost {
	##################### Post PRocessor ###################
	if (-e $SvrDrive.'/'.$SvrProjName ) {				# fix 2013/04/13
	&createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"")				;
	&reportTCHistory("null");					# TC ReporHistory -> testsuite\_tcReportHistory_.html
	&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"<html><body><pre>\n")	;
 	&appendtoFile_		($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"</pre></body></html>\n")				;
   	&mergeFile_		($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1)		;
   	&mergeFile_		($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http)	;
	&prHtml1()			;
	&appendtoFileFile_	($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1,      $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml)	;
	&appendtoFileFile_	($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http);
	&prHtml2()			;
	&reportTCSummary ();
	&generateRootIndex      ()	; 
	&updateTestsuiteHTA     ()	;
	&updateTestsuitePassFail()	;
	$AutomationtsName   = "$SvrProjName";
    	&generateExcelReport	() 	;	
	&sortCmdLog();
	}
	sleep $outputPause;
	########################################################
} 

sub printVersion { printf "%s\n",$VERSION ; }
sub printTAFVersion { printf "%s\n",$VERSION ; }
sub printOSVersion { printf "%s\n",$^O; }

sub heartBeat { print "This is heartBeat\n";}
# sub heartBeat { goto &fetchmail}

sub fetchmail { 	# this is window version
my $WinUser 		= "w";				# window user name is the cygwin user name
my $gmail 		= "wripcity\@gmail.com";	# gmail address
my $GmailPassword 	= "beaverton";			# gmail password

my $tcId = 1; $tcId = shift if @_; 
my $fetchMailDate ="";

	my $fetchMailChmodFName = "c:/cygwin/home/$WinUser/fetchmailChmod.bat" 	;
	my $fetchMailBATFName 	= "c:/cygwin/home/$WinUser/fetchmail.bat" 		;
	my $fetchMailRCFName  	= "c:/cygwin/home/$WinUser/.fetchmailrc" 		;

	my $str="poll pop.gmail.com with proto POP3 and options no dns user '$gmail' there with password '$GmailPassword' is '$WinUser' here  options ssl";
	mkpath "c:/cygwin/home/$WinUser";	
	open Fout, ">$fetchMailRCFName"; print Fout $str; close Fout; 					#print " -> $fetchMailRCFName\n";

	$str="/usr/bin/fetchmail.exe -vk";
 	open Fout, ">$fetchMailBATFName"; print Fout $str; close Fout; 					# print " -> $fetchMailBATFName\n";

	$str= "chmod 0600 /home/$WinUser/.fetchmailrc";
	open Fout, ">$fetchMailChmodFName"; print Fout $str; close Fout; 				# print " -> $fetchMailChmodFName\n";


 	my $cmd = 'c:\cygwin\bin\bash.exe -l /home/'.$WinUser.'/fetchmailChmod.bat';  my $rst = `$cmd 2>&1`;  
 	   $cmd = 'c:\cygwin\bin\bash.exe -l /home/'.$WinUser.'/fetchmail.bat';          $rst = `$cmd 2>&1`;  
 	foreach my $each (split /\n/, $rst) { if ($each =~ /protocol POP3\) at\s*(.+): poll completed/) { $fetchMailDate = $1; } }
 	copy ('c:/cygwin/var/spool/mail/'.$WinUser, 'c:/_TAF/_gmail_.txt'); 
 	$rst = "log is skipped\n";
 	return "---------- Start  ".(caller(0))[3]."-----------\n$cmd\n".$rst."----------  End   ".  (caller(0))[3]. "-----------\n";
}
 

sub getTAFArgsFromFile {
	my $fname = "$c/$_TAF/_tafArgs.txt";
	my $return="";
	if (-e $fname) { open Fin, $fname; while ($_ =<Fin>) { chop; $return .=";$_";	}	close Fin; }
	$return =~ s/^\s*;+//g; $return =~ s/;+/;/g;
       	$return =~ s/\s*//g; 
	unlink $fname;
	return $return;
}
sub markDaily {
	if ((($makeMarkLastDay  < &getExecDay()) && ($makeMark =~ /n/)) or (($tcCtr)%($tcDelta)== 0)) {
		$makeMarkLastDay = &getExecDay(); $makeMark = 'y'; 
	} else {
			$makeMark = 'n';
	}
	$tcCtr++;
}

sub getExecDay {
	my $initStartTime = &UnixDate( "Jan 1, 2012", "%m/%d/%Y %H:%M:%S %Z" );
	my $endStartTime  = &UnixDate( "now" , "%m/%d/%Y %H:%M:%S %Z" );
	my $totalTimeSpan = &DateCalc(&ParseDate($initStartTime),&ParseDate($endStartTime));  #### => YY:MM:WK:DD:HH:MM:SS  the years, months, etc. between the two
	my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $totalTimeSpan;
	my $makeMarkLastDay_Local =  int ($H/24); 
	return $makeMarkLastDay_Local;
}

sub generateTAFVars   {goto &printTAFGlobalVars}
sub generateTAFTSVars {goto &printTAFTSVars}
sub generateTAFTCVars {goto &printTAFTCVars}

sub printTAFGlobalVars { if (-e "$c/$_TAF/_tafGlobalVars.txt") 					{;} else {mkpath "$c/$_TAF"					;} ;  open Fout, ">$c/$_TAF/_tafGlobalVars.txt"					; print Fout &printGlobalVars()  ; close Fout; print " -> $c/$_TAF/_tafGlobalVars.txt\n"; }
sub printTAFTSVars     { if (-e "$c/$_TAF/$SvrProjName/_tafGlobalVars.txt")			{;} else {mkpath "$c/$_TAF/$SvrProjName" 			;} ;  open Fout, ">$c/$_TAF/$SvrProjName/_tafGlobalVars.txt"			; print Fout &printTSGlobalVars(); close Fout; print " -> $c/$_TAF/$SvrProjName/_tafGlobalVars.txt\n"; }
sub printTAFTCVars     { if (-e "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/_tafGlobalVars.txt")	{;} else {mkpath "$c/$_TAF/$SvrProjName/$SvrTCNamePattern" 	;} ;  open Fout, ">$c/$_TAF/$SvrProjName/$SvrTCNamePattern/_tafGlobalVars.txt"	; print Fout &printTCGlobalVars(); close Fout; print " -> $c/$_TAF/$SvrProjName/$SvrTCNamePattern/_tafGlobalVars.txt\n"; }

sub updateTAFGlobalVars { my $str =  "testcaseNode                  =$testcaseNode\n"; $str = shift if @_; 

			if (-e "$c/$_TAF/_tafGlobalVars.txt") {
			open Fout, ">>$c/$_TAF/_tafGlobalVars.txt"		 ; print Fout $str	; close Fout; print " ->> $c/$_TAF/_tafGlobalVars.txt\n"; 
			} else { print "updateTAFGlobalVars: $c:/$_TAF/_tafGlobalVars.txt does *NOT* exist\n"; }
		
		}

sub updateTAFTSVars     { my $str="Execution_24_7_title          =n\nExecution_local_only           =y\n";  $str = shift if @_; 
			  my	$SvrProjName_ = $SvrProjName; $SvrProjName_ =~ s/$c\///;  $SvrProjName_ =~ s/^\///g; 
			if (-e "$c/$_TAF/$SvrProjName_/_tafGlobalVars.txt") {
			open Fout, ">>$c/$_TAF/$SvrProjName_/_tafGlobalVars.txt"; print Fout $str; close Fout; print " ->> $c/$_TAF/$SvrProjName_/_tafGlobalVars.txt\n"; 
			} else { 
				print "updateTAFTSVars: $c/$_TAF/$SvrProjName_/_tafGlobalVars.txt does *NOT* exist. - Created\n"; 
				mkpath("$c/$_TAF/$SvrProjName_");
			open Fout, ">$c/$_TAF/$SvrProjName_/_tafGlobalVars.txt"; print Fout $str; close Fout; print " -> $c/$_TAF/$SvrProjName_/_tafGlobalVars.txt\n"; 
			}
}

sub updateTAFTCVars     { my $str="Execution_24_7_title          =n\nExecution_local_only           =y\n";  $str = shift if @_; 
			  my	$SvrProjName_ = $SvrProjName; $SvrProjName_ =~ s/$c\///; $SvrProjName_ =~ s/^\///g;
			if (-e "$c/$_TAF/$SvrProjName_/$SvrTCNamePattern/_tafGlobalVars.txt") {
			open Fout, ">>$c/$_TAF/$SvrProjName_/$SvrTCNamePattern/_tafGlobalVars.txt"; print Fout $str; close Fout; print " ->> $c/$_TAF/$SvrProjName_/$SvrTCNamePattern/_tafGlobalVars.txt\n"; 
			} else { 
				print "updateTAFTCVars: $c:/$_TAF/$SvrProjName_/$SvrTCNamePattern/_tafGlobalVars.txt does *NOT* exist. - created\n"; 
				mkpath("$c/$_TAF/$SvrProjName_");
				open Fout, ">$c/$_TAF/$SvrProjName_/$SvrTCNamePattern/_tafGlobalVars.txt"; print Fout $str; close Fout; print " -> $c/$_TAF/$SvrProjName_/$SvrTCNamePattern/_tafGlobalVars.txt\n"; 
			
			}
			}


sub clearTAFGlobalVars { unlink "$c/$_TAF/_tafGlobalVars.txt"		 ; print " -rm-> $c/$_TAF/_tafGlobalVars.txt\n"; }
sub clearTAFTSVars     { unlink "$c/$_TAF/$SvrProjName/_tafGlobalVars.txt" ; print " -rm-> $c/$_TAF/$SvrProjName/_tafGlobalVars.txt"; }
sub clearTAFTCVars     { unlink "$c/$_TAF/$SvrProjName/$SvrTCNamePattern/_tafGlobalVars.txt"; print " -rm-> $c/$_TAF/$SvrProjName/$SvrTCNamePattern/_tafGlobalVars.txt\n"; }
####################### remove duplicate records in file
sub removeDuplicate { 
	my $fname  = shift;
	if ($fname ) {;} else { print "remvoeDuplicate: needs filename\n"; exit; }
	if (-e $fname ) {;} else { print "remvoeDuplicate: $fname doesn't exist\n"; exit; }
	my $fname_tmp = $fname."_.htm"; 
open FILE , $fname; 
open FILE_tmp , "> $fname_tmp";
my $firstOccurence = "_firstOccurence_";
while ($_ = <FILE>) { if (($firstOccurence !~ /^_firstOccurence_$/) and ($_ ne $firstOccurence)) { print FILE_tmp $_; $firstOccurence = $_; } }
close FILE;
close FILE_tmp;
copy ($fname_tmp, $fname);
}

####################### copy Testsuite                  
sub copyTestsuite { shift; print "$copy $tsFrom -> $tsTo\n"; rcopy ($tsFrom, $tsTo) or die $!; 1;}
sub copyTS        { shift; print "$copy $tsFrom -> $tsTo\n"; 
	if (-e $tsFrom) {;} else { print "Warning: $tsFrom doesn't exist. It is created.\n"; mkdir $tsFrom; }	
	if (-e $tsTo  ) {;} else { print "Warning: $tsTo   doesn't exist. It is created.\n"; mkdir $tsTo  ; }	
	rcopy ($tsFrom, $tsTo) or die $!; return 1;}
############

sub generatePropertyTestsuite {goto &generateTestsuiteByDesc}
sub generateTestsuiteBasedOnProperty{
$SvrProjName =~ s/\\/\//g;
&tcMain_1(); 
1;
}
#######################generate Property TCs from desc

sub generateTestsuiteByDesc { $SvrProjName =~ s/\\/\//g; &tcMain_1(); 1; }
sub tcMain_1 { 
	print "	Scanning for testsuites at $SvrProjName ......\n"; 	
	find({preprocess=> sub {return reverse sort @_;}, wanted=> \&recursiveSearchtcMain_1}, $SvrProjName); 				# print "	[fyi: -> $generateTestsuiteBAT]\n"; 
1;
}
sub recursiveSearchtcMain_1() { 
	if (($File::Find::name =~ /\/$TSHookName\s*$/) && ($tcPropertyName !~ /_all_/i))	# bug 04/26/2013
	{ 	
		&readTCDesc($File::Find::name);
	 	$tcPropertyPattern->add($tcPropertyName ); 
		my @property = split ("\/", $File::Find::name) ; 
		my $tags_ = $tags; $tags_ =~ s/,/\|/g; $tags_ = "($tags_)"; 
		if ($property[$#property -1] =~ /$tags_/ ) {;} 			####  stop recursivly creating property test suite
		else {		
			&generateTS ($File::Find::name, $tcPropertyName); 
		}
	}
}


sub generateTestsuiteAgain {
my $SvrProjName_ = $SvrProjName; $SvrProjName = "$c\\$_TAF"; $SvrProjName =~ s/\\/\//g; # linux todo
&tcMain_2(); 
$SvrProjName=$SvrProjName_; $SvrProjName =~ s/\\/\//g; &readTAFProperty(); &generateRootIndex("exit");
1;
}

sub tcMain_2 { 
	print "	Scanning for testsuites at $SvrProjName ......\n"; 	
	find({preprocess=> sub {return reverse sort @_;}, wanted=>\&recursiveSearchtcMain_2}, $SvrProjName); print "	[fyi: -> $generateTestsuiteBAT]\n"; 
1;
}
sub recursiveSearchtcMain_2() { 
	if (($File::Find::name =~ /$reportHtml\s*$/))
	{ 	
		my $cmd = $File::Find::name; 
		$cmd =~ s/\/?$reportHtml//;
		$cmd =~ s/$c\/$_TAF//;
		$cmd =~ s/^\s*\///;
		if ($cmd) { $cmd = "testsuite=$cmd;performanceMode=fast;list"; 
		$passFailDisplayWidth	= 8;					# TS Variable. Should be reset for each TS execution 
		&processTCs("", $cmd); 
		
		}
	}
}

sub generateTestsuiteScript {
	my $testsuite; 								# ="c:/_CRB_/AppBuildpath/_automated_testsuites_/_testsuite_pl"; 
	$testsuite = $SvrProjName; my $testsuiteTAF = $SvrProjName; $testsuiteTAF =~ s/c://g; # here
	foreach my $each (split /,/, $tags) {
print <<EOF;
REM $c/$_TAF/taf.pl -processTSs create=$testsuite							rem create Tag     TS
$c/$_TAF/taf.pl tcPropertyName=$each;testsuite=$testsuite;generateTestsuiteByDesc			rem create Tag     TS
$c/$_TAF/taf.pl testsuite=$testsuite/$each;generateTestsuite						rem create TAF-tag TS
$c/$_TAF/taf.pl testsuite=$testsuite;testcaseNode=testcase;generateTestsuite				rem create TAF     TS
$c/$_TAF/taf.pl testsuite=$testsuiteTAF;testcaseNode=testcase;list

EOF
;
}

}
sub generateTS {
	my $str; 
	my $tsHook 		= "index.pl"	; $tsHook 		= shift if @_			;  
	my $tcPropertyNameLocal = "_smoketest_"	; $tcPropertyNameLocal 	= shift if @_			;
	my $tsDir 		= $tsHook	; $tsDir		=~ s/(\/$TSHookName\s*$)//g	;  
	my $tsHookChild 	= "$tsDir/${tcPropertyName}/$TSHookNameGenerated"			; # c:\_TAF
	my $tsDirChild 		= "$tsDir/$tcPropertyNameLocal"						; # c:\...			

	my $otherCmd = "$copy (\"$tsDir/_tcLogAppend.txt\", \"$tsDirChild/_tcLogAppend.txt\")";
	$ps1_args =~ s/\\/\//g;
	
	if ($tsHook =~ /\.ps1\s*$/)	{ $tsHook	= "powershell -executionpolicy unrestricted -file $tsHook "; } # change1   # solve the ps1->pl cerversion bug

my $perlCode=<<EOF_;
#!$perl_
use File::Copy;
if (\$ARGV[0]) { 
	#_cmd_holder_#
} else {
print \<\<EOF;
#_desc_holder_#
EOF
;
}
EOF_
;

	############ TS - > subTS maping Table _tcMap.txt 
	my $ctr_local=1; 
	for (my $i = 1; $i <= $#tcDesc; $i++) { 
		if ( $tcDesc[$i] =~ /($tcPropertyPattern)/i ) {		
			my $tmp = sprintf ("$tsDir\/testcase%04d => $tsDirChild/testcase%04d", $i, $ctr_local);
			&appendtoFileUniqly("$tsDir/_tcMap.txt", $tmp);
			$ctr_local++;
		}
	}

	########## read the Mapping to %_tcMap my %_tcMap; open Fin, "$tsDir/_tcMap.txt"; while ($_=<Fin>) { $_ =~ /(.+)=>(.+)/; $_tcMap{$2}=$1; } close Fin;

	$ctr_local=1;
	for (my $i = 1; $i <= $#tcDesc; $i++) { 
		if ( $tcDesc[$i] =~ /($tcPropertyPattern)/i ) {		
		$tcDesc[$i] = &removeTags($tcDesc[$i]);
		my $i_tmp = $i ; 
		my $tmpStr = "if (\$ARGV[0] == $ctr_local) { \$rst = \`$tsHook $i_tmp -ps1_args $ps1_args\` ; $otherCmd; print \$rst; } \n";	  # change 2
		$perlCode =~ s/#_cmd_holder_#/$tmpStr\t#_cmd_holder_#/;
		$tmpStr = "$tcDesc[$i]\n";			# remove tcDesc Serial Number
		$tmpStr =~ s/\\/\//g;  
		$perlCode =~ s/#_desc_holder_#/$tmpStr#_desc_holder_#/;		$ctr_local++;
		}
	}
	if ($ctr_local > 1) {

	if (-e $tsDirChild) {;} else { mkpath $tsDirChild;}
		$perlCode =~ s/#_cmd_holder_#//g;
		$perlCode =~ s/#_desc_holder_#//g;
		open Fout , ">$tsHookChild"; print Fout $perlCode; close Fout; print  "	-> $tsHookChild\n";
	}
}

sub tsTags {goto &readTCDesc}
sub readTCDesc {
	my $cmd = shift; my $ctr = 1; my $tags="";
	if ($cmd) {;} else { $cmd= "$SvrProjName/$TSHookName"; }		# improvement 05/10/2013
	$#tcDesc = -1;		
	if ($cmd =~ /\.ps1\s*$/) { $cmd = "powershell -executionpolicy unrestricted -file $cmd -ps1_args $ps1_args"; } 		# change 3
	else { $cmd = "$perl_ $cmd "; } 		# change 3		# linux Bug: with -ps2 args, the index.pl return nothing
	
 	foreach my $each (split /\n/, `$cmd`) {
 		if ($each =~ /^\s*$/) {; }
 		elsif ($each =~ /^\s*_test/) { ; } 
 		else {
			#### $tcDesc[$ctr++] = $each; original before add _full_ 
 			$tcDesc[$ctr++] = $each." _full_";	# _full_ bug fix 05/12/2013 (see 6 line below)
 			# $tcDesc[$ctr++] = $each.", full,";	# _full_ bug fix 05/12/2013
			$tags = $tags.",".&getTags($each);
 		}
 	}
	# $tags = "$tags,full";
	return &uniq($tags);
}

sub getTags {
	my $tags=""; my $str = shift; @_ = split (/_/, $str);
	foreach my $each (@_) { if (($str =~ /_${each}_\s*/) && ($each !~ /^\s*$/)) { $tags = $tags.','.$each; }	}
	$tags =~ s/^\s*,//g;
	$tags =~ s/,\s*$//g;
	return $tags;
}

sub uniq {
	my $str = shift; my %record;
	@_ = split (/,/,$str); 
	foreach my $each (@_) { $record{$each} = $each; }
	$str = "";
	foreach my $each (sort keys %record) { $str = $str.",".$each; }
	$str =~ s/^\s*,//g; $str =~ s/,\s*$//g; $str =~ s/^\s*,//g; $str =~ s/,\s*$//g; $str =~ s/^\s*,//g; $str =~ s/,\s*$//g; 
	$str =~ s/^\s*,//g; $str =~ s/,\s*$//g; $str =~ s/^\s*,//g; $str =~ s/,\s*$//g; $str =~ s/^\s*,//g; $str =~ s/,\s*$//g;
	return $str;
}

#######################generate Property TCs from desc
sub scanTestsuites {					######### generate index.htm
	shift; my $doit="n";  my @dir;
	if ($tsFilter =~/_doit_/i) { $doit='y'; $tsFilter =~ s/_doit_//i;} 
	elsif ($tsFilterDefault =~/_doit_/i) { $doit='y'; $tsFilterDefault =~ s/_doit_//i;} 
	elsif ($SvrProjName =~ /_doit_/i) { $doit = 'y'; $SvrProjName =~ s/_doit_//i; }
	
	if ($tsFilterDefault =~ /^$c/)	 {
		@dir = glob "${tsFilterDefault}*"; 
	} else {
		@dir = glob "${c}/${tsFilterDefault}*"; 	# c:\_filter is added to the search pattern
	}

 	if ($SvrProjName !~ /_testSuit_/i) {
 		if ($SvrProjName =~ /^$c/)	 {
 			@dir = glob "${SvrProjName}*"; 
 		} else {
 			@dir = glob "${c}/${SvrProjName}*"; 
 		}
 	}

foreach my $each (@dir) {
	$each =~ s/\\/\//g;
find( { preprocess => sub {return reverse sort @_;}, wanted => sub { if (($File::Find::name =~ /index\.\w+$/i) && ($File::Find::name !~ /${c}\/${_TAF}/i)&&($File::Find::name !~ /${c}.${_TAF}/i))  # todo1 \\
		{
			my $dirName =  $File::Find::name; $dirName =~ s/[\\|\/]index..+$//g; $tsFilterDefault =~ s/\\/\//g;
			if ($dirName =~ /$tsFilterDefault/i) {
			$ps1_args =~ s/ /___/g; 
			$notUsegetTCName = 0; 
			my $cmd = sprintf "$SvrDrive/$taf testsuite=$dirName;web_ui_title=$dirName;ps1_args=$ps1_args;generateTestsuite" ;  
			print "scanTestsuites: $cmd\n"; 
			if ($doit =~ /\by\b/) { # $cmd =~ s/\//\\/g;  # todo2 \\
				print "Running ... >>>>\n$cmd\n<<<<\n"; 
				$workingDir = $dirName; $SvrProjName = $dirName; $web_ui_title = $dirName; $ps1_args = $ps1_args; &generateTestsuite();
			}
			}
		}
	 }}, $each);
}
	1;
}
sub getWeb_ {
	my  %tsProperty;
 	my $tcname 		= 'TC_tc1'	; $tcname = shift if @_;	
 	my $scrollamount 	= -1 		; 
 	my $borderwidth  	= -1  		; 
 	my $borderStyle  	= 'SOLID'  	; 
	$tcname = &getTCName($tcname); $tcname =~ s/\\/\//g;

	if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml) {
		open Fin, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml;
 		while ($_ = <Fin>) {
 			my $tcnameTmp = $tcname;
 			if ( $_ =~ /$tcnameTmp/i) {
 				$_ =~  /scrollamount=\s*(\d+)\s*/; $scrollamount = $1;
 				$_ =~  /border:RED\s+(\d+)\s*px/; $borderwidth = $1;
 				$_ =~  /\d+\s*px\s+(\w+)\s*"/; $borderStyle= $1;
 			} 
 		}
 		close Fin;
	}
	return "borderWidth=$borderwidth;scrollAmount=$scrollamount;borderStyle=$borderStyle";
}

sub getTSMaxScrollAmount{
	my $testsuite= "$c/$_TAF/_testsuite2_"; $testsuite = shift if @_;
	my $scrollAmount = -1; 
		if (-e "$testsuite/$reportHtml") {
		open Fin, "$testsuite/$reportHtml";
 		while ($_ = <Fin>) {
			if ($_ =~  /scrollamount=\s*(\d+)\s*/) {
				my $scrollamount = $1; 
				if ($scrollamount > $scrollAmount) { $scrollAmount = $scrollamount; }
 			}
		}
 		close Fin;
	}
	return $scrollAmount;
}



#######################generateRootIndex {
sub generateRootIndex {					######### generate index.htm
	my %tafUI; my %tafUITreeView; my %tafRootProperty; my $queueSizeUI; my $queueSizeUICGI; my $exit_y_n = "NO" ; 
	$exit_y_n = shift if @_; 

	my $queueSize=0; $queueSize = &Queue("", "queueSize");  

	if ($queueSize >  0) { $queueSizeUI    = " <a href=\"$url/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 
	if ($queueSize >  0) { $queueSizeUICGI = " <a href=\"$urlHttp/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 
	if ($queueSize == 0) { $queueSizeUI    = " <a style=\"color:grey\" href=\"$url/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 
	if ($queueSize == 0) { $queueSizeUICGI = " <a style=\"color:grey\" href=\"$urlHttp/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 

	&readTAFProperty(); # read %tafProperty;
	&readTestSuitPropertyRoot(); 
	&readWebTitle($SvrDrive);
	#### part 1 ####
open INDEX, ">$SvrDrive/index.htm_"; 
open INDEX_Simple, ">$SvrDrive/index.htm_Simple"; 
print INDEX &prJScript2();

print INDEX<<EOF;
<body onload=\"addEvents();\"><pre>
<h2><a href="$urlHttp/$reportHtml_http" title="$web_ui_title_tip over Network"> $web_ui_title </a>${indexTitleRefreshRoot}${indexTitleRefresh}${queueSizeUI}</h2><ul id="LinkedList1" class="LinkedList">
EOF

find({preprocess=> sub {return sort @_;}, wanted=>sub { if ($File::Find::name =~ /index\.htm$/i) {

			my $tmp= $File::Find::name; $tmp=~ s/$SvrDrive//;
			my $tmp1 = $File::Find::name; $tmp1 =~ s/\/index.htm//g; $tmp1 =~ s/\/$reportHtml//;  
			my $tmp2 = $File::Find::name; $tmp2 =~ s/\/index.htm//g;
			my $testsuite = $tmp2; my $tsDir = $tmp2;
			if ($tafProperty{$tmp2}) { $tmp2 = $tafProperty{$tmp2}; } else { $tmp2 = $tmp2; }
			if ($tafProperty{$tmp2}) { $tmp2 = sprintf("%-${tsPropertyWidth}s", $tafProperty{$tmp2}); }  else { $tmp2 = sprintf("%-${tsPropertyWidth}s", $tmp2); }
			my $tmp3 = $tmp2;
			$tmp2 = sprintf("%-${tsPropertyWidth}s", $tmp2);
			my $tmp4 = $tmp2; $tmp4 =~ s/^\s*\d+\s*//g;
			if ($tafRootProperty{$tmp3}) { $tafRootProperty{$tmp3}=$tafRootProperty{$tmp3};} else  {$tafRootProperty{$tmp3} = $tmp2;}	### < TreeView text
			$tafUI{$tmp2}=" <marquee style=\"border:RED 0px SOLID\" width=48 direction=right behavior=alternate loop=10000 scrollamount=".&getTSMaxScrollAmount($testsuite).">*</marquee> <a href=\"$url".$tmp."\">$tafRootProperty{$tmp3}</a><a style=\"color:white\">$SvrDrive$tmp</a>\n" if ($tmp ne "/index.htm");
			my $tmp2TreeView = &getRoot_N($tsDir, $webUITreeViewLevel) ; 
			if (defined $tafUITreeView{$tmp2TreeView} ) {;} else { $tafUITreeView{$tmp2TreeView} ="";}
			if (defined $tafUI{$tmp2} ) {;} else { $tafUI{$tmp2} ="";}
			if (($tmp2TreeView !~ /^\s*$c\/$_TAF\s*$/) && ($tafUI{$tmp2} !~ /_noShow_/i)) {
 			$tafUITreeView{$tmp2TreeView} = $tafUITreeView{$tmp2TreeView}."<li>".$tafUI{$tmp2}."</li>" ;  
			$tafUITreeView{$tmp2TreeView} =~ s/\n//g; $tafUITreeView{$tmp2TreeView} =~ s/^\s*//g;  	# extra line webUI
			}
		}
	 }}, $SvrDrive);
  	foreach my $each1 (sort keys %tafUI) { print INDEX_Simple $tafUI{$each1} if (($each1 !~ /^\s*$c\/$_TAF\s*$/) && ($tafUI{$each1} !~ /_noShow_/i)); }

	foreach my $each (sort { &get1stColumn($tafProperty{$a}) cmp &get1stColumn($tafProperty{$b})} keys %tafUITreeView ) { 
		# foreach my $each (sort keys %tafUITreeView ) { 
		@_ = split(/<li>/,$tafUITreeView{$each}); my $NofTS; $NofTS = $#_; 
		my $tsDesc ;  if ($tsPropertyRoot{$each}) { $tsDesc = "<a title=\"$each\">$tsPropertyRoot{$each}"; } else { $tsDesc = $each;}
		if ($NofTS >2 ) {	print INDEX "<li>$tsDesc<ul>$tafUITreeView{$each}"."</ul></li>" if ($each !~ /$c\/$_TAF\s*$/i); }
		else 		  {	print INDEX "$tafUITreeView{$each}" if ($each !~ /$c\/$_TAF\s*$/i); }
	}

print INDEX <<EOF;
</ul>
</pre></body></html>
<style type="text/css"> a { text-decoration:none} </style>
EOF
;
close INDEX;
close INDEX_Simple;
  		move ($SvrDrive.'/index.htm_', $SvrDrive.'/'."index.htm");
	#### part 1 ####
	#################################### Generate Root tsProperty.txt ##################################
	if (-e "$SvrDrive/tsProperty.txt" ) {;} else {
	my $ctr=1;
	open FoutRootProperty, ">$SvrDrive/tsProperty.txt";
	print FoutRootProperty "web_ui_title:  Test Automaiton Framework : web_ui_title\n";
	foreach my $each (sort keys %tafRootProperty) { 
		$each =~ s/\s*$//g;
		printf FoutRootProperty "%-60s\|%04d  %-60s\n", $each, $ctr++, $each if ($each !~ /$SvrDrive\s*$/i); 
	}
	close FoutRootProperty;
	}
	#################################### Generate Root tsProperty.txt ##################################
	#### part 2 ####
	%tafUITreeView=();
open INDEX, ">$SvrDrive/index_http.htm_";		########## generate index_http.htm 

print INDEX &prJScript2();

print INDEX<<EOF;
<body onload=\"addEvents();\"><pre> <h2><a href="$urlHttp/$reportHtml_http" title="Click to view *all* Testsuites"> $web_ui_title </a>${indexTitleRefreshCGIRoot}$indexTitleRefreshCGI (Automation host: $hostname/$ip)${queueSizeUICGI}</h2><ul id="LinkedList1" class="LinkedList">
EOF
find({preprocess=> sub {return sort @_;}, wanted=>sub { if ($File::Find::name =~ /index_http\.htm$/i) {
			my $tmp = $File::Find::name; $tmp =~ s/$SvrDrive//;
			my $tmp2 = $File::Find::name; $tmp2 =~ s/\/index_http.htm//g;
			my $testsuite = $tmp2; my $tsDir = $tmp2;
			if ($tafProperty{$tmp2} ) { $tmp2 = sprintf("%-${tsPropertyWidth}s", $tafProperty{$tmp2}); }  
			else { $tmp2 = sprintf("%-${tsPropertyWidth}s", $tmp2); }
			my $tmp3 = $tmp2;
			$tmp2 = sprintf("%-${tsPropertyWidth}s", $tmp2);
			my $tmp4 = $tmp2;
			$tmp4 =~ s/^\s*\d+\s*//g;
			if ($tafRootProperty{$tmp3}) {;} else  {$tafRootProperty{$tmp3} = $tmp4;}
			$tafUI{$tmp2}=" <marquee style=\"border:RED 0px SOLID\" width=48 direction=right behavior=alternate loop=10000 scrollamount=".&getTSMaxScrollAmount($testsuite).">*</marquee> <a href=\"$urlHttp".$tmp."\">$tafRootProperty{$tmp3}</a><a style=\"color:white\">$SvrDrive$tmp</a>\n" if ($tmp ne "/index.htm");
			my $tmp2TreeView = &getRoot_N($tsDir, $webUITreeViewLevel) ; 
			if (defined $tafUITreeView{$tmp2TreeView} ) {;} else { $tafUITreeView{$tmp2TreeView} ="";}
			if (defined $tafUI{$tmp2} ) {;} else { $tafUI{$tmp2} ="";}

			if (($tmp2 !~ /^\s*$c\/$_TAF\s*$/) && ($tafUI{$tmp2} !~ /_noShow_/i)) {
 			$tafUITreeView{$tmp2TreeView} = $tafUITreeView{$tmp2TreeView}."<li>".$tafUI{$tmp2}."</li>";  
			$tafUITreeView{$tmp2TreeView} =~ s/\n//g; $tafUITreeView{$tmp2TreeView} =~ s/^\s*//g; # $tafUITreeView{$tmp2TreeView} =~ s/\s*$/\n/g; 
			}

		}
	 }}, $SvrDrive);

	foreach my $each (sort { &get1stColumn($tafProperty{$a}) cmp &get1stColumn($tafProperty{$b})} keys %tafUITreeView ) { 
		# foreach my $each ( sort  keys %tafUITreeView ) { 
		my $NofTS; @_ = split(/<li>/,$tafUITreeView{$each}); $NofTS = $#_; 
		my $tsDesc ;  if ($tsPropertyRoot{$each}) { $tsDesc = "<a title=\"$each\">$tsPropertyRoot{$each}"; } else { $tsDesc = $each;}
		if ($NofTS >2 ) {	print INDEX "<li>$tsDesc<ul>$tafUITreeView{$each}"."</ul></li>" if ($each !~ /$c\/$_TAF\s*$/i); }
		else 		  {	print INDEX "$tafUITreeView{$each}" if ($each !~ /$c\/$_TAF\s*$/i); }
	}


print INDEX <<EOF;
</ul> </pre></html>
<style type="text/css"> a { text-decoration:none} </style>
EOF
;
close INDEX;
  		move ($SvrDrive.'/index_http.htm_', $SvrDrive.'/'."index_http.htm");
	#### part 2 ####
	if ($exit_y_n =~ /exit/) { sleep $outputPause; exit; }
1;
}
 
sub get1stColumn { my $str = shift;  if ($str){;} else {$str ="";}  $str =~ s/^\s*//g; @_ = split (/\s+/,$str); my $return = $_[0];  if ($return) {;} else {$return = "0000"; } return $return; }

####################### read Testsuite web_ui_title
sub readWebTitle{ 
	my $dir = shift;  my %prop; my $webTitle = "Test Automation Framework";
	if (-e "$dir/tsProperty.txt") { 	# todo hardcoded variable
		open Fin, "$dir/tsProperty.txt"; 
		while ($_ =<Fin>) {
			my $tmp=""; /(\s*)/; $_ =~ /^\s*(.+)\|/       ; $tmp = $1; $prop{$tmp}=$_; 
			if ($_ =~ /web_ui_title\s*:\s*(.+)\s*:\s*web_ui_title/) {$webTitle = $1;}
		} close Fin; 
	}
	return $webTitle;
}


####################### get Testsuite Total Exec Time 
sub getTestsuiteTotalExecTime {
	my $index= shift; my $index_; my $tsTotalExecTime = 0;
		if (-e $index) {
		open FinTS, $index; 
		while ($_ = <FinTS>) { if ($_ =~ /^\s*<span\s+style="color:black;/i) { $_ =~ /(\d+)\s*\(s\)/; $tsTotalExecTime = $tsTotalExecTime + $1;} }
		close FinTS;
		} 
	return &timeConvert($tsTotalExecTime); 
}

####################### get Testsuite Total Exec Time 
sub timeConvert {
	my $totalTime = shift; 
	my $hr  = int ($totalTime/3600); 
	my $min = int (($totalTime - $hr*3600) / 60);
	my $sec = int (($totalTime - $hr*3600 - $min * 60));
	$totalTime = sprintf "%02d:%02d:%02d",$hr,$min,$sec;
	$totalTime = sprintf "%02d:%02d:%02d",$hr,$min,$sec;
}

#######################generateFailedTCHtml {
sub createTestsuitePassFailedHtml {
	my $index= shift; my $index_;
	####################### failed.htm #####################
	if ($index=~ /index\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_failed\.htm/;
		if (-e $index) {
		open Fin, $index; open Fout, ">$index_";
		while ($_ = <Fin>) {
			if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=fail/g; }
			if ($_ =~ /RunFile/) { $_ =~ s/index\.htm/index_failed\.htm/g; }
			if (&getLatestPassFail($_) =~ /color:gray;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:green;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:black;/i) { ;
			} else { 
				print Fout $_; }
			}
		close Fout; close Fin;
		}

	} elsif ($index=~ /index_http\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_failed\.htm/;

		if (-e $index) {
		open Fin, $index; open Fout, ">$index_";
		while ($_ = <Fin>) {
			if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=fail/g; }
			if ($_ =~ /RunFile/) { $_ =~ s/index_http\.htm/index_failed_http\.htm/g; }
			if (&getLatestPassFail($_) =~ /color:gray;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:green;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:black;/i) { ;
			} else { print Fout $_; }
		}
		close Fout; close Fin;
		}
	}	
	####################### failed.htm #####################

	####################### pass.htm #####################
	if ($index=~ /index\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_passed\.htm/;

		if (-e $index) {
		open Fin, $index; open Fout, ">$index_";
		while ($_ = <Fin>) {
			if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=pass/g; }
			if ($_ =~ /RunFile/) { $_ =~ s/index\.htm/index_passed\.htm/g; }
			if (&getLatestPassFail($_) =~ /color:gray;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:black;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
			} else { 
				print Fout $_; }
			}
		close Fout; close Fin;
		}

	} elsif ($index=~ /index_http\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_passed\.htm/;

		if (-e $index) {
		open Fin, $index; open Fout, ">$index_";
		while ($_ = <Fin>) {
			if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=pass/g; }
			if ($_ =~ /RunFile/) { $_ =~ s/index_http\.htm/index_passed_http\.htm/g; }
			if (&getLatestPassFail($_) =~ /color:gray;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:black;/i) { ;
			} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
			} else { print Fout $_; }
		}
		close Fout; close Fin;
		}
	}	
	####################### pass.htm #####################
	####################### other.htm #####################
	if ($index=~ /index\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_others\.htm/;

		if (-e $index) {
			open Fin, $index; open Fout, ">$index_";
			while ($_ = <Fin>) {
				if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=\\\\d+_pipe_null/g; }
				if ($_ =~ /RunFile/) { $_ =~ s/index\.htm/index_others\.htm/g; }
				if (&getLatestPassFail($_) =~ /color:green;/i) { ;
				} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
				} else { print Fout $_; }
			}
			close Fout; close Fin;
		}

	} elsif ($index=~ /index_http\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_others\.htm/;

		if (-e $index) {
			open Fin, $index; open Fout, ">$index_";
			while ($_ = <Fin>) {
				if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=\\\\d+_pipe_null/g; }
				if ($_ =~ /RunFile/) { $_ =~ s/index_http\.htm/index_others_http\.htm/g; }
				if (&getLatestPassFail($_) =~ /color:green;/i) { 
				} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
				} else { print Fout $_; }
			}
			close Fout; close Fin;
		}
	}	
	####################### other.htm #####################
}

#######################generateFailedTCHtml 

#######################generate_tagsHtml
sub generateTagHtml {
	my $index= shift; my $index_;
	my $tagName = "_smoke_"; 
	if ($index=~ /index\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_$tagName\.htm/;

		if (-e $index) {
			open Fin, $index; open Fout, ">$index_";
			while ($_ = <Fin>) {
				if ($_ =~ /tcPropertyPatternPattern/) { $_ =~ s/tcPropertyPatternPattern=\.\*/tcPropertyPatternPattern=\\\\d+_pipe_null/g; }
				if ($_ =~ /RunFile/) { $_ =~ s/index\.htm/index_${tagName}\.htm/g; }
				if (&processProperties("","dir", $tagName) =~ /color:green;/i) { print Fout $_; } # here to start
			}
			close Fout; close Fin;
		}

	} elsif ($index=~ /index_http\.htm\s*$/ ) {
		$index_ = $index;
		$index_ =~ s/\.htm/_others\.htm/;

		if (-e $index) {
			open Fin, $index; open Fout, ">$index_";
			while ($_ = <Fin>) {
				if (&getLatestPassFail($_) =~ /color:green;/i) { 
				} elsif (&getLatestPassFail($_) =~ /color:red;/i) { ;
				} else { print Fout $_; }
			}
			close Fout; close Fin;
		}
	}	
}
#######################generate_tagsHtml

sub getLatestPassFail {
	$_ = shift; my $color; my @symbol = $_ =~ />.<\/a><a\s+style=/g; my @color  = $_ =~ /<a style=\"color:\w+\"/g; 
for (my $i = 0; $i < $#symbol; $i++) { 
	$symbol[$i] =~ />(.)</; $symbol[$i] = $1;
	if ($symbol[$i] =~ /^\s*$/) {;}  # dumy 
	elsif ($symbol[$i] =~ /\|/) {;}  # mark
	else { $color[$i] =~ /\"(color:\w+)\"/; return "$1;"; }
}
return "";
}
sub getLatestPassFail_old {
	$_ = shift; my $color;
	if ($_ =~ /^\s*<span\s+style="color:black;">/) {
		if ($_ =~ /^\s*<span\s+style="color:black;">\s*<a\s+style="color:\s*(\w+)"/) {$color = $1;} else {$color = "black";}
	}
	if ($color) { return "color:$color;";} else {return "_";}
}


sub updateWeb {
	my  %tsProperty;
 	my $tcname = 'TC_tc1'; $tcname = shift if @_		;	
 	my $scrollamount = 0 ; $scrollamount = shift if @_	;
	$tcname = &getTCName($tcname); $tcname =~ s/\\/\//g	;

	if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml) {
 		open Fin, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml		;
 		open Fout, ">".$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_"	;
 		while ($_ = <Fin>) {
 			my $tcnameTmp = $tcname;
 			if ( $_ =~ /$tcnameTmp/i) {
 				$_ =~ /scrollamount=\s*(\d+)\s*/;
 				$_ =~ s/scrollamount=\s*$1\s*/scrollamount=$scrollamount/;
 			} 
 				print Fout $_;
 		}
 		close Fout;
 		close Fin;

  		move ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_", $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml);
	}
	return "tcCtr_Dynamics=$scrollamount";
}

################################################################################
#        
################################################################################
sub hungryMatch {    # hungryMatch("startStr_returnStr_endStr","startStr","endStr")
    my $str        = shift; my $startStr    = shift; my $endStr    = shift;

    if (index($str, $startStr) < 0) { return "";}
    if (index($str, $endStr  ) < 0) { return "";}
    my $offset     = index($str,$startStr) + length $startStr;
    my $len     = index($str,$endStr)  - $offset;
    if ($len < 0) { $len = 0; }
    return substr ($str, $offset, $len);
}
sub match1stRegexp { my $str = shift; my $pattern = shift; @_ = split (/$pattern/, $str); return $_[0]; }
sub matchRestRegexp { my $str = shift; my $pattern = shift; @_ = split (/$pattern/, $str); $str =~ s/^\s*$_[0]//; $str =~ s/^\s*$pattern//; return $str;}
sub removeTags { my $str = shift; @_ = ($str=~ /\b_\S+_\b/ig); foreach my $each (@_) {
		if ($each !~ /\//) { $str =~ s/\b$each\b//g ; 
		}
	
	} 
	
	return $str; }
sub updateTestsuiteHTA {
	open Fin, $SvrDrive."/index.htm" || die "Can't open index.htm";
	while ($_ = <Fin>) { chop; if ( &hungryMatch($_,"\/\/\/","index.htm") ) { my $ts= &hungryMatch($_,"\/\/\/","index.htm") ; &createTestsuiteHTA ($ts); } }
	close Fin;
}

sub tsPostProcessPlugin {
	open Fin, $SvrDrive."/index.htm" || die "Can't open index.htm";
	while ($_ = <Fin>) { chop; if ( &hungryMatch($_,"/\/\/\/","index.htm")) { my $ts= &hungryMatch($_,"\/\/\/","index.htm"); print "postProcessPlugin: $ts\n";} }
	close Fin;
}
sub updateTestsuitePassFail {
	#if (-e $SvrDrive."/index.htm" ) {
	#open FinIndex, $SvrDrive."/index.htm" || die "Can't open index.htm";
	if (-e $SvrDrive."/index.htm_Simple" ) {
	open FinIndex, $SvrDrive."/index.htm_Simple" || die "Can't open index.htm";
	while ($_ = <FinIndex>) { chop; 
		if ( &hungryMatch($_, "\/\/\/","index.htm" )) { 
			my $ts     = &hungryMatch($_,"\/\/\/","index.htm")."index.htm" ;  &createTestsuitePassFailedHtml ($ts); 
			my $ts_http = $ts; $ts_http =~ s/index\.htm/index_http\.htm/; &createTestsuitePassFailedHtml ($ts_http); 
		} 
	}
	close FinIndex;
	}
}

sub createTestsuiteHTA {
	my $tsDir = shift; @_ = split /\//, $tsDir; my $testsuite = $_[$#_];
	&createFile_( $tsDir.'ts.hta', 
"
<html>
<head>
	<script language=\"JavaScript\">
		function RunFileHTTP(testsuite, testcase) {
//			alert(\"testsuite is \" + testsuite + \" testcase is \" + testcase );
			 WshShell = new ActiveXObject(\"WScript.Shell\");
		    	 cmd= '$c\\\\windows\\\\system32\\\\schtasks.exe /delete /tn TAF_'+ testsuite + ' /f'; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
			 cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /create /TR \"$c\\\\$_TAF\\\\taf.pl testsuit='+testsuite+';testcaseExec='+testcase+';exec\" /TN TAF_'+testsuite+' /sc monthly /mo 1 /F'; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
    		  	 cmd= '$c\\\\windows\\\\system32\\\\schtasks.exe /run /tn TAF_'+testsuite; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
		}

	function sleep(milliseconds) {
	  var start = new Date().getTime();
	  for (var i = 0; i < 1e7; i++) {
	    if ((new Date().getTime() - start) > milliseconds){
	      break;
	    }
  	}
}

	</script>

</head>
<body onLoad =\"RunFileHTTP(\'$testsuite\', \'.*\')\">Run $testsuite\/ts.hta</button> <p>
</body>
</html>

")
;

}	

################################################################################
#        
################################################################################
sub initTAF {
	foreach my $each (split /\n/, `schtasks /query`) {
		if ($each =~ /TAF_/i) {
			$each =~ /^\s*(.+)\s+(\d+\/\d+\/\d+)\s+/;
			my $processName = $1; my $cmd = "schtasks /delete /tn $processName /f"; `$cmd`;
		}
	}
}

################################################################################
#        
################################################################################

sub readTestSuitProperty {
	if ( -e $SvrDrive.'/'.$SvrProjName.'/'."tsProperty.txt") {
	open Fin, $SvrDrive.'/'.$SvrProjName.'/'."tsProperty.txt";
	while ($_ = <Fin>) { chop;
 		if ($_ =~ /web_ui_title\s*:\s*(.+)\s*:\s*web_ui_title/)  { $web_ui_title = $1; }
		# else { $web_ui_title = "Test Automation Framework"; }
		my $tcname, my $tcdesc;
		($tcname, $tcdesc) = split /[\|]/, $_;
		if ($tcdesc) {
		#### Remove xml tags from the tcDesc for property display 
		$tcdesc =~ s/<.*>//g;
		$tcname =~ s/^\s*//; $tcname =~ s/\s*$//;  # $tcdesc =~ s/^\s*//;
		$tsProperty{$tcname}= $tcdesc;
		}
	}
	close Fin;
	}
}

sub readTestSuitPropertyRoot {
	if ( -e $SvrDrive.'/'."tsProperty.txt") {
	open Fin, $SvrDrive.'/'."tsProperty.txt";
	while ($_ = <Fin>) { chop;
 		if ($_ =~ /web_ui_title\s*:\s*(.+)\s*:\s*web_ui_title/)  { $web_ui_title = $1; }
		my $tcname, my $tcdesc;
		($tcname, $tcdesc) = split /[\|]/, $_;
		if ($tcdesc) {
		#### Remove xml tags from the tcDesc for property display 
		$tcdesc =~ s/<.*>//g;
		$tcname =~ s/^\s*//; $tcname =~ s/\s*$//;  # $tcdesc =~ s/^\s*//;
		$tsPropertyRoot{$tcname}= $tcdesc;
		}
	}
	close Fin;
	}
}
################################################################################
#        
################################################################################

sub readTAFProperty {
	if ( -e $SvrDrive.'/'.$tsProperty) {
	open Fin, $SvrDrive.'/'.$tsProperty;
	while ($_ = <Fin>) {
		chop;
 		if ($_ =~ /web_ui_title\s*:(.+):\s*web_ui_title/)  { $web_ui_title = $1; }
		my $tcname, my $tcdesc;
		($tcname, $tcdesc) = split /[\|]/, $_;
		if ($tcdesc) {
		$tcname =~ s/^\s*//; $tcname =~ s/\s*$//;  # $tcdesc =~ s/^\s*//;
		$tafProperty{$tcname}= $tcdesc;
		$tafPropertyRev{$tcdesc} = $tcname;
		}
	}
	close Fin;
	}
}

################################################################################
#        
################################################################################
sub getTSNameFromTSDesc {
	&readTAFProperty();
	my $tcDesc = "018"; $tcDesc = shift if @_;
	foreach my $each (keys %tafPropertyRev) {
		if ($each =~ /$tcDesc/i) { my $tmp = $tafPropertyRev{$each}; $tmp =~ s/$c\/$_TAF\///; return $tmp; }
	}
}
################################################################################
#        
################################################################################
sub runFromGmailService {
while (1==1) {
`$c/$_TAF/$taf runFromGmail`; 
sleep 10;
}
}

sub runFromGmail {
	my %record; my $value; my $key; my %record_file			; 
	my $fetchmailFName      = "/var/spool/mail/qa_user"		; 
	my $fetchmailFNameLocal = "/usr/local/iovation/bin/qa_user"	;
	if (-e $fetchmailFNameLocal) { open Fin1, $fetchmailFNameLocal; while ($_= <Fin1>) { $_ = /_date_(.+)_subject_(.+)/; $record_file{$1}=$2;} close Fin2; }               # read local history file
	if (-e $fetchmailFName     ) { open Fin , $fetchmailFName     ; while ($_= <Fin> ) { if (/^\s*Date:/) { chop; $key=$_; } elsif (/^\s*Subject: /) { chop; $value = $_; $record{$key}= $value;} } close Fin; }
	else { print " $fetchmailFName doesn't exit\n"; exit;}
	foreach my $each (sort keys %record) { if ($record_file{$each}) { print "$each already exist\n"; } else {
	&runIndex($record{$each}); open Fout , ">>$fetchmailFNameLocal" ; print Fout "_date_${each}_subject_$record{$each}\n"; close Fout; } }
}

sub runIndex {
# todo
}
sub runFromGmail_old_win32 {
my $cmd='c:\cygwin\bin\bash.exe -l /home/yongyan.wang/fetchmail.bat'; my $rst = `$cmd`;
# my $gmailFName = 'c:/cygwin/var/spool/mail/w'; my $testsuite="";
my $gmailFName = 'c:/cygwin/var/spool/mail/yongyan.wang'; my $testsuite="";

if ( -e $gmailFName) { open Fin, $gmailFName; while ($_ = <Fin>) { if ($_ =~ /^\s*subject:\s+Run\s*(.+)\s*$/i) { $testsuite=$1; } } close Fin; }

if ($testsuite =~ /^\s*\d+/) {
	my $cmd = "c:/strawberry/perl/bin/perl.exe $c/$_TAF/$taf testsuite=".&getTSNameFromTSDesc($testsuite).";exec";
	my $rst = `$cmd`;
	print ">>$cmd\n$rst\n";
} else { print "\nPlease input the testsuite *Number* (not $testsuite)\n"; }

unlink $gmailFName;
}




################################################################################
#	Subroutine Name : logTC
#		Function: create TC _tcLog.html for each TC
#	Input Parameters: Test Case name
#	Output/Returns  : c:\inetpub\wwwroot\*.html
################################################################################
sub logTC {		# 	Update TC Log on webUI (TH:WebUI)
    my $currentTime  = &UnixDate( "now", "%m/%d/%Y %H:%M:%S %Z" );
    my $tcname       = shift; $tcname = &getTCName ($tcname);
	 if (&getTCLogFname($tcname) =~ /_tcLog\.txt\s*$/ ) { 
	    my 	$webLogText =  &readFile("$tcname/_tcLog.html");
	       	$webLogText =~ s/<html>\s*<body>\s*<pre>\s*//;
	       	$webLogText =~ s/<\/pre>\s*<\/body>\s*<\/html>\s*//;
	       	$webLogText =~ s/\n/_nl_/g;
	       	$webLogText =~ s/\s*_nl_\s*/\n/g;
    		my $fileText = &readFile(&getTCLogFname($tcname)); 
    		my $fileText_= &readFile(&getTCLogFname_($tcname));   # for _tcLogAppendix_.txt (pyAnvil logs)
    		my $fileText__= &readFile(&getTCLogFname__($tcname)); # for _tcLogAppendix_.txt (pyAnvil logs)
    		if (-e $tcname) {;} else {mkpath $tcname;}
	 	open Fout, "> $tcname/_tcLog.html" || die "Warning: $tcname/_tcLog.html doesn't exist\n";
		print Fout &prJScript(); 
         	print Fout "==================== Update on $currentTime Start ===================== $tcname\n";
    		print Fout  $fileText__ if ($fileText__);
    		print Fout  $fileText_ if ($fileText_);
    		print Fout  $fileText;
		print Fout "\n==================== Update on $currentTime End   ===================== $tcname\n\n"; 
         	print Fout "</pre></body></html>\n";
		print Fout "<style type=\"text/css\"> a { text-decoration:none} </style>\n";
         	close Fout;
	 } elsif ((&getTCLogFname ($tcname) =~ /_tcLogAppend\.txt\s*$/) || (&getTCLogFname_ ($tcname) =~ /_tcLogAppend_\.txt\s*$/) ||(&getTCLogFname__ ($tcname) =~ /_tcLogAppend__\.txt\s*$/) ){ 
	    	my $webLogText =  &readFile("$tcname/_tcLog.html");
	        $webLogText =~ s/<html>\s*<body>\s*<pre>\s*//;
	        $webLogText =~ s/<\/pre>\s*<\/body>\s*<\/html>\s*//;
	        $webLogText =~ s/\n/_nl_/g;
       		$webLogText =~ s/\s*_nl_\s*/\n/g;
       		$webLogText =~ s/^\s*//g; 

    		my $fileText = &readFile(&getTCLogFname($tcname)); 
    		my $fileText_ = &readFile(&getTCLogFname_($tcname));  # for _tcLogAppendix_.txt (pyAnvil logs)
    		my $fileText__= &readFile(&getTCLogFname__($tcname)); # for _tcLogAppendix_.txt (pyAnvil logs)
	
		######## add html tags to $fileText_ #######  
		if ($fileText_) {$fileText_ = &addURLs($fileText_); }
		if ($fileText ) {$fileText  = &addURLs($fileText ); }
		######## add html tags to $fileText_ ####### 

    		if (-e $tcname) {;} else {mkpath $tcname;}
		open Fout, "> $tcname/_tcLog.html" || die "Warning: $tcname/_tcLog.html doesn't exist\n";
		print Fout &prJScript(); 
         	print Fout "==================== Update on $currentTime Start ===================== $tcname\n";
    		print Fout  $fileText__ if ($fileText__);
    		print Fout  $fileText_ if ($fileText_);
    		print Fout  $fileText;
		print Fout "\n==================== Update on $currentTime End   ===================== $tcname\n\n"; 
		print Fout $webLogText;
         	print Fout "</pre></body></html>\n";
		print Fout "<style type=\"text/css\"> a { text-decoration:none} </style>\n";
         	close Fout;
	 } else {
    		if (-e "$tcname/_tcLog.html") {;} else {mkpath $tcname;
		open Fout, "> $tcname/_tcLog.html" || die "Warning: $tcname/_tcLog.html doesn't exist\n";
		print Fout &prJScript(); 
		my $dirRoot = &getRoot($tcname); 
    		my $tcPropertyPatternPattern_ = ".*"; ####################### Reset the tcPropertyPatternPattern for index.htm
		my $runTCOnce = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseExec=$dirRoot;ExecutionType=runTC;exec')\"  title=\"**JScript**: Generate Logs e.g. $tcname/_tcLogAppend.txt \">St</a>";
		

		my $runTCOnceHttp = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseExec=$dirRoot;ExecutionType=runTC;exec_realSemi_tafRedirectory=${urlHttp}/$SvrProjName/$reportHtml_http\"  title=\"**Http**: Generate Logs e.g. $tcname/_tcLogAppend.txt\">Art</a>";
		$runTCOnceHttp =~ s/;/_semi_/g; $runTCOnceHttp=~ s/_realSemi_/$_realSemi_/g;
		# $runTCOnceHttp =~ s/;/_semi_/g; $runTCOnceHttp=~ s/_realSemi_/;/g; linux porting

         	print Fout "==================== Update on $currentTime ${runTCOnce}$runTCOnceHttp ===================== $tcname\n";
    		print Fout "$tcname has no log\n";
		print Fout "==================== Update on $currentTime End   ===================== $tcname\n\n"; 
		print Fout "\n\n<font color=\"white\">-------------------------AutomationFramework generated tcDriver -----------------------\n $tcname/tc.pl:\n". &readFile ("$tcname/$tc_pl") ;
		print Fout "-------------------------AutomationFramework generated tcDriver ------------------------<font>"; 
         	print Fout "</pre></body></html>\n";
		print Fout "<style type=\"text/css\"> a { text-decoration:none} </style>\n";
         	close Fout;
		}

	 } 
	 rmtree &getTCLogFname ($tcname) ;
	 rmtree &getTCLogFname_ ($tcname) ;
	 rmtree &getTCLogFname__ ($tcname) ;
	 return " tcLog[Append].[txt|html] are refreshed";
}


sub addURLs {
	my $return="";	
	foreach my $each (split "\n", shift ) {
		$_ = $each;
		#### The followings are for Powershell only 
		#s/_/_underscore_/g; s/\s/_ws_/g; s/\./_dot_/g; s/\\/_backslash_/g; s/\//_slash_/g; s/:/_col_/g; s/-/_dash_/g; s/\(/_leftPara/g; s/\)/_rightPara/g; s/</_lessThan/g; s/>/_greaterThan/g;s/=/_equal/g;
		#s/"/_doubleQuote/g; s/'/_singleQuote/g; s/\$/_dollar_/g; s/\%/_percentage_/g; s/\@/_at_/g; s/;/_semiColumn_/g;
		#s/\W//g;
		#s/\_ws_/ /g; s/_dot_/\./g; s/_backslash_/\\/g; s/_slash_/\//g; s/_col_/:/g; s/_dash_/-/g; s/_underscore_/_/g; s/_leftPara/\(/g; s/_rightPara/\)/g; s/_lessThan/</g; s/_greaterThan/>/g;s/_equal/=/g;
		#s/_doubleQuote/"/g; s/_singleQuote/'/g; s/_dollar_/\$/g; s/_percentage_/\%/g; s/_at_/\@/g; s/_semiColumn_/;/g;

	my $c_ = $c; my $_TAF_ = $_TAF; my $SvrProjName_ = $SvrProjName; 
	if ($SvrProjName_ =~ s/^$c_// ) {
		;
	} else {
		; 
		# print "\nInfo: $SvrProjName_ might have problem with the build-in file link (*.txt) \n($SvrProjName_ !~ $c_)\n\n" if ($^O =~ /linux/);  #### debug info: 
	}


		if (($_ !~ /href=\"/) && ($_ =~ /(.+)?($c\S+)\s?(.+)?/i) &&($_ !~ /_url_line_/i)) { # convert c:\abc.txt or c:/efg.txt <a href file= abc.txt </a>
			$_ =~ s/</__lt__/g; $_ =~ s/>/__gt__/g; 
			$_ =~ /(.+)?($c\S+)\s?(.+)?/i; 
			my $match1 = $1; my $logNameInLog = $2; my $match3=""; if ($3) {$match3 = $3."\n";;}
			if ($logNameInLog =~ /\.txt\s*$/) { 
				$logNameInLog =~ s/\\/\//g;
				my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_# %M_%S" );
				my $fileFrom = $logNameInLog ; 
				my $fileToFile   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToFile =~ s/\.txt\s*$/_$currentTime\.txt/;
				my $fileToHttp   = &getTCName()."/".&getRoot_4($logNameInLog); $fileToHttp =~ s/\.txt\s*$/_$currentTime\.txt/;
				$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;
				if ( -e $fileFrom ) { 
					if ( -e &getDir($fileToFile)){ ; } else {mkpath &getDir($fileToFile); }
					copy ($fileFrom, $fileToFile);
					$fileToHttp =~ s/$c\/$_TAF/${ip}${http_port}/;	
					$return = $return.$match1."<a href=\"http://$fileToHttp\"  >(http:$fileFrom)</a> $match3";
					#### tech reserver $return = $return.$match1."<a href=\"file:////$fileToFile\">(file:$fileFrom)</a> $match3";
				} else {
					$return = $return.$match1."Warning: Log $fileFrom doesn't exist! $match3";
				}
			} else {
				$return = $return.$_."\n";
			}
		} else { 
			if ($_ =~ s/_url_line_//i) {; } else {
			$_ =~ s/</__lt__/g; $_ =~ s/>/__gt__/g; 
			$_ =~ s/__lt__/&lt;/g; $_ =~ s/__gt__/&gt;/g;
			}
			$return = $return.$_."\n";
		}
	} 
			$return =~ s/__lt__/&lt;/g; $return =~ s/__gt__/&gt;/g; ### 
$return ;
}
sub addURLs_old {
	my $return="";	
	foreach my $each (split "\n", shift ) {

		$_ = $each;
		s/_/_underscore_/g; s/\s/_ws_/g; s/\./_dot_/g; s/\\/_backslash_/g; s/\//_slash_/g; s/:/_col_/g; s/-/_dash_/g; s/\(/_leftPara/g; s/\)/_rightPara/g; s/</_lessThan/g; s/>/_greaterThan/g;s/=/_equal/g;
		s/"/_doubleQuote/g;
		s/'/_singleQuote/g;
		s/\$/_dollar_/g;
		s/\%/_percentage_/g;
		s/\@/_at_/g;
		s/;/_semiColumn_/g;
		s/\W//g;
		s/\_ws_/ /g; s/_dot_/\./g; s/_backslash_/\\/g; s/_slash_/\//g; s/_col_/:/g; s/_dash_/-/g; s/_underscore_/_/g; s/_leftPara/\(/g; s/_rightPara/\)/g; s/_lessThan/</g; s/_greaterThan/>/g;s/_equal/=/g;
		s/_doubleQuote/"/g;
		s/_singleQuote/'/g;
		s/_dollar_/\$/g;
		s/_percentage_/\%/g;
		s/_at_/\@/g;
		s/_semiColumn_/;/g;
		if (($_ !~ /href=\"/) && ($_ =~ /(.+)($c\S+)\s?(.+)?/i)) { # convert c:\abc.txt  <a href file= abc.txt </a>
			my $match1 = $1; my $match2 = $2; my $match3=""; if ($3) {$match3 = $3;}

			if ($match2 =~ /\.txt\s*$/) { 
			my $currentTime  = &UnixDate( "now", "%m-%d-%Y-%H_%M_%S" );
			my $fileFrom = $match2; 
			my $fileTo   = $match2; $fileTo =~ s/\.txt\s*$/_$currentTime\.txt/;
			copy ($fileFrom, $fileTo);
			$return = $return.$match1."<a href=\"file:////$fileTo\">$fileTo</a>$match3\n";
			} else {
			$return = $return.$_."\n";
			}
		} else { 
			$return = $return.$_."\n";
		}
	} 

$return ;
}

sub ps12txt {
	my $return="";	
	foreach my $each (split "\n", shift ) {
		$_ = $each;
		s/_/_underscore_/g; s/\s/_ws_/g; s/\./_dot_/g; s/\\/_backslash_/g; s/\//_slash_/g; s/:/_col_/g; s/-/_dash_/g; 
		s/\W//g;
		s/\_ws_/ /g; s/_dot_/\./g; s/_backslash_/\\/g; s/_slash_/\//g; s/_col_/:/g; s/_dash_/-/g; s/_underscore_/_/g;
		s/^\s*//g;
		$return = $return."\n".$_;
	} 
	$return ;
}

sub addUrl {
	my $return; my $str = shift;
	foreach my $each (split /\n/, $str) {
		if ($each =~ /^\s*(.+\.html)/)  { 
			my $line = $1;
			$line =~ s/^\s*//g;
			$line =~ s/\s*$//g;
			$line =~ s/\\/\//g;
			$line =~ s/HTML:\s*/file:\/\/\//i;
			$line =~ s//file:\/\/\//;
			$return = $return.  "<a href=\"$line\">$each</a>\n";
		} elsif ($each =~ /^\s*(.+\.xml)/)  { 
			my $line = $1;
			$line =~ s/^\s*//g;
			$line =~ s/\s*$//g;
			$line =~ s/\\/\//g;
			$line =~ s/XML:\s*/file:\/\/\//i;
			$line =~ s//file:\/\/\//;
			$return = $return.  "<a href=\"$line\">$each</a>\n";
		} else {
			$return = $return.$each."\n";
		}
	}
	return $return;
}

################################################################################
#	Subroutine Name : getTCLogFname
#		Function: get valid Log (new log) fname 
#	Input Parameters: c:\TC*\_thLog.txt
#	Output/Returns  : noLog or hasWWWLog
################################################################################
sub getTCLogFname	{    	# 	Determine if a log exists (TH:TC Report)
    my $tcName  = shift;
    my ( $dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    );
	my $mtimeLogWeb; 

    if (-e $tcName.'/thProperty.txt' )
     {
	    (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    ) = stat($tcName.'/'.'thProperty.txt');
    }
    my $tcNameLog = $tcName."/_tcLogAppend.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
		if ($mtimePropertyFile - $mtimeLog>= 0 ) { return $tcNameLog; }
    }

    $tcNameLog = "$tcName/_tcLog.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
	    if ( $mtimePropertyFile - $mtimeLog>= 2 ) { return $tcNameLog; }
    }
    return "noLog"; 
}

sub getTCLogFname_	{    	# 	Determine if a log exists (TH:TC Report)
    my $tcName  = shift;
    my ( $dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    );
	my $mtimeLogWeb; 

    if (-e $tcName.'/thProperty.txt' )
     {
	    (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    ) = stat($tcName.'/'.'thProperty.txt');
    }

    my $tcNameLog = $tcName."/_tcLogAppend_.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
		if ($mtimePropertyFile - $mtimeLog>= 0 ) { return $tcNameLog; }
    }

    $tcNameLog = "$tcName/_tcLog_.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
	    if ( $mtimePropertyFile - $mtimeLog>= 2 ) { return $tcNameLog; }
    }
    return "noLog"; 
}

sub getTCLogFname__	{    	# 	Determine if a log exists (TH:TC Report)
    my $tcName  = shift;
    my ( $dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    );
	my $mtimeLogWeb; 

    if (-e $tcName.'/thProperty.txt' )
     {
	    (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimePropertyFile, $ctime, $blksize, $blocks
	    ) = stat($tcName.'/'.'thProperty.txt');
    }

    my $tcNameLog = $tcName."/_tcLogAppend__.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
		if ($mtimePropertyFile - $mtimeLog>= 0 ) { return $tcNameLog; }
    }

    $tcNameLog = "$tcName/_tcLog__.txt";
    if (-e $tcNameLog) {
	    my (
		$dev,  $ino,   $mode,  $nlink, $uid,     $gid, $rdev,
		$size, $atime, $mtimeLog, $ctime, $blksize, $blocks
	    ) = stat($tcNameLog);
	    if ( $mtimePropertyFile - $mtimeLog>= 2 ) { return $tcNameLog; }
    }
    return "noLog"; 
}

sub sortOnDate {
	my $return; my %record; my $str = shift;  if ($str =~ /^\s*$/) { return " ";}
	if ($str =~ /^\s*$/) { return "";}
	@_ = split(/\n/, $str); 
	foreach my $each (@_) { if ($each =~ /^\s*(\S+)\s+\S+\s+(\d+-\d+-\d+\s+\d+:\d+:\d+\s+).+$/) { my $rst = $1; $record{$2}=$each if ($rst !~ /mark/i && $rst !~ /dumy/i);}}
	foreach my $each (reverse sort keys %record) { $return = $return."$record{$each}\n"; } 
	return $return;
}
sub reportTCSummary {
	$reportHtmlSummaryStr = '';  

	if ( -e "$SvrDrive/$SvrProjName/$reportHtmlHistory" ) {;} else { return; }
	open Fin, "$SvrDrive/$SvrProjName/$reportHtmlHistory" || die "Can't open _tcReportHistory.html";

	my $fname_ =	$SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary."_"; 
	while (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary."_") { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }

	open Fout, "> $SvrDrive/$SvrProjName/$reportHtmlSummary"."_" || die "Can't open _tcReportSummary_.html";

	$reportHtmlSummaryStr = "<html><body><pre>\n"; $reportHtmlSummaryStr = $reportHtmlSummaryStr . "<META http-equiv=\"refresh\" content=\"$htmlRefreshRateWebUI\"> ";
	$reportHtmlSummaryStr = $reportHtmlSummaryStr .  "\n_replace_here_";
 	my $passFail ; my $dateTime; my $date1; my $date2; my %tcResult; my $tcName; my $passCtr=0;
	my $initStartTime = &UnixDate( "Jan 1, 2050", "%m/%d/%Y %H:%M:%S %Z" );
	my $endStartTime  = &UnixDate( "Jan 1, 1900", "%m/%d/%Y %H:%M:%S %Z" );
while ($_ =<Fin>) { 
	chop;
	if (($_ =~ /(testcase\d+)/) &&( $passCtr ==0 )) {
		$tcName = $1;	
		$reportHtmlSummaryStr = $reportHtmlSummaryStr . "\n$tcName: ";
		$_ = <Fin>;
		if ($_ =~ /^\s+(\w+)\s+\w+\s+(\d+\-\d+\-\d+\s+\d+:\d+:\d+)\s+/) { # always skip
		$_ =~ /^\s+(\w+)\s+\w+\s+(\d+\-\d+\-\d+\s+\d+:\d+:\d+)\s+/;
		$passFail = $1; $dateTime= $2; $date1=&ParseDate($dateTime);  my $title=" title=\"$dateTime\"";
		if (&Date_Cmp( &ParseDate($initStartTime), &ParseDate($dateTime) ) >=0 ) { $initStartTime = $dateTime; }
		if (&Date_Cmp( &ParseDate($endStartTime),  &ParseDate($dateTime) ) <=0 ) { $endStartTime  = $dateTime; }
		if    ($passFail =~ /pass/i) { $passFail = '<a style="color:green"'.$title.'>*</a>';	} 
		elsif ($passFail =~ /fail/i) { $passFail = '<a style="color:red"'.$title.'>*</a>';} 
		elsif ($passFail =~ /mark/i) {$passFail ="<a style=\"color:black\"$title>$markSymbol<\/a>";}
		elsif ($passFail =~ /Perf/i) {$passFail ="<a style=\"color:black\"$title>.<\/a>";}
		elsif ($passFail =~ /null/i) {$passFail ="<a style=\"color:black\"$title>.<\/a>";}
		elsif ($passFail =~ /dumy/i) {$passFail ="<a style=\"color:black\"$title> <\/a>";}
		elsif ($passFail =~ /expF/i) {$passFail ="<a style=\"color:black\"$title>*<\/a>";}
		elsif ($passFail =~ /bugF/i) {$passFail ="<a style=\"color:blue\"$title>*<\/a>";}
		$reportHtmlSummaryStr = $reportHtmlSummaryStr . $passFail;
		}
	} elsif (/^\s+(\w+)\s+\w+\s+(\d+\-\d+\-\d+\s+\d+:\d+:\d+\s+)/) {
		$_ =~ /^\s+(\w+)\s+\w+\s+(\d+\-\d+\-\d+\s+\d+:\d+:\d+)\s+(.+)/;
		my $note=$3;
		$passFail = $1; $dateTime= $2; $date2=&ParseDate($dateTime); 
		my $title = " title=\"$dateTime $note\""; 

		if ($passFail =~ /pass/i) { $passFail = '<a style="color:green"'.$title.'>*</a>';	} 
		elsif ($passFail =~ /fail/i)  { $passFail = '<a style="color:red"'.$title.'>*</a>';} 
		elsif ($passFail =~ /null/i) { $passFail = '<a style="color:black"'.$title.'>.</a>';}
		elsif ($passFail =~ /mark/i) {$passFail ="<a style=\"color:black\"$title>$markSymbol<\/a>";}
		elsif ($passFail =~ /Perf/i) {$passFail ="<a style=\"color:black\"$title>.<\/a>";}
		elsif ($passFail =~ /null/i) {$passFail ="<a style=\"color:black\"$title>.<\/a>";}
		elsif ($passFail =~ /dumy/i) {$passFail ="<a style=\"color:black\"$title> <\/a>";}
		elsif ($passFail =~ /expF/i) {$passFail ="<a style=\"color:black\"$title>*<\/a>";}
		elsif ($passFail =~ /bugF/i) {$passFail ="<a style=\"color:blue\"$title>*<\/a>";}
		if (&Date_Cmp( &ParseDate($initStartTime), &ParseDate($dateTime) ) >=0 ) { $initStartTime = $dateTime; }
		if (&Date_Cmp( &ParseDate($endStartTime),  &ParseDate($dateTime) ) <=0 ) { $endStartTime  = $dateTime; }

		my $delta=&DateCalc($date2,$date1); $delta =~ s/\+//g; my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $delta;
		my $totalMIN ;
		if ($Y && $M && $D && $H && $MIN && $S && $reportHtmlSummaryScale) {	
		$totalMIN = int ((((($Y*365 + $M * 30 + $D) * 24 + $H) * 60 + $MIN) * 60 + $S)/$reportHtmlSummaryScale) ;
		} else {
		$totalMIN = 0;
		}
		$reportHtmlSummaryStr = $reportHtmlSummaryStr . $passFail;
	}
}

 	my $totalTimeSpan = &DateCalc($initStartTime,$endStartTime);  my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $totalTimeSpan;
	my $NofX          = int ((((($Y*365 + $M * 30 + $D) * 24 + $H) * 60 + $MIN) * 60 + $S)/$reportHtmlSummaryScale) ;
	my $X_Unit = int (3600/$reportHtmlSummaryScale);	

	$reportHtmlSummaryStr = $reportHtmlSummaryStr. "\n_replace_here_\n";
	$reportHtmlSummaryStr = $reportHtmlSummaryStr .  "</pre></body></html>\n";

	my $tmp = "---------- |<marquee width = 50><--</marquee> ".&UnixDate($endStartTime, "%m/%d/%Y %H:%M:%S %Z")." ---------- $SvrDrive/$SvrProjName Test Summary -----...... <marquee width = 50><--</marquee>|". &UnixDate($initStartTime,  "%m/%d/%Y %H:%M:%S %Z" );
	$reportHtmlSummaryStr =~  s/_replace_here_/$tmp/g;
	print Fout $reportHtmlSummaryStr;
	close Fout;
	close Fin;
	move ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary."_", $SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlSummary);

}
################################################################################
#	Subroutine Name : reportTCHistory
#		Function: append TC result History to htmlLog
#	Input Parameters: Test Case name
################################################################################
sub reportTCHistory_ {
	my $tcname = shift;
	my $fileText = sprintf "%10s %s", "", &reportTC($tcname,"","History");
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, " ---------------------- TestCase: <a name=\"".&getTCName($tcname)."\"> ".&getTCName($tcname)." </a>-----------------------\n");
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, $fileText);
}


sub reportTCHistory {
	my $tcIdCtr_ = $tcIdCtr;
	my $tcname = shift;
	$tcIdCtr=1;
 	&createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"");
 	&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"<html><body><pre>\n");
find({ preprocess => sub {return sort @_;}, wanted=> sub {if (  ($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i) && ($File::Find::name =~ /$SvrTCNamePattern/i)  ) { # fix tcDesc tag related 
			$SvrTCName = $File::Find::name; 
			$SvrTCName =~ s/\/tc.pl//g;
	my $fileText = sprintf "%10s %s", "", &reportTC($tcname,"","History");  if ($fileText =~ /^\s*$/) { $fileText = " ";}
	$fileText = &sortOnDate($fileText); 
	if ($tcDesc[$tcIdCtr]) {;} else { $tcDesc[$tcIdCtr] ="tcDesc is unavailable. It will be updated in next \"list\"";}
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, " ---- TestCase $tcIdCtr: <a name=\"".&getTCName($tcname)."\"> ".&processProperty("",$SvrTCName, "get_tcDesc")."</a>----\n");
	if (defined $fileText) { ; } else { $fileText="";}
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, "$fileText") if ( $fileText !~ /^\s*$/) ;
	$tcIdCtr++;
		}
	 }}, "$SvrDrive/$SvrProjName");
 	&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"</pre></body></html>\n")				;
	$tcIdCtr = $tcIdCtr_;
}


sub reportTCHistory_old {
	my $tcIdCtr_ = $tcIdCtr;
	my $tcname = shift;
	$tcIdCtr=1;
 	&createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"");
 	&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"<html><body><pre>\n");
find({preprocess => sub {return reverse sort @_;}, wanted => sub { if (  ($File::Find::name =~ /tc.pl\s*$/) && ($File::Find::name =~ /$SvrDrive\/$SvrProjName\/$testcaseNode/i) && ($File::Find::name =~ /$SvrTCNamePattern/i)  ) { # fix tcDesc tag related 
			$SvrTCName = $File::Find::name; 
			$SvrTCName =~ s/\/tc.pl//g;
	my $fileText = sprintf "%10s %s", "", &reportTC($tcname,"","History");
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, " ---------------------- TestCase: <a name=\"".&getTCName($tcname)."\"> ".&getTCName($tcname)." </a>-----------------------\n");
	&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory, $fileText);
	$tcIdCtr++;
		}
	 }}, "$SvrDrive/$SvrProjName");
 	&appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtmlHistory,"</pre></body></html>\n")				;
	$tcIdCtr = $tcIdCtr_;
}

################################################################################
#	Subroutine Name : reportTC
#		Function: report TC results on STDOUT and Update TCProj HTML
#	Input Parameters: TC Name
#			  TC PropertyName = tcRunResult
#			  TC Report Type: 0 = latest 1 = historyical
#	Output/Returns  : TC Reports displayed on webUI
################################################################################
sub reportTC() {		# TC Report Function (TH:TC Report)
    my $tcPropertyPatternPattern_ = ".*"; ####################### Reset the tcPropertyPatternPattern for index.htm
    my $cmd=''; $cmd = shift; if ($cmd !~ /^\s*cmd\s*=/i) { unshift @_, $cmd; } ;
    my $timeSpan  = "2000!now"; 
    my $tcname          = $_[0]; my $propertyPattern = $_[1]; my $reportType = $_[2]; 
    $tcname = &getTCName($tcname);
    my ($timeSpanStart, $timeSpanEnd, $isInSpan, $beautifiedStr, $beautifiedStr4Web); 
    my $returnValue="";
    my ($propertyName, $startTime, $endTime, $comment1, $comment2) ;
    my $passCtr =0; my $failCtr = 0; my $nullCtr = 0 ; my $totalTime=0; my $avgResponseTime; my $propertyValue ='';
    my $totalTimeDummy; my $passFailDisplay=""; my $passFailDisplay_ =""; my $tcTags="";
	&readTestSuitProperty();
    if( $propertyPattern =~ /^\s*$/) {   $propertyPattern = 'tcRunResult';}
    if( $reportType =~ /^\s*$/) {   $reportType = 'lastValue';}

    if ($timeSpan) { $_ = $timeSpan;
 	    ($timeSpanStart, $timeSpanEnd ) = split( /!|\|/, $timeSpan );
 	    $timeSpanStart = &ParseDate($timeSpanStart);
 	    $timeSpanEnd   = &ParseDate($timeSpanEnd);
    }
     my $tcPassFailDisplayWidth = 0; 
#    ############ get maxPassFailDisplayWidth #################
#      open Fin, "$tcname/thProperty.txt" || die "Can't open file:$!"; 	################## Read Property File
#    ############################## Read Property File to update reportHtmlHistory ###########################
#         while ( $_ = <Fin> ) { chop;

local @ARGV ; 
my  $propertyFName = "$tcname/thPropertyLink.txt"; if (-e $propertyFName) { open Fin, $propertyFName; @_ = <Fin>; close Fin; foreach my $each (@_) { if (-e $each) { push @ARGV, $each."/thProperty.txt"; } } }
    $propertyFName = "$tcname/thProperty.txt"; push @ARGV, $propertyFName if (-e $propertyFName );
       while ( $_ = <> ) { chop;
          if ( $_ =~ /$propertyPattern/i ) {
                 ( $propertyName, $propertyValue, $startTime, $endTime, $totalTimeDummy, $comment1, $comment2) = split( '\|', $_);
                 my $flag1 = &Date_Cmp( &ParseDate($startTime), &ParseDate($timeSpanStart) );
                 my $flag2 = &Date_Cmp( &ParseDate($timeSpanEnd), &ParseDate($endTime) );
                  if   ( ( $flag1 >= 0 ) && ( $flag2 >= 0 ) ) { $isInSpan = 1; }
                  else                                        { $isInSpan = -1; }
 		my $date1=&ParseDate($startTime); my $date2=&ParseDate($endTime); my $delta=&DateCalc($date1,$date2); $delta =~ s/\+//g;
 		my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $delta;
 		my $totalSec = $D * 24 * 3600 + $H * 3600 + $MIN * 60 + $S;
 		if ($propertyValue =~ /^\s*[\d|.]+\s*$/) { $totalSec = $propertyValue; $propertyValue = "Perf";}
              if ( $isInSpan == 1 ) {;
 		 if ( $propertyPattern =~ /tcRunResult/i ) {
     			$tcPassFailDisplayWidth= $tcPassFailDisplayWidth + 1 ;
                 }  
   	     } # endif for InSpan
          }    # endif for /propertyPattern= tcRunResult/
          elsif ($_=~ /^\s*tcTags\s*\|(.+)\|?/) {
                 ( $propertyName, $propertyValue, $startTime, $endTime, $totalTimeDummy, $comment1, $comment2) = split( '\|', $_);
		$tcTags = $propertyValue;
	  }
     }		
     close Fin;
     if ($tcTags) {
     $tcTags =~ s/_//g; 
     $tcTags =~ s/\t//g;
     $tcTags =~ s/null/    /g;
     } 

    my $passFailDisplayWidth_1st= 0;
#    ############ get maxPassFailDisplayWidth #################
#    open Fin, "$tcname/thProperty.txt" || die "Can't open file:$!"; 	################## Read Property File
#    ############################## Read Property File to update reportHtmlHistory ###########################
#     while ( $_ = <Fin> ) { chop;
	
	      # local @ARGV ;  $propertyFName = "$tcname/thProperty.txt"; 		# Merge Ts 04/27/2013
	      # push @ARGV, $propertyFName if (-e $propertyFName );
  #$propertyFName = "$tcname/thPropertyLink.txt"; 
  #if (-e $propertyFName) { open Fin, $propertyFName; @_ = <Fin>; close Fin; foreach my $each (@_) { if (-e $each) { push @ARGV, $each."/thProperty.txt"; } } }
local @ARGV ; 
    $propertyFName = "$tcname/thPropertyLink.txt"; if (-e $propertyFName) { open Fin, $propertyFName; @_ = <Fin>; close Fin; foreach my $each (@_) { if (-e $each) { push @ARGV, $each."/thProperty.txt"; } } }
    $propertyFName = "$tcname/thProperty.txt"; push @ARGV, $propertyFName if (-e $propertyFName );
      while ( $_ = <> ) { chop;
         if ( $_ =~ /$propertyPattern/i ) {
                ( $propertyName, $propertyValue, $startTime, $endTime, $totalTimeDummy, $comment1, $comment2) = split( '\|', $_);
                my $flag1 = &Date_Cmp( &ParseDate($startTime), &ParseDate($timeSpanStart) );
                my $flag2 = &Date_Cmp( &ParseDate($timeSpanEnd), &ParseDate($endTime) );
                if   ( ( $flag1 >= 0 ) && ( $flag2 >= 0 ) ) { $isInSpan = 1; } else                                        { $isInSpan = -1; }
		my $date1=&ParseDate($startTime); my $date2=&ParseDate($endTime); my $delta=&DateCalc($date1,$date2); $delta =~ s/\+//g;
		my ($Y,$M,$W,$D,$H,$MIN,$S) = split /:/, $delta;
		my $totalSec = $D * 24 * 3600 + $H * 3600 + $MIN * 60 + $S;
		if ($propertyValue =~ /^\s*([\d|.]+)\s*$/) { $totalSec = $propertyValue; $propertyValue = "Perf"; $comment2 = "Perf Test = ${1}s";}
		if ($propertyValue =~ /null/i) 		   {                           ;                        ; $comment2 = "TC returns NULL";}
		if ($propertyValue =~ /pass/i) 		   {                           ;                        ; $comment2 = "Test Passed"  ;}
		if ($propertyValue =~ /fail/i) 		   {                           ;                        ; $comment2 = "Test Failed"  ;}
		if ($propertyValue =~ /bugF/i) 		   {                           ;                        ; $comment2 = "Failed BugID : <TBD>"  ;}
		if ($propertyValue =~ /expF/i) 		   {                           ;                        ; $comment2 = "Expected Fail"  ;}
		if ($propertyValue =~ /expected_f_a_i_l/i) {                           ; $propertyValue = "expF"; $comment2 = "Expected Fail"  ;}
             if ( $isInSpan == 1 ) {
		 if ( $propertyPattern =~ /tcRunResult/i ) {
		      $beautifiedStr = sprintf "%15s %-15s %-25s%-20s Note: %s", $propertyValue, $totalSec.'s', $startTime, $comment1, $comment2; # add comment2 for mouse-over display
		      if ($propertyValue =~ /pass/i) {$passCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."p";}
		      if ($propertyValue =~ /fail/i) {$failCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."f";}
		      if ($propertyValue =~ /mark/i) {          ; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."m";}
		      if ($propertyValue =~ /Perf/i) {          ; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."e";}
		      if ($propertyValue =~ /null/i) {$nullCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."n";}
		      if ($propertyValue =~ /expF/i) {$nullCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."x";}
		      if ($propertyValue =~ /bugF/i) {$nullCtr++; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."b";}
		      if ($propertyValue =~ /dumy/i) {          ;                                   ; $passFailDisplay = $passFailDisplay."d";}
		      #if ($propertyValue =~ /dumy/i) {$nullCtr++;                                   ; $passFailDisplay = $passFailDisplay."d";}
		      if ($propertyValue =~ /expected_F_a_i_l/i) {; $totalTime =$totalTime + $totalSec; $passFailDisplay = $passFailDisplay."x";}

		      if ($propertyValue =~ /pass/i) {                                                $passFailDisplay_ = $passFailDisplay_."p $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /fail/i) {                                                $passFailDisplay_ = $passFailDisplay_."f $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /mark/i) {                                                $passFailDisplay_ = $passFailDisplay_."m $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /Perf/i) {                                                $passFailDisplay_ = $passFailDisplay_."e $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /null/i) {                                                $passFailDisplay_ = $passFailDisplay_."n $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /expF/i) {                                                $passFailDisplay_ = $passFailDisplay_."x $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /bugF/i) {                                                $passFailDisplay_ = $passFailDisplay_."b $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /dumy/i) {                                                $passFailDisplay_ = $passFailDisplay_."d $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /expected_f_a_i_l/i) {  				      $passFailDisplay_ = $passFailDisplay_."x $startTime: ${comment2}_|_";}
		      if ($propertyValue =~ /pass|fail|mark|Perf|null|bugF|expF/i) { $passFailDisplayWidth_1st ++ ; }
		 } else { $beautifiedStr = $_; }    # endif for /tcRunResult/

                 if    ( $reportType =~ /history/i ) {   $returnValue = "$beautifiedStr\n$returnValue"; }
                 elsif ( $reportType =~ /lastValue/i ) {    $returnValue = $beautifiedStr; }
                 elsif ( $reportType =~ /forWeb/i ) { $returnValue .= $beautifiedStr4Web; }
	     } # endif for InSpan
         }    # endif for /propertyPattern/
    }									##################### 



    ############################## Adjust passFailDisplayWidth by _1st and max ###########################
 	if ( $passFailDisplayWidth < $passFailDisplayWidth_1st ) { $passFailDisplayWidth = $passFailDisplayWidth_1st;}
 	if ( $passFailDisplayWidth > $maxPassFailDisplayWidth  ) { $passFailDisplayWidth = $maxPassFailDisplayWidth ;}
    ############################## Read Property File to update reportHtmlHistory ###########################
    	if ($passCtr + $failCtr + $nullCtr == 0) {				##########  Generate TC webUI string 
	$avgResponseTime = 0; } else {
	$avgResponseTime = $totalTime / ($passCtr + $failCtr + $nullCtr); 
	}
	my $qtpHost; my $ATResultFname; my %color; my $color = 'gray'; my @color; my $colorIndex = 0; my $QASvrName; my $expFailure=""; my $bugFailure="";
	if ($propertyValue =~ /pass/i) { $color = "Green"; } elsif ($propertyValue =~ /fail/i) { $color = 'Red'; } elsif ($propertyValue =~ /bugF/i) {$color = "blue";}
	elsif ($propertyValue =~ /expected\s*fail/i) { $expFailure = "_Expected_Failure_ "; }

	$color[0]=1;

	##### testcase Desc #### 
	my $TCDesc_displayTip = "Click to view TC logs";
	my $TCDesc_display ; my $TCDesc_display_ ;
	if ($tsProperty{$tcname}) { 
		###### Handle expected failure 
		if (($tsProperty{$tcname} =~ /_expected_fail_/i) && ($propertyValue =~ /fail/i)){ $color = "Green"; }
		if (($tsProperty{$tcname} =~ /_expected_fail_/i) && ($propertyValue =~ /pass/i)){ $color = "Red"; }
		###### Handle expected failure 
		$TCDesc_display_ = $expFailure.$tsProperty{$tcname};

		my $TCDesc_display__ = $TCDesc_display_;

		$TCDesc_display__ =~ s/&lt;|&gt;|&amp;|&#37;|&#36;/X/g;

		my $n1 = ()  = $TCDesc_display_ =~ /&lt;|&gt;/g;
		my $n2 = ()  = $TCDesc_display_ =~ /&amp;|&#37;|&#36;/g;
		my $extra = $n1 * 3 + $n2 * 4 ; 

		my $webUI_TCDescWidth_extra = $webUI_TCDescWidth + $extra ;

		if (length($TCDesc_display__) <= $webUI_TCDescWidth ) { 
		$TCDesc_display = sprintf "%-${webUI_TCDescWidth}s", $TCDesc_display_; 
		} else {
		$TCDesc_display = sprintf "%-${webUI_TCDescWidth}s", substr $TCDesc_display_, 0, $webUI_TCDescWidth_extra; 
		$TCDesc_displayTip = $tsProperty{$tcname}; 
		}

	} else { $TCDesc_display = sprintf "%-${webUI_TCDescWidth}s", $tcname; }

	# prHtml3 mark for search

	my $tcSerialN = $TCDesc_display; 
	if ($tcSerialN =~ /^\s*\d+\D+/) {$tcSerialN =~ /^\s*(\d+)\D+/; $tcSerialN = "$1"; if ($tcSerialN) {;} else {$tcSerialN = "";}}
	my $dirRoot = &getRoot($tcname); 
	my $TCCtrToolTip = sprintf "Run Test (Testcase Number == $tcSerialN [%s])", &timeConvert($avgResponseTime); 
	my $TCCtrToolTipMin = sprintf "Run Tests (Testcase Number >= $tcSerialN)" ; 
	my $TCScrollAmount = 0; my $CtrSeparator = "|";
	$passFailDisplay  = &genPassFailDisplay ($passFailDisplay);
	$passFailDisplay = &genPassFailDisplay_ ($passFailDisplay_);


	my $stopTS    = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName Execution_from_cgi=$Execution_from_cgi;Execution_local_only=$Execution_local_only;exitTAFGracefullyString=$tcname;exitTAF')\" title=\"Stop Test (Testcase Number = $tcSerialN)\" >.</a>";
	my $runTS24_7 = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName Execution_from_cgi=$Execution_from_cgi;Execution_local_only=$Execution_local_only;drive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseExec=$dirRoot;ExecutionType=runTC;Execution_24_7=y;exec')\"  title=\"Exec Test 24/7 (Testcase Number == $tcSerialN)\"> ,</a>"; 
	my $runTCOnce = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName Execution_from_cgi=$Execution_from_cgi;Execution_local_only=$Execution_local_only;drive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseExec=$dirRoot;ExecutionType=runTC;exec')\"  title=\"$TCCtrToolTip\">></a>";
	my $runTSOnce = "<a href=\"${url}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName Execution_from_cgi=$Execution_from_cgi;Execution_local_only=$Execution_local_only;drive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;tcIdMin=$tcIdCtr;testsuit=$SvrProjName;ExecutionType=runTS;exec')\"  title=\"$TCCtrToolTipMin\"><marquee style=\"border:RED ${borderWidth}px ${borderStyle}\" width=48 direction=right behavior=alternate loop=10000 scrollamount=$scrollAmount>>\|</marquee></a>"; 
	my $html = sprintf( "<span style=\"color:black;\">$passFailDisplay${stopTS}$runTS24_7<font color=\"$color[$colorIndex]\"> $runTCOnce $runTSOnce</font><a href=\"${url}/$SvrProjName/".&getTCNameStr($SvrTCName)."/_tcLog.html\" title=\"$TCDesc_displayTip\">%-${webUI_TCDescWidth}s</a> <a href=\"${url}/$SvrProjName/${reportHtmlHistory}#$tcname\" title=\"Click to see Pass/Fail history\">%5d/%-5d</a> %6d(s)   $tcTags    <font color=\"white\"> %s </font></span>\n",
		    $TCDesc_display,
                    $passCtr,
                    $failCtr,
                    $avgResponseTime,
		    $tcname.'/tc.pl',
                );

	# http

	$stopTS    = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=Execution_from_cgi=y;Execution_local_only=$Execution_local_only;exitTAFGracefullyString=$tcname;exitTAF=_null__realSemi_tafRedirectory=${urlHttp}/$SvrProjName/$reportHtml_http\" title=\"Stop Test (Testcase Number = $tcSerialN)\" >.</a>";
	$runTS24_7 = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=Execution_from_cgi=y;Execution_local_only=$Execution_local_only;SysDrive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseExec=$dirRoot;ExecutionType=runTC;Execution_24_7=y;exec_realSemi_tafRedirectory=${urlHttp}/$SvrProjName/$reportHtml_http\"  title=\"Exec Test 24/7 (Testcase Number == $tcSerialN)\"> ,</a>"; 
	$runTCOnce = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=Execution_from_cgi=y;Execution_local_only=$Execution_local_only;SysDrive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseExec=$dirRoot;ExecutionType=runTC;exec_realSemi_tafRedirectory=${urlHttp}/$SvrProjName/$reportHtml_http\"  title=\"$TCCtrToolTip\">></a>";
	$runTSOnce = "<a href=\"${urlHttp}/${cgi_bin}$tafCGI?tafArgs=Execution_from_cgi=y;Execution_local_only=$Execution_local_only;SysDrive=$SvrDrive;tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;tcIdMin=$tcIdCtr;testsuit=$SvrProjName;ExecutionType=runTS;exec_realSemi_tafRedirectory=${urlHttp}/$SvrProjName/$reportHtml_http\"  title=\"$TCCtrToolTipMin\"><marquee style=\"border:RED ${borderWidth}px ${borderStyle}\" width=48 direction=right behavior=alternate loop=10000 scrollamount=$scrollAmount>>\|</marquee></a>"; 

	$stopTS =~ s/;/_semi_/g;  $stopTS =~ s/_realSemi_/$_realSemi_/g;	# todo: taf.cgi need to handle exitGracefully scenario
	$runTS24_7=~ s/;/_semi_/g; $runTS24_7=~ s/_realSemi_/$_realSemi_/g;
	$runTCOnce=~ s/;/_semi_/g; $runTCOnce=~ s/_realSemi_/$_realSemi_/g;
	$runTSOnce=~ s/;/_semi_/g; $runTSOnce=~ s/_realSemi_/$_realSemi_/g;

	my $html_http = sprintf( "<span style=\"color:black;\">$passFailDisplay${stopTS}$runTS24_7<font color=\"$color[$colorIndex]\"> $runTCOnce $runTSOnce</font><a href=\"${urlHttp}/$SvrProjName/".&getTCNameStr($SvrTCName)."/_tcLog.html\" title=\"$TCDesc_displayTip\">%-${webUI_TCDescWidth}s</a> <a href=\"${urlHttp}/$SvrProjName/${reportHtmlHistory}#$tcname\" title=\"Click to see Pass/Fail history\">%5d/%-5d</a> %6d{s}   $tcTags    <font color=\"white\"> %s </font></span>\n",
		    $TCDesc_display,
                    $passCtr,
                    $failCtr,
                    $avgResponseTime,
		    $tcname.'/tc.pl',
                );


		if ($cmd =~ /noprint/i) {;} else { 
			&appendtoFileUniq_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1, $html 		);
			&updateWeb1_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml, $html			);  

			&appendtoFileUniq_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http, $html_http); 
			&updateWeb1Http_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http, $html_http	); 
		 } 
     	close Fin;
     	if ($returnValue) {$returnValue =~ s/^\s*//g;} else {$returnValue = "";} 
     	return $returnValue;
}

sub genPassFailDisplay {
	my $str = shift;
	$str = reverse $str;	
	$str = $str. "                                                        ";	 
	$str = substr ($str, 0, $passFailDisplayWidth);
	$str =~ s/p/<a style=\"color:green\">*<\/a>/g;
	$str =~ s/f/<a style=\"color:red\">*<\/a>/g;
	$str =~ s/m/|/g;
	if ($str =~ /^\s*$/) { $str = &genStr($passFailDisplayWidth);}
	return $str; 
}

sub genPassFailDisplay_ {
	my $str = shift; my $str_ =""; my $strLenCtr=0; my $mark4One=0;
	@_ = split /_\|_/, $str; $str="";
	for (my $i=$#_; $i >= 0; $i--) { 
		my $tcResult ; 
		if( $_[$i] =~ s/^\s*(\w)\s+//g) {
			$tcResult = $1; $str_ = $_[$i];  $strLenCtr++;
			if ($tcResult =~ /p/i)    { $str = $str."<a style=\"color:green\" title=\"$str_\">*<\/a>"; }
			elsif ($tcResult =~ /f/i) { $str = $str."<a style=\"color:red\" title=\"$str_\">*<\/a>";   }
			elsif ($tcResult =~ /m/i) { 
				#if ($mark4One == 2) { ; } else {
				$str = $str."<a style=\"color:black\" title=\"$str_\">$markSymbol<\/a>"; 
				#$mark4One = 0; 
			}

			elsif ($tcResult =~ /b/i) { $str = $str."<a style=\"color:blue\" title=\"$str_\">*<\/a>"; }
			elsif ($tcResult =~ /e/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">.<\/a>"; }
			elsif ($tcResult =~ /n/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">.<\/a>"; }
			elsif ($tcResult =~ /x/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">*<\/a>"; }
			elsif ($tcResult =~ /d/i) { $str = $str."<a style=\"color:black\" title=\"$str_\"> <\/a>"; }
			elsif ($tcResult =~ /_/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">.<\/a>"; }
		}
			$mark4One++; 
		if ($strLenCtr + 1 > $passFailDisplayWidth) { return $str; }
	} 
	if ($strLenCtr < $passFailDisplayWidth) { for (my $i = $strLenCtr; $i < $passFailDisplayWidth; $i++) { $str = $str . "<a style=\"color:black\"> <\/a>"; } }
	return $str; 
}

sub genPassFailDisplay_old {
	my $str = shift; my $str_ =""; my $strLenCtr=0;
	@_ = split /_\|_/, $str; $str="";
	for (my $i=$#_; $i >= 0; $i--) { 
		my $tcResult ; 
		if( $_[$i] =~ s/^\s*(\w)\s+//g) {
			$tcResult = $1; $str_ = $_[$i];  $strLenCtr++;
			if ($tcResult =~ /p/i)    { $str = $str."<a style=\"color:green\" title=\"$str_\">*<\/a>"; }
			elsif ($tcResult =~ /f/i) { $str = $str."<a style=\"color:red\" title=\"$str_\">*<\/a>";   }
			elsif ($tcResult =~ /m/i) { $str = $str."<a style=\"color:black\" title=\"$str_\">|<\/a>"; }
		}
		if ($strLenCtr + 1 > $passFailDisplayWidth) { return $str; }
	} 
	if ($strLenCtr < $passFailDisplayWidth) { for (my $i = $strLenCtr; $i < $passFailDisplayWidth; $i++) { $str = $str . "<a style=\"color:blank\"> <\/a>"; } }
	return $str; 
}

sub genStr { my $strLen = shift; my $return=""; for (my $i = 0; $i < $strLen; $i++) { $return  .= " "; } $return; }

sub processTSs{
	shift;
 	my $each = shift;
		if ($each !~ /=/) {
			if ($each =~ /\bmarkblablaaaaa\b/i) { 							;
			} else  {
				; 
 				#print "pd: $SvrProjName,  $each\n"; my $str =  "\&$each();"; my $rst = eval $str; next				;  
			}
		} else {
			$each =~ /^\s*(\S+)\s*=\s*(\S+)\s*/; my $varName = $1; my $varValue = $2		;
			if (($varName !~ /^\s*$/) && ($varValue !~ /^\s*$/)) {
				if ($varName =~ /\bcreate\b/i) { &createTS($varValue); }
				elsif ($varName =~ /\badd\b/i) 	{ &addTS($varValue); }
				elsif ($varName =~ /\bdelete\b/i) { &deleteTS($varValue); }
				elsif ($varName =~ /\bcheckStatus\b/i) { &checkStatusTS($varValue); }
				else {
					print "Unrecognized Testsuite Command: $varName\n"; 		
				}
			}
		}
}

sub checkStatusTS {
	; # print "pass a: ".shift."\n";
}
sub processTCs{
	shift;
	my $isBatchProcessing = 1;
	my $tmp = shift;
	if (defined $tmp ) {;} else { return; }
	@_ = split /;/, $tmp;
	&genDriver_taf_pl ();
	&genDriver_taf_cgi ();
		&appendtoFile($commandLogName, "\n".&UnixDate( "now", "%m/%d/%Y %H:%M:%S %Z")."> ");
		&appendtoFile($commandLogName,"$c/$_TAF/$taf ");
	foreach my $each (@_) {
		#### uncomment for debugging   print " cmd> $each\n";
		&appendtoFile($commandLogName,$each.";");
		if ($each !~ /=/) {
			$isBatchProcessing = 0;
			if (($each =~ /\blistVars\b/i) || ($each =~ /\bgetVars\b/i)) { return &printGlobalVars();
			} elsif ($each =~ /\bprintVars\b/i) { print &printGlobalVars(); next 			;
			} elsif ($each =~ /\bexec\b/i) { 							;
				&setGlobalVars("","tcOP=exec")							;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\blistTcFilters|printTcFilters\b/i) { 				;
				&setGlobalVars("","tcOP=listtcfilters")						;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\blist\b/i) { 							;
				&setGlobalVars("","tcOP=list")							;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\blistHistory\b/i) { 						;
				&setGlobalVars("","tcOP=listHistory")						;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\bmark\b/i) { 							;
				&setGlobalVars("","tcOP=mark")							;
				$isBatchProcessing = 1								;
			} elsif ($each =~ /\blistAll\b/i) { 							;
			 	$SvrTCNamePattern =".*";  &listAll()						; 
				$isBatchProcessing = 0								;		
			} elsif ($each =~ /customer1/i) {
				&customer1();
			} else  {
				my $str =  "\&$each();"; 
				my $rst = eval $str; 
				if ($rst) { 
					print "\`$each\` = \"$rst\"\n" if ($pr2Screen == 1);
			       
				} else { print "\`$each\` is not a TAF command."; }
				next;  
			}
		} else {
			if ( $each =~ /^\s*(\S+)\s*=\s*(\S+)\s*/ ) {
				$each =~ /^\s*(\S+)\s*=\s*(\S+)\s*/; my $varName = $1; my $varValue = $2		;
				if (($varName !~ /^\s*$/) && ($varValue !~ /^\s*$/)) {
					if ($varName =~ /propertyOp/) { $isBatchProcessing = 1; } else { $isBatchProcessing = 0;} # 1 for propertyOp
					if (&setGlobalVars ("","$varName=$varValue;") == 1 ) 				    { ; } # Process value assginment
					else { my $rst = &processTC("",$each) 			; 				} # Process TC
				}
			} else { next; } 
		}
	if ($isBatchProcessing == 1) { if ($Execution_24_7 !~ /y/i) {$NofExecutionCtrExec=0}; $NofExecutionCtr = 0;  &tcLoop();}		# NofExecutionCtr reset for each list/exec
	} 

}

################################################################################
#	Subroutine Name : process Test Case
#		Function: wrapper for Test Case management functions
#	Input Parameters: PropertyOP
#	Output/Returns  : tcName and propertyO/proc
################################################################################
sub processTC {
	    my $tcname; my $cmd="";
	    shift; my $tcOP= ''; $tcOP = shift if (@_); 
	    my $prMsg = '' ; $prMsg= shift if @_;
	    $tcOP =~ /\s*([\w|\d]+)\s*(=)?\s*(\w+)?\s*([;|\/])?(\s*\S+\s*)?/;  
	    $tcOP = $1; $tcname = $3; $cmd = $5; $prMsg = $pr2Screen;
		if ($cmd) {$cmd =~ s/\n//g;} else { $cmd ="";}
	    ######## This is for TCs processing (Batching)
		if ($tcOP =~ /\blistAll\b/i) {
			# SvrTCName as a regExp
			if ($tcname =~ /^\s*$/) { $SvrTCNamePattern =".*";} else { $SvrTCNamePattern = $tcname; } 
			&listAll(); 
			return; 
			}
	    ######## The following are for TC processing 	    
 	    if ((defined $tcname) && ($tcname =~ /^.$/) && ($cmd =~ /:[\\|\/]/)) {
 			$tcname = $tcname.$cmd; # handle -s delete=c:\_ts1_
 	    }
	    $tcname =  &getTCName($tcname); 

	    if ((-e $tcname)||($tcOP =~ /create/i)) { printf "%-20s %-40s ", "processTC:", $tcname   if (($outputFormat =~ /text/i) && ($pr2Screen ==1)) ; } # print for webUI 1/2

	    # printf "%-20s %-40s ", "processTC:", $tcname   if (($outputFormat =~ /text/i) && ($pr2Screen ==1)) ; # print for webUI 1/2
	    my $tmp = sprintf "%-20s %-40s\n", "processTC: ", $tcname   ;
 	    &appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'."_listHistory.txt", "$tmp");
	    my $rst; 

	    if ( $tcOP =~ /^\s*create/i ) {
		    if ($cmd) { $rst = &createTC("cmd=$cmd",$tcname); }
		    else { $rst = &createTC($tcname); }
            } elsif ( $tcOP =~ /^\s*exec\b/i ) {
		    if ($NofExecutionCtr== 1 ) {$rst = &markTC_($tcname);}
		    $rst = &execTC_($tcname);
		    my $rst1 = &mapTC($tcname);
            } elsif ( $tcOP =~ /^\s*mark\b/i ) {
		    $rst = &markTC_($tcname);
            } elsif ( $tcOP =~ /^\s*execAll/i ) {
		    $rst = &tcLoop();
		        return $rst;
            } elsif ( $tcOP =~ /^\s*UpdateWeb/i ) {
		    if (defined $cmd) {;} else { $cmd = 0;}
		    $rst = &updateWeb_($tcname,$cmd);
	    } elsif ( $tcOP =~ /^\s*getWeb_/i ) {
		    $rst = &getWeb_($tcname);
            } elsif ( $tcOP =~ /^\s*log/i ) {
		    $rst = &logTC($tcname);
            } elsif ( $tcOP =~ /^\s*detect/i ) {
		    $rst = &detectTC($tcname, $SvrProjName, $SvrDrive); 
            } elsif ( $tcOP =~ /^\s*getLogName/i ) {
		    $rst = &getTCLogFname(&getTCName($tcname)); 
	    } elsif ( $tcOP =~ /^\s*listTCFilters/i ) {
		    $rst = &getProperties(&getTCName($tcname) , '.*_all_', 'latest');
	    } elsif ( $tcOP =~ /^\s*printtcFilters/i ) {
		    $rst = &getProperties(&getTCName($tcname) , '.*_all_', 'latest');
            } elsif ( $tcOP =~ /^\s*listHistory/i ) {
		    $rst = &getProperties(&getTCName($tcname) , 'tcRunResult', 'history');
            } elsif ( $tcOP =~ /^\s*printResult/i ) {

	    } elsif ( $tcOP =~ /^\s*list|get\b/i ) {
		    $rst = &getProperties(&getTCName($tcname) , 'tcRunResult', 'last');	   # return last valid TC result
		    my $rst1 = &mapTC($tcname);
            } elsif ( $tcOP =~ /^\s*delete/i ) {
		    $tcOP =~ s/^\s*delete\s*=//g;
		    $tcOP =~ s/\s*$//g;
		    $rst = &deleteTC($tcname);
            } else {
		    if ( -e $tcname ) {
		    print "<- Test suite \n" if $prMsg;
	    		}	
		return "_noProcessedTC_";
	    }
	     	printf "%s\n",  $rst  if (($outputFormat =~ /text/i)&&($pr2Screen == 1)) ; # print for webUI 2/2
 	        &appendtoFile_($SvrDrive.'/'.$SvrProjName.'/'."_listHistory.txt","$rst\n")				;
	 	$rst = sprintf "%-20s %-40s %s", "processTC:", $tcname,  $rst ;
		return $rst;
}

sub Queue {					# &Queue(push,"pushedContenet")  $rst = &Queue(pop)
	shift;
	my @pushQueue; my @popQueue; $#pushQueue=0, $#popQueue=0;
	my $operation = "push"; $operation = shift if @_;
	my $tafCmd = shift; 
	my $pushQueueSize; my $queueLength=0; my $queueSize=0;

	################# Set/release/check Lock ###################
	if ($operation =~ /setLock/i) {
		open Fin, ">$lockFName"; print Fin "lock is ON\n"; close Fin; return; 
	} elsif ($operation =~ /releaseLock/i) {
		unlink $lockFName; 
	} elsif ($operation =~ /checkLock/i) {
		if (-e $lockFName) { return 1;} 
		else { return 0; }
	}
	################# Set/release/check Lock ###################
	if (-e "$c/$_TAF/$queueFName") {;} else { open Fout, ">$c/$_TAF/$queueFName"; close Fout ; }
	open Fin, "$c/$_TAF/$queueFName" ;
	while ($_ = <Fin>) {
		if ($_ =~ /^\s*(pushed|poped)\s*\((.+)\):\s*(.+)\s*$/) {
			my $status = $1; my $index = $2; my $content = $3;
			if ($status =~ /pushed/) { $pushQueue[$index] = $content;}
			if ($status =~ /poped/ ) { $popQueue[$index] = $content;}
		}
	}
	close Fin;

	################# generate Active Queue & update Queue Operation ###################
 	if (($#popQueue < $#pushQueue ) || ($operation =~ /updateQueue/i)) { open Fin, ">$c/$_TAF/${queueFName}_active"; 
 		for (my $i = $#popQueue+1; $i<=$#pushQueue; $i++) { printf Fin "[%5d] %s\n", $i, $pushQueue[$i] if (defined $pushQueue[$i]);  }
		if ($#popQueue+1 > $#pushQueue) { print Fin "No task to proceed\n";}
 		close Fin;  }
	################# generate Active Queue & reset Queue Operation ###################
 	if (($#popQueue < $#pushQueue ) || ($operation =~ /reset/i)) { open Fin, ">$c/$_TAF/${queueFName}_active"; 
 		for (my $i = $#popQueue+1; $i<=$#pushQueue; $i++) { printf Fin "[%5d] %s\n", $i, $pushQueue[$i] if (defined $pushQueue[$i]);  }
		if ($#popQueue+1 > $#pushQueue) { print Fin "No task to proceed\n";}
 		close Fin;  }

	################# autoReset Operation ###################
	if (($#popQueue > $queueSizeLimit ) || ($operation =~ /reset/i)) { open Fin, ">$c/$_TAF/$queueFName"; close Fin; return; }
	
	$pushQueueSize = $#pushQueue + 1;
	################# QueueSize ###################
	if ($operation =~ /queueSize/i) {
		return ($#pushQueue - $#popQueue); 	
	}

	################# Push Operation ###################
	if ($operation =~ /push/i) { 

		if (defined $tafCmd) {
		if (($tafCmd =~ /set_property[1-2]/i) || ($tafCmd =~ /get_property[1-2]/i) || ($tafCmd =~ /printTcFilters/i)) { ;
		} else {
		open Fin, ">>$c/$_TAF/$queueFName"; print Fin "pushed ($pushQueueSize): $tafCmd\n"; close Fin; 
		return; 
		}
		}
	}

	################# Pop Operation ###################
	elsif ($operation =~ /pop/i) {
		for (my $i = 1; $i <= $#pushQueue; $i++ ) { 
			if  (defined $popQueue[$i] ) { ; } else {	# already popped
				if ((defined $pushQueue[$i]) && ($pushQueue[$i] !~ /_notPushed_ignored/i)) {
					open Fin, ">>$c/$_TAF/$queueFName"; print Fin "poped  ($i): $pushQueue[$i]\n"; close Fin;
					return $pushQueue[$i];
				} else {
					open Fin, ">>$c/$_TAF/$queueFName"; print Fin "poped  ($i): _notPushed_ignored\n"; close Fin;
					return "_notPushed_ignored";
				}
			}
		} 
	} 
	################# check Operation ###################
	elsif ($operation =~ /checkQueue/i) { 
		for (my $i = 0; $i <= $#pushQueue; $i++ ) { 
			if  (defined $popQueue[$i] ) { ; } else {	# already popped
				return $pushQueue[$i];
			}
		}
	}

}

sub listAll { 
	find({preprocess=> sub {return reverse sort @_;}, wanted=> \&recursiveSearchListAll}, $SvrDrive); }
sub recursiveSearchListAll() { 
	if (($File::Find::name =~ /tc.pl/) && ($File::Find::name =~ /$SvrTCNamePattern/i))
	{	
		print "$File::Find::name\n"; 
	
	}
}

sub createTS {		# Create Testsuite for Testbed 

	if ($SvrProjName !~ /$c/i) { print "Warning: testcase should start with $c\n"; }
	my $tsName = $SvrProjName; $tsName = shift if @_;
	$SvrProjName = $tsName; if (-e $SvrProjName) {;} else { mkdir $SvrProjName; }
	if (-e "$c/$_TAF/$createTS_indexindex" ) {
		print " --> Create $SvrProjName    <- from $c/$_TAF/$createTS_indexindex\n"; 
		copy ("$c/$_TAF/$createTS_indexindex", "$SvrProjName/$createTS_indexindex");
		print "$SvrProjName/$createTS_indexindex is running ......\n";
		my $rst = `$perl $SvrProjName/$createTS_indexindex`;
		print "$SvrProjName/$createTS_indexindex is completed.....\n";
	} elsif (-e "$c/$_TAF/$createTS_index" ) {
		print " --> Create $SvrProjName    <- from $c/$_TAF/$createTS_index\n"; 
		move ("$c/$_TAF/$createTS_index", "$SvrProjName/$TSHookNameGenerated");
	} elsif ($SvrProjName =~ s/_powershell_//i)  { 
		print " --> Create Powershell Testsuite: $SvrProjName\n"; &generatePowershell_ps1_template($SvrProjName); 
	} elsif ($NofTCinTSTemplate != -1 ) {
		&createTS_B($SvrProjName);
	} else { 
		print " --> Create Perl Testsuite: $SvrProjName\n";       &generatePerl_pl_template($SvrProjName); 
	}
	&generateTAFTestsuite ();
1;
}
sub addTS {
	my $tsName = "_testsuite_"; $tsName = shift if @_;
	if (-e $tsName) { print " --> Add Testsuite Hook : $tsName \n"; return 0; } 
	else { print "[Warning] Testsuite ($tsName) doesn't exist. No testsuite hook is added\n";
	return 1;}
}



sub deleteTS { goto &deleteTAFTestsuite }
sub updateTS {goto &listTS}
sub listTS   {
	my $tsName = $SvrProjName; $tsName = shift if @_;
	$SvrProjName = $tsName;
	&processTCs ("","tcDelay=0;performanceMode=fast;testcaseNode=$testcaseNode;testsuite=$SvrProjName;AutomationtsName=$SvrProjName;list"); 
	return 1;
}


sub createTS_B {	# $NofTCinTSTenplate is a global var
	my $cmd = $SvrProjName; my $tcDir = "c:/_TAF";
	if (-e $cmd) {;} else { mkdir $cmd; }
	mkpath $cmd;
	open Fout, "> $cmd/index.pl";
	my $tsNameTmp =	&getRoot($cmd);

my %tcDesc; my %tcExec;
for (my $i = 1; $i <= $NofTCinTSTemplate; $i++) {
	$tcExec{"$i"}="	if (\$ARGV[0] == $i) { print \\\"pass\\\"; } # <<< plug in the test case 1 here e.g. print `index.pl 1` ; >>>";
	$tcDesc{"$i"}=" $i Test case Desc for TC$i";
}

print Fout <<EOF;
#!/usr/bin/perl.exe
\$tcName = "$tsNameTmp";
 if (\$^O =~ /win32/i) { \$_TAF = "c:"; } if (\$^O =~ /linux/i) { \$_TAF = "/tmp/var/www/cgi-bin"; }
 \$tcDir = "\$_TAF/\$tcName";

 if (\$ARGV[0]) {
        open Fout, ">\$tcDir/_tcLogAppend.txt";

EOF

my $ctr = 1;
foreach my $each (sort {$a <=> $b} keys %tcExec) { print Fout "if (\$ARGV[0] == ".$ctr++.") \{print Fout \"$tcExec{$each}\"; print \"null\";\}\n"; }

print Fout <<EOF;
        close Fout;
        } else {

EOF
print Fout "\nprint<<EOF;\n";

   $ctr = 1;
foreach my $each (sort {$a <=> $b} keys %tcDesc) { print Fout $ctr++.". $tcDesc{$each}\n"; }

print Fout "EOF\n}\n";

close Fout;
print " -> $cmd/index.pl\n";
}


sub createTC {
	my $tc_pl="tc.pl"; my $cmd=''; $cmd = shift; 
	if ($cmd =~ /^\s*$/) { print "Warning: createTC lack the cmd. \n"; exit; }
	if ($cmd !~ /^\s*cmd\s*=/i) { unshift @_, $cmd; } ;
	my $tcNameRoot = "@_"; my $sleep = 0;
	if ($cmd =~ /sleep\s*=\s*(\d+)/ ) { $sleep = $1; }
	my $tcName = &getTCName("@_");
	if( &detectTC($tcName) =~ /exists/ && ($cmd !~ /Over/i) && ( $overWriteTC =~ /n/i)) { # overwrite
		return "\n\tWarning $tcName already exist! (use -create;cmd=overwrite to overwrite)" ; } 
	else {
		mkpath($tcName);
		######################## tc.hta ##########################
	@_ = split "\/", $tcName;
	my $testsuite = $_[2]; my $testcase  = $_[3]; 
	my $now = &UnixDate(&DateCalc("now","+ 6 seconds") , "%H:%M:%S" );

	if ($testsuite) {;} else { print "[Info] \$testsuite is null. Note \$tcName = $tcName\n"; $testsuite ="";}
	if ($testcase ) {;} else { print "[Info] \$testcase  is null. Note \$tcName = $tcName\n"; $testcase = "";}

	my $tcNameIIS = $tcName; 
	if ($tcNameIIS) {;} else { print "[Info] \$tcName is null, \$tcNameIIS = $c.':/inetpub/wwwroot/'\n"; $tcNameIIS = $c.':/inetpub/wwwroot/';}
	&createFile( $tcNameIIS.'/'.'tc.hta', 
"
<html>
<head>
	<script language=\"JavaScript\">
		function RunFileHTTP(testsuite, testcase) {
//			alert(\"testsuite is \" + testsuite + \" testcase is \" + testcase );
			 WshShell = new ActiveXObject(\"WScript.Shell\");
		    	 cmd= '$c\\\\windows\\\\system32\\\\schtasks.exe /delete /tn TAF_'+ testsuite + '_' + testcase + ' /f'; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
			 cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /create /TR \"$c\\\\$_TAF\\\\taf.pl testsuit='+testsuite+';testcaseExec='+testcase+';exec\" /TN TAF_'+testsuite+'_'+testcase+' /sc monthly /mo 1 /F'; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
    		  	 cmd= '$c\\\\windows\\\\system32\\\\schtasks.exe /run /tn TAF_'+testsuite+'_'+testcase; 
			sleep (1000);
 //alert (cmd);
			 WshShell.Run(cmd, 1, false);
		}

	function sleep(milliseconds) {
	  var start = new Date().getTime();
	  for (var i = 0; i < 1e7; i++) {
	    if ((new Date().getTime() - start) > milliseconds){
	      break;
	    }
  	}
}


// <a onclick=\"RunFileHTTP(\'$testsuite\', \'$testcase\')\">Click this to run Run Program</button> <p>
	</script>
</head>
<body onLoad =\"RunFileHTTP(\'$testsuite\', \'$testcase\')\">Run $testsuite\/$testcase\/tc.hta</button> <p>
</body>
</html>
"
 			);

		######################## tc.hta ##########################

		if ($cmd =~ /\bPerf\b/i) {  					# PerformanceTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"1234567.89\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bExpectedFail\b/i) { 				# ExpectedFailedTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"Expected_f_a_i_l\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bexpF\b/i) { 					# ExpF for ExpectedFailedTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"expF\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bbugF\b/i) { 					# ExpF for ExpectedFailedTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"bugF\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bFail\b/i) { 					# FailedTC
		&createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"fail\\n\"; sleep $sleep; ");
		} elsif ($cmd =~ /\bcustomTC\b/i) { 				# CustomTC
			$cmd=~ /customTC:\s*(.+)\s*:customTC/; $cmd =$1; if (defined $cmd) {;} else { $cmd="";} $cmd =~ s/_space_/ /;
		if ($cmd =~ /ps1\b/) {									# Powershell plugin
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
use File::Copy;\n\$| = 1;
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"".&getDir($cmd)."\/_tcLogAppend.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"".&getDir($cmd)."\/_tcLogAppend_.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"".&getDir($cmd)."\/_tcLogAppend__.bak\");}
print `powershell -executionpolicy unrestricted -file $cmd $ps1_args`;  # custom TC tc.pl 
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"$tcName\/_tcLogAppend.txt\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"$tcName\/_tcLogAppend_.txt\");}
if (-e \"$externalLogName\") {copy(\"$externalLogName\", \"$tcName\/_tcLogAppend__.txt\");}
"
			);
			###########
			} elsif (($cmd =~ /pyanvil/i) &&( $tc_pl =~ /index_pyAnvil\.pl/i)) { 		# pyAnvil plugin
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
use File::Copy;\n\$| = 1;
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"".&getDir($cmd)."\/_tcLogAppend.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"".&getDir($cmd)."\/_tcLogAppend_.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"".&getDir($cmd)."\/_tcLogAppend__.bak\");}
print `$perl_ $cmd $ps1_args`; 	# tc.pl
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"$tcName\/_tcLogAppend.txt\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"$tcName\/_tcLogAppend_.txt\");}
if (-e \"$externalLogName\") {copy(\"$externalLogName\", \"$tcName\/_tcLogAppend__.txt\");}
#if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"$tcName\/_tcLogAppend__.txt\");}
"
			);
			###########
			#} elsif  ($cmd =~ /\S+\.pl\s*/) { 						# perl plugin 
			} elsif  ($cmd =~ /\S+\.pl\b/) { 						# perl plugin 
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
use File::Copy;\n\$| = 1;
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"".&getDir($cmd)."\/_tcLogAppend.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"".&getDir($cmd)."\/_tcLogAppend_.bak\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"".&getDir($cmd)."\/_tcLogAppend__.bak\");}
print `$perl_ $cmd`;  # $c/$_TAF/index.pl
if (-e \"".&getDir($cmd)."\/_tcLogAppend.txt\"  ) {move(\"".&getDir($cmd)."\/_tcLogAppend.txt\" , \"$tcName\/_tcLogAppend.txt\");}
if (-e \"".&getDir($cmd)."\/_tcLogAppend_.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend_.txt\", \"$tcName\/_tcLogAppend_.txt\");}
if (-e \"$externalLogName\") {copy(\"$externalLogName\", \"$tcName\/_tcLogAppend__.txt\");}
#if (-e \"".&getDir($cmd)."\/_tcLogAppend__.txt\" ) {move(\"".&getDir($cmd)."\/_tcLogAppend__.txt\", \"$tcName\/_tcLogAppend__.txt\");}
"
			);
			###########
			} elsif ( $cmd =~ /taftestcase1/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
\$| = 1; 
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue1_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=get_property1`;
if ( \$rst =~ /propertyValue1/) { print \"pass\\n\";} else {print \"fail\\n\";}
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue0_doit_`;
"
			);
			###########
				;
			} elsif ( $cmd =~ /taftestcase2/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
\$| = 1; 
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue1A_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=get_property1`;
if ( \$rst =~ /propertyValue1A/) { print \"pass\\n\";} else {print \"fail\\n\";}
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue0_doit_`;
"
			);
			###########
				;
			} elsif ( $cmd =~ /taftestcase3/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
\$| = 1; 
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property2_as_propertyValue2_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=get_property2`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=get_property2`;
if (( \$rst =~ /testcase1/) && (\$rst =~ /testcase2/) && (\$rst =~ /property2\\s*=\\s*propertyValue2/)) { print \"pass\\n\";} else {print \"fail\\n\";}
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue0_doit_`;
"
			);
			###########
				;
			} elsif ( $cmd =~ /taftestcase4/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"#!$perl_
\$| = 1; 

\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property2_as_propertyValue1_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property2_as_propertyValue2_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property2_as_propertyValue2A_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOP=set_property1_as_propertyValue1A_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}printTcFilters`;
if (( \$rst =~ /property1\\s+propertyValue1A/) && (\$rst =~ /property2\\s+propertyValue2A/))  { print \"pass\\n\";} else {print \"fail\\n\";}

\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property1_as_propertyValue0_doit_`;
\$rst = `$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=_testcase2_${deli}propertyOP=set_property2_as_propertyValue0_doit_`;
"
			);
			###########
				;
			} elsif ( $cmd =~ /powershellTC/) {
			###########
			&createFile( $tcName.'/'.$tc_pl, 
"
"
			);
			###########
				;
			} else {
				;
			}
		} else {
			 &createFile( $tcName.'/'.$tc_pl, "\$| = 1; print \"pass\\n\"; sleep $sleep; ");
		}
        	&createPropertyTemplate($tcName);

		my $tmp =<<EOF;
open Fout, '>$tcName/_tcLogAppend.txt';
#!/usr/bin/perl
print Fout "* This is the content of TC log file\\n";
print Fout "* TC Log can has URL (file:///) pointed to <a href=\\"file:////$c/$_TAF/_blabla.html\\" >File Archieve</a> _url_line_ \\n";
print Fout "* TC Log can has URL (file:///) pointed to <a href=\\"file:////$c/$_TAF/_testsuite2_/testcase0002/_tcLog.html\\" >Another TC's Log _url_line_ </a>\\n";
print Fout "* TC Log can has URL (file:///) pointed to <a href=\\"file:////$c/$_TAF/index.htm\\" >TAF</a> _url_line_ \\n";
print Fout "* TC Log can has URL (http:///) pointed to <a href=\\"$urlHttp/_blabla.html\\" >File Archieve</a> _url_line_ \\n";
print Fout "* TC Log can has URL (http:///) pointed to <a href=\\"$urlHttp/_testsuite2_/testcase0002/_tcLog.html\\" >Another TC's Log _url_line_ </a>\\n";
print Fout "* TC Log can has URL (http:///) pointed to <a href=\\"$urlHttp/index.htm\\" >TAF</a> _url_line_ \\n";
print Fout "* TC Log can has special characters like Dollor \\\$, Percentage \\\% AT \\\@ \\n";
print Fout "* TC Log can display (add _url_line_ in the line) URL http://localhost$http_port   _ url_line_line	_url_line_ (_url_line_ indicates a real url. Not translation will be done.)\\n";
print Fout "* TC Log can parse log (*.txt) in log $c/$_TAF/_testLog.txt and add its Http and File links.\\n";
close Fout;
exit;
EOF
		if (($cmd =~ /genLog/i) || ($cmd =~ /addLog/i)) {&appendtoFile( $tcName.'/'.$tc_pl, $tmp) ; undef $tmp; }
	$tcName =~ s/\\\\/\\/g; # todo \\

	return "is created";
	}
}


sub execTC {
	my $tcName = &getTCName(@_); my $timeStart = &getDate(); my $rst=''			; 
	if  ( -e "$tcName/tc.pl" ) {
		my $cmd     = "$tcName/tc.pl"; $rst     = `$cmd`; my $timeEnd= &getDate()	; 
	       $rst =~ /(pass|fail|bugF|expF|todo|[\d|.]+)$/i; $rst = $1; 
	       if ($rst) {;} else {$rst = "null";} 
	       if (($rst =~ /Expected_f_a_i_l/i) || ($rst =~ /null/i)) { sleep 10; }
	       $rst =~ s/^\s*0+//g;
	       my $rstStr = sprintf "%20s|%10s|%s", "tcRunResult",$rst , $timeStart		;
	       $rstStr .= "|"; $rstStr .= "$timeEnd"; $rstStr .= "|"; $rstStr .= "0:0:0:0s"; $rstStr .= "|"; 
	       if ( $rst =~ /^\s*[\d+|\.]+\s*$/ ) { $rstStr .= "Performance Test ($rst) "; } 
	       else { $rstStr .= "Functional Test ($rst) "; } 
	       $rstStr .= '|comment2'; 
	       &addProperty(&getTCName($tcName), "add=$rstStr");
	       return $rst;
       } else {
	       return "tcName: $tcName doesn't exist.\n";
       }
}

sub dumyTC_ {	# create a dumy tc result 
	my $tcName = &getTCName(@_);
	my $timeStart = &getDate(); my $rst=''; 
	if  ( -e "$tcName/$tc_pl" ) { 
		my $cmd     = "$tcName/$tc_pl"; $rst = "dump"; 
		my $timeEnd= &getDate(); 
	       $rst = "dumy";
	       if ($rst) {;} else {$rst = "null";}
	       my $rstStr = sprintf "%20s|%10s|%s", "tcRunResult",$rst , $timeStart;
	       $rstStr .= "|"; $rstStr .= "$timeEnd"; $rstStr .= "|"; $rstStr .= "0:0:0:0s";
	       $rstStr .= "|"; 
	       $rstStr .= "Functional Test ($rst) ";
	       $rstStr .= '|'.$tcComment2; 
	       &addProperty(&getTCName($tcName), "add=$rstStr");
	       return $rst;
       } else {
		return "tcName: $tcName doesn't exist.\n";
       }
}


sub markTC_ {
	my $tcName = &getTCName(@_);
	my $timeStart = &getDate(); my $rst=''; 
	if  ( -e "$tcName/$tc_pl" ) { 
		my $cmd     = "$tcName/$tc_pl"; $rst = "mark"; # $rst     = `$cmd`; 
		my $timeEnd= &getDate(); 
	       $rst =~ /(mark|pass|fail|bugF|expF|todo|[\d|.]+)$/i; $rst = $1; 
	       if ($rst) {;} else {$rst = "null";}
	       $rst =~ s/^\s*0+//g;
	       my $rstStr = sprintf "%20s|%10s|%s", "tcRunResult",$rst , $timeStart;
	       $rstStr .= "|"; $rstStr .= "$timeEnd"; $rstStr .= "|"; $rstStr .= "0:0:0:0s";
	       $rstStr .= "|"; 
	       if ( $rst =~ /^\s*[\d+|\.]+\s*$/ ) {
		$rstStr .= "Performance Test ($rst) ";
	       } else {
	       $rstStr .= "Functional Test ($rst) ";
	       } 
	       $rstStr .= '|'.$tcComment2; 
	       &addProperty(&getTCName($tcName), "add=$rstStr");
	       return $rst;
       } else {
		return "tcName: $tcName doesn't exist.\n";
       }
}


sub execTC_ {
	my $tcName = &getTCName(@_);
	my $timeStart = &getDate(); my $rst=''; 
	if  ( -e "$tcName/$tc_pl" ) { 
		my $cmd     = "$perl_ $tcName/$tc_pl"; 
		$rst     = `$cmd`; my $timeEnd= &getDate(); 
	       	$rst =~ /(pass|fail|todo|bugF|expF|expected_f_a_i_l|task|[\d|.]+)$/i; $rst = $1; 
	       	if ($rst) { if ($rst =~ /expected_f_a_i_l/) { $rst = "expF"; } ;} else {$rst = "null";}
	       	$rst =~ s/^\s*0+//g;
	       	my $rstStr = sprintf "%20s|%10s|%s", "tcRunResult",$rst , $timeStart; $rstStr .= "|"; $rstStr .= "$timeEnd"; $rstStr .= "|"; $rstStr .= "0:0:0:0s"; $rstStr .= "|"; 
	       	if ( $rst =~ /^\s*[\d+|\.]+\s*$/ ) { $rstStr .= "Performance Test ($rst) "; } elsif ( $rst =~ /task/i ) { $rstStr .= "Task "; } else { $rstStr .= "Functional Test ($rst) "; } 
	       	$rstStr .= '|comment2PlaceHolder'; 
	       	&addProperty(&getTCName($tcName), "add=$rstStr");
	       	return $rst;
       } else {
		return "tcName: $tcName doesn't exist.\n";
       }
}

sub mapTC {
	my $tcName = &getTCName(@_);
	my $timeStart = &getDate(); my $rst=''; 
	if  ( -e "$tcName/$tc_pl" ) { 
	       if (-e "$c/$_TAF/$SvrProjName/_tcMap.txt") {
		       my $tcName_ = &getTCName($tcName); $tcName_ =~ s/$c\/$_TAF\///i;
			&mergethProperty($tcName_,"$c/$_TAF/$SvrProjName/_tcMap.txt");
		       }
	        return $rst;
       } else {
		return "tcName: $tcName doesn't exist.\n";
       }
}

sub mergethProperty {
my $thPropertyString ="_CRB_/AppBuildpath/_automated_testsuites_/_testsuite_pl/testcase0002"; $thPropertyString= shift if @_; 
my $tcMapFName = "_tcMap.txt"; $tcMapFName = shift if @_;
my $propertyName = "tcRunResult";my  %records; my %record_out; my $tag = "tag"; my $content_out=""; my $parent=""; my $child;
open Fin, $tcMapFName;
 	while ($_=<Fin>) { chop;
  		if ($_ =~ /$thPropertyString/) { 
			my $thPropertyFName;
			$content_out = "";
			 ($parent, $child) = split (/\s*=>\s*/, $_);
			if (($parent !~ /^\s*$/) && ($child !~ /^\s*$/)) {	
			$thPropertyFName=$parent."/thProperty.txt"; if ($thPropertyFName !~ /$c\/$_TAF/) {$thPropertyFName =~ s/$c/$c\/$_TAF/;} # TS->TAF TS conversion 
			open Fin1, $thPropertyFName or die "Can't open $thPropertyFName:$!";  
			while ($_ = <Fin1>) { 
				if ($_ =~ /$tags/) { $tag=$1;}	# todo
				if ($_ =~ /^\s*$propertyName\s*\|/) { @_ = split (/\|/, $_); $records{$_[2]}=$_; } 
				else { $content_out = $content_out.$_; }
			} 
			close Fin1;
			$thPropertyFName=$child."/thProperty.txt";    if ($thPropertyFName !~ /$c\/$_TAF/){ $thPropertyFName =~ s/$c/$c\/$_TAF/;} # TS->TAF TS conversion 
			if ( -e $thPropertyFName ) { ; } else { return ;} 
			open Fin1, "$thPropertyFName" or die "Can't open $thPropertyFName:$!";  
			while ($_ = <Fin1>) { 
				if ($_ =~ /$tags/i) { $tag=$1;}	# todo
				if ($_ =~ /^\s*$propertyName\s*\|/) { $_ =~ s/Comment2\s*$/$tag/i; @_ = split (/\|/, $_); $records{$_[2]}=$_; 
				} 
			} 
			close Fin1;
			}
		}
 	} 
close Fin;
	if (-e $parent) {
		open Fout1, ">$parent/thProperty.txt_"; 
		print Fout1 $content_out; 
		foreach my $each (sort keys %records) { print Fout1 "$records{$each}\n"; } 
		close Fout1;
		&copyFile("$parent/thProperty.txt_", "$parent/thProperty.txt");
	}

}
sub deleteTC {
	if ($_[1]) { $SvrProjName = $_[1];}
	if ($_[2]) { $SvrDrive = $_[2];}
	my $tcName = &getTCName(@_);
#### 	todo	backup deleted TCs. move ($tcName, $tcName."_".  &UnixDate( "now", "%m_%d_%Y_%H_%M_%S_%Z" ) ."_backup");
	rmtree $tcName;
	return "$tcName is deleted (saved as *_backup)";
}

sub detectTC {
	if ($_[1]) { $SvrProjName = $_[1];}
	if ($_[2]) { $SvrDrive = $_[2];}
	my $tcName = '';
	$tcName = &getTCName(@_);
     	if (-e "$tcName/tc.pl" ) { return  "exists"; } else { return 'does not exist';}
}

sub getTSName {
	my $tsname = shift;
	$tsname =~ s/\/testcase\d+.+//g;
	return $tsname;
}

sub getTCName {
	my $SvrProjNameTmp; my $SvrDriveTmp; my $SvrTCNameTmp="" ;  
	$SvrTCNameTmp = shift if @_; 
	if ($notUsegetTCName==1) 	{  return   $SvrTCName;				}	# Do nothing
	if ($SvrTCNameTmp) 		{;} else {  $SvrTCNameTmp = $SvrTCName; 		}  	# get current SvrTCName 
	if ($SvrProjNameTmp) 		{;} else {  $SvrProjNameTmp = $SvrProjName;	}  	# do nothing
	if ($SvrDriveTmp) 		{;} else {  $SvrDriveTmp = $SvrDrive;		}  	# do nothing
	if ($SvrTCNameTmp =~ /[a-z]:/i) {   return   $SvrTCNameTmp;			}	# remove c:
	elsif ($SvrTCNameTmp =~ /$c/i)  {   return   $SvrTCNameTmp;			}	# remove c:
	else { return ($SvrDriveTmp.'/'.$SvrProjNameTmp.'/'.$SvrTCNameTmp) ; 		}	# c:/testcase/testsuite
}

sub getTCNameStr{
	my $SvrTCNameStr = shift;
	@_ = split /\\|\//, $SvrTCNameStr; 
	pop;
}

################################################################################
#	Subroutine Name : processProperty
#		Function: wrapper for property management functions
#	Input Parameters: PropertyOP
#	Output/Returns  : tcName and propertyOp
################################################################################
sub processProperty {
	shift; my $tcname = shift; my $propertyOP = shift; my $rst=""; my $prMsg=0;
	#### PropertyOp String Translation
	$propertyOP =~ s/^\s*propertyOp\s*=//g; $propertyOP =~ s/^\s*po\s*=//g; $propertyOP =~ s/_doit_//g;
	if ($propertyOP =~ /^\s*_?modify_(.+)_(as|eq)_(.+)/) { $propertyOP = "add_eq_$1_column_$3"; }
	if ($propertyOP =~ /^\s*_?set_(.+)_(as|eq)_(.+)/) { $propertyOP = "add_eq_$1_column_$3"; }
	elsif ($propertyOP =~ /^\s*_?get_history(.+)/)  { $propertyOP = "get_history$1"; }
	elsif ($propertyOP =~ /^\s*_?list_history(.+)/) { $propertyOP = "get_history$1"; }

	elsif ($propertyOP =~ /^\s*_?get_latest(.+)/)  { $propertyOP = "get_latest$1"; }
	elsif ($propertyOP =~ /^\s*_?list_latest(.+)/) { $propertyOP = "get_latest$1"; }

	elsif ($propertyOP =~ /^\s*_?get_last(.+)/)  { $propertyOP = "get_last$1"; }
	elsif ($propertyOP =~ /^\s*_?list_last(.+)/) { $propertyOP = "get_last$1"; }

	elsif ($propertyOP =~ /^\s*_?get_(.+)/) { $propertyOP = "get_$1"; }
	elsif ($propertyOP =~ /^\s*_?list_(.+)/) { $propertyOP = "get_$1"; }
	#### PropertyOp String Translation
	if (defined $propertyOP) {;} else { $rst = "Warning: wrong format. Correct format is -add=prop:value"; return $rst; }
	if ($propertyOP =~ /;\s*pr2Screen\s*/) { $prMsg = 1; $propertyOP =~ s/;\s*pr2Screen\s*(=\s*\d*\s*)?//; }
	if ( $propertyOP =~ /^\s*add/i ) {
                $rst = &addProperty( &getTCName($tcname), $propertyOP );
        }
        elsif ( $propertyOP =~ /^\s*del/i ) {
                $rst = &deleteProperty( &getTCName($tcname), $propertyOP );
        }
        elsif ( $propertyOP =~ /^\s*reset/i ) {
                ;
        }    # copy to a backup and create a property file
        elsif ( $propertyOP =~ /^\s*modify/i ) {
                $rst = &modifyProperty( &getTCName($tcname), $propertyOP );
        }
        elsif ( $propertyOP =~ /^\s*get_history|list_history_/i ) {
		$propertyOP =~ s/^\s*get_history_+\s*//g; $propertyOP =~ s/^\s*list_history_+\s*//g;
		$rst = &getProperties(&getTCName($tcname), $propertyOP, "history" );
 	}
        elsif ( $propertyOP =~ /^\s*get_latest|list_latest/i ) {
		$propertyOP =~ s/^\s*get_latest_+\s*//g; $propertyOP =~ s/^\s*list_latest_+\s*//g;
		$rst = &getProperties(&getTCName($tcname), $propertyOP, "latest" );
 	}
        elsif ( $propertyOP =~ /^\s*get_last|list_last/i ) {
		$propertyOP =~ s/^\s*get_last_+\s*//g; $propertyOP =~ s/^\s*list_last_+\s*//g;
		$rst = &getProperties(&getTCName($tcname), $propertyOP, "last" );
 	}
        elsif ( $propertyOP =~ /^\s*get|list/i ) {
		    $propertyOP =~ s/^\s*get_\s*//g; $propertyOP =~ s/^\s*list_\s*//g;
		if ($propertyOP =~ /;/ ) {
		    @_ = split /;/, $propertyOP ;
		    $rst = &getProperties(&getTCName($tcname), $_[0], $_[1]);
	    	} else {
		    $rst = &getProperties(&getTCName($tcname), $propertyOP, "value" );
		}
       }
       elsif ( $propertyOP =~ /^\s*create/i ) {
        	$rst = &createPropertyTemplate($tcname);
       }
       elsif ( $propertyOP =~ /^\s*match|filter/i ) {
		if ($propertyOP =~ s/^\s*match\s*_//g) {
		    $propertyOP =~ /\s*(\S+)\s*_(as|eq)_\s*(\S+)\s*/; 
        	    $rst = &matchProperty($1, $3, $tcname);
	    }
       } else {
	    	    $rst = sprintf "ProcessProperty (no match OP) %40s %20s", $tcname, $propertyOP;
       }

	    if (($rst) && ($rst =~ /^\s*$/)) { $rst = "_noMatchedPropertyOP_";}
	    if ((defined $prMsg) && ($prMsg ==1)) { print  $rst;}
	    if ($rst) { return $rst; } else { return "doen't exist"; }
}

################################################################################
#	Subroutine Name : matchProperties
#		Function: return true/false 
#	Input Parameters: Property Name in regExp  
#	Output/Returns  : True/False
################################################################################
sub matchProperty { # &matchProperty("QAOwner","ywang", "TC_tc1");
	my $propertyName = ".*"; my $propertyPattern = ".*"; my %array; my $tcname = "TC_tc1";
	$propertyName = shift if (@_);
	$propertyPattern= shift if (@_);
	$tcname = shift if (@_);

	 if (&getProperties(&getTCName($tcname), "" ) =~ /info:There is no/ ) {
		 return "False";
	 }

	foreach my $each (split /\n/,  &getProperties(&getTCName($tcname), "", "_all_")) {
		$each =~ /^\s*(\w+)\s+(\w+)\s*$/;
		$array {$1}  = $2;
	}
	foreach my $each (sort keys %array) {
		if (($array{$each} =~ /$propertyPattern/) && ( $each =~ /$propertyName/)) { 
			 return "True\n$each:$array{$each}"; }
	}
	return 'False';
}

################################################################################
#	Subroutine Name : getProperties
#		Function: return Test Case Property
#	Input Parameters: Property Name (regExp)  (tcName, tcPattern, value)
#	Output/Returns  : Property Value
################################################################################
sub getProperties() { 	# get TC Property Names	(TH:TC Managements)
	    	my %array; my $returnValue;
		my $tcname 		; $tcname 		= shift if @_ ;
		my $propertyOp		; $propertyOp  		= shift if @_ ;
		my $returnType= 'latest'; $returnType 		= shift if @_ ;

    		if ($propertyOp =~ s/^\s*add\s*=\s*//ig) {;}
		elsif ($propertyOp =~ s/^\s*_eq_\s*//g) {;}
		elsif ($propertyOp =~ s/\s*_eq_\s*/=/g) {;}
		elsif ($propertyOp =~ s/_column_/:/g) {;}

		if ($propertyOp =~ /_all_/) { $returnType = "_all_"; $propertyOp =~ s/_all_//g; }

		# if ( -e  "$tcname/thProperty.txt" ) { ; } else { return "info:There is no $_[0]/thProperty.txt here";}
    if ( -e  "$tcname/thProperty.txt" ) { ; } else { return "info:There is no $tcname/thProperty.txt here";}
    open Fin, "$tcname/thProperty.txt" || die "Can't open file:$!";
    while ( $_ = <Fin> ) {

#local @ARGV ; my $propertyFName ; $propertyFName = "$tcname/thProperty.txt"; push @ARGV, $propertyFName if (-e $propertyFName );
#$propertyFName = "$tcname/thPropertyLink.txt"; 
#if (-e $propertyFName) { open Fin, $propertyFName; @_ = <Fin>; close Fin; foreach my $each (@_) { if (-e $each) { push @ARGV, $each."/thProperty.txt"; } } }
#    while ( $_ = <> ) {
	    @_= split /\|/, $_;

	    my $propertyName_ = $_[0]; my $propertyValue_ = $_[1]; $propertyName_ =~ s/^\s*//g; $propertyName_ =~ s/\s*$//g; my $propertyStartTime = $_[2];
	    if (($propertyName_ !~ /^\s*$/) && ( $propertyValue_ !~ /^\s*$/)) {   

 	      	if (($propertyName_ =~ /$propertyOp/i) || ( $propertyOp eq '')) { # PropertyPattern Filter
		   	if ($returnType =~ /^\s*$/) { $returnValue .= sprintf "%-20s=%s\n",$propertyName_, $propertyValue_; 
			} elsif ($returnType =~ /values/i) { 
				$returnValue .= sprintf "%s\n", $propertyValue_;
			} elsif ($returnType =~ /_all_/i) { 
				$propertyValue_ =~ s/^\s*//g;
				$propertyValue_ =~ s/\s*$//g;
				$returnValue = sprintf "\t%s\n", $propertyValue_;
			} elsif ($returnType =~ /history/i) { 
				$returnValue .= sprintf "%-20s=%s \@ $propertyStartTime\n",$propertyName_, $propertyValue_;
			} elsif ($returnType =~ /\blatest\b/i) {
				$returnValue = "$propertyValue_\n";
			} elsif ($returnType =~ /\blast\b/i) {
				if ($propertyValue_ !~ /dumy/) { $returnValue = "$propertyValue_\n"; }
			} elsif ($returnType =~ /\bvalue\b/i) {
				$returnValue = sprintf "%s\n", $propertyValue_;
		   	}
		}
		$array{$propertyName_} = $returnValue;
	}
    }
    close Fin;
	$returnValue = "\n";
	if ($returnType =~ /_all_/i) {
		foreach my $each (sort keys %array) { 
			$returnValue .= sprintf "%20s%s", $each, $array{$each}; }
		return $returnValue;
	} else {
		$returnValue =  $array{$propertyOp} ; 
		if ($returnValue ) { $returnValue =~ s/\s*\n\s*$//g; if ($returnValue =~ /^\s*$/) { $returnValue = "_noMatch_";} ; return $returnValue; }
		else { return ""; }
    	}
}

################################################################################
#	Subroutine Name : modfyProperty
#		Function: modify Test Case Property
#	Input Parameters: Test Case Property Name
#	Output/Returns  : updated c:\TC_*\thProperty.txt
#	Subroutine Name : 
#		Function: 
#	Input Parameters: 
#	Output/Returns  : 
################################################################################
sub modifyProperty() { 	# modify TC Property (TH:TC Managements)
    my $tcname       = $_[0];
    my $propertyName = $_[1];
    my $propertyValue       ; 
    if ($propertyName =~ s/^\s*modify\s*_\s*//g) {
    $propertyName =~ /(\w+)\s*_as_\s*(\w+)\s*/;
    $propertyName = $1; $propertyValue = $2;
    }
    my $cmdStr        = "delete=$propertyName";
    &deleteProperty( $tcname, $cmdStr );
    $cmdStr = "add_${propertyName}_column_${propertyValue}"; # todo
    &addProperty( $tcname, $cmdStr );
    return "$propertyName is modified to $propertyValue for $tcname";
}

################################################################################
#	Subroutine Name : deleteProperty
#		Function: delete Test Case Property
#	Input Parameters: Test Case Property Name
#	Output/Returns  : update c:\TC_*\thProperty.txt
################################################################################
sub deleteProperty() {	# delete TC Property	(TH:TC Managements)
    my $fname = "$_[0]/thProperty.txt";
    my $fout  = $fname; $fout =~ s/\.txt/_Dumpster\.txt/;

    my $propertyName = $_[1]; 
    if ($propertyName !~ /\s*del\S*\s*_\s*/) { return "Warning: wrong format  -del=prop1;pr2Screen";} else {
    $propertyName =~ s/^\s*del\S*\s*_\s*//g; $propertyName =~ s/:\s*\S*//; }
    my %array ;
    open Fin, "$fname"; @_ = <Fin>; close Fin;

    open Fout, ">>$fout";
    foreach my $each (@_) {
        if ( $each =~ /^\s*$propertyName\s*\|/i ) { print Fout "$each"; }
    }
    close Fout;

    open Fout, ">${fname}" || die "Can't open $fname:$!";
    foreach my $each (@_) {
        if ( $each !~ /^\s*$propertyName\s*\|/i ) {
            print Fout "$each";
        }
    }
    close Fout;
    return "$propertyName is deleted from $fname";
}

################################################################################
#	Subroutine Name : createPropertyTemplate
#		Function: 
#	Input Parameters: 
#	Output/Returns  : 
################################################################################
sub createPropertyTemplate() { 	# create TC Property File (TH:TC Managements)
    my $timeStr = getDate(); $timeStr = "|$timeStr|$timeStr|0:0:0:0s|Comment1|Comment2";
    my $tcDesc = "@_"; 
    my $fname = "@_/thProperty.txt";
    if (-e $fname) { open Fout, ">>$fname"; } else { open Fout, ">$fname";} 
    printf Fout "%20s|%10s%s\n", 'tcId','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'tcDesc',$tcDesc,$timeStr;
    printf Fout "%20s|%10s%s\n", 'tcSPR','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'tcSCR','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'QA','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'modolID','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'priority','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'openSPR','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'tcID','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'tcOwner','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'tcId','null',$timeStr;
    printf Fout "%20s|%10s%s\n", 'resultN','null',$timeStr;
    close Fout;
}

################################################################################
#	Subroutine Name : addProperty
#		Function: add Test Case Property
#	Input Parameters: Test Case Property Name
#	Output/Returns  : updated c:\TC_*\thProperty.txt
################################################################################
sub addProperty() { 	# add TC Property (TH:TC Managements)
    my $timeStr = &getDate(); $timeStr = "|$timeStr|$timeStr|0:0:0:0s|comment1|comment2";
    my $fname        = "$_[0]/thProperty.txt";
    my $propertyName = $_[1];
    $propertyName =~ s/^\s*add\s*=//g;
    $propertyName =~ s/^\s*add\s*_eq_\s*//g;
    if (-e $_[0]) {;} else { mkpath $_[0]; }
    open Fout, ">>$fname";
    	if ($propertyName =~ /\|/) { # for tcRunResult 
		$propertyName =~ /^\s*(\S+)\s*\|\s*(\S+)\s*\|(.+)\s*$/; 
		my $propName = $1		;
		my $propValue = $2		;
		my $propComment = $3		;
		$propValue =~ s/_space_/ /g	;
		$propValue =~ s/_eq_/=/g	;
		$propValue =~ s/_column_/:/g	;
        	printf Fout "%20s|%10s|%s\n",$propName, $propValue,$propComment;
	} else {
		$propertyName =~ /^\s*(\S+)_column_(\S+)\s*/; 
		my $propName = $1		;
		my $propValue = $2		;
		$propName = &match1stRegexp($propertyName, "_column_");
		$propValue= &matchRestRegexp($propertyName, "_column_");
		if ($propName && $propValue) {
		$propValue =~ s/_column_/:/g	;
		$propValue =~ s/_space_/ /g	;
		$propValue =~ s/_eq_/=/g	;
		$propValue =~ s/___/ /g		;
		$propName =~ s/^\s*add\s*=//g	;
		$propName =~ s/_space_/ /g	;
        	printf Fout "%20s|%10s%s\n",$propName, $propValue,$timeStr;
		}
	}
    close Fout;
    return "$propertyName is added to $fname";
}

sub printGlobalVars {
my $return=<<EOF;
##################### Frequently Used Setting ####################
web_ui_title                  =$web_ui_title                  
tags                          =$tags                          
ps1_args                      =$ps1_args                      
Execution_24_7                =$Execution_24_7                
Execution_24_7_title          =$Execution_24_7_title
Execution_local_only          =$Execution_local_only 
outputFromat                  =$outputFormat  (text,noOutput -todo ,html-todo)
htmlRefreshRate               =$htmlRefreshRate
htmlRefreshRateWebUI          =$htmlRefreshRateWebUI
htmlRefreshRateLogUI          =$htmlRefreshRateLogUI
##################### WebUI Setting           ####################
excelReportColumnWidth        =$excelReportColumnWidth        
pr2Screen                     =$pr2Screen                     
webUI_TCDescWidth             =$webUI_TCDescWidth             
scrollAmount                  =$scrollAmount                  
borderWidth                   =$borderWidth                   
borderStyle                   =$borderStyle                   
passFailDisplayWidth          =$passFailDisplayWidth          
maxPassFailDisplayWidth       =$maxPassFailDisplayWidth       
tsPropertyWidth               =$tsPropertyWidth               
webUITreeViewLevel            =$webUITreeViewLevel
##################### TAF  Default  Settings   ####################
ip                            =$ip                             
c                             =$c                             
taf                           =$taf                           
_TAF                          =$_TAF                          
overWriteTC                   =$overWriteTC
reportHtmlSummaryScale        =$reportHtmlSummaryScale        
reportHtmlSummaryScaleMajor   =$reportHtmlSummaryScaleMajor   
testcaseNode                  =$testcaseNode
NofExecution                  =$NofExecution                  
ExecutionLength               =$ExecutionLength               
tsFilter                      =$tsFilter                      
tcComment1                    =$tcComment1                    
tcComment2                    =$tcComment2                    
MaxTCExecTime                 =$MaxTCExecTime                 
TSHookName                    =$TSHookName                    
TSHookNameGenerated           =$TSHookNameGenerated           
TSHookIsPerl                  =$TSHookIsPerl                  
interact                      =$interact                      
tcPropertyPatternName         =$tcPropertyPatternName         
tcPropertyPatternPattern      =$tcPropertyPatternPattern      
tcPropertyPatternName1        =$tcPropertyPatternName1        
tcPropertyPatternPattern1     =$tcPropertyPatternPattern1     
tcPropertyPatternName2        =$tcPropertyPatternName2        
tcPropertyPatternPattern2     =$tcPropertyPatternPattern2     
tcPropertyPatternName3        =$tcPropertyPatternName3        
tcPropertyPatternPattern3     =$tcPropertyPatternPattern3     
tcPropertyName                =$tcPropertyName                
tcNamePattern                 =$tcNamePattern                 
tcOp                          =$tcOp                          
tcCtr                         =$tcCtr                         
tcDelta                       =$tcDelta                       
markSymbol                    =$markSymbol                    
tsFilterDefault               =$tsFilterDefault               
tcFilterDefault               =$tcFilterDefault               
SvrDrive                      =$SvrDrive                      
SvrProjName_ignore            =$SvrProjName                   
SvrTCName_ignore  	      =$SvrTCName                     
SvrTCNamePattern              =$SvrTCNamePattern              
SvrPropNamePattern            =$SvrPropNamePattern            
SvrPropValuePattern           =$SvrPropValuePattern           
SvrTCNameExecPattern          =$SvrTCNameExecPattern          
exitTAFGracefullyLock         =$exitTAFGracefullyLock         
performanceMode               =$performanceMode               
resetTSFileName               =$resetTSFileName               
externalLogName               =$externalLogName               
commandLogName                =$commandLogName                
commandLogLifeSpan            =$commandLogLifeSpan            
testType                      =$testType                      
AutomationtsName              =$AutomationtsName              
tsProperty                    =$tsProperty                    
sleep4Display		      =$sleep4Display
createOrAppendTS	      =$createOrAppendTS
NofTCinTSTemplate  	      =$NofTCinTSTemplate
EOF
}
################
 

sub printTSGlobalVars {
my $return=<<EOF;
##################### Frequently Used Setting ####################
Execution_24_7                =$Execution_24_7                
Execution_24_7_title          =$Execution_24_7_title
Execution_local_only          =$Execution_local_only 
htmlRefreshRate               =$htmlRefreshRate
htmlRefreshRateWebUI          =$htmlRefreshRateWebUI
htmlRefreshRateLogUI          =$htmlRefreshRateLogUI
##################### WebUI Setting           ####################
EOF
}

sub printTCGlobalVars {
my $return=<<EOF;
##################### Frequently Used Setting ####################
Execution_24_7                =$Execution_24_7                
Execution_24_7_title          =$Execution_24_7_title
Execution_local_only          =$Execution_local_only 
htmlRefreshRate               =$htmlRefreshRate
htmlRefreshRateWebUI          =$htmlRefreshRateWebUI
htmlRefreshRateLogUI          =$htmlRefreshRateLogUI
##################### WebUI Setting           ####################
EOF
}



###############

# sub readTAFTCVars     { open Fin, "$c/$_TAF/$SvrProjName/$SvrTCName/_tafGlobalVars.txt"		; while (<Fin>) { chop; if ($_ =~ /(.+)=(.+)/ ) { &readTAFGlobalVars1($1, $2); } }; close Fin; }
sub readTAFTCVars     { open Fin, "$SvrTCName/_tafGlobalVars.txt"		; while (<Fin>) { chop; if ($_ =~ /(.+)=(.+)/ ) { &readTAFGlobalVars1($1, $2); } }; close Fin; }
sub readTAFTSVars     { open Fin, "$c/$_TAF/$SvrProjName/_tafGlobalVars.txt"			; while (<Fin>) { chop; if ($_ =~ /(.+)=(.+)/ ) { &readTAFGlobalVars1($1, $2); } }; close Fin; }
sub readTAFGlobalVars { open Fin, "$c/$_TAF/_tafGlobalVars.txt"					; while (<Fin>) { chop; if ($_ =~ /(.+)=(.+)/ ) { &readTAFGlobalVars1($1, $2); } } close Fin; }
sub readTAFGlobalVars1 {
	my $varName  = shift;
	my $varValue = shift;
	$varName  =~ s/^\s*//g; $varName  =~ s/\s*$//g;
	$varValue =~ s/^\s*//g; $varValue=~ s/\s*$//g;
if ($varName eq "web_ui_title"                ) { $web_ui_title                   = $varValue; }
if ($varName eq "tags"                        ) { $tags                           = $varValue; }
if ($varName eq "ps1_args"                    ) { $ps1_args                       = $varValue; }
if ($varName eq "excelReportColumnWidth"      ) { $excelReportColumnWidth         = $varValue; }
if ($varName eq "testcaseNode"                ) { $testcaseNode                   = $varValue; }
if ($varName eq "pr2Screen"                   ) { $pr2Screen                      = $varValue; }
if ($varName eq "webUI_TCDescWidth"           ) { $webUI_TCDescWidth              = $varValue; }
if ($varName eq "webUITreeViewLevel"          ) { $webUITreeViewLevel             = $varValue; }
if ($varName eq "scrollAmount"                ) { $scrollAmount                   = $varValue; }
if ($varName eq "borderWidth"                 ) { $borderWidth                    = $varValue; }
if ($varName eq "borderStyle"                 ) { $borderStyle                    = $varValue; }
if ($varName eq "passFailDisplayWidth"        ) { $passFailDisplayWidth           = $varValue; }
if ($varName eq "maxPassFailDisplayWidth"     ) { $maxPassFailDisplayWidth        = $varValue; }
if ($varName eq "reportHtmlSummaryScale"      ) { $reportHtmlSummaryScale         = $varValue; }
if ($varName eq "reportHtmlSummaryScaleMajor" ) { $reportHtmlSummaryScaleMajor    = $varValue; }
if ($varName eq "tsPropertyWidth"             ) { $tsPropertyWidth                = $varValue; }
if ($varName eq "c"                           ) { $c                              = $varValue; }
if ($varName eq "taf"                         ) { $taf                            = $varValue; }
if ($varName eq "_TAF"                        ) { $_TAF                           = $varValue; }
if ($varName eq "Execution_24_7"              ) { $Execution_24_7                 = $varValue; }
if ($varName eq "Execution_24_7_title"        ) { $Execution_24_7_title           = $varValue; }
if ($varName eq "Execution_local_only"        ) { $Execution_local_only           = $varValue; }
if ($varName eq "Execution_from_cgi"          ) { $Execution_from_cgi             = $varValue; }
if ($varName eq "NofExecution"                ) { $NofExecution                   = $varValue; }
if ($varName eq "ExecutionLength"             ) { $ExecutionLength                = $varValue; }
if ($varName eq "tsFilter"                    ) { $tsFilter                       = $varValue; }
if ($varName eq "tcComment1"                  ) { $tcComment1                     = $varValue; }
if ($varName eq "tcComment2"                  ) { $tcComment2                     = $varValue; }
if ($varName eq "MaxTCExecTime"               ) { $MaxTCExecTime                  = $varValue; }
if ($varName eq "TSHookName"                  ) { $TSHookName                     = $varValue; }
if ($varName eq "TSHookNameGenerated"         ) { $TSHookNameGenerated            = $varValue; }
if ($varName eq "interact"                    ) { $interact                       = $varValue; }
if ($varName eq "tcPropertyPatternName"       ) { $tcPropertyPatternName          = $varValue; }
if ($varName eq "tcPropertyPatternPattern"    ) { $tcPropertyPatternPattern       = $varValue; }
if ($varName eq "tcPropertyPatternName1"      ) { $tcPropertyPatternName1         = $varValue; }
if ($varName eq "tcPropertyPatternPattern1"   ) { $tcPropertyPatternPattern1      = $varValue; }
if ($varName eq "tcPropertyPatternName2"      ) { $tcPropertyPatternName2         = $varValue; }
if ($varName eq "tcPropertyPatternPattern2"   ) { $tcPropertyPatternPattern2      = $varValue; }
if ($varName eq "tcPropertyPatternName3"      ) { $tcPropertyPatternName3         = $varValue; }
if ($varName eq "tcPropertyPatternPattern3"   ) { $tcPropertyPatternPattern3      = $varValue; }
if ($varName eq "tcPropertyName"              ) { $tcPropertyName                 = $varValue; }
if ($varName eq "tcNamePattern"               ) { $tcNamePattern                  = $varValue; }
if ($varName eq "tcOp"                        ) { $tcOp                           = $varValue; }
if ($varName eq "tcCtr"                       ) { $tcCtr                          = $varValue; }
if ($varName eq "tcDelta"                     ) { $tcDelta                        = $varValue; }
if ($varName eq "markSymbol"                  ) { $markSymbol                     = $varValue; }
if ($varName eq "tsFilterDefault"             ) { $tsFilterDefault                = $varValue; }
if ($varName eq "tcFilterDefault"             ) { $tcFilterDefault                = $varValue; }
if ($varName eq "SvrDrive"                    ) { $SvrDrive                       = $varValue; }
if ($varName eq "SvrProjName"                 ) { $SvrProjName                    = $varValue; }
if ($varName eq "SvrTCName"                   ) { $SvrTCName                      = $varValue; }
if ($varName eq "SvrTCNamePattern"            ) { $SvrTCNamePattern               = $varValue; }
if ($varName eq "SvrPropNamePattern"          ) { $SvrPropNamePattern             = $varValue; }
if ($varName eq "SvrPropValuePattern"         ) { $SvrPropValuePattern            = $varValue; }
if ($varName eq "SvrTCNameExecPattern"        ) { $SvrTCNameExecPattern           = $varValue; }
if ($varName eq "exitTAFGracefullyLock"       ) { $exitTAFGracefullyLock          = $varValue; }
if ($varName eq "performanceMode"             ) { $performanceMode                = $varValue; }
if ($varName eq "tsFrom"                      ) { $tsFrom                         = $varValue; }
if ($varName eq "tsTo"                        ) { $tsTo                           = $varValue; }
if ($varName eq "resetTSFileName"             ) { $resetTSFileName                = $varValue; }
if ($varName eq "externalLogName"             ) { $externalLogName                = $varValue; }
if ($varName eq "commandLogName"              ) { $commandLogName                 = $varValue; }
if ($varName eq "commandLogLifeSpan"          ) { $commandLogLifeSpan             = $varValue; }
if ($varName eq "testType"                    ) { $testType                       = $varValue; }
if ($varName eq "AutomationtsName"            ) { $AutomationtsName               = $varValue; }
if ($varName eq "tsProperty"                  ) { $tsProperty                     = $varValue; }
if ($varName eq "TsHookIsPerl"                ) { $TSHookIsPerl                   = $varValue; }
if ($varName eq "createOrAppendTS"            ) { $createOrAppendTS               = $varValue; }
if ($varName eq "htmlRefreshRate"             ) { $htmlRefreshRate 		  = $varValue; }
if ($varName eq "htmlRefreshRateWebUI"        ) { $htmlRefreshRateWebUI 	  = $varValue; }
if ($varName eq "NofTCinTSTemplate"           ) { $NofTCinTSTemplate    	  = $varValue; }

if ($varName eq "testcaseNode"                ) { $testcaseNode                   = $varValue; 
# &updateTAFGlobalVars(); 
if ($testcaseNode =~ /_null_/) { $testcaseNode = "";} 
}
}

sub getGlobalVars_old { 
	my $return = <<EOF;
	\$ip        		= $ip
	\$c        		= $c
	\$_TAF        		= $_TAF
	\$SvrDrive 		= $SvrDrive
	\$SvrProjName 		= $SvrProjName
 	\$SvrTCName 		= $SvrTCName
 	\$SvrTCNamePattern 	= $SvrTCNamePattern
 	\$SvrTCNameExecPattern	= $SvrTCNameExecPattern
	\$tcOp			= $tcOp
	\$SvrPropNamePattern 	= $SvrPropNamePattern
	\$SvrPropValuePattern 	= $SvrPropValuePattern
	\$pr2Screen           	= $pr2Screen            
	\$tc_pl               	= $tc_pl
	\$tsDriver            	= $tsDriver
	\$web_ui_title        	= $web_ui_title
	\$workingDir          	= $workingDir		
	\$tcIdMin             	= $tcIdMin   
	\$tcPropertyPatternPattern     = $tcPropertyPatternPattern
	\$tcPropertyPatternName = $tcPropertyPatternName
	\$ps1_args              = $ps1_args
	\$sleep4Display         = $sleep4Display
	\$Execution_24_7	= $Execution_24_7
	\$NofExecution		= $NofExecution
	\$ExecutionLength 	= $ExecutionLength
	\$ExecutionType   	= $ExecutionType   
	\$performanceMode 	= $performanceMode
	\$testcaseNode    	= $testcaseNode
	\$testType        	= $testType
	\$tsTo            	= $tsTo         
	\$tsFrom          	= $tsFrom
	\$sleep4Display 	= $sleep4Display
	\$makeMark      	= $makeMark
	\$externalLogName	= $externalLogName
	\$tags			= $tags
	
EOF
	return $return;
} 
sub setGlobalVars {
	shift;
	@_ = split /;/, shift;
	my $foundMatch = 0;
	foreach my $each (@_) {
		my $varName = ""; my $varValue = "";
		if ($each =~ /^\s*(\S+)\s*=\s*(\S+)?\s*/) { $varName = $1; $varValue = $2; } 
		elsif (/^\s*(\S+)\s*=\s*(\S+)?\s*/) { $varName =$1; $varValue = "";}
		if ($varName =~ /SysDrive/i) 			{ $SvrDrive = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrDrive/i) 			{ $SvrDrive = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrProjName/i) 		{ $SvrProjName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrTCName\b/i) 		{ $SvrTCName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrTCNamePattern\b/i) 	{ $SvrTCNamePattern = $varValue; $SvrTCNameExecPattern = $SvrTCNamePattern; $foundMatch = 1;}
		elsif ($varName =~ /SvrTCNameExecPattern/i) 	{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrPropNamePattern\b/i) 	{ $SvrPropNamePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /SvrPropValuePattern/i)  	{ $SvrPropValuePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bDrive\b/i) 		{ $SvrDrive = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bProjName\b/i) 		{ $SvrProjName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTCName\b/i) 		{ $SvrTCName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTCNamePattern\b/i) 	{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTCNameExecPattern/i) 	{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcOp\b/i) 		{ $tcOp= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bPropNamePattern\b/i)  	{ $SvrPropNamePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bPropValuePattern\b/i)  	{ $SvrPropValuePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTestSuit\b/i) 		{ $SvrProjName = $varValue; $foundMatch = 1; $SvrProjName =~ s/\\/\//g; $SvrProjName =~ s/$c\/$_TAF\///; }
		elsif ($varName =~ /\bTestSuite\b/i) 		{ $SvrProjName = $varValue; $foundMatch = 1; $SvrProjName =~ s/\\/\//g; $SvrProjName =~ s/$c\/$_TAF\///;}
		elsif ($varName =~ /\bsubTestSuite\b/i) 	{ $SvrProjNameSub = $varValue; $foundMatch = 1; $SvrProjNameSub =~ s/\\/\//g; $SvrProjNameSub =~ s/$c\/$_TAF\///;}
		elsif ($varName =~ /\bTestSuiteSub\b/i) 	{ $SvrProjNameSub = $varValue; $foundMatch = 1; $SvrProjNameSub =~ s/\\/\//g; $SvrProjNameSub =~ s/$c\/$_TAF\///;}
		elsif ($varName =~ /\bTCNameFilter\b/i) 	{ $SvrTCNamePattern = $varValue;$foundMatch = 1;}
		elsif ($varName =~ /\bTCNameExecFilter\b/i) 	{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTestCaseExec\b/i) 	{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTestCase\b/i) 		{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bPropNameFilter\b/i)  	{ $SvrPropNamePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bPropValueFilter\b/i)  	{ $SvrPropValuePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcPropertyName\b/i)  	{ $tcPropertyName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btsuit\b/i) 		{ $SvrProjName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btname\b/i) 		{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bpname\b/i)  		{ $SvrPropNamePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bpvalue\b/i)  		{ $SvrPropValuePattern= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btop\b/i) 			{ $tcOp= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\bts\b/i) 			{ $SvrProjName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btn\b/i) 			{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btc\b/i) 			{ $SvrTCNamePattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btne\b/i) 			{ $SvrTCNameExecPattern = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bop\b/i) 			{ $tcOp= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\bpr2Screen\b/i)  		{ $pr2Screen= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bnotUsegetTCName\b/i)  	{ $notUsegetTCName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btc_pl\b/i)     		{ $tc_pl= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcDriver\b/i)  		{ $tc_pl= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btsDriver\b/i)  		{ $tsDriver = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bweb_ui_title\b/i)  	{ $web_ui_title= $varValue; $foundMatch = 1; $web_ui_title =~ s/___/ /g;}
		elsif ($varName =~ /\bworkingDir\b/i)  		{ $workingDir= $varValue; $foundMatch = 1; $workingDir =~ s/\\/\//g;}
		elsif ($varName =~ /\btcIdMin\b/i)  		{ $tcIdMin = $varValue; $foundMatch = 1;}

		elsif ($varName=~/\btcPropertyPatternPattern\b/i){ $tcPropertyPatternPattern= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btcPropertyPatternName\b/i){ $tcPropertyPatternName= $varValue; $foundMatch = 1;}

		elsif ($varName=~/\btcFilterFilter\b/i)		{ $tcPropertyPatternPattern= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;} 
		elsif ($varName =~ /\btcFilterName\b/i)		{ $tcPropertyPatternName= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btppp\b/i)  		{ $tcPropertyPatternPattern= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btppn\b/i)			{ $tcPropertyPatternName= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btppp1\b/i)  		{ $tcPropertyPatternPattern1= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btppn1\b/i)		{ $tcPropertyPatternName1= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btppp2\b/i)  		{ $tcPropertyPatternPattern2= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btppn2\b/i)		{ $tcPropertyPatternName2= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btppp2\b/i)  		{ $tcPropertyPatternPattern3= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\btppn2\b/i)		{ $tcPropertyPatternName3= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\bkeyValue\b/i)  		{ $tcPropertyPatternPattern= $varValue; $foundMatch = 1; $tcPropertyPatternPattern =~ s/_pipe_/\|/gi;}
		elsif ($varName =~ /\bkey\b/i)			{ $tcPropertyPatternName= $varValue; $foundMatch = 1;}

		elsif ($varName =~ /\btcFilters\b/i)  		{ 
			$varValue =~ /(.+)_matches_(.+)/; 
			$tcPropertyPatternName    = $1;
			$tcPropertyPatternPattern = $2;
			$foundMatch = 1;
		}

		elsif ($varName =~ /\bps1_args\b/i)		{ $ps1_args             = $varValue; $foundMatch = 1; $ps1_args =~ s/___/ /ig;}
		elsif ($varName =~ /\bsleep4Display\b/i)  	{ $sleep4Display 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcDelay\b/i)  		{ $sleep4Display 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bc\b/i)  			{ $c		 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\b_TAF\b/i)  		{ $_TAF		 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bExecution_24_7\b/i)  	{ $Execution_24_7	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bNofExecution\b/i)  	{ $NofExecution  	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bExecutionLength\b/i)  	{ $ExecutionLength 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bExecutionType\b/i)  	{ $ExecutionType   	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bperformanceMode\b/i)  	{ $performanceMode 	= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bpm\b/i)  			{ $performanceMode = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bpropertyOp\b/i)  		{ $propertyOp	   = $varValue; $foundMatch = 1; $propertyOp =~ s/_null_//ig;}
		elsif ($varName =~ /\bpo\b/i)  			{ $propertyOp	   = $varValue; $foundMatch = 1; $propertyOp =~ s/_null_//ig;}
		elsif ($varName =~ /\btsFilter\b/i)  		{ $tsFilter	   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bSUTSymbol\b/i)  		{ $SUTSymbol       = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btsFilterDefault\b/i)  	{ $tsFilterDefault = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bnotUsegetTCName\b/i)  	{ $notUsegetTCName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTSHookName\b/i)  		{ $TSHookName      = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTSHookNameGenerated\b/i)  { $TSHookNameGenerated  = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btestcaseNode\b/i)  	{ $testcaseNode    = $varValue; $foundMatch = 1; if ($testcaseNode =~ /_null_/) {$testcaseNode = "";}; }
		elsif ($varName =~ /\btestType\b/i)  		{ $testType        = $varValue; $foundMatch = 1; 
			#if ($testcaseNode !~ /^\s*$/) {
				if ($testType =~ /tc/i) { $testcaseNode = ".*";}
				if ($testType =~ /ts/i) { $testcaseNode = "testcase";}
				#}
		} 
		elsif ($varName =~ /\btsFrom\b/i)  		{ $tsFrom          = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btsTo\b/i)  		{ $tsTo            = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bmakeMark\b/i)  		{ $makeMark        = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bexitTAFGracefullyString\b/i) { $exitTAFGracefullyString = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bAutomationtsName\b/i)     { $AutomationtsName= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bresetTSFileName\b/i)      { $resetTSFileName = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bexitTAFTCId\b/i)          { $exitTAFTCId 	   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcComment1\b/i)            { $tcComment1	   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btcComment2\b/i)            { $tcComment2	   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bexternalLogName\b/i)       { $externalLogName= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bexternalLogName\b/i)       { $externalLogName= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\boutputFormat\b/i)          { $outputFormat   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bhtmlRefreshRate\b/i)       { $htmlRefreshRate= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bhtmlRefreshRateWebUI\b/i)  { $htmlRefreshRateWebUI= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bhtmlRefreshRateLogUI\b/i)  { $htmlRefreshRateLogUI= $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bip\b/i)       		 { $ip		   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\boverWriteTC\b/i)       	 { $overWriteTC    = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bTSHookIsPerl\b/i)       	 { $TSHookIsPerl   = $varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bcreateOrAppendTS\b/i)      { $createOrAppendTS=$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btitleStatus\b/i)      	 { $titleStatus     =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bwebUITreeViewLevel\b/i)    { $webUITreeViewLevel =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bNofPropertyExec\b/i) 	 { $NofPropertyExec =$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\bNofTCinTSTemplate\b/i)     { $NofTCinTSTemplate=$varValue; $foundMatch = 1;}
		elsif ($varName =~ /\btags\b/i)       		 { $tags	    =$varValue; $foundMatch = 1;
		my $tmp = ""; foreach my $each (split (/_,_/, $tags)) { $tmp=$tmp."|".$each; } $tmp =~ s/\|_/_(/g; $tmp =~ s/_\s*$/)_/g; $tags =  $tmp;	
		}
	$url 			= 'file:///'.$SvrDrive;  		# will be updated in the sub-processTCs. Update derived Global Variable
	$urlHttp		= 'http://'.$ip.$http_port;		# will be updated in the sub-processTCs. Update derived Global Variable
	}
	# if (($SvrTCNamePattern =~ /\//) || ($SvrTCNamePattern =~ /\\/)) { print "Error: Testcase can't have directory structure\n"; exit; }
	$foundMatch;
	#### &printTAFGlobalVars(); todo Non-volatile GlobalVars
	#### Variable content verfication 
}


sub runPowershell {
	my $cmd = shift;  my $return; if ($cmd =~ /.ps1\s+/) { $cmd = "$cmd"; $return = `$cmd`;} else { $return = `$perl $cmd`; }
	$return =~ s/\@/&amp;/g; $return =~ s/\%/&#37;/g; $return =~ s/\$/&#36;/g;
 	$return =~ s/\s+<\s+/ &lt; /g; $return =~ s/\s+>\s+/ &gt; /g;			# improvement : handle < > in tcDesc
	if ($return =~ /^\s*$/) { $return = "Testsuite has no Testcase";}		# bug fix on 2013/09/20
	return $return;
}

sub generateIndex_pyAnvil_pl {
	my $cwd = $SvrProjName; my $cmd = $SvrProjName. "\/index.ps1";
	open Fout, "> ".$cwd."/index_pyAnvil.pl";
print Fout<<EOF_;
############################ index_pyAnvil.pl ###################################
use strict;
&execTC(\$ARGV[0]);

sub execTC {
	my \$passFail='FAIL'; my \$logHtml; my \$logXml	;
	my \$pyAnvil= $c.'/pyAnvil/pyAnvil -s '		;
	my \$tcDir  = "$cwd\/"		;
	my \$testsuiteHook = "index.pl"			; 
	my \$tcId   = -1				; \$tcId   = shift if \@_;
	my \$tcDesc = "Testcase \$tcId Demo"		; \$tcDesc = shift if \@_;
	my \$tsDesc = "pyAnvil Testsuite Demo"		; \$tsDesc = shift if \@_; 

	\$testsuiteHook = \$tcDir.\$testsuiteHook		; 
	my \$tcScenario = "_tc.xml"			; \$tcScenario = \$tcDir."_tc.xml"	; 
	my \$tcLog_pyAnvil = "_tcLogAppend_.txt"         ; \$tcLog_pyAnvil = \$tcDir."\$tcLog_pyAnvil";
	if (\$tcId =~ /^\\s*\$/) { print `\$testsuiteHook`; return 0; }
my \$str=<<EOF;
<?xml version="1.0" encoding="utf-8"?>
<XMLTestCollection>
    <TestList TestCases="\$tcDesc">
	<ToolCase>
	    <Name>\$tcDesc</Name>
	    <Executable>C:/strawberry/perl/bin/perl.exe</Executable>
	    <Parameters>\$testsuiteHook \$tcId</Parameters>
	    <StdoutContains>PASS</StdoutContains>
	</ToolCase>
    </TestList>
</XMLTestCollection>
EOF
	open Fout, ">\$tcScenario"; print Fout \$str; close Fout; my \$cmd = \$pyAnvil."\$tcScenario"; my \$rst = `\$cmd`; 
	foreach my \$each (split /\n/, \$rst) { 
		if (   \$each =~ /^\\s+PASS\\s+/)     { \$passFail = "PASS";}
		elsif (\$each =~ /^\\s+FAIL\\s+/)     { \$passFail = "FAIL";}
		elsif (\$each =~ /^\\s+XML:\\s+(.+)/) { \$logXml   = \$1;}
		elsif (\$each =~ /^\\s+HTML:\\s+(.+)/){ \$logHtml  = \$1;}
	}
open Fout, "> \$tcLog_pyAnvil "; print Fout "\$rst\n"; close Fout;  print "- > \$tcLog_pyAnvil\n"; 
	print "\$passFail\n"; 
}
############################ index_pyAnvil.pl ###################################
EOF_
	close Fout; print    "  -->".$cwd."/index_pyAnvil.pl\n";

}
sub generateExcelReport {
	my $key; my %listHistory; my %tcDesc; my @tcExecDateTime; my $tcExecDateTimeCtr=0; my $isPassFail = "n"; my $tsName= "MVSDK_OCSP"; my @columnWidth;
	# bug: _tc_Desc.txt and _list_history_tcRunResult are not genreated 	- fixed by NofPropertyExecCtr = 0; !!!!!!
	my    $rst   = &processTCs ("","testsuite=$SvrProjName;AutomationtsName=$SvrProjName;pr2Screen=0;resetTSFileName=_list_history_tcRunResult.txt;resetTSFile;propertyOp=list_history_tcRunResult;pr2Screen=1");
		$NofPropertyExecCtr=0; $propertyOp="";
	      $rst   = &processTCs ("","testsuite=$SvrProjName;AutomationtsName=$SvrProjName;pr2Screen=0;resetTSFileName=_list_tcDesc.txt;resetTSFile;propertyOp=list_tcDesc;pr2Screen=1"); 
		$NofPropertyExecCtr=0; $propertyOp="";
	my $tcDescMax=40; my $tcIdMax=10;
	if ( -e "$SvrDrive/$SvrProjName/_list_tcDesc.txt") {
		##### print " <- $SvrDrive/$SvrProjName/_list_tcDesc.txt\n";
		open Fin, "$SvrDrive/$SvrProjName/_list_tcDesc.txt" || die "Can't open file $!"; 
		while( $_ = <Fin>) {
		chop; 
		$_ =~ s/(list_)?tcDesc\s*=\s*(\d+\.)?//; 
		if ($_ =~ /testcase\d+(_)?\s+/) { @_ = split (/\t/, $_); 
			my $key = $_[0]; my $value = $_[1];	
			if ($_ =~ /\/_/)  {;} else { # exclude directory like /_ 
				## $value =~ s/_.+_//g; # remove property
				$value = &removeTags($value);
					}
			$tcDesc{$key} = $value; 
			if (length($value) > $tcDescMax) { $tcDescMax = length ($value); }
			if (length($key) > $tcIdMax) { $tcIdMax = length ($key); }
		} 
		} 
	        close Fin;	
	} else { print "Info: $SvrDrive/$SvrProjName/_list_tcDesc.txt doesn't exist. Proceed ... (generateExcelReport won't work. Run -propertyOp=list_tcDesc)\n"; return 0 ;}

	$columnWidth[0]=$tcIdMax; $columnWidth[1]=$tcDescMax;

	if ( -e "$SvrDrive/$SvrProjName/_list_history_tcRunResult.txt") {
	####		print " <- $SvrDrive/$SvrProjName/_list_history_tcRunResult.txt\n";
	open Fin, "$SvrDrive/$SvrProjName/_list_history_tcRunResult.txt" || die "Can't open file $!"; 
	while($_ = <Fin>) { chop; s/\s*=\s*/ /g;
		if ($_ =~ /list_history_tcRunResult/) { 
			if ($_ =~ /list_history_tcRunResult/) { $tcExecDateTimeCtr ++ ;}
			@_ = split (/\s+/, $_); 
			$_ =~ /(.+)\s+(.+)/;
			$key 	= $_[0]; my $value 	= $_[1];
			if ($_ =~ s/^.+list_history_tcRunResult//) {
				my $passFail=""; my $date="";
				if ($_ =~ /tcRunResult\s*(\S+)\s+\@\s+(\d\d\d\d-\d\d-\d\d\s+\d\d:\d\d:\d\d)/ ) {
				$passFail = $1; $date = $2; }
				if ($passFail =~ /pass|fail|\d+/i) { 
					my $tmp = $listHistory{$key};	# remove the unreasable error - concat undefined variables
					if ($tmp) {;} else { $tmp="";}
					$listHistory{$key} = $tmp."$passFail\t"; 
					$isPassFail = 'y';
				} else {$isPassFail = 'n'; }
				if (($isPassFail =~ /y/i) && ($tcExecDateTimeCtr == 1)) { push (@tcExecDateTime, $date) ;} 
;
			}
		} elsif ($_ =~ /tcRunResult/i) {
			my $passFail = ""; my $date = "";
			#if ($_ =~ /tcRunResult\s*(\S+)\s+\@\s+(\d\d\d\d-\d\d-\d\d\s+\d\d:\d\d:\d\d)/) {
			if ($_ =~ /tcRunResult\s*(\S+)\s+\@\s+(\d\d\d\d-\d\d-\d\d\s+\d\d:\d\d:\d\d)/) {
			$passFail = $1; $date = $2; 
			}
			if ($passFail =~ /pass|fail|\d+/i) { 
				my $tmp = $listHistory{$key};	# remove the unreasable error - concat undefined variables
				if ($tmp) {;} else { $tmp="";}
				$listHistory{$key} = $tmp."$passFail\t"; 
				$isPassFail = 'y';
			} else {$isPassFail = 'n'; }
			if (($isPassFail =~ /y/i) && ($tcExecDateTimeCtr == 1)) { push (@tcExecDateTime, $date) ;
} 
		} else {
			;
		}
	} 
	close Fin;
	} else { print "Info: $SvrDrive/$SvrProjName/_list_history_tcRunResult.txt doesn't exist. Proceed ... (generateExcelReport won't work. Run propertyOp=list_history_tcRunResult)\n"; return 0 ;}


open Fout, "> $SvrDrive/$SvrProjName/_generateExcelReport.txt";
open Fout1, "> $SvrDrive/$SvrProjName/_generateExcelReport.html"; print Fout1 "<html><body><pre>\n";
my $currentDate ="";
for (my $i = 0; $i <= $#tcExecDateTime; $i++) { 
	$tcExecDateTime[$i] =~ /(\d\d\d\d-\d\d-\d\d)\s+(\d\d:\d\d:\d\d)/; my $date = $1; my $time = $2; 
	if ($currentDate eq $date) { 
	$tcExecDateTime[$i] = $time; $columnWidth[$i+2] = length ($time); } elsif ($currentDate ne $date) { $currentDate = $date; $columnWidth[$i+2] = length ("$date $time"); }
} 

printf Fout "Test Suite Name: $AutomationtsName\n";
printf Fout1 "Test Suite Name: $AutomationtsName\n";

printf Fout "%-${tcIdMax}s\t%-${tcDescMax}s\t", "tcId", "Description"; for (my $i = 0; $i <= $#tcExecDateTime; $i++) { print Fout "($tcExecDateTime[$i])\t"; } print Fout "\n";
printf Fout1 "%-${tcIdMax}s %-${tcDescMax}s", "tcId", "Description"; for (my $i = 0; $i <= $#tcExecDateTime; $i++) { print Fout1 "($tcExecDateTime[$i])"; } print Fout1 "\n";

foreach my $each (sort keys %listHistory) { 
	my $each_ = $each; 
	if ($tcDesc{$each}) {
		printf Fout "%-$columnWidth[0]s\t%-$columnWidth[1]s\t", $each_, $tcDesc{$each};
		printf Fout1 "%-$columnWidth[0]s %-$columnWidth[1]s ", $each_, $tcDesc{$each};
	} else {	# for Test-AutomationFramework.t  
		printf Fout "%-$columnWidth[0]s\t%-$columnWidth[1]s\t", $each_, "";
		printf Fout1 "%-$columnWidth[0]s %-$columnWidth[1]s ", $each_, "";
	}

	my @fields = split (/\t/, $listHistory{$each}); 
	for (my $i=0; $i <= $#fields; $i++) {
		my $tmp;
		if ($columnWidth[$i + 2]) {;} else { $columnWidth[$i+2] = 10;}
		$tmp = $columnWidth[$i + 2] + 1;
		if ($tmp) {;} else { $tmp = $excelReportColumnWidth;} 
		printf Fout "%-${tmp}s\t", $fields[$i];
		printf Fout1 "%-${tmp}s ", $fields[$i];
	}
	print Fout "\n";
	print Fout1 "\n";
}

close Fout;
print Fout1 "</pre></body></html>\n";
close Fout1;
#### uncomment for debugging    print " -> $SvrDrive/$SvrProjName/_generateExcelReport.html\n";
1;
}

sub generateIndex_pl {
	my $cwd = $workingDir; $cwd = shift if @_;
	open Fout, "> ".$cwd."/index.pl";
	my $ps1_args_ = $ps1_args;
	$ps1_args_ =~ s/\\/\//g;

print Fout<<EOF_;

##################### index.pl for pyAnvil ############################

my \$testsuiteHook = "powershell -executionpolicy unrestricted -file $cwd/index.ps1 ";
my \$testsuiteHookPartB = " \$ps1_args_";


if    (\$ARGV[1]) { print &call_index(\$ARGV[0], "noExec") ;	}  
elsif (\$ARGV[0]) { print &call_index(\$ARGV[0], "yesExec");    }
else             { print &call_index();                         }


sub call_index { 		my \$return ; my \$recordCtr=1;
	if (\@_) {;} else {; return `\$testsuiteHook \$testsuiteHookParkB`;}
	my \$indexCtr = 9999	; \$indexCtr = shift if \@_; 		 
	my \$execYN   = 'noExec' ; \$execYN   = shift if \@_; 
	\@_ = (split /\\n/, `\$testsuiteHook`) ;


	foreach \$each (\@_) { 
		if ((\$each) && (\$each =~ /^\\s*_/)) { \$return = \$return .\$each."\n";
		} elsif ((\$each) && (\$each !~ /^\\s*_/)) {
			\$return = \$return . sprintf "TC [%04s] %s\\n",\$recordCtr,\$each; 
			if ((\$recordCtr == \$indexCtr ) && ( \$execYN =~ /noExec/i )) { return "TC [\$recordCtr]       \$each"; } 
			if ((\$recordCtr == \$indexCtr ) && ( \$execYN =~ /yesExec/i)) { return `\$testsuiteHook \$indexCtr \$testsuiteHookPartB`  ; } 
			\$recordCtr++;
	  	} 
 	} 
	if (\$return =~ /pass/i) { return 0;} 
	if (\$return =~ /fail/i) { return 1;} 
}

##################### index.pl for pyAnvil ############################
EOF_
	close Fout; print    "  -->".$cwd."/index.pl\n";


}

sub generatePerl_pl_template {
	my $cmd = $SvrProjName; 
	if (-e $cmd) {;} else { mkdir $cmd; }
	mkpath $cmd;
	open Fout, "> $cmd/index.pl";
	my $tsNameTmp =	&getRoot($cmd);
print Fout<<EOF_;
#!$perl_
\$tcName = "$tsNameTmp";
if (\$^O =~ /win32/i) { \$_TAF = "$c"; } if (\$^O =~ /linux/i) { \$_TAF = "/tmp/var/www/cgi-bin"; } 
\$tcDir = "\$_TAF/\$tcName";


if (\$ARGV[0]) { 
	open Fout, ">\$tcDir/_tcLogAppend.txt";
	if (\$ARGV[0] == 1) { print "pass"; } # <<< plug in the test case 1 here e.g. print `index.pl 1` ; >>>
	if (\$ARGV[0] == 2) { print "pass"; } # <<< plug in the test case 2 here e.g. print `index.pl 2`>>>
	if (\$ARGV[0] == 3) { print "pass"; } # <<< plug in the test case 3 here e.g. print `index.pl 3`>>>
	if (\$ARGV[0] == 4) { print "pass"; } # <<< plug in the test case 4 here e.g. print `index.pl 4`>>>
	if (\$ARGV[0] == 5) { print "pass"; } # <<< plug in the test case 5 here e.g. print `index.pl 5`>>>
	if (\$ARGV[0] == 6) { print "pass"; } # <<< plug in the test case 6 here e.g. print `index.pl 6`>>>
	close Fout;
} else {
print \<\<EOF;
1. Test case description 1 for < > \\\$ \\\% @ testing the function 1 --- Please modifyaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa _smoke_ _regression_
2. Test case description 2 for testing _smoketest__regressiontest_the function 2 --- Please modifybbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb _smoke_
3. Test case description 3 for testing _smoketest_the function 3 --- Please modifycddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd _regression_
4. Test case description 4 for testing _regressiontest_the function 4 --- Please modify _smoke_
5. Test case description 5 for testing _regressiontest_the function 5 --- Please modify
6. Test case description 6 for testing the function 6 --- Please modify
EOF
;
}

EOF_
	close Fout;
	print "\n[Warning] Creating Temporial testsuite hook --> [".$SvrProjName."/index.pl]\n"; ; 
}

sub generatePowershell_ps1_template {
	my $cmd = $SvrProjName; 
	open Fout, "> $cmd/index.ps1";
	my $tsNameTmp =	&getRoot($cmd);
	my $tmpWorkingDir = $tsNameTmp; $tmpWorkingDir =~ s/\\/\//g;
print Fout<<EOF_;

###########################
param([INT]\$index = "-1", \$buildpath="")

if(\$verbose -eq \$true) { cls }

\$subHtml = "/auto_html/LBP_automation.html"
\$index = \$index -1 		
######################################################################################
# Dictionary for pre-canned test scenarios.
######################################################################################
\$testDictionary = \@()

\$testDictionary += \@( `
		\@{	"desc" = "Testcase1 description $SvrProjName"; 
			"result" = "PASS";
		} `
)
\$testDictionary += \@( `
		\@{	"desc" = "Testcase2 description $SvrProjName _smoketest_ _regression_ _regressiontest_"; 
			"result" = "FAIL"; 
		} `
)
\$testDictionary += \@( `
		\@{	"desc" = "Testcase3 Description $SvrProjName _smoketest_ _regression"; 
			"result" = "FAIL"; `
		} `
)
\$testDictionary += \@( `
		\@{	"desc" = "Testcase4 Description $SvrProjName _smoketest_"; `
			"result" = "PASS"; `
		} `
)


################################################################################################

\$idx = [Int32]::Parse(\$index)
\$testDictionaryCount =  \$testDictionary.length - 1
\$count = 1
if((\$idx -lt 0) -or (\$idx -gt \$testDictionaryCount)) 
{
	foreach(\$dictionaryDesc in \$testDictionary) 
	{
		Write-Host "\$count :"\$dictionaryDesc.desc
		\$count++
	}
	exit
}

write-host \$testDictionary[\$idx].result;



###########################

EOF_
	close Fout;
	print "\n[Warning] Creating Temporial testsuite hook --> [".$SvrProjName."/index.ps1]\n"; ; 
}

sub eraseTAFTestsuite {goto &deleteTAFTestsuite}


sub deleteTAFTestsuite {
        my $c_ = $c; my $_TAF_ = $_TAF; my $SvrProjName_ = $SvrProjName;
        if ($SvrProjName_ =~ /^$c_/ ) {
        	if ($^O =~ /win/i) { $SvrProjName_ =~ s/^$c//;}
        	my $TSDir = "$c/$_TAF/$SvrProjName_"; $TSDir =~ s/\/\//\//g;
                if ( -e $TSDir ) {
                        rmtree $TSDir;
                        print "Delete TAF Testsuite $TSDir\n";
                        &generateRootIndex();
                } else {
                        print "Warning: TAF Testsuite $c_/${_TAF}$SvrProjName_ doesn't exist!\n";
                }
        } else {
                print "\nWarning: $SvrProjName_ is NOT a TAF testsuite. \n($SvrProjName_ !~ $c_)\n\n";
        }
}

########### index2index

sub index2index {       #### Generate subIndex from TAF-generate-index.pl       # input $tcDir, $matchStr

	my $tcDir = $SvrProjName; 
	my $matchStr = "2013.09.13"; $matchStr = shift if @_;

        my @tcExec_; my @tcDesc_;        my $is_tcDesc="n";  my %tcDesc_; my %tcExec_;
        if (-e "$tcDir/index.pl") {;} else {print "Warning: There is no $tcDir/index.pl. The taf.pl exit\n"; exit; }
        open Fin, "$tcDir/index.pl"; my @index = <Fin>; close Fin;
        foreach my $each (@index) {
                if ($each =~ /ARGV\[0\]\s*==/) {
                        $each =~ /\{(.+); print \"null\"/i;  $each = $1;
                        $each =~ s/^\s*print\s+Fout\s+\"//g;
                        $each =~ s/\"\s*$//g;
                        push (@tcExec_, $each);
                }
                if ($each =~ /print<<EOF;/) { $is_tcDesc = 'y'; }
                elsif ($each =~ /^EOF\b/) { $is_tcDesc = 'n'; }
                elsif ($is_tcDesc =~ /y/i) { chop $each; push (@tcDesc_, $each);} }

        for (my $i = 0; $i <= $#tcDesc_; $i++ )  {
                if ($tcDesc_[$i] =~ /$matchStr/i) {
                $tcDesc_{$i} = $tcDesc_[$i];
                $tcExec_{$i} = $tcExec_[$i];
                }
        }

if (-e "$tcDir/$matchStr") {;} else { mkpath ("$tcDir/$matchStr"); print " -dir-> $tcDir/$matchStr\n";} #### create new TS dir

open INDEX , ">$tcDir/$matchStr/index.pl";
print INDEX <<EOF;
#!/usr/bin/perl.exe
\$tcName = "AresPerformance";
 if (\$^O =~ /win32/i) { \$_TAF = "c:"; } if (\$^O =~ /linux/i) { \$_TAF = "/tmp/var/www/cgi-bin"; }
 \$tcDir = "\$_TAF/\$tcName";

 if (\$ARGV[0]) {
        open Fout, ">\$tcDir/$matchStr/_tcLogAppend.txt";

EOF

my $ctr = 1;
foreach my $each ( sort keys %tcExec_) { print INDEX "if (\$ARGV[0] == ".$ctr++.") \{print Fout \"$tcExec_{$each}\\n\\\"; \\nThe results are also displayed at <a href=\\\"http://pdxnpgraph01.iovationnp.com\\\" >Graphite</a> _url_line_ \nprint \\\"null\\\"\";\}\n"; }

print INDEX <<EOF;
        close Fout;
        } else {

EOF
print INDEX "\nprint<<EOF;\n";

   $ctr = 1;
foreach my $each (sort keys %tcDesc_) { print INDEX $ctr++.". $tcDesc_{$each}\n"; }

print INDEX "EOF\n}\n";

close INDEX;
print " -> $tcDir/$matchStr/index.pl\n";
}


########### index2index


sub generateTAFTestsuite {goto &generateTestsuite}
sub generateTestsuite { 						# Generating 1. index.pl 2. index.pl + index_pyAnvil.pl 
	my $cmd = $SvrProjName ;  $cmd = shift if @_;
	#if ($cmd !~ /:/) { $cmd = $c.'/'.$_TAF.'/'.$cmd; }		linux
	# This is a logic for window system (c:) if testsuite !~ c:\, it is a TAF TS under c:\_TAF\....

	if ($SvrProjNameSub !~ /^\s*$/) { &index2index($SvrProjNameSub);  exit;}
       

	if ( $^O =~ /win32/i ) {	# window only logic
		if ($cmd !~ /$c\//i) { $cmd = $c.'/'.$_TAF.'/'.$cmd; }
	}

	$cmd =~ s/\/\//\//g;		# Fix the // problem in the linux coding

	my $cwd = $cmd;

	if ( -e $cwd) {;} else { mkpath $cwd;		#### bug fix 
	if ($tsDriver =~ /null/i) { $tsDriver = "$cmd\/index.pl"; }	
		&generatePerl_pl_template();	
	}				
	if (-e "$cmd\/index.ps1") { $cmd = $cmd . "\/index.ps1";	#### pre-existing testsuiteHook is index.ps1 
		&generateIndex_pl ($cwd)			  ; 	# --> generate index.pl 
		$cmd =~ s/index.ps1/index.pl/; 
		}
	elsif (-e "$cmd\/index.pl")     { 
		$cmd = $cmd . "\/index.pl";}				#### pre-existing testsuiteHook is index.pl 
	else  { 							####  No pre-existing index.pl 
		if ($tsDriver =~ /null/i) { $tsDriver = "$cmd\/index.pl"; }	
		&generatePerl_pl_template();
	}								

	##############################################  subroutine Main ###########################################
	$cmd = shift if @_; my $testsuiteName="_default_testsuiteblas_"; my $testsuitePropertyFName='tsProperty.txt'; my $testDriverName = $cmd; 
	my $tsPropertyStr = "web_ui_title: "; my $tcCtr=1; my $TAF= $SvrDrive ;
 	$testsuiteName = &getRoot_4($cwd);  			############ $testsuiteName = &getRoot(&getcwd());  
if ($^O =~ /win32/i) { $testsuiteName =~ s/^\s*$_TAF//g; }
	if (($TSHookIsPerl =~ /y/i) && ($cmd =~ /index\.ps1\s*$/))    { $cmd =~ s/index\.ps1\s*$/index\.pl /g;}	 

	############ Generate Property file for webUI tc description
	if ($ps1_args =~ /^\s*$/) { $ps1_args = "-ps1_args powershell_args";}
 	if ($cmd =~ /\.ps1\s*$/) { $cmd = "powershell -executionpolicy unrestricted -file ". $cmd. " $ps1_args"; }

	foreach my $each (split "\n", &runPowershell($cmd)) {	# get testsuiteName _testsuitename_: (\w+)and _testdrivername_: (\w+)
		if    ($each =~ /_testsuitename_/i)  { $each =~ /_testsuitename_\s*:\s*(.+)\s*$/i;  $testsuiteName  = $1; if ($testsuiteName =~ /\s/) { print "white space in testsuitename\n";exit; }}
		elsif ($each =~ /_testdrivername_/i) { $each =~ /_testdrivername_\s*:\s*(.+)\s*$/i; $testDriverName = $1; }
		else { ; }
	}
####  <--$cmd       _testsuitename_ : [$testsuiteName] 
####  <--$cmd       _testdrivername_: [$testDriverName] 
$testsuiteName =~ s/^\///g; # linux
print<<EOF;
  <--$cmd 
  --> $c/$_TAF/$testsuiteName ...... (Can take several minutes)
EOF

	if ($web_ui_title =~ /Test Automation Framework/) {$tcCtr=1; $tsPropertyStr = $tsPropertyStr . " $testsuiteName : web_ui_title\n";} # overwrite web_ui_title 
	else {$tcCtr=1; $tsPropertyStr = $tsPropertyStr . " $web_ui_title: web_ui_title\n";}

	foreach my $each (split "\n", &runPowershell($cmd)) { # get testsuitePropertyString
		if    ($each =~ /_testsuitename_/i)  { $each =~ /testsuitename_\s*:\s*(.+)\s*$/i;	$testsuiteName  = $1; }
		elsif ($each =~ /_testdrivername_/i) { $each =~ /testdrivername_\s*:\s*(.+)\s*$/i; 	$testDriverName = $1; }
		elsif ($each =~ /^\s*\n/i) { ; }
		elsif ($each =~ /^\s*$/i) { ; }
		else { 
			if ($each =~ /^\s*\d/) { 		#### Fix duplicated serial # problem  - double serial # problem
			$tsPropertyStr = $tsPropertyStr . sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d\|%s\n", $tcCtr, $each; $tcCtr++;
	  		} else {	
			$tsPropertyStr = $tsPropertyStr . sprintf "$c/$_TAF\/$testsuiteName\/testcase%04d\|%4d  %s\n", $tcCtr, $tcCtr, $each; $tcCtr++;
			}
		} 
	}
	############ Generate Property file for webUI tc description

	############ add tcDesc Property #############

	my $tcCtr_ = 0;
	foreach my $each (split "\n", &runPowershell($cmd)) { # get testsuitePropertyString
		if    ($each =~ /_testsuitename_/i)  { $each =~ /testsuitename_\s*:\s*(.+)\s*$/i;	$testsuiteName  = $1; }
		elsif ($each =~ /_testdrivername_/i) { $each =~ /testdrivername_\s*:\s*(.+)\s*$/i; 	$testDriverName = $1; }
		elsif ($each =~ /^\s*\n/i) { ; }
		elsif ($each =~ /^\s*$/i) { ; }
		else { 
			$each =~ s/\s/_space_/g;
			$each =~ s/:/_column_/g;
			$each =~ s/=/_eq_/g;
			$tcDesc[$tcCtr_] = $each ; $tcCtr_ ++; 
			$propertyOp = "tcDescAuto";
		} 
	}
	############ add tcDesc Property #############
	############ Generate Tags Property ################

	my @tcDescPropertyList; my $ctr=0; my $maxPropertyNameLength=1; my %propertyList;

	foreach my $each (split "\n", &runPowershell($cmd)) { # get testsuitePropertyString
		$each =~ s/__/_ _/g; @_ = ($each =~ /_\w+_/gi ) ; 
		for (my $i=0; $i <= $#_;$i++) { $propertyList{$_[$i]}=$_[$i];
			if ($maxPropertyNameLength < length($propertyList{$_[$i]})) { $maxPropertyNameLength = length($propertyList{$_[$i]}); }
		}
	}
	############ Generate Tags Property ################

	############ Create Testsuite/Testcase
	$tcCtr=1;
	foreach my $each (split "\n", &runPowershell($cmd)) { # get testsuitePropertyString
		if    ($each =~ /_testsuitename_/i)  { $each =~ /testsuitename_\s*:\s*(.+)\s*$/i;	$testsuiteName  = $1; }
		elsif ($each =~ /_testdrivername_/i) { $each =~ /testdrivername_\s*:\s*(.+)\s*$/i; 	$testDriverName = $1; }
		elsif ($each =~ /^\s*\n/i) { ; }
		elsif ($each =~ /^\s*$/i) { ; }
		else { 
			if ($tsDriver !~ /null/) { $testDriverName = $tsDriver; } # tsDriver overwrite testDriverName
			#### todo: need to decide to generate pl or ps1 
		
			my $ps1_args_; my $cmd_; 	
			if (    $cmd =~ /index\.ps1\s*$/) {
				$ps1_args_ = $ps1_args; $ps1_args_ =~ s/ /___/g; $ps1_args_ =~ s/\\/\//g; # ps1_args 
				$cmd_ = sprintf "ps1_args=$ps1_args_;testsuite=$testsuiteName;create=testcase%04d/customTC:${testDriverName}_space_${tcCtr}:customTC\n", $tcCtr  ; 
			} elsif ( $cmd =~ /index\.pl\s*$/) {
				$cmd_ = sprintf "testsuite=$testsuiteName;create=testcase%04d/customTC:${testDriverName}_space_${tcCtr}:customTC\n", $tcCtr  ; 
			}

			&processTCs("",$cmd_);
			my $tcnameTmp = sprintf "$c/$_TAF/$testsuiteName/testcase%04d", $tcCtr++;
			my $propertyTmp = $each;
			$propertyTmp =~ s/ /_space_/g; 
			$propertyTmp =~ s/:/_column_/g; 
			$propertyTmp =~ s/=/_eq_/g; 
			$propertyTmp =~ s/ /__/g; 
			&processProperty("",$tcnameTmp, "set_tcDesc_as_$propertyTmp");
			foreach $each (split (",", $tags)) { if ($propertyTmp =~ /$each/i) { &processProperty("",$tcnameTmp, "_add_${each}_as_y"); } }

			$propertyTmp=""; #### reuse the variable
			foreach my $propertyName (sort keys %propertyList) {
				if ($each=~ /\b$propertyName\b/i) {
					$propertyTmp = sprintf "$propertyTmp%-${maxPropertyNameLength}s",$propertyName;
				} else {
					$propertyTmp = sprintf "$propertyTmp%-${maxPropertyNameLength}s","_null_";
				}
			}
			$propertyTmp =~ s/ /_space_/g; 
			$propertyTmp =~ s/:/_column_/g; 
			$propertyTmp =~ s/=/_eq_/g; 
			$propertyTmp =~ s/ /__/g; 
			&processProperty("",$tcnameTmp, "set_tcTags_as_$propertyTmp");
		}
	}

	$tcCtr = 1;
	############ Create Testsuite/Testcase
	open Fout, ">>$c/$_TAF/$testsuiteName/$testsuitePropertyFName" || die "Can't create file\n"; print Fout $tsPropertyStr; close Fout;
	print    "  -->$c/$_TAF/$testsuiteName/$testsuitePropertyFName\n";
#	&generateGenerateTestsuite(); 
	#### print    "  -->$c/$_TAF/$testsuiteName/generateTestsuite.pl\n";

	if ( -e "$c/$testsuiteName/_tcMap.txt" ) { 
		open Fin2, "$c/$testsuiteName/_tcMap.txt" ;
		open Fout2, ">$c/$_TAF/$testsuiteName/_tcMap.txt"; 
		while ($_=<Fin2>) { $_ =~ s/$c/$c\/$_TAF/ig; print Fout2 $_; }
		close Fout2; 
		close Fin2;
		print    "  -->$c/$_TAF/$testsuiteName/_tcMap.txt\n";
	}
	$testsuiteName = $testsuiteName;
			if ($testcaseNode =~ /^\s*$/) { $testcaseNode = "_null_"; }
			#$cmd = sprintf "$c/$_TAF/taf.pl tcDelay=0;performanceMode=fast;testcaseNode=$testcaseNode;testsuite=$testsuiteName;list"; 
			#print "\nlist: todo> $cmd\n". `$cmd`;
			#### !!!!!!!!!! the processTCs works !!!!!!!!!!!!!!!
			$cmd = sprintf "tcDelay=0;testcaseNode=$testcaseNode;testsuite=$testsuiteName;list";  &processTCs("",$cmd); # todo
			&generateRootIndex();
	if ($interact =~ /\by\b/) {system ("C:/Program Files/Internet Explorer/iexplore.exe", "$c/$_TAF/$testsuiteName/index.htm");}

	print "\n";
	1;
}


sub generateTAFChildTestsuites { 						# Generating 1. index.pl 2. index.pl + index_pyAnvil.pl 
	my $cmd = $SvrProjName ;  $cmd = shift if @_;
	if ($cmd !~ /:/) { $cmd = $c.'/'.$_TAF.'/'.$cmd; }
	my $cwd = $cmd; my $testsuiteName = &getRoot_4($cwd);  			############ $testsuiteName = &getRoot(&getcwd());  
	if (-e "$cmd\/index.ps1") { $cmd = $cmd . "\/index.ps1";		#### pre-existing testsuiteHook is index.ps1 
		}
	elsif (-e "$cmd\/index.pl")     { 
		$cmd = $cmd . "\/index.pl";}					#### pre-existing testsuiteHook is index.pl 
	else  { 								####  No pre-existing index.pl 
		print "generateChildTestsuites: The parentTestsuite doesn't exist! \n"; exit; 
	}								

	open FOUT, ">$c/$_TAF/_generateChildTestsuite.bat"; 

 	if ($cmd =~ /\.ps1\s*$/) { $cmd = "powershell -executionpolicy unrestricted -file ". $cmd. " $ps1_args"; }
	foreach my $each (split "\n", &runPowershell($cmd)) {	# get testsuiteName _testsuitename_: (\w+)and _testdrivername_: (\w+)
		 $each = " _full_ ".$each;
		@_ = $each =~ /_(\w+)_/g; 
		if ($#_ > 0) {	
			foreach my $each1 (@_) { 
				if ($recordTags{$each1}) { $recordTags{$each1} = $recordTags{$each1} + 1; } else { $recordTags{$each1} = 1;}
			} 
		}
	}

		#$cmd = "$c/$_TAF/$taf testsuite=$SvrProjName;tcPropertyName=_full_;generateTestsuiteByDesc\n"; $cmd =~ s/\//\\/g; print FOUT "$cmd"; 	# todo  \\
		#$cmd = "$c/$_TAF/$taf testsuite=$SvrProjName/_full_;generateTestsuite\n"; $cmd =~ s/\//\\/g; print FOUT "$cmd"; 			# todo  \\
		$cmd = "$c/$_TAF/$taf testsuite=$SvrProjName;tcPropertyName=_full_;generateTestsuiteByDesc\n"; 		print FOUT "$cmd"; 			# todo5 \\
		$cmd = "$c/$_TAF/$taf testsuite=$SvrProjName/_full_;generateTestsuite\n";  				print FOUT "$cmd"; 			# todo6 \\
		
	foreach my $key (sort hashValueDescendingNum (keys(%recordTags))) { 
		if ($key !~ /\bfull\b/i) {
		#$cmd = "$c/$_TAF/$taf testsuite=$SvrProjName;tcPropertyName=_${key}_;generateTestsuiteByDesc\n"; $cmd =~ s/\//\\/g; print FOUT "$cmd"; 	# todo \\
		#$cmd = "$c/$_TAF/$taf testsuite=$SvrProjName/_${key}_;generateTestsuite\n"; $cmd =~ s/\//\\/g; print FOUT "$cmd"; 			# todo \\
		$cmd = "$c/$_TAF/$taf testsuite=$SvrProjName;tcPropertyName=_${key}_;generateTestsuiteByDesc\n"; 	print FOUT "$cmd"; 	# todo7 \\
		$cmd = "$c/$_TAF/$taf testsuite=$SvrProjName/_${key}_;generateTestsuite\n"; 				print FOUT "$cmd"; 			# todo8 \\
		}
	
	}
	close FOUT;
	print " -> $c/$_TAF/_generateChildTestsuite.bat\n --.....-> Running $c/$_TAF/_generateChildTestsuite.bat to generate _smoke_, _regression_ sub Testsuite\n";    
	
	##############################################################################################

	1;
}
sub hashValueDescendingNum { $recordTags{$a} <=> $recordTags{$b}; }


sub help4install {
	&genDriver_taf_pl ();
	&genDriver_taf_cgi ();

my $help=<<EOF;
-----------------------------------------------------------------------------------------------------------------------
	Test::AutomationFramework - Test Automation Framework  (TAF)	version: $VERSION

	TAF manages automated test cases regarding test setup, test query, test execution and 
	test reportings with *ONE* mouse-click. No programming and no manual Reading.

        ---------------------------------------------------------------------------------------------------------------
	$c/$_TAF/index.htm	         WebAccess TAF-Testbed
	$c/$_TAF/taf.pl -help4intro      TAF Introduction
	$c/$_TAF/taf.pl -help4install    Command_line usages 
	$c/$_TAF/taf.pl -help4cmd        Command_line usages 
	$c/$_TAF/taf.pl -help4developer  Historical and under-development Functions
        ---------------------------------------------------------------------------------------------------------------

	TAF Test Case integration - $c/$_TAF/[test_suite]/[test_case]/tc.pl
				
			* $c/$_TAF/[test_suite]/[test_case]/tc.pl  : print Pass|fail|number to STDOUT
			* $c/$_TAF/[test_suite]/[test_case]/tc.pl  : geneate TC Log as cwd()/_appendLog.txt 

	TAF Test Suite integration - $c/$_TAF/[test_suite]/index.pl or index.ps1

			* $c/$_TAF/index.[pl|ps1]             : print one TC Description per line
			* $c/$_TAF/index.[pl|ps1] Index       : exec Index-th TC

  	[Web Access: http://$c/$_TAF/index.htm]
	1. Install StrawberryPerl 
	2. Install TAF from CPAN                 (Perl -MCPAN -e "install Test::AutomationFramework)
	3. Install TAF Testbed                           (Perl -MTest::AutomationFramework -e "help"   
	4. *One* mouse click to execute and view test results in the Test Bed

	[Web examples]
	5. Add test suite by modifying $c/$_TAF/taf.bat 
	6. Add test case by modifying $c/$_TAF/[test_suite]/[test_case]/tc.pl 
	7. Run $c/$_TAF/taf.bat to create user's test suite structure and start its webUI
	
	webUI TAF usages scenarios:  	
		List Test cases:		
			* list test pass|fail                                     (click Pass|Fail) 
			   cmd>taf.pl testsuite=_testsuit2_;list
			* list Passed test cases                               (click title's Pass)
			   cmd>taf.pl testsuite=_testsuit2_;tcFilters=tcRunResult_matches_pass 
			* list Failed test cases                             (click title's Failed)
			   cmd>taf.pl testsuite=_testsuit2_;tcFilters=tcRunResult_matches_fail
			* list non-Pass|Failed test cases          (click \| between Pass and Fail) 
			   cmd>taf.pl testsuite=_testsuit2_;tcFilters=tcRunResult_matches_null
		Exec Test cases:		
			* Exec test cases 		      	  	  (click pass|fail counters)
			   cmd>taf.pl testsuite=_testsuit2_;testcase=testcase0001;exec
			   cmd>taf.pl testsuite=_testsuit2_;testcase=testcase000[1,2,3,4];exec
			   cmd>taf.pl testsuite=_testsuit2_;testcase=testcase000[1-9];exec
			* Exec test suite 		            (click title pass|fail counters)
			   cmd>taf.pl testsuite=_testsuit2_;exec
		View Test Results
			* View historical pass/fail 	                           (click Pass|Fail) 
			* View historical logs		                           (click Test Desc) 
			* View historical pass/fail in graphics 		(click title Result)
-----------------------------------------------------------------------------------------------------------------------
EOF
	print $help;
	&genDriver_testbed();
	1;
}

sub help {
	&genDriver_taf_pl ();
	&genDriver_taf_cgi ();
	&genDriver_taf_svr ();

my $help=<<EOF;
-----------------------------------------------------------------------------------------------------------------------
	Test::AutomationFramework - Test Automation Framework  (TAF)	version: $VERSION
		TAF manages automated test cases regarding test setup, test query, test execution and 
		test reportings with *ONE* mouse-click. No programming and no manual Reading.
-----------------------------------------------------------------------------------------------------------------------

	$c/$_TAF/taf.pl helpmore                TAF Usage Samples
	$c/$_TAF/taf.pl testsuite=_testsuit3_   Frequently Used Command line


	$c/$_TAF/index.htm	       WebAccess TAF-Testbed
	$c/$_TAF/taf.pl help4intro      TAF Introduction
	$c/$_TAF/taf.pl help4install    Command_line usages 
	$c/$_TAF/taf.pl help4cmd        Command_line usages 
	$c/$_TAF/taf.pl help4dev        Historical and under-development Functions

-----------------------------------------------------------------------------------------------------------------------
EOF
	print $help;
	&genDriver_testbed();
	sleep $outputPause;
	1;
}


sub help4intro {
if ( $^O =~ /MSWin32/ ) {; } else { print "TAF supports Win32 ONLY currently.\n"; exit; }
	&genDriver_taf_pl ();
	&genDriver_taf_cgi ();

my $help=<<EOF;
-----------------------------------------------------------------------------------------------------------------------
	Test::AutomationFramework - Test Automation Framework  (TAF)	version: $VERSION

	TAF manages automated test cases regarding test setup, test query, test execution and 
	test reportings with *ONE* mouse-click. No programming and no manual Reading.

	TAF Test Case integration - $c/$_TAF/[test_suite]/[test_case]/tc.pl
				
			* $c/$_TAF/[test_suite]/[test_case]/tc.pl  : print Pass|fail|number to STDOUT
			* $c/$_TAF/[test_suite]/[test_case]/tc.pl  : geneate TC Log as cwd()/_appendLog.txt 

	TAF Test Suite integration - $c/$_TAF/[test_suite]/index.pl or index.ps1

			* $c/$_TAF/index.[pl|ps1]             : print one TC Description per line
			* $c/$_TAF/index.[pl|ps1] Index       : exec Index-th TC

  	[Web Access: http://$c/$_TAF/index.htm]
	1. Install StrawberryPerl 
	2. Install TAF from CPAN                 (Perl -MCPAN -e "install Test::AutomationFramework)
	3. Install TAF Testbed                           (Perl -MTest::AutomationFramework -e "help"   
	4. *One* mouse click to execute and view test results in the Test Bed

	[Web examples]
	5. Add test suite by modifying $c/$_TAF/taf.bat 
	6. Add test case by modifying $c/$_TAF/[test_suite]/[test_case]/tc.pl 
	7. Run $c/$_TAF/taf.bat to create user's test suite structure and start its webUI
	
	webUI TAF usages scenarios:  	
		List Test cases:		
			* list test pass|fail                                     (click Pass|Fail) 
			   cmd>taf.pl testsuite=_testsuit2_;list
			* list Passed test cases                               (click title's Pass)
			   cmd>taf.pl testsuite=_testsuit2_;tcFilters=tcRunResult_matches_pass 
			* list Failed test cases                             (click title's Failed)
			   cmd>taf.pl testsuite=_testsuit2_;tcFilters=tcRunResult_matches_fail
			* list non-Pass|Failed test cases          (click \| between Pass and Fail) 
			   cmd>taf.pl testsuite=_testsuit2_;tcFilters=tcRunResult_matches_null
		Exec Test cases:		
			* Exec test cases 		      	  	  (click pass|fail counters)
			   cmd>taf.pl testsuite=_testsuit2_;testcase=testcase0001;exec
			   cmd>taf.pl testsuite=_testsuit2_;testcase=testcase000[1,2,3,4];exec
			   cmd>taf.pl testsuite=_testsuit2_;testcase=testcase000[1-9];exec
			* Exec test suite 		            (click title pass|fail counters)
			   cmd>taf.pl testsuite=_testsuit2_;exec
		View Test Results
			* View historical pass/fail 	                           (click Pass|Fail) 
			* View historical logs		                           (click Test Desc) 
			* View historical pass/fail in graphics 		(click title Result)
-----------------------------------------------------------------------------------------------------------------------
EOF
	print $help;
	&genDriver_testbed();
}

sub helpmore {
if ( $^O =~ /MSWin32/ ) {; } else { print "TAF supports Win32 ONLY currently.\n"; exit; }
	&genDriver_taf_pl ();
	&genDriver_taf_cgi ();

my $help=<<EOF;
-----------------------------------------------------------------------------------------------------------------------
	Test::AutomationFramework - Test Automation Framework  (TAF)	version: $VERSION

	[TAF Execution Controls]
	$c\\$_TAF\\taf.pl -help 
	$c\\$_TAF\\taf.pl tcPropertyPatternPattern=\\d+_pipe_null;tcPropertyPatternName=tcRunResult;testsuite=_testsuite3_  rem list tcRunResult =~ /performance|null/
	$c\\$_TAF\\taf.pl -processTSs [create|delete|add]=$c/_testsuite1/_testsuite2
	$c\\$_TAF\\taf.pl Execution_24_7=y;NofExecution=5;Execution=24hour;testsuite=_MV_SDK_OCSP;[list|exec]
	$c\\$_TAF\\taf.pl testsuit=CPD_QA_Tests/BATtests/MVTests/Bat/MV_2-0-1-0057/_MV_SDK_OCSP;list
	$c\\$_TAF\\taf.pl exitTAF
	$c\\$_TAF\\taf.pl ExecutionType=[runTC|runTS]
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;performanceMode=fast;list
	$c\\$_TAF\\taf.pl [SUTSymbol|tsFilterDefault]=_;tsFilter="2.2.0.217[_doit_];scanTestsuites 
	$c\\$_TAF\\taf.pl generateRootIndex
	$c\\$_TAF\\taf.pl -processTCs create=tc1/fail,overwrite
	$c\\$_TAF\\taf.pl -processTCS tsDriver=index_pyAnvil.pl;printVars;testsuite=_testsuite3_;list
		
	#####################  Powershell Testsuite Exmaples     ##################################
	$c\\$_TAF\\taf.pl -processTSs create=c:/_CRB_/AppBuildpath/_automated_testsuites_/_testsuite_ps1__powershell_
	$c\\$_TAF\\generatePyAnvilTestsuite.pl -buildpath c:/_CRB_/AppBuildpath -genTAF y

	#####################  get/set tc [Property|Filter]      ##################################
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=set_property1_[as|eq]_propVal1[_doit_]
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=_get_property1[_doit_]
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=_get__all_[_doit]

	##################### TC [list|exec] based on TC Filters ##################################
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;listTcfilters
		taf.pl testsuite=_testsuite2_;pm=fast;tcOp=listtcfilters
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;tcFilters=testproperty_matches_tsetProperValue1;[list|exec]		
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;tppp1=;tppn1=;tppp2=;tppn2=....

	$c\\$_TAF\\taf.pl tcPropertyName=smoke;tsFilterDefault=c:\\_CRB_\\AppBuildpath;generateTestsuiteByDesc
	e.g. 
		1. taf.pl testsuite=_testsuite2_;[list|print]Tcfilters
		2. taf.pl testsuite=_testsuite2_;propertyOP=_set_property1_[as|eq]_propVal1_doit_
		3. taf.pl testsuite=_testsuite2_;propertyOP=_get_property1
		4. taf.pl testsuite=_testsuite2_;tcFilters=property1_matches_PropertyValue1;[list|exec]		
-----------------------------------------------------------------------------------------------------------------------
EOF
	print $help;
	&genDriver_testbed();
	1;
}

sub help4cmd{
if ( $^O =~ /MSWin32/ ) {; } else { print "TAF supports Win32 ONLY now.\n"; exit; }
	&genDriver_taf_pl ();
	&genDriver_taf_cgi ();

my $help=<<EOF;
-----------------------------------------------------------------------------------------------------------------------
	Test::AutomationFramework - Test Automation Framework  (TAF)	version: $VERSION

	TAF manages automated test cases regarding test setup, test query, test execution and 
	test reportings with *ONE* mouse-click. No programming and no manual Reading.

	[Programmer's Usage: from command line. see TAF commands cmd> and taf cmds in $c/$_TAF/taf.bat>]

		Create Testcases		
			* c:\\_TAF\\taf.pl -processTSs create=c:/_TAF/_testsuiteTestBed/_testsuite4_
		Create Testsuites
			* c:\\_TAF\\taf.pl testsuit=_testsuite3_;create=_testcase2_/overwrite,perf,sleep=3
			* c:\\_TAF\\taf.pl testsuit=_testsuite2_;create=_testcase1_/overwrite,sleep=20
			* c:\\_TAF\\taf.pl testsuit=_testsuite3_;create=_testcase6_/overwrite,genLog,sleep=10
			* c:\\_TAF\\taf.pl testsuit=_testsuite3_;create=_testcase9_/overwrite,expectedFail,genLog,sleep=1
		Copy Testsuite 
			taf.pl tsFrom=e.txt;tsTo=ee.txt;copyTS
		TS/TC Management by _tcGlobal.txt
			taf.pl testsuite=_testsuite2;printTAFTSVars
			taf.pl testsuite=_testsuite2;testcase=testcase0002;printTAFTCVars
			
		TC Execution controls
		
			* tcIdMin			: start TC Id for Testsuite Execution (default = 0)
			* printVars			: Print Global Variables
			* printTCFilters		: print TC Filters 
			* setTCFilter			: set_property1_as_value1[_doit_]
			* getTCFilter			: get_property
			* tcFilters			: =property_match_propertyvalue
			* tsDriver			: Testsuite Driver|hook
			* web_ui_title			: set webUI title
			* Execution_24_7		: Continuous execution [y|n]
			* NofExecution			: Number of Executions
			* ExecutionDuration		: Execution Longivity
			* exitTAF			: exitTAF gracefully
			* executionType			: TC|TS
			* performanceMode		: 'slow' for webUI & 1st time execution. 'fast' for command line exec 

-----------------------------------------------------------------------------------------------------------------------

	[Examples]
	$c\\$_TAF\\taf.pl -help 
	$c\\$_TAF\\taf.pl genDriver_testbed
	$c\\$_TAF\\taf.pl generateIndex_pl | generateIndex_pyAnvil_pl
	$c\\$_TAF\\taf.pl generateTestsuite
	$c\\$_TAF\\taf.pl generateRootIndex
	taf.pl testsuite=_testsuite1_;resetTSFileName=_list_history_tcRunResult.txt;resetTSFile;resetTSFile


	#####################  TS/TC Management (Create/List/Exec) ##################################
		
	$c\\$_TAF\\taf.pl -processTCs create=tc1/fail,overwrite
	$c\\$_TAF\\taf.pl testsuite=c:/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl;createOrAppendTS=create;generateTAFTestsuite
	$c\\$_TAF\\taf.pl -processTSs [create|delete|add]=$c/_testsuite1/_testsuite2
	$c\\$_TAF\\taf.pl [SUTSymbol|tsFilterDefault]=_;tsFilter="2.2.0.217[_doit_];scanTestsuites 
	$c\\$_TAF\\taf.pl tsDriver=$c/TAF_pyAnvil/index_pyAnvil.pl;web_ui_title=Test___Automation___Framework;printVars;generateTestsuite 	Generate pyAnvil Testsuite

	$c\\$_TAF\\taf.pl tcIdMin=5;printVars;testsuite=_testsuite3_;list 
	$c\\$_TAF\\taf.pl testsuit=CPD_QA_Tests/BATtests/MVTests/Bat/MV_2-0-1-0057/_MV_SDK_OCSP;list
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;performanceMode=fast;list
	$c\\$_TAF\\taf.pl -processTCS tsDriver=index_pyAnvil.pl;printVars;testsuite=_testsuite3_;list
	$c\\$_TAF\\taf.pl tcPropertyPatternPattern=\\d+_pipe_null;tcPropertyPatternName=tcRunResult;testsuite=_testsuite3_  rem list tcRunResult =~ /performance|null/
	$c\\$_TAF\\taf.pl tcPropertyPatternPattern=fail;tcPropertyPatternName=tcRunResult;testsuite=_testsuite3_

	$c\\$_TAF\\taf.pl tcIdMin=5;printVars;testsuite=_testsuite3_;exec
	$c\\$_TAF\\taf.pl ExecutionType=[runTC|runTS]
	$c\\$_TAF\\taf.pl exitTAF
	$c\\$_TAF\\taf.pl Execution_24_7=y;NofExecution=5;Execution=24hour;testsuite=_MV_SDK_OCSP;[list|exec]

	#####################  Powershell Testsuite Exmaples     ##################################
	$c\\$_TAF\\taf.pl -processTSs create=c:/_CRB_/AppBuildpath/_automated_testsuites_/_testsuite_ps1__powershell_
	$c\\$_TAF\\generatePyAnvilTestsuite.pl -buildpath c:/_CRB_/AppBuildpath -genTAF y

	#####################  get/set/list/list_history tc [Property|Filter]      ##################################
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=set_property1_[as|eq]_propVal1[_doit_]
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=_get_property1[_doit_]
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=_get__all_[_doit]

        $c\\$_TAF\\taf.pl testsuite=Autobat\\Bat\\QA_Tests\\BATtests\\MVTests\\BAT\\AutomationtsNameSUT\\_full_;AutomationtsName=AutomationtsNameSUT;propertyOp=list_tcDesc 
        $c\\$_TAF\\taf.pl testsuite=Autobat\\Bat\\QA_Tests\\BATtests\\MVTests\\BAT\\AutomationtsNameSUT\\_full_;AutomationtsName=AutomationtsNameSUT;propertyOp=list_history_tcRunResult
        $c\\$_TAF\\taf.pl testsuite=Autobat\\Bat\\QA_Tests\\BATtests\\MVTests\\BAT\\AutomationtsNameSUT\\_full_;AutomationtsName=AutomationtsNameSUT;generateExcelReport

	##################### TC [list|exec] based on TC Filters ##################################
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;listTcfilters
		taf.pl testsuite=_testsuite2_;pm=fast;tcOp=listtcfilters
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;tcFilters=testproperty_matches_tsetProperValue1;[list|exec]		
	$c\\$_TAF\\taf.pl testsuite=_testsuite2_;pm=fast;tppp1=;tppn1=;tppp2=;tppn2=....

	e.g. 
		1. taf.pl testsuite=_testsuite2_;[list|print]Tcfilters
		2. taf.pl testsuite=_testsuite2_;propertyOP=_set_property1_[as|eq]_propVal1_doit_
		3. taf.pl testsuite=_testsuite2_;propertyOP=_get_property1
		4. taf.pl testsuite=_testsuite2_;tcFilters=property1_matches_PropertyValue1;[list|exec]		
	
	##################### MISC   Maintenance info ###########################	
	  	1. ......titleStatus=(UnderMaint);list  
-----------------------------------------------------------------------------------------------------------------------
EOF
	print $help;
	&genDriver_testbed();
	1;
}


sub help4dev{
my $help=<<EOF;
-----------------------------------------------------------------------------------------------------------------------

---------------- This help is for historical and under-development functions -----------------
taf.pl testsuit=_ts1_;list 
taf.pl testsuit=_ts1_;testcase=_tc1_;list 
taf.pl testsuite=Autobat\\Bat\\QA_Tests\\BATtests\\MVTests\\BAT\\Automation_MVSDK\\_full_;propertyOp=list_tcDesc
taf.pl testsuite=Autobat\\Bat\\QA_Tests\\BATtests\\MVTests\\BAT\\Automation_MVSDK\\_full_;listHistory
taf.pl testsuite=generateReport

taf.pl  -processTC or -tc arg=[tcName;cmd] create=tc1|list|get|exec=tc1|detect|delete|log|getLogName|printResult;all

	# e.g.  taf.pl -tc create=tc1;fail,overwrite
	        taf.pl -tc create=tc1;fail,genLog;pr2Screen
	        taf.pl -tc create=tc1;performanceTC,genLog;pr2Screen
	        taf.pl -tc delete=tc1;pr2Screen

	-processTCs or -s  arg=[TCOP=list;...]  # e.g.  taf.pl -s TCNamePattern=tc.*
	                                 	#       taf.pl -s list
		Drive=c:;			# c: d: e: ...
		TestSuite=_testSuit_;		# directory 
		TCOp=list;			# List test cases that matches the TCNameFilter and PropertyFilter
		TCName=_testCase_;		# test case name 
		TCNamePattern=*;		# Test Case Name Filter 
		TCNameFilter=*;			# Test Case Name Filter 
		PropNameFilter=.*;		# Property_Name Filter
		PropValueFilter.=.*;		# Property_Value Filter
		pr2Screen;			# Results will be displayed on screen 
		getVars|listVars|printVars	# get or print TAF settings

        -processTSs [create|delete|add]=c:/... 
	-processProperty or -prop arg=[add=prop1:val1]  add|delete|list|get|modify|match|filter

	# e.g   taf.pl -prop list=tc;pr2Screen
	        taf.pl -prop add=prop1:val1;pr2Screen
	        taf.pl -prop match=.*:.*;pr2Screen
	        taf.pl -prop match=propNameFilter:propValFilter

	To create driver (taf.pl): perl.pl -MTest::AutomationFramework -e "help" 

	taf.pl -processTCs create=tc1/fail,overwrite
	taf.pl -processTCS tsDriver=index_pyAnvil.pl;printVars;testsuite=_testsuite3_;list
	$c\\$_TAF\\taf.pl  tsDriver=index_pyAnvil.pl;printVars;generateTestsuite
	$c\\$_TAF\\taf.pl  web_ui_title=testtitle;printVars;generateTestsuite
	cwd/taf.pl generateTestsuite 
	taf.pl generateRootIndex
	$c\\$_TAF\\taf.pl workingDir=c:/_MahoBby_/CPD_QA_Tests/BATtests/MVTests/Bat/MV_2-0-1-0062/_MV_SDK_OCSP;web_ui_title=c:/_MahoBby_/CPD_QA_Tests/BATtests/MVTests/Bat/MV_2-0-1-0062/_MV_SDK_OCSP;ps1_args=-buildpath___c:/_MahoBay_/CPD_QA_Tests/BATTests/MVTests/Bat/;generateTestsuite
	$c\\$_TAF\\taf.pl -scanTestsuites Tests/BATtests/MVtests/Bat/2.2.0.217_doit_
	$c\\$_TAF\\taf.pl testsuite=_testsuite1_;resetTSFileName=_list_history_tcRunResult.txt;resetTSFile;resetTSFile

	########################## Property add/get ##################################
	taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=set_property1_[as|eq]_propVal1_doit_
	taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=_get_property1_doit_
	taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=_get__all__doit

		taf.pl testsuite=_testsuite3_;testcase=testcase1;propertyOp=add_eq_prop1_column_val1[_doit_]
		taf.pl testsuite=_testsuite3_;testcase=testcase1;propertyOp=add_eq_tcDesc_column_TCDescription___Test[_doit_]
		taf.pl testsuite=_testsuite2_;pm=fast;propertyOp=get_eq_prop1_doit_
		taf.pl testsuite=_testsuite2_;pm=fast;propertyOp=get_eq_tcDesc_doit_
		taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=get_eq_.*_all__doit_
		taf.pl testsuite=_testsuite2_;pm=fast;propertyOP=get_eq_tcOwner_doit_

	##################### TC Property Filter for TC Execution ##################################
	taf.pl testsuite=_testsuite2_;pm=fast;listTcfilters
		taf.pl testsuite=_testsuite2_;pm=fast;tcOp=listtcfilters
	taf.pl testsuite=_testsuite2_;pm=fast;tcFilters=testproperty_matches_tsetProperValue1;[list|exec]		
		taf.pl testsuite=_testsuite2_;pm=fast;tcPropertyPatternName=prop1;tcPropertyPatternPattern=val1;list
		taf.pl testsuite=_testsuite2_;pm=fast;tppn=prop1;tppp=val1;list
		taf.pl testsuite=_testsuite2_;pm=fast;key=prop1;keyValue=val1;list

	e.g. 
		1. taf.pl testsuite=_testsuite2_;listTcfilters
		2. taf.pl testsuite=_testsuite2_;propertyOP=_set_property1_[as|eq]_propVal1_doit_
		3. taf.pl testsuite=_testsuite2_;propertyOP=_get_property1
		4. taf.pl testsuite=_testsuite2_;tcFilters=property1_matches_PropertyValue1;[list|exec]		


	taf.pl install (obsoleted)


-----------------------------------------------------------------------------------------------------------------------
EOF
	print $help;
	1;
}
sub genDriver_taf_pl {
	if (-e "$c/$_TAF/taf.pl") {;} else { mkpath "$c/$_TAF"; open Fout, ">$c/$_TAF/taf.pl"; print Fout &prDriver(1); close Fout; print " --> $c/$_TAF/taf.pl\n"; }
	1;
}
sub genDriver_taf_cgi {
	if (-e "$c/$_TAF/taf.cgi") {;} else { mkpath "$c/$_TAF"; open Fout, ">$c/$_TAF/taf.cgi"; print Fout &prDriverCGI(1); close Fout; print " --> $c/$_TAF/taf.cgi\n"; }
	1;
}
sub genDriver_taf_svr {
	if (-e "$c/$_TAF/taf.svr") {;} else { mkpath "$c/$_TAF"; open Fout, ">$c/$_TAF/taf.svr"; print Fout &prDriverSvr(1); close Fout; print " --> $c/$_TAF/taf.svr\n"; }
	1;
}


sub genDriver_testbed {
	if ($^O =~ /win32/i) { &genDriverWindow(); &delDriverWindow();}
	if ($^O =~ /linux/i) { &genDriverLinux();  &delDriverLinux();}
}
sub genDriverWindow {	# Testbed/testbed
	mkpath  "$c/$_TAF";
	if (-e "$c/$_TAF/taf.pl") { ;} else { open Fout, ">$c/$_TAF/taf.pl"; print Fout &prDriver(1); close Fout; print " --> $c/$_TAF/taf.pl\n"; }
	if (-e "$c/$_TAF/taf.bat") {;} else {

my $testbed4Window =<<EOF;

REM ------------- Create TC/TS under $c/$_TAF -----------------------------------
REM * Create Functional test case, which returns Pass with different execution time. 
REM * Create Functional test case, which returns Fail with different execution time. 
REM * Create Performance test case, which returns number of seconds
REM * Create Functional test case, with logs and links in the logs (_tcLogAppend.txt)
REM * Create Functional test case, with expected failure (expF)
REM * Create Functional test case, with expected failure (bugF)
REM * Test case  execution  testcase=string ~ (testType=tc or ts~ what does it mean?) 
REM * Test case  execution  testcase=regExp ~ (testType=tc or ts~ what does it mean?) 
REM * Test suite execution  testsuite=string ~ (testType=tc or ts~ what does it mean?) 
REM * Test suite execution  testsuite=regExp ~ (testType=tc or ts~ what does it mean?) 
REM * Test case  status ~ moving ">"
REM * Test case  24/7 execution
REM * Test suite 24/7 execution
REM * Test case  "stop" 
REM * Test suite "stop"
REM * Test suite title tsProperty.txt
REM * Test case  title tcProperty.txt
REM create test_suite (_test_suite?_)/_test_case?_  under $c/$_TAF
REM * Modify 
REM * Delete TC/TS
REM * Update TS/TC Status
REM * deleteTS  $perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}deleteTS


rem debug: C:/strawberry/perl/bin/perl.exe c:/_TAF/taf.pl testsuite=_testsuite1_;deleteTS
rem debug: C:/strawberry/perl/bin/perl.exe c:/_TAF/taf.pl testsuite=_testsuite1_;create=testcase0001/overwrite,sleep=1
rem debug: C:/strawberry/perl/bin/perl.exe c:/_TAF/taf.pl testsuite=_testsuite1_;list

rem debug /usr/bin/perl /tmp/var/www/cgi-bin/_TAF/taf.pl testsuite=/tmp/var/www/cgi-bin/_testsuite5_non_TAF_~deleteTS
rem debug /usr/bin/perl /tmp/var/www/cgi-bin/_TAF/taf.pl testsuite=/tmp/var/www/cgi-bin/_TAF/tmp~deleteTS
rem debug /usr/bin/perl /tmp/var/www/cgi-bin/_TAF/taf.pl generateRootIndex
rem debug /usr/bin/perl /tmp/var/www/cgi-bin/_TAF/taf.pl testsuite=/tmp/var/www/cgi-bin/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1~createTS


REM ------------- Create TC/TS in directory $c/$_TAF...... -----------------------------------

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0001/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0002/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0003/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0004/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0005/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0006/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0001/overwrite,sleep=20
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0002/overwrite,sleep=20
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0003/overwrite,sleep=40
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0004/overwrite,sleep=30
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0005/overwrite,sleep=20
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0006/overwrite,sleep=20
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0001/overwrite,sleep=2
REM create performance test 
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0002/overwrite,perf,sleep=3
REM create Failed Functional test 
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0003/overwrite,fail,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0004/overwrite,sleep=2
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0005/overwrite,fail,sleep=4
REM create functional test /w log
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0006/overwrite,genLog,sleep=10
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0007/overwrite,fail,genLog,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0008/overwrite,pass,genLog,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0009/overwrite,expectedFail,genLog,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0010/overwrite,expF,genLog,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0011/overwrite,bugF,genLog,sleep=1

REM create customrized TAF test cases for property operation test (TC contents are hardcoded in TAF)
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}create=testcase0001/overwrite,sleep=1,customTC:taftestcase1:customTC
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}create=testcase0002/overwrite,sleep=1,customTC:taftestcase2:customTC
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}create=testcase0003/overwrite,sleep=1,customTC:taftestcase3:customTC
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}create=testcase0004/overwrite,sleep=1,customTC:taftestcase4:customTC
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}exec

REM $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}printTAFTSVars
REM $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}testcase=testcase0003${deli}printTAFTCVars

REM _TAF/_testsuite/TAFTSVars.txt that overwrite _TAF/TAFGlobalVARS.txt
REM updateTAFTSVars set Execution_local_only=y
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}printTAFTSVars
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}updateTAFTSVars
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testcase=testcase0002${deli}updateTAFTCVars



REM ************ Make _testsuite1_/testcase0001 Execution_local_only (no remote exectuion)
REM _TAF/_testsuite/TAFTSVars.txt that overwrite _TAF/TAFGlobalVARS.txt
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}printTAFTSVars
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}updateTAFTSVars

REM ************ Make _testsuite2_/testcase0002 Execution_local_only (no remote exectuion)
rem $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testcase=testcase0002${deli}clearTAFTCVars
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testcase=testcase0002${deli}printTAFTCVars
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testcase=testcase0002${deli}updateTAFTCVars
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}list



REM exec all test_suite (testsuite~= Regexp~ testcase=RegExp)

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}testType=tc${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}testType=tc${deli}testcase=.*${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}testType=tc${deli}testcase=testcase.1*${deli}exec

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testType=tc${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testType=tc${deli}exec

REM test execution status (1. moving symbol = test-in-prog 2. Current execution status = getWeb_ 3. delete TS
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite1_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite2_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=_testcase1_/2
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=_testcase2_/1
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=_testcase3_/3
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}getWeb_=_testcase1_
$perl_ $c/$_TAF/taf.pl testType=tc${deli}delete=$c/$_TAF/_test_suit1_

REM TS Property update 
REM *Verification* _test_suit1_ is removed from disk and webUI
EM
   

REM ------------- Create TC/TS in $c/_testsuite5_/...... ------
REM generate test suite from TS Hook (index.pl)
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite2_/_TS1${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite3_/_TS1${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite4_/_TS1${deli}createTS

REM ------------- generate TAF testsuite ($c/_testsuite5_/... -> $c/_TAF/_testsuite5_/...)
rem $perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1${deli}generateTAFTestsuite 
rem $perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite2_/_TS1${deli}generateTAFTestsuite 
rem $perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite3_/_TS1${deli}generateTAFTestsuite 
rem $perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite4_/_TS1${deli}generateTAFTestsuite 

REM *Verification* TC_TAF $c/$_TAF/_TAF/_testsuiteTestBed/_testsuite?_ should be created and executable
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite2_/_TS1${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite3_/_TS1${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite4_/_TS1${deli}exec



REM ------------- Generate Perl testsuite with different tags (_smoketest_, _regression_ ) -----------------------------------

$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}createTS

rem $perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generateTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generateTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}generateTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}generateTAFTestsuite

REM ------------- Generate sub-Testsuites (_smoketest_, _regression_ ) -----------------------------------
$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generatePropertyTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generatePropertyTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}generatePropertyTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}generatePropertyTestsuite

REM ------------- Generate sub-Testsuies' TAF testsuite ---------------------------------------------------
$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_regressiontest_${deli}generateTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_regressiontest_${deli}generateTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_regressiontest_${deli}generateTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_regressiontest_${deli}generateTAFTestsuite

REM ------------- Generate Summary of Original Testsuite and its TAG Testsuites by testcaseNode=_null_ ---------------------------------------------------

$perl_ $c/_TAF/taf.pl testcaseNode=_null_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generateTAFTestsuite
$perl_ $c/_TAF/taf.pl testcaseNode=_null_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generateTAFTestsuite

REM ------------- Create Perl-Testsuite Hook and its Test suites /w Tag-based sub-Testsuites (_smoketest_, _regression_ )
REM                  (make sure the ts ends with _powershell_, which indicate a powershell testsuite)


REM ------------- Create Powershell-Testsuite Hook and its Test suites    -  Generate Tag-based sub-Testsuites -------------
$perl_ $c/$_TAF/taf.pl testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1__powershell_${deli}createTS

REM ------------- Generate sub-Testsuites (_smoketest_, _regression_ ) -----------------------------------
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}generatePropertyTestsuite


$perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}generateTAFTestsuite	
rem  For powershell only ${deli} use index.pl over index.ps1
$perl_ $c/$_TAF/taf.pl testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_/_regressiontest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl testcaseNode=_null_${deli}TSHookIsPerl=y${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}generateTAFTestsuite		
rem combine all the property testsuites
REM ------------- Create Powershell-Testsuite Hook and its Test suites    -  Generate Tag-based sub-Testsuites -------------

REM Demo for generating daily excel report 

REM ------------- Scabiality Test${deli} multi-testsuites and testing scanTestsuite  --------------------------
REM
REM HelloWorld-testbed powershell-Hook (property = _full_, _smoketest_, _regressiontest_)  	Note: _powershell_ indicate the testsuite hook is index.ps1, in stead of index.pl
$perl_ $c/$_TAF/taf.pl testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1__powershell_${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2__powershell_${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3__powershell_${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4__powershell_${deli}createTS

$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}generatePropertyTestsuite

$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_${deli}generatePropertyTestsuite

$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_${deli}generatePropertyTestsuite

$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_${deli}generatePropertyTestsuite


REM Generate index.ps1 -> index.pl for the original TC  (_doit_ is deleted)
 
rem $perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}generateTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}generateTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_${deli}generateTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_${deli}generateTAFTestsuite

REM scanTestsuites from testsuite directory  - generate root index.html 

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_/_regressiontest_${deli}generateTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_/_regressiontest_${deli}generateTAFTestsuite


$perl_ $c/_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_/_full_${deli}generateTAFTestsuite
$perl_ $c/_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_/_regressiontest_${deli}generateTAFTestsuite


REM The above scripts should be replace by the scanTestsuites below 
rem $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1__doit_${deli}scanTestsuites
rem $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2__doit_${deli}scanTestsuites
rem $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3__doit_${deli}scanTestsuites
rem $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4__doit_${deli}scanTestsuites

REM ------------- Scabiality Test: multi-testsuites and testing scanTestsuite  --------------------------


REM ------------- Update testbed' s _thProperties.txt[s] by generateRootIndex

$perl_ $c/$_TAF/taf.pl printTestBedProperties${deli}generateRootIndex 

REM ------------- TS execution
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite1_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite2_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=testcase0001/2
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=testcase0002/1
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=testcase0003/3

$perl_ $c/$_TAF/taf.pl testsuit=_testsuite2_${deli}testType=tc${deli}updateWeb_=testcase0001/2

$perl_ $c/$_TAF/taf.pl generateRootIndex


rem Mark TS with comments
rem taf.pl testsuite=_testsuite1_${deli}tcComment2=abcd${deli}mark 
\@start "" /b "C:/Program Files/Internet Explorer/iexplore.exe" "$c/$_TAF/_testsuite3_/index.htm"

rem  mark3
rem todo: --------------------- property operation and property filter
rem add/set, createTemplate, del, modify, match/filter, get/list (values,_all_, history, latest, last, value, filters), 
REM Property Operation: add a property
REM Property Operation: set/modify a property
REM Property Operation: get/list a property
REM Property Operation: print TC properties
REM Property Operation: propertyFilter 
REM 
REM	copy testsuites			taf.pl tsFrom=e.txt${deli}tsTo=ee.txt${deli}copyTS   

REM Test the tcFilter functions
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1a_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1b_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1c_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1d_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1e_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1f_doit_

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1a_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1b_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1c_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1d_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1e_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1f_doit_

REM get TC properties 
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=get_property1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=get_history_property1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=get_last_property1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=get_latest_property1

REM del TC properties (remove all the property-values)
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property2_eq_value2a_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=del_property2_doit_

REM Modify TC properties (same as add properties - append to thProperty.txt)
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=modify_property3_eq_value3f_doit_

REM print TS/TC tcFilters 
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}printTCFilters		
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}printTCFilters

REM property match (might need regExp in the future)

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=match_property2_as_value1h_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=match_property1_as_value1h_doit_

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}printTCFilters

rem *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite6_${deli}NofTCinTSTemplate${deli}createTS ##### createTS with different number of TC

rem *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOp=set_propverty1_as_value1_doit_
rem *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase2${deli}propertyOp=set_property1_as_value2_doit_
rem *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase2${deli}printTCFilters

rem *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}printTcFilters
rem *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOp=get_property1
rem *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase2 propertyOp=get_property1

REM Old memories 
rem taf.pl 'testsuit=_test_suit1_${deli}create=_testcase1_/overwrite,customTC${deli}$c/tmp/purge.pl_space_1${deli}customTC'
rem taf.pl 'testsuit=_test_suit1_${deli}create=_testcase1_/overwrite,pyAnvil,customTC:$c/tmp/indexPyAnvil.pl_space_1:customTC'

REM reminder
REM _noShow_ tag the TS/TC will not be displayed on webUI
REM TS can't be executed from remotly over http
REM UnderExecution message 
REM \$cmd = "c${deli}/_TAF/taf.pl testsuite=\$tsGenerated${deli}tsTags";  Get Testsuite tags
REM taf.pl webUITreeViewLevel=3${deli}generateRootIndex

EOF

	open Fout, ">$c/$_TAF/taf.txt"; print Fout $testbed4Window; close Fout; print " --> $c/$_TAF/taf.txt\n"; my $cmd = "$c/$_TAF/taf.txt"; 
	open Fout, ">$c/$_TAF/taf.bat"; print Fout $testbed4Window; close Fout; print " --> $c/$_TAF/taf.bat\n";    $cmd = "$c/$_TAF/taf.bat"; 
	if ($^O =~ /win32/i) { print "                           Please exec $cmd to setup testbed\n";} 
	if ($^O =~ /linux/i) { print "                           Please exec $cmd to setup testbed\n";} }
	1;
}



sub genDriverLinux {	# Testbed/testbed
	mkpath  "$c/$_TAF";
	if ($^O =~ /linux/i) { `sudo /bin/chmod -R ugo+rwx $c`;}
	if (-e "$c/$_TAF/taf.pl") { ;} else { open Fout, ">$c/$_TAF/taf.pl"; print Fout &prDriver(1); close Fout; print " --> $c/$_TAF/taf.pl\n"; }
	if (-e "$c/$_TAF/taf.sh") {;} else {

my $testbed4Linux=<<EOF;

#  ------------- Create TC/TS under $c/$_TAF -----------------------------------
#  * Create Functional test case, which returns Pass with different execution time. 
#  * Create Functional test case, which returns Fail with different execution time. 
#  * Create Performance test case, which returns number of seconds
#  * Create Functional test case, with logs and links in the logs (_tcLogAppend.txt)
#  * Create Functional test case, with expected failure (expF)
#  * Create Functional test case, with expected failure (bugF)
#  * Test case  execution  testcase=string ~ (testType=tc or ts~ what does it mean?) 
#  * Test case  execution  testcase=regExp ~ (testType=tc or ts~ what does it mean?) 
#  * Test suite execution  testsuite=string ~ (testType=tc or ts~ what does it mean?) 
#  * Test suite execution  testsuite=regExp ~ (testType=tc or ts~ what does it mean?) 
#  * Test case  status ~ moving ">"
#  * Test case  24/7 execution
#  * Test suite 24/7 execution
#  * Test case  "stop" 
#  * Test suite "stop"
#  * Test suite title tsProperty.txt
#  * Test case  title tcProperty.txt
#  create test_suite (_test_suite?_)/_test_case?_  under $c/$_TAF
#  * Modify 
#  * Delete TC/TS
#  * Update TS/TC Status
#  * deleteTS  $perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}deleteTS
#  ------------- Create TC/TS in directory $c/$_TAF...... -----------------------------------

# debug: C:/strawberry/perl/bin/perl.exe c:/_TAF/taf.pl testsuite=_testsuite1_;deleteTS
# debug: C:/strawberry/perl/bin/perl.exe c:/_TAF/taf.pl testsuite=_testsuite1_;create=testcase0001/overwrite,sleep=1
# debug: C:/strawberry/perl/bin/perl.exe c:/_TAF/taf.pl testsuite=_testsuite1_;list



# debug /usr/bin/perl /tmp/var/www/cgi-bin/_TAF/taf.pl testsuite=/tmp/var/www/cgi-bin/_testsuite5_non_TAF_~deleteTS
# debug /usr/bin/perl /tmp/var/www/cgi-bin/_TAF/taf.pl testsuite=/tmp/var/www/cgi-bin/_TAF/tmp~deleteTS
# debug /usr/bin/perl /tmp/var/www/cgi-bin/_TAF/taf.pl generateRootIndex
# debug /usr/bin/perl /tmp/var/www/cgi-bin/_TAF/taf.pl testsuite=/tmp/var/www/cgi-bin/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1~createTS


sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0001/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0002/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0003/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0004/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0005/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}create=testcase0006/overwrite,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0001/overwrite,sleep=20
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0002/overwrite,sleep=20
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0003/overwrite,sleep=40
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0004/overwrite,sleep=30
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0005/overwrite,sleep=20
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}create=testcase0006/overwrite,sleep=20
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0001/overwrite,sleep=2
#  create performance test 
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0002/overwrite,perf,sleep=3
#  create Failed Functional test 
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0003/overwrite,fail,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0004/overwrite,sleep=2
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0005/overwrite,fail,sleep=4
#  create functional test /w log
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0006/overwrite,genLog,sleep=10
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0007/overwrite,fail,genLog,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0008/overwrite,pass,genLog,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0009/overwrite,expectedFail,genLog,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0010/overwrite,expF,genLog,sleep=1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}create=testcase0011/overwrite,bugF,genLog,sleep=1

#  create customrized TAF test cases for property operation test (TC contents are hardcoded in TAF)
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}create=testcase0001/overwrite,sleep=1,customTC:taftestcase1:customTC
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}create=testcase0002/overwrite,sleep=1,customTC:taftestcase2:customTC
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}create=testcase0003/overwrite,sleep=1,customTC:taftestcase3:customTC
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}create=testcase0004/overwrite,sleep=1,customTC:taftestcase4:customTC

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}exec

#  $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}printTAFTSVars
#  $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}testcase=testcase0003${deli}printTAFTCVars

#  _TAF/_testsuite/TAFTSVars.txt that overwrite _TAF/TAFGlobalVARS.txt
#  updateTAFTSVars set Execution_local_only=y
#$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}printTAFTSVars
#$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}updateTAFTSVars
#$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testcase=testcase0002${deli}updateTAFTCVars

#  ************ Make _testsuite1_/testcase0001 Execution_local_only (no remote exectuion)
#  _TAF/_testsuite/TAFTSVars.txt that overwrite _TAF/TAFGlobalVARS.txt
#$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}printTAFTSVars
#$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}updateTAFTSVars

#  ************ Make _testsuite2_/testcase0002 Execution_local_only (no remote exectuion)
# $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testcase=testcase0002${deli}clearTAFTCVars
#$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testcase=testcase0002${deli}printTAFTCVars
#$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testcase=testcase0002${deli}updateTAFTCVars
#$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}list

#  exec all test_suite (testsuite~= Regexp~ testcase=RegExp)

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}testType=tc${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}testType=tc${deli}testcase=.*${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite1_${deli}testType=tc${deli}testcase=testcase.1*${deli}exec

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite2_${deli}testType=tc${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testType=tc${deli}exec

#  test execution status (1. moving symbol = test-in-prog 2. Current execution status = getWeb_ 3. delete TS
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite1_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite2_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=_testcase1_/2
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=_testcase2_/1
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=_testcase3_/3
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}getWeb_=_testcase1_
$perl_ $c/$_TAF/taf.pl testType=tc${deli}delete=$c/$_TAF/_test_suit1_

#  TS Property update 
#  *Verification* _test_suit1_ is removed from disk and webUI

#  ------------- Create TC/TS in $c/_testsuite5_/...... ------
#  generate test suite from TS Hook (index.pl)
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite2_/_TS1${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite3_/_TS1${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite4_/_TS1${deli}createTS

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- generate TAF testsuite ($c/_testsuite5_/... -> $c/_TAF/_testsuite5_/...)
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1${deli}generateTAFTestsuite 
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite2_/_TS1${deli}generateTAFTestsuite 
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite3_/_TS1${deli}generateTAFTestsuite 
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite4_/_TS1${deli}generateTAFTestsuite 

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  *Verification* TC_TAF $c/$_TAF/_TAF/_testsuiteTestBed/_testsuite?_ should be created and executable
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite2_/_TS1${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite3_/_TS1${deli}exec
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite4_/_TS1${deli}exec

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- Generate Perl testsuite with different tags (_smoketest_, _regression_ ) -----------------------------------

$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}createTS
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}createTS

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generateTAFTestsuite
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generateTAFTestsuite
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}generateTAFTestsuite
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}generateTAFTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- Generate sub-Testsuites (_smoketest_, _regression_ ) -----------------------------------
$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generatePropertyTestsuite


$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generatePropertyTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}generatePropertyTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}generatePropertyTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}generatePropertyTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- Generate sub-Testsuies' TAF testsuite ---------------------------------------------------
$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_regressiontest_${deli}generateTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_regressiontest_${deli}generateTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_regressiontest_${deli}generateTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_full_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_smoketest_${deli}generateTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_regressiontest_${deli}generateTAFTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- Generate Summary of Original Testsuite and its TAG Testsuites by testcaseNode=_null_ ---------------------------------------------------

$perl_ $c/_TAF/taf.pl testcaseNode=_null_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}generateTAFTestsuite
$perl_ $c/_TAF/taf.pl testcaseNode=_null_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}generateTAFTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- Create Perl-Testsuite Hook and its Test suites /w Tag-based sub-Testsuites (_smoketest_, _regression_ )
#                   (make sure the ts ends with _powershell_, which indicate a powershell testsuite)


#  Demo for generating daily excel report 

#  ------------- Scabiality Test${deli} multi-testsuites and testing scanTestsuite  --------------------------
# 
#  ------------- Update testbed' s _thProperties.txt[s] by generateRootIndex

$perl_ $c/$_TAF/taf.pl printTestBedProperties${deli}generateRootIndex 
$perl_ $c/$_TAF/taf.pl printTAFGlobalVars

#  ------------- TS execution
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite1_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite2_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite4_${deli}testType=tc${deli}list
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=testcase0001/2
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=testcase0002/1
$perl_ $c/$_TAF/taf.pl testsuit=_testsuite3_${deli}testType=tc${deli}updateWeb_=testcase0003/3

$perl_ $c/$_TAF/taf.pl testsuit=_testsuite2_${deli}testType=tc${deli}updateWeb_=testcase0001/2

$perl_ $c/$_TAF/taf.pl generateRootIndex


# \@start "" /b "C:/Program Files/Internet Explorer/iexplore.exe" "$c/$_TAF/_testsuite3_/index.htm"

# mark3
# todo: --------------------- property operation and property filter
# add/set, createTemplate, del, modify, match/filter, get/list (values,_all_, history, latest, last, value, filters), 
#  Property Operation: add a property
#  Property Operation: set/modify a property
#  Property Operation: get/list a property
#  Property Operation: print TC properties
#  Property Operation: propertyFilter 
#  
# 	copy testsuites			taf.pl tsFrom=e.txt${deli}tsTo=ee.txt${deli}copyTS   

#  Test the tcFilter functions
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1a_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1b_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1c_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1d_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1e_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property1_eq_value1f_doit_

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1a_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1b_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1c_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1d_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1e_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0002${deli}propertyOp=set_property1_eq_value1f_doit_

#  get TC properties 
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=get_property1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=get_history_property1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=get_last_property1
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=get_latest_property1

#  del TC properties (remove all the property-values)
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=set_property2_eq_value2a_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=del_property2_doit_

#  Modify TC properties (same as add properties - append to thProperty.txt)
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=modify_property3_eq_value3f_doit_

#  print TS/TC tcFilters 
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}printTCFilters		
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}printTCFilters

#  property match (might need regExp in the future)

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=match_property2_as_value1h_doit_
$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase0001${deli}propertyOp=match_property1_as_value1h_doit_

$perl_ $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}printTCFilters

# *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite6_${deli}NofTCinTSTemplate${deli}createTS   	##### createTS with different number of TC

# *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOp=set_propverty1_as_value1_doit_
# *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase2${deli}propertyOp=set_property1_as_value2_doit_
# *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase2${deli}printTCFilters

# *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}printTcFilters
# *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}propertyOp=get_property1
# *Technology Reserve* $c/$_TAF/taf.pl testsuite=_testsuite3_${deli}testcase=testcase2 propertyOp=get_property1

#  Old memories 
# taf.pl 'testsuit=_test_suit1_${deli}create=_testcase1_/overwrite,customTC${deli}$c/tmp/purge.pl_space_1${deli}customTC'
# taf.pl 'testsuit=_test_suit1_${deli}create=_testcase1_/overwrite,pyAnvil,customTC:$c/tmp/indexPyAnvil.pl_space_1:customTC'

#  reminder
#  _noShow_ tag the TS/TC will not be displayed on webUI
#  TS can't be executed from remotly over http
#  UnderExecution message 
#  Test result merge by _thProperty_link.txt 
#  printGlobalVars for TAF/TS/TC ...  printTAFGlobalVars ,  printTAFTSVars  , printTAFTCVars   
#  \$cmd = "c${deli}/_TAF/taf.pl testsuite=\$tsGenerated${deli}tsTags";  Get Testsuite tags
#  taf.pl webUITreeViewLevel=3${deli}generateRootIndex
#  Configuration: 1. disable selinux 2. disable firewall (iptable)
#  !!!!!!!!!!!!! Run sudo chmod -R ugo+rwx /tmp/var !!!!!!!!!!!!!!!

EOF

	open Fout, ">$c/$_TAF/taf.txt"; print Fout $testbed4Linux; close Fout; print " --> $c/$_TAF/taf.txt\n"; my $cmd = "$c/$_TAF/taf.txt"; 
	open Fout, ">$c/$_TAF/taf.sh" ; print Fout $testbed4Linux; close Fout; print " --> $c/$_TAF/taf.sh\n";     $cmd = "$c/$_TAF/taf.sh"; 

	if ($^O =~ /linux/i) { `sudo /bin/chmod -R ugo+rwx $c`;}
	if ($^O =~ /linux/i) { print "Please exec $cmd manually\n";} }


	1;
}

##############

sub delDriverWindow {	# Testbed/testbed
#here 	if ($workingDir =~ /\w+:[\/|\\]\s*$/) { print 'Please do *NOT* run perl -MTest::AutomationFramework -e "install" from rootDir. Run it from non-root directory.'; exit}
	if ( -e "$c/$_TAF") {;} else { mkpath  "$c/$_TAF"; }
	if (-e "$c/$_TAF/taf.pl") { ;} else { open Fout, ">$c/$_TAF/taf.pl"; print Fout &prDriver(1); close Fout; print " --> $c/$_TAF/taf.pl\n"; }
	if (-e "$c/$_TAF/taf_delete.bat") {;} else {

my $testbed4Window =<<EOF;

REM ------------- Create TC/TS in directory $c/$_TAF...... -----------------------------------

$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite1_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite2_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite3_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite4_${deli}deleteTAFTestsuite



REM ------------- Create TC/TS in $c/_testsuite5_/...... ------
REM generate test suite from TS Hook (index.pl)
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}deleteTAFTestsuite

REM ------------- Generate sub-Testsuites (_smoketest_, _regression_ ) -----------------------------------
$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}deleteTAFTestsuite

REM ------------- Generate sub-Testsuies' TAF testsuite ---------------------------------------------------
$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_regressiontest_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_regressiontest_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_regressiontest_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_regressiontest_${deli}deleteTAFTestsuite

REM ------------- Generate Summary of Original Testsuite and its TAG Testsuites by testcaseNode=_null_ ---------------------------------------------------

$perl_ $c/_TAF/taf.pl testcaseNode=_null_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/_TAF/taf.pl testcaseNode=_null_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite


REM ------------- Generate sub-Testsuites (_smoketest_, _regression_ ) -----------------------------------
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}deleteTAFTestsuite


$perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}deleteTAFTestsuite	

$perl_ $c/$_TAF/taf.pl testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_/_regressiontest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testcaseNode=_null_${deli}TSHookIsPerl=y${deli}testsuite=$c/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_${deli}deleteTAFTestsuite		


REM ------------- Scabiality Test${deli} multi-testsuites and testing scanTestsuite  --------------------------
REM
REM HelloWorld-testbed powershell-Hook (property = _full_, _smoketest_, _regressiontest_)  	Note: _powershell_ indicate the testsuite hook is index.ps1, in stead of index.pl

$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl TSHookName=index.ps1${deli}TSHookNameGenerated=index.pl${deli}tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_${deli}deleteTAFTestsuite


REM Generate index.ps1 -> index.pl for the original TC  (_doit_ is deleted)
 
rem $perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}deleteTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_${deli}deleteTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_${deli}deleteTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl TSHookIsPerl=y${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_${deli}deleteTAFTestsuite

REM scanTestsuites from testsuite directory  - generate root index.html 

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_/_regressiontest_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_/_regressiontest_${deli}deleteTAFTestsuite


$perl_ $c/_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_/_full_${deli}deleteTAFTestsuite
$perl_ $c/_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_/_regressiontest_${deli}deleteTAFTestsuite


REM ------------- Scabiality Test: multi-testsuites and testing scanTestsuite  --------------------------


REM ------------- Update testbed' s _thProperties.txt[s] by generateRootIndex

$perl_ $c/$_TAF/taf.pl printTestBedProperties${deli}generateRootIndex 

$perl_ $c/$_TAF/taf.pl generateRootIndex


EOF

	open Fout, ">$c/$_TAF/taf_delete.txt"; print Fout $testbed4Window; close Fout; print " --> $c/$_TAF/taf_delete.txt\n"; my $cmd = "$c/$_TAF/taf_delete.txt"; 
	open Fout, ">$c/$_TAF/taf_delete.bat"; print Fout $testbed4Window; close Fout; print " --> $c/$_TAF/taf_delete.bat\n";    $cmd = "$c/$_TAF/taf_delete.bat"; 
	# if ($^O =~ /win32/i) {if ( &enterY("Execute $c/$_TAF/taf_delete.bat (y/n)? ") =~ /y/) {system $cmd;} }


	if ($^O =~ /win32/i) { print "                           Please exec $cmd to teardown testbed\n";} 
	if ($^O =~ /linux/i) { print "                           Please exec $cmd to teardown testbed\n";} 

	}

	1;
}



sub delDriverLinux {	# Testbed/testbed
	if ( -e "$c/$_TAF") {;} else { mkpath  "$c/$_TAF"; }
	if ($^O =~ /linux/i) { `sudo /bin/chmod -R ugo+rwx $c`;}
	if (-e "$c/$_TAF/taf.pl") { ;} else { open Fout, ">$c/$_TAF/taf.pl"; print Fout &prDriver(1); close Fout; print " --> $c/$_TAF/taf.pl\n"; }
	if (-e "$c/$_TAF/taf_delete.sh") {;} else {

my $testbed4Linux=<<EOF;


sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite1_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite2_${deli}deleteTAFTestsuite
rem $perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite3_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite4_${deli}deleteTAFTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- Create TC/TS in $c/_testsuite5_/...... ------
#  generate test suite from TS Hook (index.pl)
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite2_/_TS1${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite3_/_TS1${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite4_/_TS1${deli}deleteTAFTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- generate TAF testsuite ($c/_testsuite5_/... -> $c/_TAF/_testsuite5_/...)
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1${deli}deleteTAFTestsuite 
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite2_/_TS1${deli}deleteTAFTestsuite 
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite3_/_TS1${deli}deleteTAFTestsuite 
#$perl_ $c/$_TAF/taf.pl testsuite=$c/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite4_/_TS1${deli}deleteTAFTestsuite 

#  ------------- Generate Perl testsuite with different tags (_smoketest_, _regression_ ) -----------------------------------

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}deleteTAFTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- Generate sub-Testsuites (_smoketest_, _regression_ ) -----------------------------------
$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite


$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl${deli}deleteTAFTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- Generate sub-Testsuies' TAF testsuite ---------------------------------------------------
$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_regressiontest_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_regressiontest_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_regressiontest_${deli}deleteTAFTestsuite

$perl_ $c/$_TAF/taf.pl tcPropertyName=_full_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_full_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_smoketest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_smoketest_${deli}deleteTAFTestsuite
$perl_ $c/$_TAF/taf.pl tcPropertyName=_regressiontest_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_regressiontest_${deli}deleteTAFTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

#  ------------- Generate Summary of Original Testsuite and its TAG Testsuites by testcaseNode=_null_ ---------------------------------------------------

$perl_ $c/_TAF/taf.pl testcaseNode=_null_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl${deli}deleteTAFTestsuite
$perl_ $c/_TAF/taf.pl testcaseNode=_null_${deli}testsuite=$c/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl${deli}deleteTAFTestsuite

sudo chmod -R ugo+rwx $c
sudo chmod -R go-wx $c

EOF

	open Fout, ">$c/$_TAF/taf_delete.txt"; print Fout $testbed4Linux; close Fout; print " --> $c/$_TAF/taf_delete.txt\n"; my $cmd = "$c/$_TAF/taf_delete.txt"; 
	open Fout, ">$c/$_TAF/taf_delete.sh" ; print Fout $testbed4Linux; close Fout; print " --> $c/$_TAF/taf_delete.sh\n";     $cmd = "$c/$_TAF/taf_delete.sh"; 

	if ($^O =~ /linux/i) { `sudo /bin/chmod -R ugo+rwx $c`;}
	if ($^O =~ /linux/i) { print "Please exec $cmd manually\n";} }


	1;
}

##############


#sub enterY { print shift ; $_ = &getYorN(); if (($_ =~ /n/i) || ($_ =~ /^\s*$/)) { return "n"; } if ($_ =~ /y/i) { return "y"; } }

#sub timed_input {
#    my $end_time = time + shift;
#    my $default = "timed_input_default"; $default = shift if (@_);
#    my $string ; 
#    do {
#        my $key = ReadKey(1);
#        print $key if defined $key;
#        $string .= $key if defined $key;
#    } while (time < $end_time);
#	return $string;
#};

# sub getYorN { my $input = &timed_input(6); if ($input) { return $input ; } else { return "n";} }

sub install 		{ &genDriver(); 1; } 	#### install is replaced by genDriver () . it is kept for backwards compatible


sub printTestBedProperties {
	############ Generate taf Property file for _testsuite1_
	mkpath "$c/$_TAF/_testsuite1_";
open Fout, ">$c/$_TAF/_testsuite1_/tsProperty.txt";
my $str = <<EOF;
There is no $c/$_TAF/_testsuite1_/tsProperty.txt for c:/_TAF/_testsuite1_. This is as designed.
EOF
print Fout $str;
close Fout; 
	############ Generate taf Property file for _testsuite1_

	############ Generate taf Property file for _testsuite2_
	mkpath "$c/$_TAF/_testsuite2_";
open Fout, ">$c/$_TAF/_testsuite2_/tsProperty.txt";
$str = <<EOF;
There is no $c/$_TAF/_testsuite2_/tsProperty.txt for $c/$_TAF/_testsuite2_. This is as designed.
EOF
print Fout $str;
close Fout; 
	############ Generate taf Property file for _testsuite2_



	############ Generate taf Property file for _testsuite3_
	mkpath "$c/$_TAF";
open Fout, ">$c/$_TAF/_blabla.html";
$str=<<EOF;
<html><body><pre>
This is a demo for URL link in log 
</pre></body></html>
EOF
print Fout $str;
close Fout; 

open Fout, ">$c/$_TAF/_testLog.txt";
$str=<<EOF;
This is a demo for Log in Log (Recursive Log) 
EOF
print Fout $str;
close Fout; 

	mkpath "$c/$_TAF/_testsuite3_";
open Fout, ">$c/$_TAF/_testsuite3_/tsProperty.txt";
$str = <<EOF;
web_ui_title: Test Automation Framework : web_ui_title
$c/$_TAF/_testsuite3_/testcase0001| 1  Test case 1 description                            Manual edit please     
$c/$_TAF/_testsuite3_/testcase0002| 2  Test case 2 Perform TC  for tsProperty.txt         Manual edit please     
$c/$_TAF/_testsuite3_/testcase0003| 3  Test case 3 Fail TC     for .. tsProperty.txt      Manual edit please     
$c/$_TAF/_testsuite3_/testcase0004| 4  Test case 4 Pass TC     for ... tsProperty.txt     Manual edit please     
$c/$_TAF/_testsuite3_/testcase0005| 5  Test case 5 Fail TC     for .... tsProperty.txt    Manual edit please     
$c/$_TAF/_testsuite3_/testcase0006| 6  Test case 6 TC /w Log   for ..... tsProperty.txt   Manual edit please     
$c/$_TAF/_testsuite3_/testcase0007| 7  Test case 7 _Expected_Fail_ for ... tsProperty.txt Manual edit please     
$c/$_TAF/_testsuite3_/testcase0008| 8  Test case 8 _Expected_Fail_ for ... tsProperty.txt Manual edit please     
$c/$_TAF/_testsuite3_/testcase0009| 9  Test case return Expected_f_a_i_l   for ... tsPro  Manual edit please     
$c/$_TAF/_testsuite3_/testcase0010| 10 Test case return expF               for ... tsPro  Manual edit please     
$c/$_TAF/_testsuite3_/testcase0011| 11 Test case return bugF               for ... tsPro  Manual edit please     
EOF
print Fout $str;
close Fout; 

	############ Generate taf Property file for _testsuite3_
	
	mkpath "$c/$_TAF/_testsuite4_";
open Fout, ">$c/$_TAF/_testsuite4_/tsProperty.txt";
$str = <<EOF;
web_ui_title: Testcase/Testsuite Property Operation Test Suite : web_ui_title
$c/$_TAF/_testsuite4_/testcase0001| 1  Test case 1 add testcase Property1 = propertyValue1                       
$c/$_TAF/_testsuite4_/testcase0002| 2  Test case 2 get testcase Property1 = propertyValue1A                      
$c/$_TAF/_testsuite4_/testcase0003| 3  Test case 3 add testsuite Property                                        
$c/$_TAF/_testsuite4_/testcase0004| 4  Test case 4 get testsutie Property
EOF
print Fout $str;
close Fout; 

	############ Generate taf Property file for webUI tc description
	mkpath "$c/$_TAF";
open Fout, ">$c/$_TAF/tsProperty.txt";
print Fout<<EOF;
web_ui_title: Test Automation Framework : web_ui_title
$c/$_TAF/_testsuite1_|0001  TAF Testbed 1 : Test Case  Management: TC list, TC execution, TC Reporting /o TC Description
$c/$_TAF/_testsuite2_|0002  TAF Testbed 2 : Test Case  Management: TC list, TC execution, TC Reporting /o TC Description 
$c/$_TAF/_testsuite3_|0003  TAF Testbed 3 : Test Case  Management: Concurrency, Performance TCs, TC Logging, TC Description 
$c/$_TAF/_testsuite4_|0004  TAF Testbed 4 : Test Case  Management: Property operations : add/get properties 

$c/$_TAF/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite1_/_TS1|0007  TAF Testbed 7 : Test Suite Management: Multiple test suite coexistence (testsuite1)
$c/$_TAF/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite2_/_TS1|0008  TAF Testbed 8 : Test Suite Management: Multiple test suite coexistence (testsuite2)
$c/$_TAF/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite3_/_TS1|0009  TAF Testbed 9 : Test Suite Management: Multiple test suite coexistence (testsuite3)
$c/$_TAF/_testsuite5_non_TAF_/_testsuiteTestBed/_testsuite4_/_TS1|0010  TAF Testbed 10: Test Suite Management: Multiple test suite coexistence (testsuite4)

$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl|0011  TAF Testbed 11: ts1: perl testsuite hook /o tags _smoketest_, _regressiontest_
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl|0012  TAF Testbed 12: ts2: perl testsuite hook /o tags _smoketest_, _regressiontest_
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl|0013  TAF Testbed 13: ts3: perl testsuite hook /o tags _smoketest_, _regressiontest_
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl|0014  TAF Testbed 14: ts4: perl testsuite hook /o tags _smoketest_, _regressiontest_

$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl|0015  TAF Testbed 15: Test Suite Management: Perl Script Automation    Test Suite 1 (_full_, _smoketest_, _regressiontest_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_full_|0016  TAF Testbed 16: Test Suite Management:                       sub Test Suite   (_full_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_regressiontest_|0017  TAF Testbed 17: Test Suite Management:                       sub Test Suite   (_regressiontest_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl/_smoketest_|0018  TAF Testbed 18: Test Suite Management:                       sub Test Suite   (_smoketest_)


$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl|0019  TAF Testbed 19: Test Suite Management: Perl Script Automation    Test Suite 2 (_full_, _smoketest_, _regressiontest_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_full_|0020  TAF Testbed 20: Test Suite Management:                       sub Test Suite   (_full_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_regressiontest_|0021  TAF Testbed 21: Test Suite Management:                       sub Test Suite   (_regressiontest_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites2_/_testsuite_pl/_smoketest_|0022  TAF Testbed 22: Test Suite Management:                       sub Test Suite   (_smoketest_)


$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl|0023  TAF Testbed 23: Test Suite Management: Perl Script Automation    Test Suite 3 (_full_, _smoketest_, _regressiontest_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_full_|0024  TAF Testbed 24: Test Suite Management:                       sub Test Suite   (_full_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_regressiontest_|0025  TAF Testbed 25: Test Suite Management:                       sub Test Suite   (_regressiontest_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites3_/_testsuite_pl/_smoketest_|0026  TAF Testbed 26: Test Suite Management:                       sub Test Suite   (_smoketest_)


$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl|0027  TAF Testbed 27: Test Suite Management: Perl Script Automation    Test Suite 4 (_full_, _smoketest_, _regressiontest_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_full_|0028  TAF Testbed 28: Test Suite Management:                       sub Test Suite   (_full_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_regressiontest_|0029  TAF Testbed 29: Test Suite Management:                       sub Test Suite   (_regressiontest_)
$c/$_TAF/_perlTestsuite_/AppBuildpath/_automated_testsuites4_/_testsuite_pl/_smoketest_|0030  TAF Testbed 30: Test Suite Management:                       sub Test Suite   (_smoketest_)


$c/$_TAF/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_|0031  TAF Testbed 31: Test Suite Management: Powershell Script Automation Test Suite(_full_, _smoketest_, _regressiontest_)
$c/$_TAF/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_/_full_|0032  TAF Testbed 32: Test Suite Management:                                        (_full_)
$c/$_TAF/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_/_smoketest_|0033  TAF Testbed 33: Test Suite Management:                                        (_smoketest_)
$c/$_TAF/_powershellTestsuite_/AppBuildpath/_automated_testsuites_/_testsuite_ps1_/_regressiontest_|0034  TAF Testbed 34: Test Suite Management:                                        (_regressiontest_) 

REM testsuite Desc (tsDesc) example 
$c/$_TAF/Autobat/Bat|Testsuite : Test suite of Tree structure and Test suite Node functon
$c/$_TAF/Autobat/Bat/QA_Tests|TAF Testsuite : Test suite Tree structure and Test suite Node function
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests|TAF Testsuite : Test suite Tree structure and Test suite Node function


$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_|0035  TAF Testbed 35: Test suite Tree structure: Test suite Node (in develop)  of testsuite1
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_/_full_|0036  TAF Testbed 36: Test Suite Management: Test Suite Hook (testsuite1/index.ps1) (_full_, _smoketest_, _regressiontest_) 
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_/_regressiontest_|0037  TAF Testbed 37: Test Suite Management:                                        (_regression tests_)
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite1_/_smoketest_|0038  TAF Testbed 38: Test Suite Management:                                        (_smoketest_)

$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_|0039  TAF Testbed 39: Test suite Tree structure: Test suite Node (in develop)  of testsuite1
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_/_full_|0040  TAF Testbed 40: Test Suite Management: Test Suite Hook (testsuite2/index.ps1) (_full_, _smoketest_, _regressiontest_) 
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_/_regressiontest_|0041  TAF Testbed 41: Test Suite Management:                                        (_regression tests_)
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite2_/_smoketest_|0042  TAF Testbed 42: Test Suite Management:                                        (_smoketest_)

$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_|0043  TAF Testbed 43: Test suite Tree structure: Test suite Node (in develop)  of testsuite1
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_/_full_|0044  TAF Testbed 44: Test Suite Management: Test Suite Hook (testsuite3/index.ps1) (_full_, _smoketest_, _regressiontest_) 
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_/_regressiontest_|0045  TAF Testbed 45: Test Suite Management:                                        (_regression tests_)
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite3_/_smoketest_|0046  TAF Testbed 46: Test Suite Management:                                        (_smoketest_)

$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_|0047  TAF Testbed 47: Test suite Tree structure: Test suite Node (in develop)  of testsuite1
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_/_full_|0048  TAF Testbed 48: Test Suite Management: Test Suite Hook (testsuite4/index.ps1) (_full_, _smoketest_, _regressiontest_) 
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_/_regressiontest_|0049  TAF Testbed 49: Test Suite Management:                                        (_regression tests_)
$c/$_TAF/Autobat/Bat/QA_Tests/BATtests/BAT/Automation_testsuite4_/_smoketest_|0050  TAF Testbed 50: Test Suite Management:                                        (_smoketest_)


EOF
close Fout;
1;
}

###########

sub prDriverSvr { 
my $driver=<<'EOF';
#!/usr/bin/perl
 {
 package MyWebServer;
 
 use HTTP::Server::Simple::CGI;
 use base qw(HTTP::Server::Simple::CGI);
 my %dispatch = (
     '/hello' => \&resp_hello,
 );
 my $root = "c:/_TAF"; if ($^O =~ /win32/i ) { ;} elsif ($^O =~ /linux/i) { $root="/tmp/var/www/cgi-bin/_TAF";}
 
 sub handle_request {
     my $self = shift;
     my $cgi  = shift;
   
     my $path = $cgi->path_info();
     my $handler = $dispatch{$path};
 
     if (ref($handler) eq "CODE") {
         	print "HTTP/1.0 200 OK\r\n"; $handler->($cgi);
     } elsif (-e "${root}${path}")  { 	
		print "HTTP/1.0 200 OK\r\n";
		if (${path} !~ /taf\.cgi/i) {	#### display html file
			print $cgi->header , $cgi->start_html("$root$path");
			open Fin, "$root$path"; @_ = <Fin>; close Fin; my $content = "@_"; print $cgi->body($content);
			print $cgi->end_html;
		} else { 			#### process taf.cgi 
######################## sub taf_cgi {

my $tafArgs = "help";
   $tafArgs = $cgi->param("tafArgs");  
if (($tafArgs =~ /exitTAFGracefullyString/i) && ($tafArgs !~ /;exitTAF/i)) { $tafArgs = $tafArgs.";exitTAF";}
if ($^O =~ /win32/i ) { $tafArgs =~ s/_semi_/;/g; } if ($^O =~ /linux/i ) { $tafArgs =~ s/_semi_/\~/g; }
$tafArgs =~ s/exitTAF=_null_/exitTAF/g;
my $tafRedirectory = $cgi->param("tafRedirectory");
my $refreshRate = 5;
print $cgi->header, $cgi->start_html("$root$path");
print "<pre>";
if (($tafArgs =~ /Execution_local_only=y/i) && ($tafArgs =~ /Execution_from_cgi=y/i)) {
	print "This test can NOT be executed over the network. Pleae execute the test from host w-PC/192.168.0.140. To Turn ON Remote Execution, email the administrator. \n" ;
} else {
	my $cmd = "start c:/_TAF/taf.pl $tafArgs";
	print "Running at _host_/_ip_: $cmd\n";
	system $cmd;
}

print<<EOF1;
</pre>
<meta http-equiv="refresh" content="$refreshRate; url=$tafRedirectory">
EOF1
print $cgi->end_html ;
####################### }
		}
     } else {
         print "HTTP/1.0 404 Not found\r\n";
         print $cgi->header, $cgi->start_html('Not found'), $cgi->body("${root}$path is Not found");
	 if (-e "${root}${path}") {
		open Fin, "$root$path"; 
			@_ = <Fin>; close Fin;
		       	my $content = "@_";
	        print $cgi->body("$content");
		}
               print $cgi->end_html;
     }
 }

 

 sub resp_hello {
     my $cgi  = shift;   # CGI.pm object
     return if !ref $cgi;
     
     my $who = $cgi->param('name');
     my  $dir = `C:/strawberry/perl/bin/perl.exe c:/_TAF/taf.pl -help`;
     open Fin, "c:/_TAF/_blabla.html";
     @_ = <Fin>; $file = "@_"; $file ="@_";
     close Fin;
     my $pathinfo = $cgi->path_info();
     my $fullpath = $cgi->url(-full=>1);
     print $cgi->header, $cgi->start_html("Hello"), 
     $cgi->body("$file, $pathinfo, $fullpath"), 
     $cgi->end_html;
 }

 
 } 
 
 # start the server on port 8080
 my $pid = MyWebServer->new(8080)->background();
 print "Use 'kill $pid' to stop server.\n";

EOF

$driver =~ s/_host_/$hostname/ig;
$driver =~ s/_ip_/$ip/ig;
;
# $c = "c:"; $_TAF = "_TAF";
# open Fout, ">$c/$_TAF/taf.svr"; print Fout $driver ; close Fout; print " ->$c/$_TAF/taf.svr"; 
if (@_) { return $driver;} else { print $driver;}
}
###########
sub prDriver {
	my $driver=<<EOF;
#!/usr/bin/perl
use Test::AutomationFramework;
use Getopt::Long;
	GetOptions(
	    'processTSs=s'         	      => \\\$processTSs,			
	    'processTCs|settings|s=s'         => \\\$processTCs,			
	    'processTC|tc=s'                  => \\\$processTC,		
	    'processProperty|property=s'      => \\\$processProperty,		
	    'help'                  	      => \\\$help,	
	);
\$TAF = new Test::AutomationFramework;
if (\$help) 		{\$TAF->help();}
if (\$prDriver) 	{\$TAF->prDriver();}
if (\$processTSs) 	{ \$TAF->processTSs(\$processTSs);}
if (\$processTCs) 	{ \$TAF->processTCs(\$processTCs);}
if (\$processProperty) 	{ \$TAF->processProperty(\$processProperty);}
if (\$processTC) 	{ \$TAF->processTC(\$processTC);}
if (\$scanTestsuites) 	{ \$TAF->scanTestsuites();}
\$cmdLine = \$TAF->getTAFArgsFromFile();
if (\$cmdLine) {;} else {foreach \$each (\@ARGV) {\$cmdLine =\$cmdLine.\$each.';'; } }
\$cmdLine =~ s/\\\~/;/g;	# Linux porting

# Single Uer mode 
# Mult-user mode: can be done by modifying taf.pl 

\$TAF->processTCs(\$cmdLine);
# print "debug: taf: done. Please uncomment this from taf.pl\\n";

exit;
if (\$cmdLine =~ /exitTAF/i)  { \$TAF->processTCs(\$cmdLine);  \$TAF->Queue("releaseLock"); } else { if (\$cmdLine) {\$TAF->Queue("push",\$cmdLine);} }
	if (\$TAF->Queue("checkLock") > 0) { print "The task is in queue. The lock (\$c/\$_TAF/taf.lock) exist!\\n"; exit;}
	\$TAF->Queue("setLock"); 
	while (\$TAF->Queue("queueSize") > 0 ) { \$cmdLine = \$TAF->Queue("pop");	\$TAF->processTCs(\$cmdLine); } 
	\$TAF->Queue("updateQueue");
	\$TAF->Queue("releaseLock"); 
#	\$TAF->generateRootIndex();
#	\$TAF->Queue("releaseLock"); 

#	if (\$TAF->Queue("checkLock") > 0) { print "The task is in queue. (c:/_TAF/taf.lock exist!\\n"; exit;}
#	\$TAF->Queue("setLock"); while (\$TAF->Queue("queueSize") > 0 ) { \$cmdLine = \$TAF->Queue("pop");	\$TAF->processTCs(\$cmdLine); \$TAF->Queue("releaseLock"); }
#	\$TAF->generateRootIndex();
##	\$TAF->Queue("releaseLock"); 
EOF
if (@_) { return $driver;} else { print $driver;}
}


sub prDriverCGI {


my $perl_loc ;
if ($^O =~ /win32/i) { $perl_loc = "#!c:/strawberry/perl/bin/perl.exe";}
if ($^O =~ /linux/i) { $perl_loc = "#!/usr/bin/perl";}

my $cmdFormat ;
if ($^O =~ /win32/i) { $cmdFormat = "my \$cmd = \"start c:/_TAF/taf.pl \$tafArgs\""; }
if ($^O =~ /linux/i) { $cmdFormat = "my \$cmd = \"/usr/bin/perl  $c/$_TAF/taf.pl \$tafArgs\""; }


	my $driver=<<EOF;
$perl_loc
use strict;
use warnings;
use CGI ":all";
my \$q = new CGI;
my \$tafArgs = "help";
   \$tafArgs = \$q->param("tafArgs");  
if ((\$tafArgs =~ /exitTAFGracefullyString/i) && (\$tafArgs !~ /;exitTAF/i)) { \$tafArgs = \$tafArgs.";exitTAF";}
if (\$^O =~ /win32/i ) { \$tafArgs =~ s/_semi_/;/g; }
if (\$^O =~ /linux/i ) { \$tafArgs =~ s/_semi_/\\~/g; }

\$tafArgs =~ s/exitTAF=_null_/exitTAF/g;

my \$tafRedirectory = \$q->param("tafRedirectory");
my \$refreshRate = 5;

print \$q->header(); print \$q->start_html(); print "<pre>";

# ################## add Remove_or_local_execution variable here and in TAF
if ((\$tafArgs =~ /Execution_local_only=y/i) && (\$tafArgs =~ /Execution_from_cgi=y/i)) {
	print "This test can NOT be executed over the network. Pleae execute the test from host $hostname/$ip. To Turn ON Remote Execution, email the administrator. \\n" ;
} else {
#if (\$tafArgs =~ /Again/) { \$refreshRate = 50000000; }
# my \$cmd = "start c:/_TAF/taf.pl \$tafArgs"; # todo
$cmdFormat;
#print \$q->param("tafArgs"); print "\\n-----------\\n";
#print \$q->param("tafRedirectory"); print "\\n-----------\\n";
print "Running at $hostname/$ip: \$cmd\\n";
system \$cmd;
}

print<<EOF1;
</pre>
<meta http-equiv="refresh" content="\$refreshRate; url=\$tafRedirectory">
EOF1
print \$q->end_html ;

EOF


if (@_) { return $driver;} else { print $driver;}
}

################################################################################
#	Subroutine Name : getDate
#		Function: get current Datetime 
#	Input Parameters: 
#	Output/Returns  : currentDate in the format of 2010-10-02 12:11:22
################################################################################
sub getDate ( ) {	# 	TH:Generic Functions: get current Time (TH:Generic Functions)
    my ( $y, $m, $d, $hh, $mm, $ss ) = (localtime)[ 5, 4, 3, 2, 1, 0 ];
    $y += 1900;
    $m++;
    my $iso_sale_time =
      sprintf( "%d-%02d-%02d %02d:%02d:%02d", $y, $m, $d, $hh, $mm, $ss );
    $iso_sale_time;
}


sub sortCmdLog {
my %record;
open Fin, "$c/$_TAF/_cmdLogs.txt"; 
while (<Fin>) { if ($_ =~ /(.+)>\s+/) { if ( &Date_Cmp (&DateCalc("now", "+0 day"), &DateCalc("now", $commandLogLifeSpan))  >= 0  ) {$record{$1} = $_;} } } close Fin;
open Fout, "> $c/$_TAF/_cmdLogs.txt_"; foreach my $each (reverse sort keys %record) { $record{$each} =~ s/\s*\n$//g; if ($record{$each}) {print Fout "$record{$each}\n";} } close Fout;
copy ("$c/$_TAF/_cmdLogs.txt_", "$c/$_TAF/_cmdLogs.txt");
}

################################################################################
#	Subroutine Name : appendtoFile
#		Function: append text to a file
#	Input Parameters: 1 Filename 2 String
#	Output/Returns  : New File with the appened text
################################################################################
sub appendtoFile() {  	# TH:Generic Functions: append to file (TH:Generic Functions)
    my $fname = $_[0];
    open Fout, ">>$fname";
    print Fout "$_[1]";
    close Fout;
}

sub appendtoFileStart() {  	# TH:Generic Functions: append to file (TH:Generic Functions)
    my $fname = $_[0];
    if (-e $fname ) { open Fin, $fname; @_=<Fin>; close Fin;}
    open Fout, ">>$fname";
    print Fout "$_[1]\n";
    print Fout @_;
    close Fout;
}


################################################################################
#	Subroutine Name : appendtoFileFile
#		Function: append file1 to file2
#	Input Parameters: 1 Filename 2 String
#	Output/Returns  : New File with the appened text
################################################################################
sub appendtoFileFile() {  	# TH:Generic Functions: append file to file (TH:Generic Functions)
    my $fname = $_[0]; my $fnameOUT = $_[1];
    open Fin, "$fname" || die "Can't open $fname:$!";
    while ($_ = <Fin>) {
    	&appendtoFile($fnameOUT, $_) if ($_ !~ /^\s*$/);
    }
    close Fin;
}


sub appendtoFileUniq_ { # fname, fileContent, maxTCExecTime 
    my $fname         = "e.txt"    ; $fname     = shift if @_; 
    my $content         = ""         ; $content     = shift if @_;
    my $MaxTCExecTime     = 10          ; $MaxTCExecTime= shift if @_; 
    my $fname_         = $fname."_"    ;
    my %record;
    while (-e $fname_) { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
    #if (-e $fname ){		
    if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1,"")	}; 
    if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http) {;} else { &createFile_($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml1_http,"")	}; 
    open Fin ,  "$fname"; while ($_ = <Fin>) { my $_tmp = $_; $_tmp =~ s/_semi_/;/g; if ($_tmp =~ /exitTAFGracefullyString=(.+)\s*;\s*exitTAF/) { $record{$1} = $_; } } close Fin;
    #}
	my $content_tmp = $content; $content_tmp =~ s/_semi_/;/g;	if ( $content_tmp  =~ /exitTAFGracefullyString=(.+)\s*;\s*exitTAF/) {$record{$1} = $content;}
    # open Fout, ">$fname_"; foreach my $each (sort keys %record) { 
    open Fout, ">$fname_"; foreach my $each (sort keys %record) { 
print Fout $record{$each} } close Fout; 

    move ($fname_, $fname);
}

sub appendtoFileUniqly { # fname, fileContent, maxTCExecTime 
     my $fname           = "e.txt"    ; $fname     = shift if @_; 
     my $content         = ""         ; $content     = shift if @_;
     my $MaxTCExecTime     = 10          ; $MaxTCExecTime= shift if @_; 
     my $fname_         = $fname."_"    ;
     my %record;
     while (-e $fname_) { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
	if (-e $fname) {
     	open Fin ,  "$fname"; while ($_ = <Fin>) { $_ =~ s/\s*\n//g; $record{$_} = $_;  } close Fin; $record{$content}=$content;
     	open Fout, ">$fname_"; foreach my $each (sort keys %record) { print Fout "$record{$each}\n" if ($record{$each} !~ /^\s*$/); } 
	close Fout;
	move ($fname_, $fname);
     } else {
 	    open Fout , ">$fname" || die "Can't open $fname:$!";
 		print Fout $content;
 	    close  Fout;
     }
}

sub write2File{ # fname, fileContent, maxTCExecTime 
     my $fname           = "e.txt"    ; $fname     = shift if @_; 
     my $content         = ""         ; $content     = shift if @_;
     my $MaxTCExecTime     = 10          ; $MaxTCExecTime= shift if @_; 
     my $fname_         = $fname."_"    ;
     my %record;
     while (-e $fname_) { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
	open Fout, ">$fname_"; print Fout $content; close Fout; move ($fname_, $fname);
}


sub copyFile { # fname, fileContent, maxTCExecTime 
     my $fnameFrom         = "e.txt"    ; $fnameFrom     = shift if @_; 
     my $fnameTo           = "e.txt"    ; $fnameTo     = shift if @_; 
     my $MaxTCExecTime     = 10          ; $MaxTCExecTime= shift if @_; 
     # my $fname_         = $fname."_"    ;
     # my %record;
     #while (-e $fname_) { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
	copy ($fnameFrom, $fnameTo);
}

################################################################################
#	Subroutine Name : createFile
#		Function: create a new file
#	Input Parameters: 1 Filename 2 String
#	Output/Returns  : New File with the appened text
################################################################################
sub createFile() {  	# TH:Generic Functions: create to file (TH:Generic Functions)
    my $fname = $_[0];
    $fname =~ s/\\/\//g;
    if (-e &getDir($fname)) { chmod 0777, &getDir($fname); ;} else { umask 0000; mkpath &getDir($fname); chmod 0777, &getDir($fname); }
	umask 0000; open Fout, ">$fname"; print Fout "$_[1]\n"; close Fout; chmod 0777, $fname;
}

################################################################################
#	Subroutine Name : readFile
#		Function: Read a file
#	Input Parameters: Filename 
#	Output/Returns  : String
################################################################################
sub readFile() {  	# TH:Generic Functions: read file (TH:Generic Functions)
    my $fname = $_[0];
    if ( -e $fname ) {
    open Fin, "$fname";
    @_ = <Fin>;
    close Fin;
    return " @_";
    } else { return "";}
}


################################## STOP TAF Gracefully  ############################################
sub getExitTAFGracefullyLock  { 
	if ( -e $exitTAFGracefullyLock) { 
		open Fin, $exitTAFGracefullyLock || die "Can't open $exitTAFGracefullyLock:$!";
		$_ = <Fin>;
		close Fin;
		if ($_ =~ /exitTAFGracefullyString\s*=\s*(.+)/) {
		return $1;
		}
	} else { return "unlocked"; } 
}
sub detectExitTAFGracefullyLock  { if ( -e $exitTAFGracefullyLock) { return "locked"; } else { return "unlocked"; } }
sub setExitTAFGracefullyLock     { open Fout, ">$exitTAFGracefullyLock"; print Fout "exitTAFGracefullyString=$exitTAFGracefullyString"; close Fout; }
sub releaseExitTAFGracefullyLock { unlink $exitTAFGracefullyLock; } 
sub exitTAF			 { open Fout, ">$exitTAFGracefullyLock"; print Fout "exitTAFGracefullyString=$exitTAFGracefullyString"; close Fout; sleep $outputPause; 1;}
################################## concurrency file log ############################################

sub updateWeb_ {
	my  %tsProperty;
 	my $tcname 		= 'TC_tc1'	; $tcname = shift if @_;	
 	my $scrollamount 	= 0 		; $scrollamount = shift if @_;
	my $borderwidth  	= 0 		; $borderwidth  = shift if @_;
	my $borderstyle  	= 'SOLID' 	; $borderstyle  = shift if @_;
	my $movingString 	= '>' 	 	; $movingString = shift if @_;
	my $MaxTCExecTime	= 10 	 	; $MaxTCExecTime= shift if @_; 
	@_ = split (/,/ , $scrollamount);
	if ($_[0]) { $scrollamount = $_[0];}
	if ($_[1]) { $borderwidth= $_[1];} 
	if ($_[2]) { $borderstyle= $_[2];} 

	if ($movingString =~ /runTC/i) { $movingString = '>'; }
	if ($movingString =~ /runTS/i) { $movingString = '>>'; }

	$tcname = &getTCName($tcname); $tcname =~ s/\\/\//g;
	############ BEGIN #############
	my $fname_ =	$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_"; 
	while (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_") { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
	if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml) {
 		open Fin, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml;
 		open Fout, ">".$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_";
 		while ($_ = <Fin>) {
 			my $tcnameTmp = $tcname;
 			if ( $_ =~ /$tcnameTmp/i) {
 				$_ =~  />(\S+)<\/marquee>/;  my $movingString_ = $1; 
				if ($movingString_) {;} else { $movingString_ = '>>'; }
 				$_ =~ s/>$movingString_<\/marquee>/>$movingString<\/marquee>/;
 				$_ =~  /scrollamount=\s*(\d+)\s*/;  my $scrollamount_ = $1; if ($scrollamount_) {;} else { $scrollamount_ = 0; }
 				$_ =~ s/scrollamount=\s*$scrollamount_\s*/scrollamount=$scrollamount/;

				$_ =~  /border:RED\s+(\d+)\s*px/;  my $borderwidth_ = $1;  if ($borderwidth_) {;} else { $borderwidth_ = 0; }
 				$_ =~ s/border:RED\s*$borderwidth_\s*px/border:RED ${borderwidth}px/;

				$_ =~  /(border:RED\s+\d+\s*px\s+)(DASHED|SOLID|DOTTED)"/;  my $borderstyle_= $2;  if ($borderstyle_) {;} else { $borderstyle_ = 'SOLID'; }
				$_ =~ s/(border:RED\s+\d+\s*px\s+)$borderstyle_"/${1}${borderstyle}"/ ; 
 			} 
 				print Fout $_;
 		}
 		close Fout;
 		close Fin;
		move ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_", $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml);
	} ############ END ###############

	############ BEGIN #############
	my $fname_http =	$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http."_"; 
	while (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http."_") { my $mtime = ( stat $fname_http)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
	if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http) {
 		open Fin, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http;
 		open Fout, ">".$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http."_";
 		while ($_ = <Fin>) {
 			my $tcnameTmp = $tcname;
 			if ( $_ =~ /$tcnameTmp/i) {
 				$_ =~  /scrollamount=\s*(\d+)\s*/;  my $scrollamount_ = $1; if ($scrollamount_) {;} else { $scrollamount_ = 0; }
 				$_ =~ s/scrollamount=\s*$scrollamount_\s*/scrollamount=$scrollamount/;

				$_ =~  /border:RED\s+(\d+)\s*px/;  my $borderwidth_ = $1;  if ($borderwidth_) {;} else { $borderwidth_ = 0; }
 				$_ =~ s/border:RED\s*$borderwidth_\s*px/border:RED ${borderwidth}px/;

				$_ =~  /(border:RED\s+\d+\s*px\s+)(DASHED|SOLID|DOTTED)"/;  my $borderstyle_= $2;  if ($borderstyle_) {;} else { $borderstyle_ = 'SOLID'; }
				$_ =~ s/(border:RED\s+\d+\s*px\s+)$borderstyle_"/${1}${borderstyle}"/ ; 
 			} 
 				print Fout $_;
 		}
 		close Fout;
 		close Fin;

		move ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http."_", $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http);
	} ############ END ###############

#	move ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_", $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml);
	return "tcCtr_Dynamics=$scrollamount";
}

sub mergeFile_ {
 	my $indexFName = "index.htm"		; $indexFName   = shift if @_; 
 	my $reportFName = "_tcReport_.html"	; $reportFName  = shift if @_;
        my $MaxTCExecTime     = 10          	; $MaxTCExecTime= shift if @_; 

	$indexFName =~ s/\\/\//g; # todo10 \\
	$reportFName =~ s/\\/\//g; # todo11 \\

 	my %index; my $indexFName_ = $indexFName."_"; 
        while (-e $indexFName_) { my $mtime = ( stat $indexFName)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
	if ( -e $indexFName)  {open Fin, $indexFName ; while ($_ = <Fin> ) { if ($_ =~ /$_TAF\/(.+)\/_tcLog.html/) { $_ =~ /$_TAF\/(.+)\/_tcLog.html/; $index{$1} = $_; } } close Fin; }
 	if ( -e $reportFName) {open Fin, $reportFName; while ($_ = <Fin> ) { if ($_ =~ /$_TAF\/(.+)\/_tcLog.html/) { $_ =~ /$_TAF\/(.+)\/_tcLog.html/; $index{$1} = $_; } } close Fin; }
}

sub updateWeb1_ {
	my  %tsProperty;
 	my $tcname 		= 'TC_tc1'	; $tcname = shift if @_;	
	my $tcHtml        	= "" 	 	; $tcHtml = shift if @_;
	my $MaxTCExecTime	= 10 	 	; $MaxTCExecTime= shift if @_; 
	my $testsuiteTotalExecTime =  &getTestsuiteTotalExecTime ("$SvrDrive/$SvrProjName/$reportHtml1");

	$tcname = &getTCName($tcname); $tcname =~ s/\\/\//g;
	my $fname_ =	$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_"; 
	while (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_") { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
	my $findMatch = 'n';
	if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml) {
 		open Fin, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml;
 		open Fout, ">".$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_";
 		while ($_ = <Fin>) {
 			my $tcnameTmp = $tcname;
 			if ( $_ =~ /$tcnameTmp/i) {
				$_ = $tcHtml;
				$findMatch ='y';
 			} 

			# Update Testsuite properties on Test case level
			if ( $_ =~ /\(Avg Time is\s+(\d+:\d+:\d+)\)/) { $_ =~ s/Avg Time is $1/Avg Time is $testsuiteTotalExecTime/; }
 			print Fout $_;
 		}
 		close Fout;
 		close Fin;

		move ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml."_", $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml);
	}
	return 1;
}

sub updateWeb1Http_ {
	my  %tsProperty;
 	my $tcname 		= 'TC_tc1'	; $tcname = shift if @_;	
	my $tcHtml        	= "" 	 	; $tcHtml = shift if @_;
	my $MaxTCExecTime	= 10 	 	; $MaxTCExecTime= shift if @_; 
	my $testsuiteTotalExecTime =  &getTestsuiteTotalExecTime ("$SvrDrive/$SvrProjName/$reportHtml1");

	$tcname = &getTCName($tcname); $tcname =~ s/\\/\//g;
	my $fname_ =	$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http."_"; 
	while (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http."_") { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
	my $findMatch = 'n';
	if (-e $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http) {
 		open Fin, $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http;
 		open Fout, ">".$SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http."_";
 		while ($_ = <Fin>) {
 			my $tcnameTmp = $tcname;
 			if ( $_ =~ /$tcnameTmp/i) {
				$_ = $tcHtml;
				$findMatch ='y';
 			} 

			# Update Testsuite properties on Test case level
			if ( $_ =~ /\(Avg Time is\s+(\d+:\d+:\d+)\)/) { $_ =~ s/Avg Time is $1/Avg Time is $testsuiteTotalExecTime/; }
 			print Fout $_;
 		}
 		close Fout;
 		close Fin;

		move ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http."_", $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http);
	}
	return 1;
}

sub resetTSFile { # fname, fileContent, maxTCExecTime 
	my $fname = "$SvrDrive/$SvrProjName/$resetTSFileName";   $fname = shift if @_; 
 	my $MaxTCExecTime 	= 10 	 	; $MaxTCExecTime= shift if @_; 
	my $content = "";
 	my $fname_ 		= $fname."_"	;
 	while (-e $fname_) { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
 	open Fout, ">$fname_" or die $!;
 	print Fout $content; 
 	close Fout;
 	move ($fname_, $fname);
	#### print " <-> Reset $SvrDrive/$SvrProjName/$resetTSFileName - Done\n"; 
	1;
}

sub createFile_ { # fname, fileContent, maxTCExecTime 
	my $fname 		= "e.txt"	; $fname 	= shift if @_; 
	my $content 		= ""	 	; $content 	= shift if @_;
	my $MaxTCExecTime 	= 10 	 	; $MaxTCExecTime= shift if @_; 
	my $fname_ 		= $fname."_"	;
	while (-e $fname_) { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }
	mkpath &getDir($fname_); 
	open Fout, ">$fname_" or die $!;
	print Fout $content; 
	close Fout;
	move ($fname_, $fname);
	1;
}

sub appendtoFile_ { # fname, fileContent, maxTCExecTime 
	my $fname 		= "e.txt"	; $fname 	= shift if @_; 
	my $content 		= " "	 	; $content 	= shift if @_;
	my $MaxTCExecTime 	= 10 	 	; $MaxTCExecTime= shift if @_; 
	my $fname_ 		= $fname."_"	;
	if (-e $fname) {;} else { &createFile($fname,"");}

	while (-e $fname_) { my $mtime = ( stat $fname_)[9]; my $current_time = time;  my $diff = $current_time - $mtime; if ($diff > $MaxTCExecTime) { last; } sleep 1; }

	copy ($fname, $fname_);
	open Fout, ">>$fname_" or die $!;
		if ($content) {;} else { $content = "";}
	print Fout $content; 
	close Fout;
	move ($fname_, $fname);
}

sub appendtoFileFile_ {  	# TH:Generic Functions: append file to file (TH:Generic Functions)
    my $fname = $_[0]; my $fnameOUT = $_[1];
     if (-e $fname) {
    open Fin, "$fname" || die "Can't open $fname:$!";
    my $content;
    while ($_ = <Fin>) {
	    if ($_ !~ /^\s*$/) {$content = $content .$_; } 
     }
    close Fin;
    &appendtoFile_($fnameOUT, $content) ;
     }
}

################################## concurrency file log ############################################
sub getRoot   { my $string = shift; @_ = split /\\|\//, $string; 			return $_[$#_]; }	# return tc.pl
sub getRoot_1 { my $string = shift; @_ = split /\\|\//, $string; 			return $_[$#_-1]; }	# remove tc.pl
sub getRoot_2 { my $string = shift; $string =~ s/\\/\//g; $string =~ s/\/$tc_pl//; 	return $string;   }	# remove c:\
sub getRoot_3 { my $string = shift; @_ = split /\\|\//, $string; 			# remove c:\
	if    ($#_ == 1) { return $_[$#_]; }
	elsif ($#_ == 2) { my $tmp = $#_ -1; return $_[$tmp].'/'.$_[$#_]; }
	elsif ($#_ == 3) { my $tmp = $#_ -1; my $tmp1 = $#_ -2;  return $_[$tmp1].'/'.$_[$tmp].'/'.$_[$#_]; }
	elsif ($#_ == 4) { my $tmp = $#_ -1; my $tmp1 = $#_ -2;  my $tmp2 = $#_ - 3; return $_[$tmp2].'/'.$_[$tmp1].'/'.$_[$tmp].'/'.$_[$#_]; }
	elsif ($#_ == 5) { my $tmp = $#_ -1; my $tmp1 = $#_ -2;  my $tmp2 = $#_ - 3; my $tmp3 = $#_ - 4; return $_[$tmp3].'/'.$_[$tmp2].'/'.$_[$tmp1].'/'.$_[$tmp].'/'.$_[$#_]; }
}
sub getRoot_4 { my $string = shift; $string =~ s/\w:[\/|\\]//; $string =~ s/\s*\/\s*$//; return $string;  }	# remove c:\ yw remove last /
sub getRoot_N { my $string = shift; my $len = shift; @_ = split /\\|\//, $string; my $return=""; 
	if ($len >$#_) { return $string;} 		# "_treeLevel_ > dir Level_ ";
	for (my $i = 0; $i <= $len; $i++ ) { 
		$return = $return."/".$_[$i]};	$return =~ s/^\s*\///g;
	return $return; 
}	

sub getDir  { my $string = shift; my $root =&getRoot($string); $string =~ s/([\\|\/])?$root//i;  return $string;  }

sub prJScript {
	
my $indexHtml =<<EOF;

<html>
<head> 
<META http-equiv="refresh" content="$htmlRefreshRateLogUI"> 
		<HTA:APPLICATION ID="oMyApp" 
		    APPLICATIONNAME="Application Executer" 
		    BORDER="no"
		    CAPTION="no"
		    SHOWINTASKBAR="yes"
		    SINGLEINSTANCE="yes"
		    SYSMENU="yes"
		    SCROLL="no"
		    WINDOWSTATE="normal">
	<script language="JavaScript">
		function RunFile(file) {
			// alert("file is " + file );
			WshShell = new ActiveXObject("WScript.Shell");
			WshShell.Run(file, 1, false);
		}

		function RunFileHTTP(testsuite, testcase) {
			// alert("testsuite is " + testsuite + " testcase is " );
			WshShell = new ActiveXObject("WScript.Shell");
		    	cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /delete /tn TAF_'+ testsuite + '_' + testcase + ' /f'; WshShell.Run(cmd, 1, false);
			cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /create /TR "$c\\\\$_TAF\\\\taf.pl testsuit='+testsuite+';testcaseExec='+testcase+';exec" /TN TAF_'+testsuite+'_'+testcase+' /sc monthly /mo 1 /F'; WshShell.Run(cmd, 1, false);
    		  	cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /run /tn TAF_'+testsuite+'_'+testcase; WshShell.Run(cmd, 1, false);
		}
		// <body OnLoad ="function1()">
	</script>
</head>
<body><pre>
EOF
# <!-script type="text/javascript"> if (navigator.appName != "Microsoft Internet Explorer") alert("Please use IE to access TAF's webUI") </script>
return $indexHtml; 
}

sub prJScript2 {
my $str=<<EOF;
<html>
<META http-equiv="refresh" content="$htmlRefreshRate"> 
		<HTA:APPLICATION ID="oMyApp" 
		    APPLICATIONNAME="Application Executer" c:/_TAF/taf.pl testcaseNode=_null_;testsuite=c:/_perlTestsuite_/AppBuildpath/_automated_testsuites1_/_testsuite_pl;generateTAFTestsuite
		    BORDER="no"
		    CAPTION="no"
		    SHOWINTASKBAR="yes"
		    SINGLEINSTANCE="yes"
		    SYSMENU="yes"
		    SCROLL="no"
		    WINDOWSTATE="normal">

<style type="text/css">
/* ul.LinkedList { display: block; } */
ul.LinkedList { display: black; }
ul.LinkedList { list-style-type: none; }
ul.LinkedList { list-style-position: inside; }
ul.LinkedList { list-style-padding: 0px; }
ul.LinkedList { list-style-margin-left: 0px; }
ul.LinkedList { list-style-padding-left: 0px; }
ul.LinkedList { list-style-text-indent: 0px; }
ul.LinkedList { list-style-text-align: left; }

ul.LinkedList ul { display: none; } 
ul.LinkedList ul { list-style-type: none; } 
ul.LinkedList ul { list-style-position: inside; } 
ul.LinkedList ul { list-style-padding: 0px; } 
ul.LinkedList ul { list-style-margin-left: 0px; } 
ul.LinkedList ul { list-style-padding-left: 0px; } 
ul.LinkedList ul { list-style-text-indent: 0px; } 
ul.LinkedList ul { list-style-text-align: left; } 
.HandCursorStyle { cursor: pointer; cursor: hand; }  /* For IE */
  </style>

  <script type="text/JavaScript">
  		function RunFile(file) {
			// alert("file is " + file );
			WshShell = new ActiveXObject("WScript.Shell");
			WshShell.Run(file, 1, false);
		}

		function RunFileHTTP(testsuite, testcase) {
			// alert("testsuite is " + testsuite + " testcase is " );
			WshShell = new ActiveXObject("WScript.Shell");
		    	cmd = 'c:\\windows\\system32\\schtasks.exe /delete /tn TAF_'+ testsuite + '_' + testcase + ' /f'; WshShell.Run(cmd, 1, false);
			cmd = 'c:\\windows\\system32\\schtasks.exe /create /TR "$c\\$_TAF\\taf.pl testsuit='+testsuite+';testcaseExec='+testcase+';exec" /TN TAF_'+testsuite+'_'+testcase+' /sc monthly /mo 1 /F'; WshShell.Run(cmd, 1, false);
    		  	cmd = 'c:\\windows\\system32\\schtasks.exe /run /tn TAF_'+testsuite+'_'+testcase; WshShell.Run(cmd, 1, false);
		}
		// <body OnLoad ="function1()">

    // Add this to the onload event of the BODY element
    function addEvents() {
      activateTree(document.getElementById("LinkedList1"));
    }

    // This function traverses the list and add links 
    // to nested list items
    function activateTree(oList) {
      // Collapse the tree
      for (var i=0; i < oList.getElementsByTagName("ul").length; i++) {
        oList.getElementsByTagName("ul")[i].style.display="none";            
      }                                                                  
      // Add the click-event handler to the list items
      if (oList.addEventListener) {
        oList.addEventListener("click", toggleBranch, false);
      } else if (oList.attachEvent) { // For IE
        oList.attachEvent("onclick", toggleBranch);
      }
      // Make the nested items look like links
      addLinksToBranches(oList);
    }

    // This is the click-event handler
    function toggleBranch(event) {
      var oBranch, cSubBranches;
      if (event.target) {
        oBranch = event.target;
      } else if (event.srcElement) { // For IE
        oBranch = event.srcElement;
      }
      cSubBranches = oBranch.getElementsByTagName("ul");
      if (cSubBranches.length > 0) {
        if (cSubBranches[0].style.display == "block") {
          cSubBranches[0].style.display = "none";
        } else {
          cSubBranches[0].style.display = "block";
        }
      }
    }

    // This function makes nested list items look like links
    function addLinksToBranches(oList) {
      var cBranches = oList.getElementsByTagName("li");
      var i, n, cSubBranches;
      if (cBranches.length > 0) {
        for (i=0, n = cBranches.length; i < n; i++) {
          cSubBranches = cBranches[i].getElementsByTagName("ul");
          if (cSubBranches.length > 0) {
            addLinksToBranches(cSubBranches[0]);
            cBranches[i].className = "HandCursorStyle";
            cBranches[i].style.color = "blue";
            cSubBranches[0].style.color = "black";
            cSubBranches[0].style.cursor = "auto";
          }
        }
      }
    }
  </script>

	<script language="JavaScript">
		function RunFile(file) {
			// alert("file is " + file );
			WshShell = new ActiveXObject("WScript.Shell");
			WshShell.Run(file, 1, false);
		}

		function RunFileHTTP(testsuite, testcase) {
			// alert("testsuite is " + testsuite + " testcase is " );
			WshShell = new ActiveXObject("WScript.Shell");
		    	cmd = 'c:\\windows\\system32\\schtasks.exe /delete /tn TAF_'+ testsuite + '_' + testcase + ' /f'; WshShell.Run(cmd, 1, false);
			cmd = 'c:\\windows\\system32\\schtasks.exe /create /TR "$c\\$_TAF\\taf.pl testsuit='+testsuite+';testcaseExec='+testcase+';exec" /TN TAF_'+testsuite+'_'+testcase+' /sc monthly /mo 1 /F'; WshShell.Run(cmd, 1, false);
    		  	cmd = 'c:\\windows\\system32\\schtasks.exe /run /tn TAF_'+testsuite+'_'+testcase; WshShell.Run(cmd, 1, false);
		}
		// <body OnLoad ="function1()">
	</script>
EOF
return $str;
}
sub prHtml1_strGen() {
	my $localUrl = $url; $localUrl = shift if @_;	
	my $tcPropertyPatternPattern_ = ".*"; ####################### Reset the tcPropertyPatternPattern for index.htm
	my $testsuiteTotalExecTime =  &getTestsuiteTotalExecTime ("$SvrDrive/$SvrProjName/$reportHtml1"); 
	my $tcDescTitle 	= "<a href=\"${localUrl}/$SvrProjName/_generateExcelReport.html\" title=\"Link to Daily Report. Below link to TC Logs\">"; 
	   $tcDescTitle 	= sprintf "$tcDescTitle%-${webUI_TCDescWidth}s</a>","   ------------------Testcase Description------------------";
	my $TCCtrToolTip 	= sprintf "Run Test Suite 24/7 (Avg Time is $testsuiteTotalExecTime)"; 
	if ($Execution_24_7_title =~ /n/i) { $TCCtrToolTip = sprintf "Run Test Suite (Avg Time is $testsuiteTotalExecTime)";} 
	my $execTS 		= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;Execution_24_7=$Execution_24_7_title;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;exec')\" title=\"$TCCtrToolTip\"> Exec</a>");
	my $stopTS 		= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName exitTAFGracefullyString=exitTAF;exitTAF')\" title=\"Stop Test Execution gracefully\" >.</a>");
	my $markTS 		= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;Execution_24_7=n;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;mark')\" title=\"Make the beginning of a execution by \|\"> \|</a>");
	my $listTSUnderTest     = sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=(UnderTestDontUse);list')\" title=\"Display UnderTestDontUser\">    </a>");
	my $listTSUnderTestNull = sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=;list')\" title=\"set titleStatus to Null \">    </a>");
	my $listTS 		= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseNode=testcase;list')\" title=\"Update webUI /o Tags (default)\">S</a>");
	my $listTSAll 		= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=_null_;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;list')\" title=\"Update webUI /w Tags\">U</a>");
	my $updateTS  		= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtml\" onClick=\"RunFile('$perl $scriptName SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;createOrAppendTS=append;testsuit=$c/$SvrProjName;generateTAFTestsuite')\" title=\"Update webUI /o Tags (default)\">S</a>");
	my $listTAFTestBed   	= sprintf("<a href=\"${localUrl}/taf.txt\" title=\"Display TAF Testbed scripts\">E</a>");
	my $indexthProperty 	= sprintf("<a href=\"${localUrl}/$SvrProjName/tsProperty.txt\" title=\"Display TS property\">L</a>");
	my $tafGlobalVars 	= sprintf("<a href=\"${localUrl}/_tafGlobalVars.txt\" title=\"Display TAF Global Variables\">T</a>");
	my $indexCmdLog   	= sprintf("<a href=\"${localUrl}/_cmdLogs.txt\" title=\"Display TAF Cmd History\">S</a>");
	my $indexFailed 	= sprintf("<a href=\"${localUrl}/$SvrProjName/index_failed.htm\" title=\"Display *Failed* TCs\">Fail</a>");
	my $indexPassed 	= sprintf("<a href=\"${localUrl}/$SvrProjName/index_passed.htm\" title=\"Display *Passed* TCs\">Pass</a>");
	my $indexOthers		= sprintf("<a href=\"${localUrl}/$SvrProjName/index_others.htm\" title=\"Display *others* TCs\">/</a>");
	my $indexUrlIIS 	= sprintf("<a href=\"${url}/$SvrProjName/index_http.htm\" title=\"$web_ui_title_tip\"> <font color=\"white\">TC Manual Command</font></a>");
	my $indexSeconds 	= "<a title=\"Total TS Execution time = $testsuiteTotalExecTime (s) \">(sec)</a>";
	my $indexTitle 		= sprintf("<a href=\"${localUrl}/index.htm\" title=\"View *all* Testsuites\">$web_ui_title</a>");
	my $indexResult 	= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtmlSummary\" title=\"testofUpdate\">".substr ("Result                                                                                                                                               ", 0, $passFailDisplayWidth-7)."</a>");
	my $tmp10 		= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtmlSummary\" title=\"$reportHtmlSummaryStr\">");
	my $passFailDisplay = &genPassFailDisplay("");

	my $queueSizeUI; my $queueSizeUICGI; my $queueSize=0; $queueSize = &Queue("", "queueSize");  
	if ($queueSize > 0) { $queueSizeUI    = " <a href=\"$url/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 
	if ($queueSize > 0) { $queueSizeUICGI = " <a href=\"$urlHttp/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 
	if ($queueSize == 0) { $queueSizeUI    = " <a style=\"color:white\" href=\"$url/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 
	if ($queueSize == 0) { $queueSizeUICGI = " <a style=\"color:white\" href=\"$urlHttp/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 

	if ( $localUrl =~ /^\s*http:/) {
	$indexTitle  = sprintf("<a href=\"${localUrl}/index_http.htm\" title=\"$web_ui_title_tip\">$web_ui_title</a>");
	$indexFailed = sprintf("<a href=\"${localUrl}/$SvrProjName/index_http_failed.htm\" title=\"Display *Failed* TCs\">Fail</a>");
	$indexPassed = sprintf("<a href=\"${localUrl}/$SvrProjName/index_http_passed.htm\" title=\"Display *Passed* TCs\">Pass</a>");
	$indexOthers = sprintf("<a href=\"${localUrl}/$SvrProjName/index_http_others.htm\" title=\"Display *others* TCs\">/</a>");
	}
	
my $indexHtml =<<EOF;

<html>
<head> 
<META http-equiv="refresh" content="$htmlRefreshRate"> 
		<HTA:APPLICATION ID="oMyApp" 
		    APPLICATIONNAME="Application Executer" 
		    BORDER="no"
		    CAPTION="no"
		    SHOWINTASKBAR="yes"
		    SINGLEINSTANCE="yes"
		    SYSMENU="yes"
		    SCROLL="no"
		    WINDOWSTATE="normal">
	<script language="JavaScript">
		function RunFile(file) {
			// alert("file is " + file );
			WshShell = new ActiveXObject("WScript.Shell");
			WshShell.Run(file, 1, false);
		}

		function RunFileHTTP(testsuite, testcase) {
			// alert("testsuite is " + testsuite + " testcase is " );
			WshShell = new ActiveXObject("WScript.Shell");
		    	cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /delete /tn TAF_'+ testsuite + '_' + testcase + ' /f'; WshShell.Run(cmd, 1, false);
			cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /create /TR "$c\\\\$_TAF\\\\taf.pl testsuit='+testsuite+';testcaseExec='+testcase+';exec" /TN TAF_'+testsuite+'_'+testcase+' /sc monthly /mo 1 /F'; WshShell.Run(cmd, 1, false);
    		  	cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /run /tn TAF_'+testsuite+'_'+testcase; WshShell.Run(cmd, 1, false);
		}
		// <body OnLoad ="function1()">
	</script>
</head>
<script type="text/javascript"> if (navigator.appName != "Microsoft Internet Explorer") alert("Please use IE to access TAF's webUI") </script>
<body>
<pre>
<p>
<h2> ${titleStatus}${indexTitle}${listTSUnderTest}${listTSUnderTestNull}${queueSizeUI}</h2>
${indexResult}${listTAFTestBed}${updateTS}${listTSAll}${indexthProperty}${tafGlobalVars}${indexCmdLog} ${stopTS}${markTS}${execTS} <a title=\"Click Testcase Desc to view TC logs\">$tcDescTitle      ${indexPassed}${indexOthers}${indexFailed}       ${indexSeconds}       ${indexUrlIIS}  </span>
EOF
	return $indexHtml; 
	}

sub prHtml1_strGen_CGI() {
	my $localUrl = $url; $localUrl = shift if @_;	
	my $tcPropertyPatternPattern_ = ".*"; ####################### Reset the tcPropertyPatternPattern for index.htm
	my $testsuiteTotalExecTime =  &getTestsuiteTotalExecTime ("$SvrDrive/$SvrProjName/$reportHtml1"); 
	my $tcDescTitle = "<a href=\"${localUrl}/$SvrProjName/_generateExcelReport.html\" title=\"Link to Daily Report. Below link to TC Logs\">"; 
	   $tcDescTitle = sprintf "$tcDescTitle%-${webUI_TCDescWidth}s</a>","   ------------------Testcase Description------------------";
	my $TCCtrToolTip = sprintf "Run Test Suite 24/7 (Avg Time is $testsuiteTotalExecTime)"; 
	if ($Execution_24_7_title =~ /n/i) { $TCCtrToolTip = sprintf "Run Test Suite (Avg Time is $testsuiteTotalExecTime)";} 
	my $execTS =  sprintf("<a href=\"${localUrl}/${cgi_bin}$tafCGI?tafArgs=Execution_from_cgi=y;Execution_local_only=$Execution_local_only;SysDrive=$SvrDrive;performanceMode=fast;Execution_24_7=$Execution_24_7_title;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;exec_realSemi_tafRedirectory=${localUrl}/$SvrProjName/$reportHtml_http\" title=\"$TCCtrToolTip\"> Exec</a>");
	my $stopTS =  sprintf("<a href=\"${localUrl}/${cgi_bin}$tafCGI?tafArgs=exitTAFGracefullyString=exitTAF;exitTAF_realSemi_tafRedirectory=${localUrl}/$SvrProjName/$reportHtml_http\" title=\"Stop Test Execution gracefully\" >.</a>");
	my $markTS =  sprintf("<a href=\"${localUrl}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;Execution_24_7=n;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;mark_realSemi_tafRedirectory=${localUrl}/$SvrProjName/$reportHtml_http\" title=\"Make the beginning of a execution by \|\"> \|</a>");
	my $listTSUnderTest =  sprintf("<a href=\"${localUrl}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=(UnderTestDontUse);list_realSemi_tafRedirectory=${localUrl}/$SvrProjName/$reportHtml_http\" title=\"Display (UnderTestDontUse)\">    </a>");
	my $listTSUnderTestNull =  sprintf("<a href=\"${localUrl}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseNode=testcase;titleStatus=;list_realSemi_tafRedirectory=${localUrl}/$SvrProjName/$reportHtml_http\" title=\"Set titleStatus as Null\">    </a>");
	my $listTS =  sprintf("<a href=\"${localUrl}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=$testcaseNode;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;testcaseNode=testcase;list_realSemi_tafRedirectory=${localUrl}/$SvrProjName/$reportHtml_http\" title=\"Update webUI /o Tags (default)\">S</a>");
	my $listTSAll=sprintf("<a href=\"${localUrl}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;testcaseNode=_null_;$tcPropertyPatternName=$tcPropertyPatternName;tcPropertyPatternPattern=$tcPropertyPatternPattern_;testsuit=$SvrProjName;list_realSemi_tafRedirectory=${localUrl}/$SvrProjName/$reportHtml_http\" title=\"Update webUI /w Tags\">U</a>");
	my $updateTS =sprintf("<a href=\"${localUrl}/${cgi_bin}$tafCGI?tafArgs=SysDrive=$SvrDrive;performanceMode=fast;tcPropertyPatternPattern=$tcPropertyPatternPattern_;createOrAppendTS=append;testsuit=$c/$SvrProjName;generateTAFTestsuite;list_realSemi_tafRedirectory=${localUrl}/$SvrProjName/$reportHtml_http\" title=\"Update webUI /o Tags (default)\">S</a>");

	$execTS =~ s/;/_semi_/g; $execTS =~ s/_realSemi_/$_realSemi_/g;
	$stopTS =~ s/;/_semi_/g; $stopTS =~ s/_realSemi_/$_realSemi_/g;
	$markTS =~ s/;/_semi_/g; $markTS =~ s/_realSemi_/$_realSemi_/g;
	$listTSUnderTest =~ s/;/_semi_/g; $listTSUnderTest =~ s/_realSemi_/$_realSemi_/g;
	$listTS =~ s/;/_semi_/g; $listTS =~ s/_realSemi_/$_realSemi_/g;
	$listTSAll =~ s/;/_semi_/g; $listTSAll =~ s/_realSemi_/$_realSemi_/g;
	$updateTS  =~ s/;/_semi_/g; $updateTS=~ s/_realSemi_/$_realSemi_/g;

	my $listTAFTestBed      = sprintf("<a href=\"${localUrl}/taf.txt\" title=\"Display TAF Testbed scripts\">E</a>");
	my $indexthProperty 	= sprintf("<a href=\"${localUrl}/$SvrProjName/tsProperty.txt\" title=\"Display TS property\">L</a>");
	my $tafGlobalVars 	= sprintf("<a href=\"${localUrl}/_tafGlobalVars.txt\" title=\"Display TAF Global Variables\">T</a>");
	my $indexCmdLog   	= sprintf("<a href=\"${localUrl}/_cmdLogs.txt\" title=\"Display TAF Cmd History\">S</a>");
	my $indexFailed 	= sprintf("<a href=\"${localUrl}/$SvrProjName/index_failed.htm\" title=\"Display *Failed* TCs\">Fail</a>");
	my $indexPassed 	= sprintf("<a href=\"${localUrl}/$SvrProjName/index_passed.htm\" title=\"Display *Passed* TCs\">Pass</a>");
	my $indexOthers		= sprintf("<a href=\"${localUrl}/$SvrProjName/index_others.htm\" title=\"Display *others* TCs\">/</a>");
	my $indexUrlIIS		= sprintf("<a href=\"${url}/$SvrProjName/index_http.htm\" title=\"$web_ui_title\"> <font color=\"white\">TC Manual Command</font></a>");
	my $indexSeconds 	= "<a title=\"Total TS Execution time = $testsuiteTotalExecTime (s) \">(sec)</a>";
	my $indexTitle 		= sprintf("<a href=\"${localUrl}/index.htm\" title=\"$web_ui_title_tip\">Test Automation </a>");
	my $indexResult		= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtmlSummary\" title=\"Latest TC pass/fail (Gree/Red) Click to Display Test Suite Summary\">".substr ("Result                                                                                                                                               ", 0, $passFailDisplayWidth-7)."</a>");
	my $tmp10 		= sprintf("<a href=\"${localUrl}/$SvrProjName/$reportHtmlSummary\" title=\"$reportHtmlSummaryStr\">");
	my $passFailDisplay 	= &genPassFailDisplay("");

	my $queueSizeUI; my $queueSizeUICGI; my $queueSize=0; $queueSize = &Queue("", "queueSize");  
	if ($queueSize > 0) { $queueSizeUI    = " <a href=\"$url/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 
	if ($queueSize > 0) { $queueSizeUICGI = " <a href=\"$urlHttp/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 
	if ($queueSize == 0) { $queueSizeUI    = " <a style=\"color:white\" href=\"$url/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 
	if ($queueSize == 0) { $queueSizeUICGI = " <a style=\"color:white\" href=\"$urlHttp/${queueFName}_active\" title=\"View waiting jobs\">$queueSize job(s) is/are waiting....</a>";} 

	if ( $localUrl =~ /^\s*http:/) {
	$indexTitle  = sprintf("<a href=\"${localUrl}/index_http.htm\" title=\"$web_ui_title_tip\">$web_ui_title</a>");
	$indexFailed = sprintf("<a href=\"${localUrl}/$SvrProjName/index_http_failed.htm\" title=\"Display *Failed* TCs\">Fail</a>");
	$indexPassed = sprintf("<a href=\"${localUrl}/$SvrProjName/index_http_passed.htm\" title=\"Display *Passed* TCs\">Pass</a>");
	$indexOthers = sprintf("<a href=\"${localUrl}/$SvrProjName/index_http_others.htm\" title=\"Display *others* TCs\">/</a>");
	}
	
my $indexHtml =<<EOF;

<html>
<head> 
<META http-equiv="refresh" content="$htmlRefreshRate"> 
		<HTA:APPLICATION ID="oMyApp" 
		    APPLICATIONNAME="Application Executer" 
		    BORDER="no"
		    CAPTION="no"
		    SHOWINTASKBAR="yes"
		    SINGLEINSTANCE="yes"
		    SYSMENU="yes"
		    SCROLL="no"
		    WINDOWSTATE="normal">
	<script language="JavaScript">
		function RunFile(file) {
			// alert("file is " + file );
			WshShell = new ActiveXObject("WScript.Shell");
			WshShell.Run(file, 1, false);
		}

		function RunFileHTTP(testsuite, testcase) {
			// alert("testsuite is " + testsuite + " testcase is " );
			WshShell = new ActiveXObject("WScript.Shell");
		    	cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /delete /tn TAF_'+ testsuite + '_' + testcase + ' /f'; WshShell.Run(cmd, 1, false);
			cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /create /TR "$c\\\\$_TAF\\\\taf.pl testsuit='+testsuite+';testcaseExec='+testcase+';exec" /TN TAF_'+testsuite+'_'+testcase+' /sc monthly /mo 1 /F'; WshShell.Run(cmd, 1, false);
    		  	cmd = '$c\\\\windows\\\\system32\\\\schtasks.exe /run /tn TAF_'+testsuite+'_'+testcase; WshShell.Run(cmd, 1, false);
		}
		// <body OnLoad ="function1()">
	</script>
</head>
<body>
<pre>
<p>
<h2> ${titleStatus}${indexTitle}(Automation Host: $hostname/$ip)${listTSUnderTest}${listTSUnderTestNull}${queueSizeUICGI}</h2>
${indexResult}${listTAFTestBed}${updateTS}${listTSAll}${indexthProperty}${tafGlobalVars}${indexCmdLog} ${stopTS}${markTS}${execTS} <a title=\"Click Testcase Desc to view TC logs\">$tcDescTitle      ${indexPassed}${indexOthers}${indexFailed}       ${indexSeconds}       ${indexUrlIIS}  </span>
EOF

	return $indexHtml; 
	}


sub prHtml1 {		# print index.htm beginnings
	my $tcPropertyPatternPattern_ = ".*"; ####################### Reset the tcPropertyPatternPattern for index.htm
	my $testsuiteTotalExecTime =  &getTestsuiteTotalExecTime ("$SvrDrive/$SvrProjName/$reportHtml1"); 
&createFile_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml, '' );
&createFile_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http, '' );
my $str =<<EOF;
taf.pl       : TAF Driver    
taf.bat      : TAF testbed setup
tc.pl        : TC hook       
_tcAppend.txt: TC log  hook 
EOF

&readTestSuitProperty();
my $indexHtml = &prHtml1_strGen($url); 
&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml, $indexHtml);

my $indexHtml_http = &prHtml1_strGen_CGI($urlHttp); 
&appendtoFile_ ($SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http, $indexHtml_http);
}

sub prHtml2 {	# print index.htm endings

############ Temporal Solution of $c collision #############
my $tsDriverStr= &readFile("$c/$SvrProjName/index.pl") if ($^O =~ /win/i); ##### unix only
   $tsDriverStr= &readFile("/$SvrProjName/index.pl") if ($^O =~ /linux/i); ##### unix only

if ($tsDriverStr =~ /^\s*$/){ $tsDriverStr = "This Testsuite doesn't have a hook (index.pl). "; }

my $tmp;

if ($^O =~ /linux/i) { 
$tmp =<<EOF;
 Step 1: Generate Testsuite Template: $perl_ $c/$_TAF/$taf testsuite=/$SvrProjName${deli}createTS
 Step 2: Edit the Testsuite Template: /$SvrProjName/index.pl to add customer test suite
EOF

} 

if ($^O =~ /win/i) {
$tmp =<<EOF;
 Step 1: Generate Testsuite Template: $perl_ $c/$_TAF/$taf testsuite=$c/$SvrProjName${deli}createTS
 Step 2: Edit the Testsuite Template: $c/$SvrProjName/index.pl to add customer test suite
EOF
}

my $html =<<EOF;

<font color=\"white\">
---------------------------TS Driver $c/$SvrProjName/index.pl -------------------------
 Step 1: Generate Testsuite Template: $perl_ $c/$_TAF/$taf testsuite=$c/$SvrProjName${deli}createTS
 Step 2: Edit the Testsuite Template: $c/$SvrProjName/index.pl to add customer test suite
---------------------------TS Driver $c/$SvrProjName/index.pl -------------------------
$tsDriverStr
---------------------------TS Driver -------------------------<font>
</pre></body>
</html>
<style type="text/css"> a { text-decoration:none} </style> 
EOF


 &appendtoFile_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml, $html );
 &appendtoFile_( $SvrDrive.'/'.$SvrProjName.'/'.$reportHtml_http, $html );
}



__END__
		TAF Function Requirement Summary  (Sept 27, 2011)
------------------------------------------------------------------------------------------
TH Function Category     Function Name            Function Description
------------------------------------------------------------------------------------------
TH:TC Managements        logIsValid               Verify if a log is valid by comparing TC created T and log create T Commented Done 
TH:TC Managements        tcRunningYN              get the TC result Pass/Fail                                         Commented Done
TH:TC Managements        getProperty              get TC Property Names                                               Commented Done
TH:TC Managements        getPropertyValues        get TC Property Values                                              Commented Done
TH:TC Managements        deleteProperty           delete TC Property                                                  Commented Done
TH:TC Managements        addProperty              add TC Property                                                     Commented Done
TH:TC Managements        modifyProperty           modify TC Property                                                  Commented Done
TH:TC Managements        appendPropFile           append to TC Property File                                          Commented Done
TH:TC Managements        createPropFile           create TC Property File                                             Commented n/a
TH:TC Managements        readProperty             Read TC Property                                                    Commented n/a
TH:TC Managements        updateTCResultProperty   Update TC Property                                                  Commented n/a
TH:TC Managements        genTC                    Generate a HelloWorld TC                                            Commented Done

TH:TC Report             Report                   TC Report Function                                                  Commented Done
TH:TC Report             reportUpdateOnWeb        update TC Report on webUI                                           Commented 
TH:TC Report             logExist                 Determine if a log exists                                           Commented Done

TH:TC Execution          ReportAvgResponseTime    report TC Average Response Time                                     Commented n/a
TH:TC Execution          lastPassFail             get the latest TC Pass/Fail Result                                  Commented Done
TH:TC Execution          longivityPeriod          If the TC in LongivityPeriod                                        Commented 

TH:WebUI                 thWebUIUpdate            Update the webUI based on thProperty.txt                            Commented v2
TH:WebUI                 tcStatusHtmlSync         synchrinize the HTML with with TC Result                            Commented v2
TH:WebUI                 tcStatusHtml             Display the TCStatuse in Html format                                Commented v2
TH:WebUI                 rearrangeWebUI           Update webUI based on thProperty.txt                                Commented v2
TH:WebUI                 tcLog2Web                Update TC Log on webUI                                              Commented v2

TH:Concurrency Control   tcRunningYNOther         get the running TC Status for Concurrency Control.                  Commented v2          
TH:Concurrency Control   tcScheduledYNOther       get the scheduled TC for Concurrency Control.                       Commented v2
TH:Concurrency Control   tcQueue                  TC Queue function for Concurrency Control.                          Commented v2
TH:Concurrency Control   tcDeQueue                TC deQueue for Concurrency Control                                  Commented v2

TH:Email Notification    emailNotification        Process the Outlook email Notification Commands                     Commented v3  
TH:Conti. Integration    thBuzRule                Handle Continuous Integration                                       Commented v3

TH:Assist Functions      genTimeStr               time format function                         			      Commented	                                   
TH:Assist Functions      getIP                    TH:Generic Functions: get IP of local machine                       Commented 
TH:Assist Functions      genThProperty            generate TH property file                                           Commented  
TH:Assist Functions      printLibraryFun          print QTP Library Functions                                         Commented 
TH:Assist Functions      readTestHarnessCmdLine   read Test Harness Cmd Line args                                     Commented 
TH:Assist Functions      genQTPInputs             generate QTP Input files                                            Commented 
TH:Assist Functions      thPropertyUpdate         update TH property                                                  Commented 
TH:Assist Functions      prHelp_short             Print the short Help                                                Commented todo
TH:Assist Functions      prHelp                   print lengthy Help                                                  Commented 
TH:Assist Functions      genQTPDriver             Generic qtpDriver                                                   Commented 
TH:Assist Functions      genQTPLibrary            Generate QTP Library                                                Commented 
TH:Assist Functions      genCmd                   Generate the Test Harness ASP files                                 Commented 

TH:Generic Functions     appendtoFile             TH:Generic Functions: append to file                                Commented Done
TH:Generic Functions     createFile               TH:Generic Functions: create a file                                 Commented Done
TH:Generic Functions     getDate                  TH:Generic Functions: get current Time                              Commented Done
TH:Generic Functions     reverse                  TH:Generic Functions: reverse a Associate Array                     Commented            
TH:Generic Functions     strLen                   Generic Functon: return Str len                                     Commented            
TH:Generic Functions     decrCtr                  Decrease Ctr                                                        Commented            
TH:Generic Functions     incrCtr                  Increase Ctr                                                        Commented            
TH:Generic Functions     getCtr                   Get Ctr                                                             Commented 
TH:Generic Functions     getCurrentTime           TH:Generic Functions: getCurrentTime                                Commented 
TH:Generic Functions     getHost                  getHost function done by SZ Team Charlie and David                  Commented 
TH:Generic Functions     getHostFromIP            Get Host done by SZ Team Charlie and David                          Commented               

------------------------------------------------------------------------------------------


=head1 NAME
Test::AutomationFramework - Test Automation Framework  (TAF)

=head2 SYNOPSIS
	1. Download and install Test::AutomationFramework from CPAN
	2. DOS>perl -MTest::AutomationFramework -e "help"
	3. A WebUI is created, which can display and execute, as well as view test case by *ONE* mouse click
	3. Modify taf.bat for the automated test suit structures 
	4. Modify c:\[test_suit]\[test_case]\tc.pl to plug-in the customer test case
	5. Execute taf.bat to get the webUI
	6. Run test cases, view test result, view test logs with mouse click only. - Enjoy TAF
	7. Please email ywangperl@gmail for questions/suggestions/bugs 

=head2 DESCRIPTION
	TAF manages automated test cases regarding test setup, test query, test execution and 
	test reult reportings without any programming nor reading user manual. 

	TAF defines a automated test case as [c:]\[test_suite]\[test_case]\tc.pl
		tc.pl returns Pass|fail|numerical number
		tc.pl creates tc's log file as [c:]\[test_suite]\[test_case]\tc.pl
		tc.pl creates test suite's webUI at [c:]\[test_suite]\index.htm 

=head1  LICENSE
	This script is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=head1 AUTHOR
    	Yong Wang (ywangperl@gmail.com)

=cut;


1;



taf.pl 'testsuit=_default_testsuite_;create=testcase01/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_1:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase02/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_2:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase03/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_3:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase04/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_4:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase05/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_5:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase06/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_6:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase07/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_7:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase08/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_8:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase09/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_9:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase10/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_10:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase11/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_11:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase12/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_12:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase13/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_13:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase14/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_14:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase15/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_15:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase16/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_16:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase17/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_17:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase18/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_18:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase19/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_19:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase20/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_20:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase21/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_21:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase22/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_22:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase23/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_23:customTC'
taf.pl 'testsuit=_default_testsuite_;create=testcase23/overwrite,customTC:c:/tmp/test_default_testsuite_.pl_space_23:customTC'

taf.pl testbed=c:\_testbed_ts;NofTCinTSTemplate;createTS


-- history/good memory --

taf.pl testsuit=propertyChangedEvent;list
rem taf.pl testsuit=propertyChangedEvent;exec
rem taf.pl testsuit=propertyChangedEvent;updateWeb=_testcase2_/1
* using the directory recursive for searching testcases
* CustomTC:....:CustomTC

__END__

#################### Todo list: Functional Requirements ################################
# * improvement: runFromGmail in prog  (test fetchmail in linux; win/linux )
# * bug? No () in the index.pl tcDesc/special character @, too long, tab
# * $c collision temporal solution line 6206
# * testbed: improvement: tsProperty with combination of TreeViewLevel (local confg) need to be tested
# * Testbed improvement: _thProperty_link.txt 
# * Testbed improvement: _noShow_
# * bug: One text link per line. need extra space at the line 1426 tail 
# * bug: fix the powershell bug (generateTAFTestsuite)*test*on linux    -done 10/26/2013
# * taf.svr uses hostname and ip dynamically				-done 12/26/2013
# * bug: the TC exec time is too small (null time shoul not be counted 	-done 10/26/2013
# * todo test the genTAFDriver_Svr on linux system !!!!!!!!!!!!!! depend HTTP::Server::Simple::CGI
# * research python as http/cgi server or CPAN : Solution: taf.svr 	-done 10/26/2013
# * add genTAFDriver_SVR	to replacy mongoose (work on windowOS)	-done 10/25/2013
# * activate/test queue 						-onhod10/12/2013 <- on hold
# * explore cygwin/bash .....  usages (see plink.pl) 			-done 10/12/2013
# * remove "Pleaes uncoment this from taf.pl message". Concurency 	-done 10/12/2013
# Linux Only: comment print "\nInfo: $SvrProjName_ might have problem 	-done 10/12/2013
  with the build-in file link (*.txt) \n($SvrProjName_ !~ $c_)\n\n"   	................
  if ($^O =~ /linux/);  #### debug info: 				................
#   <style type="text/css"> a { text-decoration:none} </style>		-done 10/10/2013
# -----------------------------------------------------------------------done 09/30/2013
# * Integrate the taftaf.pl/index2index.pl to handle subTS - $SvrProjNameSub ...........
#	taf.pl testsuite=c:/aa;createTS					................
#	taf.pl testsuite=c:/aa;subtestsuite=TC3;generateTestsuite	................
# -----------------------------------------------------------------------done 09/30/2013
# * createTS_B: sort {$a <=> $b}					-done 09/30/2013 
# * improvement: printVersion printOSVersion has \n (need AF change)	-done 09/26/2013
# * bug: __lt__  __gt__ are not converted to <> in tcLog.html (addURLs)	-done 09/25/2013
# * requirement: createTS (numberOfTC = N) 				-done 09/24/2013   <- needs in test bed and tested on linux
# * improvement: verify testcase =~ /$c/ at createTC			-done 09/25/2013
# * improvement remove underline for url 				-done 09/25/2013
# * improvement: add a url on webUI to run indexindex.pl (genSubTS) 	-n/a  09/24/2013
# * tech reserver line 1425  file:// is commented for http/cgi version  -done 09/23/2013
# * bug: linux title misses / (tmp/var/www...) noBug ts=tmp/...	 	-doen 09/23/2013
# * add printVersion	/printOSVersion					-done 09/23/2013
# * explore testsuite=_testsuite-1,3-4]_;testcase=testcase000[1,2]	-done 09/22/2013
# * ----------------- remove several comment lines 			-done 09/21/2013
# * add createTS_index var to make createTS using proveded indexindex.pl-done 09/20/2013 
# * modification sub deleteTS poiintint to deleteTAFTestsuite		-done 09/20/2013
# * bug: When index.pl has none TC, write error sub runPowershell  	-done 09/20/2013
# * add createTS_index var to make createTS using proveded index.pl 	-done 09/19/2013
# * bug : taf_delete.sh was not created (check taf.sh)			-done 09/18/2013
# * bug: line 2446 perf|expectedF... is a reserved word  -> \bperf\b	-done 09/17/2013
# * bug: deleteTAFTestsuite won't work on linux				-done 09/09/2013
# * print warning message when TS is outside /tmp/var/www/cgi-bin (1412)-done 09/06/2013
# * request: remove testBed		delDriverWindow delDriverLinux 	-done 09/06/2013
# * request: deleteTAFTestsuite						-done 09/06/2013
# * bug: should not create generateTestsuite.pl line 3638		-done 09/06/2013
# * bug fix: modify the test bed for linux security			-done 08/07/2013
# * user experience: add testbed's tcDriver display line 1386		-done 08/07/2013
# * user experience: add testbed's tsDriver display line 6200		-done 08/07/2013
# * improvement: deleteTS (remove a directory) 				-done 08/06/2013
# * improvement: combine createTS and generateTAFTestsuite		-done 08/06/2013
# * bug line sub getProperties uncomment the close Fin 			-done 07/30/2013
# * line 3699: add OS independency for generateTestcase 		-done 07/30/2013
# * scan TAF server 	sub scanTAFServer 	done by a TC 		-n/a  07/30/2013 
# * bug: commandline should overwrite _TAF/_tafGlobalVari.txt 		-nobg 06/12/2013
#   The _tafGlobalVars.txt is used by the webUI 			-...............
# * improvement: title and link too far generateRootIndex		-done 06/12/2013
# * cosmatic improvement: webUI extra \n				-done 06/12/2013
# improvement: when TS and TAF-mapp-TA is from different root (linux)	-done 06/11/2013
#                                              same root (window) 	-...........
# ???? $copy window and linux -> copy					-done 06/11/2013
# * Improvemnt: createTS add  #!/usr/bin/perl				-done 06/11/2013
# execTC_ has debugging code for plink.pl linux/expect			-done 06/11/2013	
# improvement         Running at Hostname/IP				-done 06/11/2013
# bug: full is not add to the tsTags 					-done 06/10/2013
# improvement: tc sub createTC  add #!/usr/bin/perl			-done 06/07/2013
# bug: $c/$SvrPRojname -> //  in file creation (line 422, 431)		-done 06/07/2013
# function: use mongoose on linux set http_port = :1234			-done 06/07/2013
# function: use mongoose on linux set $cgi_bin = "/";   		-done 06/07/2013
# ./mongoose -enable_directory_listing yes -listening_ports 1234 -document_root /tmp/var/www/cgi-bin/_TAF
# * bug: generatePropertyTestsuite (tag $i = $i -1  line 585		-done 06/05/2013
# * line 3777  window only logic if ($^O) { ; }				-done 06/04/2013
# * line 3769  //-> / in the $cmd for linux				-done 06/04/2013
# * bug: index_pass.htm only work for _testsuite1_ (line 1130) _Simple 	-done 05/30/2013
# * configuraiton: sudo doesn't prompt for root password		-done 05/30/2013
#   /etc/sudoers/ ywang00 ALL=(ALL) NOPASSWD: ALL			-...............
# * bug: createFile doesn't set executable permission 	(line 5495) 	-done 05/30/2013
# *       todo  mkpath("dir", 0, 0777)                                  -..............
# * bug: testbed use c:/ in stead of $c for testsuite3/testcase0006 	-done 05/30/2013
# * bug: ExcelReport report only testcase. It should repoert all TS/TC	-nBug 05/29/2013
# * bug: TC Result * string only testcase. It should repoert all TS/TC	-nBug 05/29/2013
# * bug: 734 800 write to close filehandle -happens one time only
# * bug when there is no tags (_full_ and _smoketest_), _full_ will break the TAF
# * Linux Port: Makefile.PL (package version requirement update)
# * Linux Port: mkpath use umask and openfile with umask or chmod
# * dubug prDriver ignore the Queue function (will be reversed later)		
# * misc: testbed for tsTags, thProperty_link.txt, _noShow_ 
# * bug: when there is no TC in a TS, the TS * is default to move 	-nSee 05/29/2013
# * bug? htmlRefreshRate is not read from _tafGlobal.txt 		-done 05/29/2013
#        Modify sub readTAFGlobalVars1 for each read variables		-...............
# * bug? webUI_tcDescWidth is not read from _tafGlobal.txt 		-done 05/29/2013
# * minor bug : the result webUI misses several record (* is outofrange	-nobg 05/29/2013
# * minor bug : when TC run 24/7  it always display 2/1 (should n/1) 	-done 05/29/2013
# *             line 201, 2124 						-done .........
# * bug: miss generate default tsProperty.txt function	(default=none)	-nobg 05/29/2013
# # Linux Port: Setup: disable selinux, and disable firewall iptable    -setup ........
# * Bug: missed the printTestBedPropertyFunction during copy/paste     	-done 05/29/2013
# * Linux Port: testsuite generation is not working yet -tested! 	-done 05/28/2013			
# * Linux Port: add genDriverLinux 					-done 05/28/2013
# * apache confi file template is appended				-done 05/28/2013	
# * Linux Port:	if ($^O =~ /linux/i) { `sudo /bin/chmod -R ugo+rwx $c`;}-done 05/27/2013
#   	To take care of TAF-doesn't-have-enough-permission 		-...............
# * Linux port: taf.pl and taf.cgi are tested				-done 05/27/2013
# * Linux bug: tcIdMin is a stack variable (should be reset somewhere0  -done 05/27/2013
# * Linux bug: tcExec sequence is reversed 	line 223 and line 1723	-done 05/27/2013
# * Bug: the find loop display testcase000N no random order (findsorted)-done 05/27/2013
# * Linux porting: #!/usr/bin/perl or $!c:/strawberry/bin/		-done 05/27/2013
# * Linux porting: taf.cgi_realSemi_ = ; for win32 and ~ for linux 	-done 05/24/2013
# * Linux porting: taf.cgi_$cmd is modi for  win32 and linux       	-done 05/24/2013
# * Linux porting (convert \\ to / for unix port)			-done 05/24/2013
# * Bug http:ip:port// <double 	fix cgi_bin = cgi-bin/              	-done 05/23/2013
# * Improvement: TreeView.tsDesc at generateRootIndex			-done 05/19/2013	
# * bug: tsTags doesn't work after webUITreeView  (add to testbed) tsDir-done 05/18/2013
# * bug: tsProperty.txt will not work when modified (add %tcUIDesc )   	-dupl 05/18/2013
# * bug sub updateTAFTSVars (SvrProjName =~ s/c:\_TAF//;		-done 05/16/2013
# * bug : The TrewView should display the TS when there is only one TS	-done 05/15/2013
# * Function: webUITreeView controled by webUITreeViewLevel = 1,2...   	-done 05/15/2013
#                       taf.pl webUITreeViewLevel=3;generateRootIndex
# * Improvemen: webUI tree struc sub getRoot_N				-done 05/15/2013
# * Improvment: Modify the Local Execution only messate 		-done 05/14/2013
# * taf.queue_active: display no waiting job				-done 05/12/2013	
# * bug: Displaying "UnderExecution" can't be undone 			-done 05/12/2013
# * bug: cmdline var=; var=""                                   	-done 05/12/2013
# * minor bug _full_ (need to retest) removeTags 			-done 05/12/2013
# * improve &tsTags : taf.pl testsuite=c:\io....;tsTags			-done 05/10/2013
# * improvement: c:\_TAF\taf.pl testsuite=c:/iovation/pdxnpywang02/Service;readTCDesc -done 05/10/2013
# * bug: 1st execution have undefined $fileText line 1666  		-done 05/06/2013
# * Test: TS=4, TC=1 (20s) 1 (20s)                                   	-done 05/02/2013
# * Test: TS=4, TC=1,2,1,2,3,4  /w lock (tc1 = 20sec)			-done 05/02/2013
# * Test: TS=4, TC=1,2,1,2,3,4  /o lock					-done 05/02/2013
# * bug: add updateQueue to update taf.queue_active			-done 05/02/2013
# * bug: stopTS have ;   ;->_semi_ (like 4995,4997,1897,1902,taf.cgi)   -done 05/02/2013
# * Testing concurrency (1usr, 2 usr, + exitTAF )			-done 04/30/2013 (tested!!!)
# * bug: testsuite=_t1_;list (have errro when _testsuite1_ doen's exist	-done 05/02/2013
# * impromement: job is running info for every title 			-impletmented (need testing)
# * todo: test different $c/$_TAF scenarios (work around available) 	-done 05/00/2013
# * impromement: display *Real* job queue 				-done 04/30/2013


# ........................ above should be compled ...........................
# * Add a service of fetchmail and triger behind webUI is good     	
# * sub fetchGmail	as a place holder
# * Improvement: merge Test result  batch   _thPropertyExtend.txt       5/n   



# * *MS/IE* Bug: when IE open the html, it locks the file for writting  -Limitation
# * improvement: use xterm to show the execution at linux server	-postponed 
# * test delete TS/TC scenario						-postponed
# * improvement: delete TS/TC by clicing webUI component		-postponed
# * Improvement: a TS with 100 testcases to test the performance   	-postponed
# * Improvement: Virtual PropertyTestsuites 				-postponed
# * improve: exit status = manl for manual test 			-postponed
# * Improvement: Testsuite search won't take regexp (as testcase does) 	-postponed
# * remote installation? or create c:\_TAF from installation 		-postponed
# * todo: need do a mass copy/replace commands from linux sed ? 	-postponed
# * ouptputFormat = text|no|html 					-postponed
# * create testbed regression 						-postponed
# * handle unexpected reboot scenario					-postponed
# * improvement: Title of TS + propertyTS needs retrunHtml ...	    	-postponed
# * _generateExcelReport.html (alignment for , )		    	-postponed
# * improvement: tcDesc width can be self-adjusted		    	-postponed
# * bug sometimes TS has not testcases (*U*pdate is the workaround) 	-postponed

# * bug: queueFName missing $c/$_TAF					-done 04/30/2013
# * bug: exitTAF should be handled separately				-done 04/30/2013
# * bug: 5226 read on closed filehandle (can't be reproduced)		-doen 04/30/2013
# * multi-TS Execution sequentially or concurrently			-done 04/29/2013
# * Bug see Todo: &processTCs won't gernerate _list_tcDesc.txt 		-done 04/29/2013
# * there is recursive call on scanTestsuite (call list)		-done 04/30/2013
# * add CGI support for the index_http.htm 				-done 02/00/2013
# * Bugs fix at generateExecelReport &processTC recursively is possible -done 04/29/2013
# * Improve: QueueSizeLimit = 10000 					-done 04/29/2013
# * QueueTest: batch drive, queue driven, multi-taf.pl exections	-done 04/29/2013
# * Improve: Queue limitation: it require sequential index		-done 04/29/2013
# * bug fix: no embeded taf.pl !!!!!! NofPropertyExec processTC(); 	-done 04/29/2013
# * Improvement: add generateRootIndex link at Title			-done 04/29/2013
# * bug: exitGracefully stops working after the taf.cgi taf.pl update   -nobug04/29/2013
# * bug: propertyTS index number is not sequential tmp4 in genRootIndx	-done 04/29/2013
# * Concurrency Control: add sub Queue (queueSize) queueSizeUI     	-done 04/29/2013
# * Concurrency Control: add sub Queue (set/releaseLock)                -done 04/28/2013
# * Concurrency Control: add sub Queue                  		-done 04/28/2013
# * Concurrency Control: add sub pushQueue and popQueue (absolete) 	-done 04/28/2013
# * Improvement: merge Test result  histrorystring              4/n     -done 04/27/2013 
# * Improvement: merge Test result  thPropertyLink.txt          3/n     -done 04/27/2013			
# * Improvement: merge Test result  sub sortOnDate		2/n	-done 04/29/2013
# * Improvement: merge Test result  sub sortOnDate		1/n	-done 04/26/2013
# * Improvement: create independent TS (redirect != c:\_TAF		-n/a  04/26/2013
# * improvement: generate c:\_TAF\tsProperty.pl for index.htm    	-done 04/26/2013       
#        To refresh, delete c:\_TAF\tsProperty.txt & generateRootIndex  ----------------
# * Bug: _install_ is matched by /all/                       		-done 04/26/2013
# * Bug: 5089 open non-existence file (1st run bug) 			-done 04/22/2013
# * Bug: 4790 open non-existence file (1st run bug) 			-done 04/22/2013
# * Bug: Execution_24_7 won't update the historical &reportTCSummary () -done 04/20/2013
# * Bug: Testsuite <- Testsuite displays default. Not real TS 		-done 04/20/2013
# * Bug:  Variable is treated as testsuite ( if -e $tcname ) 		-done 04/20/2013
# * Improvement: treat c:\_TAF ($c/$_TAF) is a global variable 		-done 04/20/2013
# * Improvement: self-identify local-execution or Execution_from_cgi    -done 04/17/2013
#   TC Variables should overwrite TS variables (TC over TS when no TS	-done 04/17/2013
# * Improvement: Testsuite/Testcase local execution only (taf.cgi) 	-done 04/17/2013
#   updateTAFTSVars, updateTAFTCVars, updateTAFVars                 	-done 04/1y/2013
#   clearTAFTSVars, clearTAFTCVars, clearTAFTSVars, readTAFTCVars 	-done 04/1y/2013
#   printTAFTSVars, printTAFTCVars, readTAFTSVars, readTAFTCVars 	-done 04/15/2013
# * bug: taf.pl ts=_ts_  create a invalid c:\_TAF\_ts_			-done 04/13/2013
# * Request: disable Execution_24_7 on the title line (sub readTAFTSVar)-done 04/10/2013 <- TestBed:_testsuite1_->title.Exec won't run 24/7
# * bug: generateTestsuiteByDesc uses wrong index.pl # 	(_tcMap.txt)    -doen 04/03/2013
# * add sub runFromGmailService for gmail interaction			-done 03/30/2013 <-
# * add sub runFromGmail        for gmail interaction			-done 03/30/2013
# * add sub getTSNameFromTSDesc for gmail interaction			-done 03/30/2013
# * improvement: propertyExecCtrEqZero (24_7 & propertyOp won't exit) 	-obsolete-------
# * add <body OnLoad function to getGamil and create c:\_TAF\_TAFArgs.txt -replaced by the following
# * improvement: the c:\_TAF\index.htm and index_http is not updated 	-deon 03/30/2013 (generateRootIndex after updateWeb)
# * sub getTAFArgsFromFile (c:\_TAF\_tafArgs.txt) 			-done 03/27/2013
#   modify the genDrive_taf_pl to show the change 			-done 03/27/2013
# * improvmemt: no more taf.pl recursive call				-done 03/27/2013
# * bug: fixing special character bug introduce < in &lt; broke loglink -done 03/21/2013 (add _url_link_)
# *    : should create http for http.htm                                ----------------                    
# * add titleStatus for maintenance info titleStatus=(UnderMaint);list  -done 03/19/2013
# * add sub listTS aka updateTS 					-done 03/19/2013
#   Technical point: reDirect variable is passed to taf.cgi		-done 03/19/2013	
# * add Global createOrAppendTS  to handle append TC to TS 		-done 03/19/2013
#   append new TC in the webUI sub createPropertyTemplate() 		-done 03/18/2013  	
# * tcDesc display special characters  < > will dis-align the webUI (work around < lessThan > greaterThan see        #### special character -> Conversion  in progress. Testbed is done with _testsuite5_
#          modify sub runPowershell and sub                             -done 03/14/2013
# * check _url_line_ for _logTC is treated as URL no < replace		-done 03/14/2013
# * improvement: htmlRefreshRate for webUI (fast) and for logUI (slow) 	-done 03/14/2013
# * Req: tcDesc can't have xml tags from the tcDesc for property display-done 03/12/2013
# * bug # bug: parsing tcSerialN failed	- sprintf error			-done 03/12/2013
# * href> in the _tcLogAppend.txt (sub addURL) 				-done 03/07/2013 
# * improvement: add bugF return state					-done 03/07/2013 
# * bug: < > @ in _tcLogAppend.txt to tcLog.htm sub addURL()a		-done 03/06/2013 <more char # ...>
# * bug: <a> </a> in _tcLogAppend.txt should be &lt; &gt; 	  	-done 03/06/2013
# * todo: remove javascripts in the html title 		invalid		-ign  03/04/2013
# * Improvement: add a exec URL in tc_log and tc_log_http.htm 		-done 03/04/2013
# * improvement: tcDesc has c:\_TAF too short by removeTags/match1stReg -done 03/02/2013
# * bug: tcDesc = _..._ should not remove '/' by removeTags 		-done 03/02/2013
# * improvement: add performanceMode=fast to webUI cmds			-done 03/01/2013
# * improvement: add performanceMode=fast to generateTestsuiteAgain	-done 03/01/2013
# * improvement: add nullCtr to display total execution time for null 	-done 03/01/2013
# * performance improvement move updateTCPassFAil to Post 		-done 02/28/2013
# * performance improvement move reportHistory to tcPost		-done 02/28/2013
# * performance improvement ping -n 1 localhost 			-done 02/28/2013
# * overWriteTC = 'y'  ***Default is overwrite***			-done 02/28/2013
# * bug: duplicated serial # in the tcDesc  #### Fix duplicated serial  -done 02/27/2013
# * improment: combine tags with the tcDesc			 	-done 02/28/2013
# * bug: command history is not updated by HTA, only by Httpd (No BUG) 	-done 02/24/2013
# * bug (sec)-Tip is total time Work-around: use Total TS Exec Time. 	-done 02/24/2013
# * improvement: test hook color grey->white				-done 02/24/2013
# * add testcaseNode commandline 					-done 02/24/2013
# * improvement: Title of TS + propertyTS needs testcaseNode=_null_ for *U*  -done 02/24/2013
# * update the _tafGlobal_txt after setGlobal (testcaseNode) outdated   -done 02/23/2013
# * bug "Use uniniatialize $cmd 1807 "					-done 02/23/2013
# * testcaseNode=_null_ will set testcaseNode = ""			-done 02/21/2013
# * generateTAFTestsuite including subTS by testcaseNode = "" 		-done 02/21/2013
# * use Term::ReadKey for the enterY() 					-done 02/21/2013
# * bug:  recursive usage of creating propertyTS by generatePropertyTS  -done 02/16/2013
# * bug: ResultString width is max-so-far during generateTestsuiteAgain -done 02/15/2013
# * handle no httpd service scenario (ping localhost)			-done 02/14/2013
# * taf.pl generateTestsuiteAgain (Can't be executed by webUI)		-done 02/14/2013
# * add taf.pl generateTestsuiteAgain to the title			-done 02/14/2013
# * outputPause = 5 							-done 02/14/2013
# * Bug: web_ui_title should from readTSProperty (not readTAFProperty)  -done 02/13/2013 
# * modify taf.cgi 							-done 02/11/2013
# * htmlRefreshRate = 20						-done 02/11/2013
# * add ip as a global variable						-done 02/11/2013
# * modify prHtml2 for http						-done 02/09/2013
# * add prHtml1_strGen_CGI() for http title line			-done 02/08/2013
# * Integration with mongoose web server				-done 02/08/2013
# * add genDriver_taf_CGI						-done 02/08/2013
# * c:\_TAF independency (change $_TAF will change different testsuite  -done 01/31/2013
# * add URL to c:\_TAF\taf.bat (taf.txt)                     		-done 01/29/2013
# * add tsProperty.txt for testsuite1 and testsuite2			-done 01/29/2013
# * bug mapTC shadows the listTC/execTC $rst				-done 01/23/2013 
# * modify the ps1_args___powershell_args				-done 01/22/2013
# * add the generateChildTestsuites  					-done 01/16/2013  (need further test)
# * Add thProperty.txt for each TS					-not an issue
# * add the c:\_TAF\_tafGlobalVars.txt &readTAFGlobalVars		-done 01/15/2013
# * c:\_TAF\_cmdLogs.txt can grow very big potentially			-done 01/15/2013
# * Issue: testcaseNode default = testcase000N (comflict between taf/ts and generated/ts) -fixed 01/15/2013
# * But one PS TC failed in the test bed  ps1_arg=powershell_args	-doen 01/15/2013
# * cmdLog.txt TimeSpan    $commandLogLifeSpan		= "- 3 days"; 	-done 01/15/2013
# * add command history to c:\_cmdLogs.txt				-done 01/15/2013
# * remove autoTCDesc related lines (remove tcDesc Serial Number) 	-done 01/15/2013
# * tcDelta needs to be copied from Jan_11B version markdaily 		-done 01/15/2013
# * add _tag_ function (index_faild 	mergethProperty();		-done 01/15/2013
# * add refresh from webUI $listTS,$listTSAll				-done 01/14/2013
# * bug: list should not make the moving bar	$scrollAmount_		-done 01/13/2013
# * testsuite log $externalLogName=... see &getTCLogFname__ 		-done 01/13/2013
# * Format the passFailString	add dumyTC				-done 01/13/2013
# * Pass/Fail link failed  getLastPassFail() and genPassFailOther	-done 01/13/2013 
# * Bug Exec_24_7 will run infinite number for propertyOp		-done 01/13/2013 	(propertyExecCtr)
# * duplicated records in webUI (possible reason/solution) testcaseNode (solution: testcaseNode?)
# * fix todo in the code						-done 01/13/2013	(4 todo left to fix)
# * generateRootIndex copy index.htm_ to index.htm doens't work on some system (need exit IE/index.htm or manual copy)
# * add Regexp::Assemble->new; 		 in the build process		-done 01/04/2013
# * add File::Copy::Recursive dependency in the build process		-done 01/04/2013
# * generate the index_http.htm. 					-In progress (12/26/2012 onhold wait for RubyOnRail)
# * Animate Testsuite bulletin. - generateRootIndex ? 			-in Prog (need testing)
# * Extra searial#. was added in the code. thProperty.txt) - as designed-done 01/01/2012
# * Mark automation every day  by            sub getExecDay 		-done 01/04/2013
# * Full width passFailString (index_Full_Length.htm) 	Add intelegent 	-done 01/02/2012
# * Mark with Automation Note/Mouse Over display 			-done 01/01/2013
# * MouseOver * in the Automation history				-done 12/26/2012 
# * generate taf.pl on e: (other than c:)  taf.pl _TAF=tmp\tmp;genDriver-done 12/26/2012
# * generateExcelReport has $rst = `$cmd`. should &func() 		-done 12/26/2012
# * add Mark by "|" in webUI						-done 12/21/2012
# * add stop TS by "." in webUI						-done 12/21/2012
# * multiple command in squence: list;exec;list;exec			-done 12/18/2012 
# * scan TS under c:\_TAF\ doen't work yet. (errous test bed)		-done 12/20/2012
# * fix bug ps1_arg1= bug	In processTCS				-done 12/20/2012 
# * add function: exitTAFGracefully for any TC  .Execution		-done 12/20/2012
# * multiple commands separated by ;	$isBatchProcessing == 1) { $NofExecutionCtr=0; &tcLoop();} -done 12/18/2012
# * add refresh function to c:\_TAF\index.htm				-done 12/14/2012
# * Stop a specific test execution					-done 12/13/2012 
# * Repeat a specific test case	($markTS)				-done 12/13/2012
# * GeneratePowershellShellTS 						-done 06/06/2012
# * create ps1 testsuite createTS and its test cases			-done 06/01/2012
# * integrate gerneatePShellTestsuite 					-done 06/06/2012
# * remove taf recursive by $makeMark=y (perform improvement)		-done 12/05/201/
# * exitGracefully for each test case					-done 12/12/2012 
# * add generateExcelReport Function					-done 12/06/2012
# * add enterY function							-done 12/10/2012
# * remove _cmd_holder and _desc_holder_				-done 12/11/2012
# * convert listHistory to propertyOP=list_history_tcRunReport  	-done 12/11/2012
# * generate daily Excel report						-done 12/11/2012
# * resetTSFile								-done 12/12/2012
# * make Testcase Description link to Daily Report 			-done 12/12/2012
# * run one TC 24_7							-done 05/01/2012
# * win8 installation							-done 12/05/2012
# * use testsuite for tcFilter, tcDefaultFilter 			-done 12/12/2012
# * generateExcelReport handles performance TC (return NN.NN)  		-done 12/12/2012
* # addURLs will add date-time to the log fname 			-done 12/13/2012
############# Low Priority Requirement/Bugs #########	                -----
#   Need to setup IIS and _TAF as a virtual directory documentation 	-obso 04/30/2013 (use mogoose)
# * multiple tppp filters 	(Very difficult/Low priority)		-postpone
# * Notif for the expected failure					-done 01/01/2013
# * generateIndex (including generateRootIndex) based on scanTestsuite - works. but index.htm has a lock on it?  (investigation)
############# todo: MarkTC related Actions #########                    -----
# * mark by delta time (every day at 0:00?) 				-postpone
# * mark with comments (mouse over comments)				-done 12/26/2012
# * history mark link to logs/passfail					-postpone
# * mark non-executed TCs						-postpone
#################### Completed Requirements/Bug fixes ###########################
# * passFailDisplayWidth is self-adjustable (see todo) 			-done
# * line 1951: **recursive calling** -Done on 09/04/2012		-done
# * 24 exec,  					done			-done
# * Number of TS execution  setGlobal(NofExecution = 5) 		-done
# * start/stop gracefully	taf.pl exitTAF				-done
# * 24 continuously, in stead of one test suite 			-done
# * Stop TAF graceffully from webUI 					-done
# * bug: * history is incorrect 					-done
# * Bug 'mark' is counted as a failure 					-done
# * Cleanup the directory with index.ps1 				-done (.ps1 takes high priority over *.pl)
# * Bug 'L' has characters other than '*' 				-Ignore (invalid bug)
# * Performance improvements						-done (performanceMode)
# * generateTestsuite will add the tcDesc property 			-done 
# * propertyOperation by propertyOp=add=prop1:val1 			-done 
# * propertyOperation by propertyOp=get_prop1:val1			-done 
# * PropertyFilter for TC operation (e.gl tcDesc = ..)			-done
# * Search by TCDesc							-done by tcProperty
# * list should list all TS/TCs						-done -handle by scanTestsuites
# * Refresh or the historical "*"					-done
# * testcase=testcase[1,2,3..] work for list. not work for exec 	-done (it works)
# * Bug: pass/fail html is incorrect					-done
# * modify the getProperties to pass regression				-done
# * add removeDuplicated records to handle webUI dup			-done (wrong fix. reversed)
# * scanTestsuite for generated property files _full_, _smoketest_, _regressiontest_ -done (see taf.bat)
# * scanTestsuite for generated property files _full_,  _tcLogAppend.txt was not copied to the _property_ directory - Done
# * c:\_TAF\index.htm concurrency control 				-done
# * Bug fix for generate index_[pass|fail].htm				-done
###################################################################################
############# property operations ###############			-----
# * Add 								-done
# * Delete      add=prop:null						-done 
# * Modify	add=prop:newValue					-done 
# * List|get	propertyOp=list_[history_]propName               	-dene 12/11/2012
############ repalced by [set|get]_tcFilter 				-----
# When The TS is under c:\_TAF, generateTestsuite will generate c:\_TAF\_TAF.... no index.pl is copied. 
# The original c:\_TAF\... is treated as the test suites		-postponed
# Q: does the c:\_TAF\_TAF is necessary created? (It won't hurt for now)-postponed
##################### Research Topic1: TAF_Team function   ############################
# * Web Service architecture / CGI / RPC / RubyOnRail			-done 04/30/2013
# * Browser independency 						-done 04/30/2013
# * local run version and /o IIS , support multiple TC Concurrency .,   -done 04/30/2013
# * Working with new Concurrency Control scheme, TCExecSummary, tcDelay=10 -obsolete 
#################### Research Topics2:TestSuite Machine independency ###################
# *  Move/Merge TAF over machine					-future 
# ** Merge test suite from one machine					-future
# ** Merge test suite from multi-machine				-future
# ** Move TS from one dir to different dir and regenerate the index*.*	-future
# 0. Move the TS to c:\_MachineName\....				-future
# 1. generateAyAnvilTestsuite.pl					-done 01/02/2013
# 2. Copy c:\_TAF\* to new server					-todo
# 3. taf testsuite=...;list						-done 01/01/2013
# 4. Need to copy the AUT to new server
# 5. use tsProperty.txt to update 					-postpone
# 6. TS titleName							-obsolete	
# 7. TC directory 							-obsolete
#Note: ts;list will update all index.html				-done 


############################## Apache Config File (/etc/httpd/conf/httpd.conf ###################################
#  DocumentRoot     =    /tmp/var/www/cgi-bin/_TAF 
#################################################################################################################
#
# This is the main Apache server configuration file.  It contains the
# configuration directives that give the server its instructions.
# See <URL:http://httpd.apache.org/docs/2.2/> for detailed information.
# In particular, see
# <URL:http://httpd.apache.org/docs/2.2/mod/directives.html>
# for a discussion of each configuration directive.
#
#
# Do NOT simply read the instructions in here without understanding
# what they do.  They're here only as hints or reminders.  If you are unsure
# consult the online docs. You have been warned.  
#
# The configuration directives are grouped into three basic sections:
#  1. Directives that control the operation of the Apache server process as a
#     whole (the 'global environment').
#  2. Directives that define the parameters of the 'main' or 'default' server,
#     which responds to requests that aren't handled by a virtual host.
#     These directives also provide default values for the settings
#     of all virtual hosts.
#  3. Settings for virtual hosts, which allow Web requests to be sent to
#     different IP addresses or hostnames and have them handled by the
#     same Apache server process.
#
# Configuration and logfile names: If the filenames you specify for many
# of the server's control files begin with "/" (or "drive:/" for Win32), the
# server will use that explicit path.  If the filenames do *not* begin
# with "/", the value of ServerRoot is prepended -- so "logs/foo.log"
# with ServerRoot set to "/etc/httpd" will be interpreted by the
# server as "/etc/httpd/logs/foo.log".
#

### Section 1: Global Environment
#
# The directives in this section affect the overall operation of Apache,
# such as the number of concurrent requests it can handle or where it
# can find its configuration files.
#

#
# Don't give away too much information about all the subcomponents
# we are running.  Comment out this line if you don't mind remote sites
# finding out what major optional modules you are running
ServerTokens OS

#
# ServerRoot: The top of the directory tree under which the server's
# configuration, error, and log files are kept.
#
# NOTE!  If you intend to place this on an NFS (or otherwise network)
# mounted filesystem then please read the LockFile documentation
# (available at <URL:http://httpd.apache.org/docs/2.2/mod/mpm_common.html#lockfile>);
# you will save yourself a lot of trouble.
#
# Do NOT add a slash at the end of the directory path.
#
ServerRoot "/etc/httpd"

#
# PidFile: The file in which the server should record its process
# identification number when it starts.  Note the PIDFILE variable in
# /etc/sysconfig/httpd must be set appropriately if this location is
# changed.
#
PidFile run/httpd.pid

#
# Timeout: The number of seconds before receives and sends time out.
#
Timeout 60

#
# KeepAlive: Whether or not to allow persistent connections (more than
# one request per connection). Set to "Off" to deactivate.
#
KeepAlive Off

#
# MaxKeepAliveRequests: The maximum number of requests to allow
# during a persistent connection. Set to 0 to allow an unlimited amount.
# We recommend you leave this number high, for maximum performance.
#
MaxKeepAliveRequests 100

#
# KeepAliveTimeout: Number of seconds to wait for the next request from the
# same client on the same connection.
#
KeepAliveTimeout 15

##
## Server-Pool Size Regulation (MPM specific)
## 

# prefork MPM
# StartServers: number of server processes to start
# MinSpareServers: minimum number of server processes which are kept spare
# MaxSpareServers: maximum number of server processes which are kept spare
# ServerLimit: maximum value for MaxClients for the lifetime of the server
# MaxClients: maximum number of server processes allowed to start
# MaxRequestsPerChild: maximum number of requests a server process serves
<IfModule prefork.c>
StartServers       8
MinSpareServers    5
MaxSpareServers   20
ServerLimit      256
MaxClients       256
MaxRequestsPerChild  4000
</IfModule>

# worker MPM
# StartServers: initial number of server processes to start
# MaxClients: maximum number of simultaneous client connections
# MinSpareThreads: minimum number of worker threads which are kept spare
# MaxSpareThreads: maximum number of worker threads which are kept spare
# ThreadsPerChild: constant number of worker threads in each server process
# MaxRequestsPerChild: maximum number of requests a server process serves
<IfModule worker.c>
StartServers         4
MaxClients         300
MinSpareThreads     25
MaxSpareThreads     75 
ThreadsPerChild     25
MaxRequestsPerChild  0
</IfModule>

#
# Listen: Allows you to bind Apache to specific IP addresses and/or
# ports, in addition to the default. See also the <VirtualHost>
# directive.
#
# Change this to Listen on specific IP addresses as shown below to 
# prevent Apache from glomming onto all bound IP addresses (0.0.0.0)
#
#Listen 12.34.56.78:80
Listen 80

#
# Dynamic Shared Object (DSO) Support
#
# To be able to use the functionality of a module which was built as a DSO you
# have to place corresponding `LoadModule' lines at this location so the
# directives contained in it are actually available _before_ they are used.
# Statically compiled modules (those listed by `httpd -l') do not need
# to be loaded here.
#
# Example:
# LoadModule foo_module modules/mod_foo.so
#
LoadModule auth_basic_module modules/mod_auth_basic.so
LoadModule auth_digest_module modules/mod_auth_digest.so
LoadModule authn_file_module modules/mod_authn_file.so
LoadModule authn_alias_module modules/mod_authn_alias.so
LoadModule authn_anon_module modules/mod_authn_anon.so
LoadModule authn_dbm_module modules/mod_authn_dbm.so
LoadModule authn_default_module modules/mod_authn_default.so
LoadModule authz_host_module modules/mod_authz_host.so
LoadModule authz_user_module modules/mod_authz_user.so
LoadModule authz_owner_module modules/mod_authz_owner.so
LoadModule authz_groupfile_module modules/mod_authz_groupfile.so
LoadModule authz_dbm_module modules/mod_authz_dbm.so
LoadModule authz_default_module modules/mod_authz_default.so
LoadModule ldap_module modules/mod_ldap.so
LoadModule authnz_ldap_module modules/mod_authnz_ldap.so
LoadModule include_module modules/mod_include.so
LoadModule log_config_module modules/mod_log_config.so
LoadModule logio_module modules/mod_logio.so
LoadModule env_module modules/mod_env.so
LoadModule ext_filter_module modules/mod_ext_filter.so
LoadModule mime_magic_module modules/mod_mime_magic.so
LoadModule expires_module modules/mod_expires.so
LoadModule deflate_module modules/mod_deflate.so
LoadModule headers_module modules/mod_headers.so
LoadModule usertrack_module modules/mod_usertrack.so
LoadModule setenvif_module modules/mod_setenvif.so
LoadModule mime_module modules/mod_mime.so
LoadModule dav_module modules/mod_dav.so
LoadModule status_module modules/mod_status.so
LoadModule autoindex_module modules/mod_autoindex.so
LoadModule info_module modules/mod_info.so
LoadModule dav_fs_module modules/mod_dav_fs.so
LoadModule vhost_alias_module modules/mod_vhost_alias.so
LoadModule negotiation_module modules/mod_negotiation.so
LoadModule dir_module modules/mod_dir.so
LoadModule actions_module modules/mod_actions.so
LoadModule speling_module modules/mod_speling.so
LoadModule userdir_module modules/mod_userdir.so
LoadModule alias_module modules/mod_alias.so
LoadModule substitute_module modules/mod_substitute.so
LoadModule rewrite_module modules/mod_rewrite.so
LoadModule proxy_module modules/mod_proxy.so
LoadModule proxy_balancer_module modules/mod_proxy_balancer.so
LoadModule proxy_ftp_module modules/mod_proxy_ftp.so
LoadModule proxy_http_module modules/mod_proxy_http.so
LoadModule proxy_ajp_module modules/mod_proxy_ajp.so
LoadModule proxy_connect_module modules/mod_proxy_connect.so
LoadModule cache_module modules/mod_cache.so
LoadModule suexec_module modules/mod_suexec.so
LoadModule disk_cache_module modules/mod_disk_cache.so
LoadModule cgi_module modules/mod_cgi.so
LoadModule version_module modules/mod_version.so

#
# The following modules are not loaded by default:
#
#LoadModule asis_module modules/mod_asis.so
#LoadModule authn_dbd_module modules/mod_authn_dbd.so
#LoadModule cern_meta_module modules/mod_cern_meta.so
#LoadModule cgid_module modules/mod_cgid.so
#LoadModule dbd_module modules/mod_dbd.so
#LoadModule dumpio_module modules/mod_dumpio.so
#LoadModule filter_module modules/mod_filter.so
#LoadModule ident_module modules/mod_ident.so
#LoadModule log_forensic_module modules/mod_log_forensic.so
#LoadModule unique_id_module modules/mod_unique_id.so
#

#
# Load config files from the config directory "/etc/httpd/conf.d".
#
Include conf.d/*.conf

#
# ExtendedStatus controls whether Apache will generate "full" status
# information (ExtendedStatus On) or just basic information (ExtendedStatus
# Off) when the "server-status" handler is called. The default is Off.
#
#ExtendedStatus On

#
# If you wish httpd to run as a different user or group, you must run
# httpd as root initially and it will switch.  
#
# User/Group: The name (or #number) of the user/group to run httpd as.
#  . On SCO (ODT 3) use "User nouser" and "Group nogroup".
#  . On HPUX you may not be able to use shared memory as nobody, and the
#    suggested workaround is to create a user www and use that user.
#  NOTE that some kernels refuse to setgid(Group) or semctl(IPC_SET)
#  when the value of (unsigned)Group is above 60000; 
#  don't use Group #-1 on these systems!
#
User apache
Group apache

### Section 2: 'Main' server configuration
#
# The directives in this section set up the values used by the 'main'
# server, which responds to any requests that aren't handled by a
# <VirtualHost> definition.  These values also provide defaults for
# any <VirtualHost> containers you may define later in the file.
#
# All of these directives may appear inside <VirtualHost> containers,
# in which case these default settings will be overridden for the
# virtual host being defined.
#

#
# ServerAdmin: Your address, where problems with the server should be
# e-mailed.  This address appears on some server-generated pages, such
# as error documents.  e.g. admin@your-domain.com
#
ServerAdmin root@localhost

#
# ServerName gives the name and port that the server uses to identify itself.
# This can often be determined automatically, but we recommend you specify
# it explicitly to prevent problems during startup.
#
# If this is not set to valid DNS name for your host, server-generated
# redirections will not work.  See also the UseCanonicalName directive.
#
# If your host doesn't have a registered DNS name, enter its IP address here.
# You will have to access it by its address anyway, and this will make 
# redirections work in a sensible way.
#
ServerName ywang02.iovatonnp.com:80

#
# UseCanonicalName: Determines how Apache constructs self-referencing 
# URLs and the SERVER_NAME and SERVER_PORT variables.
# When set "Off", Apache will use the Hostname and Port supplied
# by the client.  When set "On", Apache will use the value of the
# ServerName directive.
#
UseCanonicalName Off

#
# DocumentRoot: The directory out of which you will serve your
# documents. By default, all requests are taken from this directory, but
# symbolic links and aliases may be used to point to other locations.
#
#  DocumentRoot "/var/www/html"
DocumentRoot "/tmp/var/www/cgi-bin/_TAF"

#
# Each directory to which Apache has access can be configured with respect
# to which services and features are allowed and/or disabled in that
# directory (and its subdirectories). 
#
# First, we configure the "default" to be a very restrictive set of 
# features.  
#
<Directory />
    Options FollowSymLinks
    AllowOverride None
</Directory>

#  <Directory "/var/www/html">
<Directory "/tmp/var/www/cgi-bin/_TAF">

#
# Possible values for the Options directive are "None", "All",
# or any combination of:
#   Indexes Includes FollowSymLinks SymLinksifOwnerMatch ExecCGI MultiViews
#
# Note that "MultiViews" must be named *explicitly* --- "Options All"
# doesn't give it to you.
#
# The Options directive is both complicated and important.  Please see
# http://httpd.apache.org/docs/2.2/mod/core.html#options
# for more information.
#

    AllowOverride FileInfo AuthConfig Limit
#    Options MultiViews Indexes SymLinksIfOwnerMatch IncludesNoExec Indexes FollowSymLinks ExecCGI
	Options All
	AddHandler cgi-script .cgi .pl


#
# AllowOverride controls what directives may be placed in .htaccess files.
# It can be "All", "None", or any combination of the keywords:
#   Options FileInfo AuthConfig Limit
#
#    AllowOverride None

#
# Controls who can get stuff from this server.
#
    Order allow,deny
    Allow from all

</Directory>

#<Directory /home/*/public_html>
#    AllowOverride FileInfo AuthConfig Limit
#    Options MultiViews Indexes SymLinksIfOwnerMatch IncludesNoExec
#    <Limit GET POST OPTIONS>
#        Order allow,deny
#        Allow from all
#    </Limit>
#    <LimitExcept GET POST OPTIONS>
#        Order deny,allow
#        Deny from all
#    </LimitExcept>
#</Directory>




#
# UserDir: The name of the directory that is appended onto a user's home
# directory if a ~user request is received.
#
# The path to the end user account 'public_html' directory must be
# accessible to the webserver userid.  This usually means that ~userid
# must have permissions of 711, ~userid/public_html must have permissions
# of 755, and documents contained therein must be world-readable.
# Otherwise, the client will only receive a "403 Forbidden" message.
#
# See also: http://httpd.apache.org/docs/misc/FAQ.html#forbidden
#
<IfModule mod_userdir.c>
    #
    # UserDir is disabled by default since it can confirm the presence
    # of a username on the system (depending on home directory
    # permissions).
    #
    UserDir disabled

    #
    # To enable requests to /~user/ to serve the user's public_html
    # directory, remove the "UserDir disabled" line above, and uncomment
    # the following line instead:
    # 
    #UserDir public_html

</IfModule>

#
# Control access to UserDir directories.  The following is an example
# for a site where these directories are restricted to read-only.
#
#<Directory /home/*/public_html>
#    AllowOverride FileInfo AuthConfig Limit
#    Options MultiViews Indexes SymLinksIfOwnerMatch IncludesNoExec
#    <Limit GET POST OPTIONS>
#        Order allow,deny
#        Allow from all
#    </Limit>
#    <LimitExcept GET POST OPTIONS>
#        Order deny,allow
#        Deny from all
#    </LimitExcept>
#</Directory>

#
# DirectoryIndex: sets the file that Apache will serve if a directory
# is requested.
#
# The index.html.var file (a type-map) is used to deliver content-
# negotiated documents.  The MultiViews Option can be used for the 
# same purpose, but it is much slower.
#
DirectoryIndex index.html index.html.var index_http.htm

#
# AccessFileName: The name of the file to look for in each directory
# for additional configuration directives.  See also the AllowOverride
# directive.
#
AccessFileName .htaccess

#
# The following lines prevent .htaccess and .htpasswd files from being 
# viewed by Web clients. 
#
<Files ~ "^\.ht">
    Order allow,deny
    Deny from all
    Satisfy All
</Files>

#
# TypesConfig describes where the mime.types file (or equivalent) is
# to be found.
#
TypesConfig /etc/mime.types

#
# DefaultType is the default MIME type the server will use for a document
# if it cannot otherwise determine one, such as from filename extensions.
# If your server contains mostly text or HTML documents, "text/plain" is
# a good value.  If most of your content is binary, such as applications
# or images, you may want to use "application/octet-stream" instead to
# keep browsers from trying to display binary files as though they are
# text.
#
DefaultType text/plain

#
# The mod_mime_magic module allows the server to use various hints from the
# contents of the file itself to determine its type.  The MIMEMagicFile
# directive tells the module where the hint definitions are located.
#
<IfModule mod_mime_magic.c>
#   MIMEMagicFile /usr/share/magic.mime
    MIMEMagicFile conf/magic
</IfModule>

#
# HostnameLookups: Log the names of clients or just their IP addresses
# e.g., www.apache.org (on) or 204.62.129.132 (off).
# The default is off because it'd be overall better for the net if people
# had to knowingly turn this feature on, since enabling it means that
# each client request will result in AT LEAST one lookup request to the
# nameserver.
#
HostnameLookups Off

#
# EnableMMAP: Control whether memory-mapping is used to deliver
# files (assuming that the underlying OS supports it).
# The default is on; turn this off if you serve from NFS-mounted 
# filesystems.  On some systems, turning it off (regardless of
# filesystem) can improve performance; for details, please see
# http://httpd.apache.org/docs/2.2/mod/core.html#enablemmap
#
#EnableMMAP off

#
# EnableSendfile: Control whether the sendfile kernel support is 
# used to deliver files (assuming that the OS supports it). 
# The default is on; turn this off if you serve from NFS-mounted 
# filesystems.  Please see
# http://httpd.apache.org/docs/2.2/mod/core.html#enablesendfile
#
#EnableSendfile off

#
# ErrorLog: The location of the error log file.
# If you do not specify an ErrorLog directive within a <VirtualHost>
# container, error messages relating to that virtual host will be
# logged here.  If you *do* define an error logfile for a <VirtualHost>
# container, that host's errors will be logged there and not here.
#
ErrorLog logs/error_log

#
# LogLevel: Control the number of messages logged to the error_log.
# Possible values include: debug, info, notice, warn, error, crit,
# alert, emerg.
#
LogLevel warn

#
# The following directives define some format nicknames for use with
# a CustomLog directive (see below).
#
LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"" combined
LogFormat "%h %l %u %t \"%r\" %>s %b" common
LogFormat "%{Referer}i -> %U" referer
LogFormat "%{User-agent}i" agent

# "combinedio" includes actual counts of actual bytes received (%I) and sent (%O); this
# requires the mod_logio module to be loaded.
#LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\" %I %O" combinedio

#
# The location and format of the access logfile (Common Logfile Format).
# If you do not define any access logfiles within a <VirtualHost>
# container, they will be logged here.  Contrariwise, if you *do*
# define per-<VirtualHost> access logfiles, transactions will be
# logged therein and *not* in this file.
#
#CustomLog logs/access_log common

#
# If you would like to have separate agent and referer logfiles, uncomment
# the following directives.
#
#CustomLog logs/referer_log referer
#CustomLog logs/agent_log agent

#
# For a single logfile with access, agent, and referer information
# (Combined Logfile Format), use the following directive:
#
CustomLog logs/access_log combined

#
# Optionally add a line containing the server version and virtual host
# name to server-generated pages (internal error documents, FTP directory
# listings, mod_status and mod_info output etc., but not CGI generated
# documents or custom error documents).
# Set to "EMail" to also include a mailto: link to the ServerAdmin.
# Set to one of:  On | Off | EMail
#
ServerSignature On

#
# Aliases: Add here as many aliases as you need (with no limit). The format is 
# Alias fakename realname
#
# Note that if you include a trailing / on fakename then the server will
# require it to be present in the URL.  So "/icons" isn't aliased in this
# example, only "/icons/".  If the fakename is slash-terminated, then the 
# realname must also be slash terminated, and if the fakename omits the 
# trailing slash, the realname must also omit it.
#
# We include the /icons/ alias for FancyIndexed directory listings.  If you
# do not use FancyIndexing, you may comment this out.
#
Alias /icons/ "/var/www/icons/"

<Directory "/var/www/icons">
    Options Indexes MultiViews FollowSymLinks
    AllowOverride None
    Order allow,deny
    Allow from all
</Directory>

Alias /perl/ "/home/ywang00/perl/"
# Alias /perl/ "/home/ywang00/Desktop/_TAF/"

<Location /perl/>
      SetHandler perl-script
      PerlResponseHandler ModPerl::Registry
      PerlOptions +ParseHeaders
      Options +ExecCGI
      Order allow,deny
      Allow from all 
  </Location>
#
# WebDAV module configuration section.
# 
<IfModule mod_dav_fs.c>
    # Location of the WebDAV lock database.
    DAVLockDB /var/lib/dav/lockdb
</IfModule>

#
# ScriptAlias: This controls which directories contain server scripts.
# ScriptAliases are essentially the same as Aliases, except that
# documents in the realname directory are treated as applications and
# run by the server when requested rather than as documents sent to the client.
# The same rules about trailing "/" apply to ScriptAlias directives as to
# Alias.
#
 

ScriptAlias /cgi-bin/ "/tmp/var/www/cgi-bin/_TAF/"

#
# "/var/www/cgi-bin" should be changed to whatever your ScriptAliased
# CGI directory exists, if you have that configured.
#
<Directory "/tmp/var/www/cgi-bin/_TAF/">
    AllowOverride None
    Options None
    Order allow,deny
    Allow from all
</Directory>

#
# Redirect allows you to tell clients about documents which used to exist in
# your server's namespace, but do not anymore. This allows you to tell the
# clients where to look for the relocated document.
# Example:
# Redirect permanent /foo http://www.example.com/bar

#
# Directives controlling the display of server-generated directory listings.
#

#
# IndexOptions: Controls the appearance of server-generated directory
# listings.
#
IndexOptions FancyIndexing VersionSort NameWidth=* HTMLTable Charset=UTF-8

#
# AddIcon* directives tell the server which icon to show for different
# files or filename extensions.  These are only displayed for
# FancyIndexed directories.
#
AddIconByEncoding (CMP,/icons/compressed.gif) x-compress x-gzip

AddIconByType (TXT,/icons/text.gif) text/*
AddIconByType (IMG,/icons/image2.gif) image/*
AddIconByType (SND,/icons/sound2.gif) audio/*
AddIconByType (VID,/icons/movie.gif) video/*

AddIcon /icons/binary.gif .bin .exe
AddIcon /icons/binhex.gif .hqx
AddIcon /icons/tar.gif .tar
AddIcon /icons/world2.gif .wrl .wrl.gz .vrml .vrm .iv
AddIcon /icons/compressed.gif .Z .z .tgz .gz .zip
AddIcon /icons/a.gif .ps .ai .eps
AddIcon /icons/layout.gif .html .shtml .htm .pdf
AddIcon /icons/text.gif .txt
AddIcon /icons/c.gif .c
AddIcon /icons/p.gif .pl .py
AddIcon /icons/f.gif .for
AddIcon /icons/dvi.gif .dvi
AddIcon /icons/uuencoded.gif .uu
AddIcon /icons/script.gif .conf .sh .shar .csh .ksh .tcl
AddIcon /icons/tex.gif .tex
AddIcon /icons/bomb.gif core

AddIcon /icons/back.gif ..
AddIcon /icons/hand.right.gif README
AddIcon /icons/folder.gif ^^DIRECTORY^^
AddIcon /icons/blank.gif ^^BLANKICON^^

#
# DefaultIcon is which icon to show for files which do not have an icon
# explicitly set.
#
DefaultIcon /icons/unknown.gif

#
# AddDescription allows you to place a short description after a file in
# server-generated indexes.  These are only displayed for FancyIndexed
# directories.
# Format: AddDescription "description" filename
#
#AddDescription "GZIP compressed document" .gz
#AddDescription "tar archive" .tar
#AddDescription "GZIP compressed tar archive" .tgz

#
# ReadmeName is the name of the README file the server will look for by
# default, and append to directory listings.
#
# HeaderName is the name of a file which should be prepended to
# directory indexes. 
ReadmeName README.html
HeaderName HEADER.html

#
# IndexIgnore is a set of filenames which directory indexing should ignore
# and not include in the listing.  Shell-style wildcarding is permitted.
#
IndexIgnore .??* *~ *# HEADER* README* RCS CVS *,v *,t

#
# DefaultLanguage and AddLanguage allows you to specify the language of 
# a document. You can then use content negotiation to give a browser a 
# file in a language the user can understand.
#
# Specify a default language. This means that all data
# going out without a specific language tag (see below) will 
# be marked with this one. You probably do NOT want to set
# this unless you are sure it is correct for all cases.
#
# * It is generally better to not mark a page as 
# * being a certain language than marking it with the wrong
# * language!
#
# DefaultLanguage nl
#
# Note 1: The suffix does not have to be the same as the language
# keyword --- those with documents in Polish (whose net-standard
# language code is pl) may wish to use "AddLanguage pl .po" to
# avoid the ambiguity with the common suffix for perl scripts.
#
# Note 2: The example entries below illustrate that in some cases 
# the two character 'Language' abbreviation is not identical to 
# the two character 'Country' code for its country,
# E.g. 'Danmark/dk' versus 'Danish/da'.
#
# Note 3: In the case of 'ltz' we violate the RFC by using a three char
# specifier. There is 'work in progress' to fix this and get
# the reference data for rfc1766 cleaned up.
#
# Catalan (ca) - Croatian (hr) - Czech (cs) - Danish (da) - Dutch (nl)
# English (en) - Esperanto (eo) - Estonian (et) - French (fr) - German (de)
# Greek-Modern (el) - Hebrew (he) - Italian (it) - Japanese (ja)
# Korean (ko) - Luxembourgeois* (ltz) - Norwegian Nynorsk (nn)
# Norwegian (no) - Polish (pl) - Portugese (pt)
# Brazilian Portuguese (pt-BR) - Russian (ru) - Swedish (sv)
# Simplified Chinese (zh-CN) - Spanish (es) - Traditional Chinese (zh-TW)
#
AddLanguage ca .ca
AddLanguage cs .cz .cs
AddLanguage da .dk
AddLanguage de .de
AddLanguage el .el
AddLanguage en .en
AddLanguage eo .eo
AddLanguage es .es
AddLanguage et .et
AddLanguage fr .fr
AddLanguage he .he
AddLanguage hr .hr
AddLanguage it .it
AddLanguage ja .ja
AddLanguage ko .ko
AddLanguage ltz .ltz
AddLanguage nl .nl
AddLanguage nn .nn
AddLanguage no .no
AddLanguage pl .po
AddLanguage pt .pt
AddLanguage pt-BR .pt-br
AddLanguage ru .ru
AddLanguage sv .sv
AddLanguage zh-CN .zh-cn
AddLanguage zh-TW .zh-tw

#
# LanguagePriority allows you to give precedence to some languages
# in case of a tie during content negotiation.
#
# Just list the languages in decreasing order of preference. We have
# more or less alphabetized them here. You probably want to change this.
#
LanguagePriority en ca cs da de el eo es et fr he hr it ja ko ltz nl nn no pl pt pt-BR ru sv zh-CN zh-TW

#
# ForceLanguagePriority allows you to serve a result page rather than
# MULTIPLE CHOICES (Prefer) [in case of a tie] or NOT ACCEPTABLE (Fallback)
# [in case no accepted languages matched the available variants]
#
ForceLanguagePriority Prefer Fallback

#
# Specify a default charset for all content served; this enables
# interpretation of all content as UTF-8 by default.  To use the 
# default browser choice (ISO-8859-1), or to allow the META tags
# in HTML content to override this choice, comment out this
# directive:
#
AddDefaultCharset UTF-8

#
# AddType allows you to add to or override the MIME configuration
# file mime.types for specific file types.
#
#AddType application/x-tar .tgz

#
# AddEncoding allows you to have certain browsers uncompress
# information on the fly. Note: Not all browsers support this.
# Despite the name similarity, the following Add* directives have nothing
# to do with the FancyIndexing customization directives above.
#
#AddEncoding x-compress .Z
#AddEncoding x-gzip .gz .tgz

# If the AddEncoding directives above are commented-out, then you
# probably should define those extensions to indicate media types:
#
AddType application/x-compress .Z
AddType application/x-gzip .gz .tgz

#
#   MIME-types for downloading Certificates and CRLs
#
AddType application/x-x509-ca-cert .crt
AddType application/x-pkcs7-crl    .crl

#
# AddHandler allows you to map certain file extensions to "handlers":
# actions unrelated to filetype. These can be either built into the server
# or added with the Action directive (see below)
#
# To use CGI scripts outside of ScriptAliased directories:
# (You will also need to add "ExecCGI" to the "Options" directive.)
#
AddHandler cgi-script .cgi .pl

# yw

<Directory /tmp/var/www/cgi-bin/_TAF>
	Options +ExecCGI
	AddHandler cgi-script .cgi .pl
</Directory>

<Directory /home/*/_TAF>
	Options +ExecCGI
	AddHandler cgi-script .cgi .pl
</Directory>
#
# For files that include their own HTTP headers:
#
#AddHandler send-as-is asis

#
# For type maps (negotiated resources):
# (This is enabled by default to allow the Apache "It Worked" page
#  to be distributed in multiple languages.)
#
AddHandler type-map var

#
# Filters allow you to process content before it is sent to the client.
#
# To parse .shtml files for server-side includes (SSI):
# (You will also need to add "Includes" to the "Options" directive.)
#
AddType text/html .shtml
AddOutputFilter INCLUDES .shtml

#
# Action lets you define media types that will execute a script whenever
# a matching file is called. This eliminates the need for repeated URL
# pathnames for oft-used CGI file processors.
# Format: Action media/type /cgi-script/location
# Format: Action handler-name /cgi-script/location
#

#
# Customizable error responses come in three flavors:
# 1) plain text 2) local redirects 3) external redirects
#
# Some examples:
#ErrorDocument 500 "The server made a boo boo."
#ErrorDocument 404 /missing.html
#ErrorDocument 404 "/cgi-bin/missing_handler.pl"
#ErrorDocument 402 http://www.example.com/subscription_info.html
#

#
# Putting this all together, we can internationalize error responses.
#
# We use Alias to redirect any /error/HTTP_<error>.html.var response to
# our collection of by-error message multi-language collections.  We use 
# includes to substitute the appropriate text.
#
# You can modify the messages' appearance without changing any of the
# default HTTP_<error>.html.var files by adding the line:
#
#   Alias /error/include/ "/your/include/path/"
#
# which allows you to create your own set of files by starting with the
# /var/www/error/include/ files and
# copying them to /your/include/path/, even on a per-VirtualHost basis.
#

Alias /error/ "/var/www/error/"

<IfModule mod_negotiation.c>
<IfModule mod_include.c>
    <Directory "/var/www/error">
        AllowOverride None
        Options IncludesNoExec
        AddOutputFilter Includes html
        AddHandler type-map var
        Order allow,deny
        Allow from all
        LanguagePriority en es de fr
        ForceLanguagePriority Prefer Fallback
    </Directory>

#    ErrorDocument 400 /error/HTTP_BAD_REQUEST.html.var
#    ErrorDocument 401 /error/HTTP_UNAUTHORIZED.html.var
#    ErrorDocument 403 /error/HTTP_FORBIDDEN.html.var
#    ErrorDocument 404 /error/HTTP_NOT_FOUND.html.var
#    ErrorDocument 405 /error/HTTP_METHOD_NOT_ALLOWED.html.var
#    ErrorDocument 408 /error/HTTP_REQUEST_TIME_OUT.html.var
#    ErrorDocument 410 /error/HTTP_GONE.html.var
#    ErrorDocument 411 /error/HTTP_LENGTH_REQUIRED.html.var
#    ErrorDocument 412 /error/HTTP_PRECONDITION_FAILED.html.var
#    ErrorDocument 413 /error/HTTP_REQUEST_ENTITY_TOO_LARGE.html.var
#    ErrorDocument 414 /error/HTTP_REQUEST_URI_TOO_LARGE.html.var
#    ErrorDocument 415 /error/HTTP_UNSUPPORTED_MEDIA_TYPE.html.var
#    ErrorDocument 500 /error/HTTP_INTERNAL_SERVER_ERROR.html.var
#    ErrorDocument 501 /error/HTTP_NOT_IMPLEMENTED.html.var
#    ErrorDocument 502 /error/HTTP_BAD_GATEWAY.html.var
#    ErrorDocument 503 /error/HTTP_SERVICE_UNAVAILABLE.html.var
#    ErrorDocument 506 /error/HTTP_VARIANT_ALSO_VARIES.html.var

</IfModule>
</IfModule>

#
# The following directives modify normal HTTP response behavior to
# handle known problems with browser implementations.
#
BrowserMatch "Mozilla/2" nokeepalive
BrowserMatch "MSIE 4\.0b2;" nokeepalive downgrade-1.0 force-response-1.0
BrowserMatch "RealPlayer 4\.0" force-response-1.0
BrowserMatch "Java/1\.0" force-response-1.0
BrowserMatch "JDK/1\.0" force-response-1.0

#
# The following directive disables redirects on non-GET requests for
# a directory that does not include the trailing slash.  This fixes a 
# problem with Microsoft WebFolders which does not appropriately handle 
# redirects for folders with DAV methods.
# Same deal with Apple's DAV filesystem and Gnome VFS support for DAV.
#
BrowserMatch "Microsoft Data Access Internet Publishing Provider" redirect-carefully
BrowserMatch "MS FrontPage" redirect-carefully
BrowserMatch "^WebDrive" redirect-carefully
BrowserMatch "^WebDAVFS/1.[0123]" redirect-carefully
BrowserMatch "^gnome-vfs/1.0" redirect-carefully
BrowserMatch "^XML Spy" redirect-carefully
BrowserMatch "^Dreamweaver-WebDAV-SCM1" redirect-carefully

#
# Allow server status reports generated by mod_status,
# with the URL of http://servername/server-status
# Change the ".example.com" to match your domain to enable.
#
#<Location /server-status>
#    SetHandler server-status
#    Order deny,allow
#    Deny from all
#    Allow from .example.com
#</Location>

#
# Allow remote server configuration reports, with the URL of
#  http://servername/server-info (requires that mod_info.c be loaded).
# Change the ".example.com" to match your domain to enable.
#
#<Location /server-info>
#    SetHandler server-info
#    Order deny,allow
#    Deny from all
#    Allow from .example.com
#</Location>

#
# Proxy Server directives. Uncomment the following lines to
# enable the proxy server:
#
#<IfModule mod_proxy.c>
#ProxyRequests On
#
#<Proxy *>
#    Order deny,allow
#    Deny from all
#    Allow from .example.com
#</Proxy>

#
# Enable/disable the handling of HTTP/1.1 "Via:" headers.
# ("Full" adds the server version; "Block" removes all outgoing Via: headers)
# Set to one of: Off | On | Full | Block
#
#ProxyVia On

#
# To enable a cache of proxied content, uncomment the following lines.
# See http://httpd.apache.org/docs/2.2/mod/mod_cache.html for more details.
#
#<IfModule mod_disk_cache.c>
#   CacheEnable disk /
#   CacheRoot "/var/cache/mod_proxy"
#</IfModule>
#

#</IfModule>
# End of proxy directives.

### Section 3: Virtual Hosts
#
# VirtualHost: If you want to maintain multiple domains/hostnames on your
# machine you can setup VirtualHost containers for them. Most configurations
# use only name-based virtual hosts so the server doesn't need to worry about
# IP addresses. This is indicated by the asterisks in the directives below.
#
# Please see the documentation at 
# <URL:http://httpd.apache.org/docs/2.2/vhosts/>
# for further details before you try to setup virtual hosts.
#
# You may use the command line option '-S' to verify your virtual host
# configuration.

#
# Use name-based virtual hosting.
#
NameVirtualHost *:80
#
# NOTE: NameVirtualHost cannot be used without a port specifier 
# (e.g. :80) if mod_ssl is being used, due to the nature of the
# SSL protocol.
#

#
# VirtualHost example:
# Almost any Apache directive may go into a VirtualHost container.
# The first VirtualHost section is used for requests without a known
# server name.
#
#<VirtualHost *:80>
#    ServerAdmin webmaster@dummy-host.example.com
#    DocumentRoot /www/docs/dummy-host.example.com
#    ServerName dummy-host.example.com
#    ErrorLog logs/dummy-host.example.com-error_log
#    CustomLog logs/dummy-host.example.com-access_log common
#</VirtualHost>
############################## Apache Config File ###################################

############################## MakeFile.pl ###################################
# todo
############################## MakeFile.pl ###################################




# TAF Linux setup:

# mkdir /var/www/cgi-bin/_TAF
# sudo chmod -R ugo+rwx /var/www  
# #!/usr/bin/perl in generated perl script and TCs (!)
# Security config: * disable selinux *disable firewall (iptable)
# Apache *setup  /etc/httpd/conf/httpd.conf (see sample above)  */etc/init.d/httpd restart * 
	# DocumentRoot: /var/www/html -> /var/www/cgi-bin/_TAF
	# <Directory> /var/www/html>  -> /var/www/cgi-bin/_TAF
	# ScriptAlias /cgi-bin/ 
	# AddHandler cgi-script .pl .cgi
	# Servername: yw.io.com
	# DirectoryIndex: -> index_http.htm 
	# Alias /perl/ "/home..." -> <Location /perl/> setHandler  </Location>
# for security reason:  sudo yum install perl-suidperl


#If you are running a Perl script with the setuid bit, it actually runs a slightly modified version of Perl so that it is a bit more cautious. On a CentOS box, you need to install the perl-suidperl package to get the necessary files installed. Otherwise you get an error like this:
#[root@host bin]# ls -al myscript.pl
#-rws--S--- 1 mail mail 1218 Oct  1 13:09 myscript.pl
#[root@host bin]# ./myscript.pl
#Can't do setuid (cannot exec sperl)

# Here is taftaf.pl 


