# Generated by default/object.tt
package Paws::Backup::AdvancedBackupSetting;
  use Moose;
  has BackupOptions => (is => 'ro', isa => 'Paws::Backup::BackupOptions');
  has ResourceType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Backup::AdvancedBackupSetting

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Backup::AdvancedBackupSetting object:

  $service_obj->Method(Att1 => { BackupOptions => $value, ..., ResourceType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Backup::AdvancedBackupSetting object:

  $result = $service_obj->Method(...);
  $result->Att1->BackupOptions

=head1 DESCRIPTION

A list of backup options for each resource type.

=head1 ATTRIBUTES


=head2 BackupOptions => L<Paws::Backup::BackupOptions>

Specifies the backup option for a selected resource. This option is
only available for Windows VSS backup jobs.

Valid values:

Set to C<"WindowsVSS":"enabled"> to enable the WindowsVSS backup option
and create a VSS Windows backup.

Set to C<"WindowsVSS":"disabled"> to create a regular backup. The
WindowsVSS option is not enabled by default.

If you specify an invalid option, you get an
C<InvalidParameterValueException> exception.

For more information about Windows VSS backups, see Creating a
VSS-Enabled Windows Backup
(https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html).


=head2 ResourceType => Str

Specifies an object containing resource type and backup options. The
only supported resource type is Amazon EC2 instances with Windows VSS.
For an CloudFormation example, see the sample CloudFormation template
to enable Windows VSS
(https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html)
in the I<AWS Backup User Guide>.

Valid values: C<EC2>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Backup>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

