# Generated by default/object.tt
package Paws::CodeGuruProfiler::Anomaly;
  use Moose;
  has Instances => (is => 'ro', isa => 'ArrayRef[Paws::CodeGuruProfiler::AnomalyInstance]', request_name => 'instances', traits => ['NameInRequest'], required => 1);
  has Metric => (is => 'ro', isa => 'Paws::CodeGuruProfiler::Metric', request_name => 'metric', traits => ['NameInRequest'], required => 1);
  has Reason => (is => 'ro', isa => 'Str', request_name => 'reason', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruProfiler::Anomaly

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruProfiler::Anomaly object:

  $service_obj->Method(Att1 => { Instances => $value, ..., Reason => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruProfiler::Anomaly object:

  $result = $service_obj->Method(...);
  $result->Att1->Instances

=head1 DESCRIPTION

Details about an anomaly in a specific metric of application profile.
The anomaly is detected using analysis of the metric data over a period
of time.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Instances => ArrayRef[L<Paws::CodeGuruProfiler::AnomalyInstance>]

A list of the instances of the detected anomalies during the requested
period.


=head2 B<REQUIRED> Metric => L<Paws::CodeGuruProfiler::Metric>

Details about the metric that the analysis used when it detected the
anomaly. The metric includes the name of the frame that was analyzed
with the type and thread states used to derive the metric value for
that frame.


=head2 B<REQUIRED> Reason => Str

The reason for which metric was flagged as anomalous.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

